/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.core.bouncycastle.asn1;

import com.jxdinfo.hussar.core.bouncycastle.asn1.ASN1OutputStream;
import com.jxdinfo.hussar.core.bouncycastle.asn1.DEREncodable;
import com.jxdinfo.hussar.core.bouncycastle.asn1.DERObject;
import com.jxdinfo.hussar.core.bouncycastle.asn1.DEROutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public abstract class ASN1Encodable
implements DEREncodable {
    public static final String DER = "DER";
    public static final String BER = "BER";

    public boolean equals(Object a) {
        ASN1Encodable a2;
        if (a2 == a) {
            return true;
        }
        if (!(a instanceof DEREncodable)) {
            return false;
        }
        a = (DEREncodable)a;
        return a2.toASN1Object().equals(a.getDERObject());
    }

    public int hashCode() {
        ASN1Encodable a;
        return a.toASN1Object().hashCode();
    }

    public byte[] getEncoded(String a) throws IOException {
        ASN1Encodable a2;
        if (((String)a).equals(DER)) {
            a = new ByteArrayOutputStream();
            new DEROutputStream((OutputStream)a).writeObject(a2);
            return ((ByteArrayOutputStream)a).toByteArray();
        }
        return a2.getEncoded();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] getDEREncoded() {
        try {
            ASN1Encodable a;
            return a.getEncoded(DER);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public DERObject getDERObject() {
        ASN1Encodable a;
        return a.toASN1Object();
    }

    public ASN1Encodable() {
        ASN1Encodable a;
    }

    public abstract DERObject toASN1Object();

    public byte[] getEncoded() throws IOException {
        ASN1Encodable a;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        new ASN1OutputStream(byteArrayOutputStream).writeObject(a);
        return byteArrayOutputStream.toByteArray();
    }
}

