/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar;

import com.jxdinfo.hussar.core.util.CookieUtils;
import com.jxdinfo.hussar.core.util.DateTimeUtils;
import com.jxdinfo.hussar.core.util.IdGenerator;
import com.jxdinfo.hussar.core.util.ProductInfo;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.time.ZonedDateTime;
import java.util.Properties;
import java.util.regex.Pattern;
import java.util.zip.CRC32;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.VfsResource;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class CoreVersion {
    private static String cus_version;
    public static String licFileNameRegex;
    private static String version;
    public static final String licCusHeaderRegex = "[\\u3000-\\u303F\\p{P}\\p{IsHan}\\u4E00-\\u9FA5A-Za-z0-9_-]+";
    public static String licFileName;
    private static String frameworkVersion;
    private static String hussarFrameworkVersion;
    public static String licCusHeader;
    private static final Logger LOGGER;
    private static Pattern versionPattern;

    public static String getLicenseVersion() {
        if (StringUtils.isNotEmpty((CharSequence)cus_version)) {
            return cus_version;
        }
        return CoreVersion.getVersion();
    }

    public static ZonedDateTime getDateTime() {
        URL uRL;
        block6: {
            String string;
            block5: {
                Class<CoreVersion> clazz;
                Class<CoreVersion> clazz2 = clazz = CoreVersion.class;
                Class<CoreVersion> clazz3 = clazz;
                uRL = clazz3.getResource(clazz3.getSimpleName() + ".class");
                if (!"file".equals(uRL.getProtocol())) break block5;
                return DateTimeUtils.zonedDateTimeOf(new File(uRL.toURI()).lastModified());
            }
            if (!"jar".equals(uRL.getProtocol())) break block6;
            String string2 = string = uRL.getPath();
            return DateTimeUtils.zonedDateTimeOf(new File(string2.substring(5, string2.indexOf(33))).lastModified());
        }
        try {
            if ("vfs".equals(uRL.getProtocol())) {
                File file = new VfsResource(uRL.openConnection().getContent()).getFile();
                return DateTimeUtils.zonedDateTimeOf(file.lastModified());
            }
        }
        catch (IOException | NullPointerException | URISyntaxException exception) {
            return ZonedDateTime.now();
        }
        LOGGER.warn(CookieUtils.enum("\no?i0-sj=21f.42t?a,*pHH(\u0005n>_tC\u0002q;`1w'4xS%t\u0002"), (Object)uRL.getProtocol(), (Object)uRL);
        return ZonedDateTime.now();
    }

    private static /* synthetic */ long final(byte[] a) {
        CRC32 cRC32 = new CRC32();
        cRC32.update(a);
        return cRC32.getValue();
    }

    public static String getHussaarFrameworkVersion() {
        if (hussarFrameworkVersion == null) {
            Properties properties = new Properties();
            InputStream inputStream = CoreVersion.class.getClassLoader().getResourceAsStream(IdGenerator.try("7c)A\u0010h)z:'&v8f%{#"));
            if (inputStream != null) {
                try {
                    properties.load(inputStream);
                    hussarFrameworkVersion = properties.getProperty(CookieUtils.enum("4k*{7f1"));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        if (hussarFrameworkVersion == null) {
            hussarFrameworkVersion = IdGenerator.try("r;\u007f:5");
            return hussarFrameworkVersion;
        }
        return hussarFrameworkVersion;
    }

    public static String getFolderName() {
        return new StringBuilder().insert(0, CookieUtils.enum("'7")).append(Long.toHexString(CoreVersion.final(CoreVersion.getLicenseVersion().getBytes()))).toString();
    }

    public static Pattern getVersionPatern() {
        return versionPattern;
    }

    public static String getSpecificationVersion() {
        return CoreVersion.class.getPackage().getSpecificationVersion();
    }

    public static String getVersion() {
        if (version == null) {
            Properties properties;
            Properties properties2 = new Properties();
            InputStream inputStream = CoreVersion.class.getClassLoader().getResourceAsStream(CookieUtils.enum("a;g&:4k*{7f1"));
            try {
                properties2.load(inputStream);
                properties = properties2;
            }
            catch (IOException iOException) {
                properties = properties2;
                iOException.printStackTrace();
            }
            version = properties.getProperty(IdGenerator.try("&v8f%{#"));
        }
        return version;
    }

    static {
        LOGGER = LoggerFactory.getLogger(CoreVersion.class);
        version = null;
        cus_version = ProductInfo.getCusVersion();
        frameworkVersion = ProductInfo.getFramewrokVersion();
        hussarFrameworkVersion = null;
        licFileNameRegex = "^[a-zA-Z][a-zA-Z0-9_]+\\.(lic|dat|conf|txt)$";
        licFileName = ProductInfo.getLicFileName();
        licCusHeader = ProductInfo.getLicCusHeader();
        versionPattern = Pattern.compile(IdGenerator.try(" \n9}*\u0017>\u0010:\u0016v2 \u001d=\u0013=\u0011$`*\u0017%~j7"), 2);
    }

    public static String getDevFolderName() {
        return new StringBuilder().insert(0, IdGenerator.try("`w\"")).append(Long.toHexString(CoreVersion.final(CoreVersion.getLicenseVersion().getBytes()))).toString();
    }

    public static String getFrameworkVersion() {
        if (frameworkVersion == null) {
            Properties properties = new Properties();
            InputStream inputStream = CoreVersion.class.getClassLoader().getResourceAsStream(CookieUtils.enum("%p5\\\u0002u;g(:4k*{7f1"));
            if (inputStream != null) {
                try {
                    properties.load(inputStream);
                    frameworkVersion = properties.getProperty(IdGenerator.try("&v8f%{#"));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        if (frameworkVersion == null) {
            frameworkVersion = CookieUtils.enum("`&m''");
            return frameworkVersion;
        }
        return frameworkVersion;
    }

    public CoreVersion() {
        CoreVersion a;
    }
}

