/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.core.bouncycastle.math.ec;

import com.jxdinfo.hussar.core.HussarCoreAutoConfiguration;
import com.jxdinfo.hussar.core.bouncycastle.asn1.ASN1StreamParser;
import com.jxdinfo.hussar.core.bouncycastle.asn1.x9.X9IntegerConverter;
import com.jxdinfo.hussar.core.bouncycastle.jce.provider.asymmetric.ec.EC5Util;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.AUX;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.ECConstants;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.ECCurve;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.ECFieldElement;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.NUL;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.cON;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.nul;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.prn;
import com.jxdinfo.hussar.core.util.LicenseInfo;
import java.math.BigInteger;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class ECPoint {
    ECCurve E;
    protected AUX multiplier;
    private static X9IntegerConverter K = new X9IntegerConverter();
    ECFieldElement m;
    ECFieldElement private;
    protected boolean withCompression;
    protected NUL preCompInfo;

    public abstract ECPoint negate();

    public abstract ECPoint subtract(ECPoint var1);

    public ECFieldElement getX() {
        ECPoint a;
        return a.private;
    }

    public abstract ECPoint twice();

    protected ECPoint(ECCurve a, ECFieldElement a2, ECFieldElement a3) {
        ECPoint a4;
        ECPoint eCPoint = a4;
        ECPoint eCPoint2 = a4;
        a4.multiplier = null;
        eCPoint2.preCompInfo = null;
        eCPoint2.E = a;
        eCPoint.private = a2;
        eCPoint.m = a3;
    }

    public abstract byte[] getEncoded();

    public abstract ECPoint add(ECPoint var1);

    public ECCurve getCurve() {
        ECPoint a;
        return a.E;
    }

    public ECPoint multiply(BigInteger a) {
        ECPoint a2;
        if (a.signum() < 0) {
            throw new IllegalArgumentException(ASN1StreamParser.interface("\u0010Q(\u0010k\u000e)L D0H#\\r\u0014?\u0010(Wh\u0015\u0002dKt\u001d%)_&]2R*D"));
        }
        if (a2.isInfinity()) {
            return a2;
        }
        if (a.signum() == 0) {
            return a2.E.getInfinity();
        }
        ECPoint eCPoint = a2;
        eCPoint.short();
        ECPoint eCPoint2 = a2;
        return eCPoint.multiplier.abstract(eCPoint2, a, eCPoint2.preCompInfo);
    }

    public int hashCode() {
        ECPoint a;
        if (a.isInfinity()) {
            return 0;
        }
        return a.private.hashCode() ^ a.m.hashCode();
    }

    void do(NUL a) {
        a.preCompInfo = a;
    }

    public boolean isInfinity() {
        ECPoint a;
        return a.private == null && a.m == null;
    }

    synchronized void short() {
        ECPoint a;
        if (a.multiplier == null) {
            ECPoint eCPoint = a;
            eCPoint.multiplier = new nul();
        }
    }

    public ECFieldElement getY() {
        ECPoint a;
        return a.m;
    }

    public boolean equals(Object a) {
        ECPoint a2;
        if (a == a2) {
            return true;
        }
        if (!(a instanceof ECPoint)) {
            return false;
        }
        a = (ECPoint)a;
        if (a2.isInfinity()) {
            return ((ECPoint)a).isInfinity();
        }
        return a2.private.equals(((ECPoint)a).private) && a2.m.equals(((ECPoint)a).m);
    }

    public boolean isCompressed() {
        ECPoint a;
        return a.withCompression;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class F2m
    extends ECPoint {
        @Override
        public ECPoint twice() {
            F2m a;
            if (a.isInfinity()) {
                return a;
            }
            if (a.private.toBigInteger().signum() == 0) {
                return a.E.getInfinity();
            }
            F2m f2m = a;
            ECFieldElement.F2m f2m2 = (ECFieldElement.F2m)f2m.private.add(f2m.m.divide(a.private));
            ECFieldElement.F2m f2m3 = (ECFieldElement.F2m)f2m2.square().add(f2m2).add(a.E.getA());
            F2m f2m4 = a;
            ECFieldElement eCFieldElement = f2m4.E.fromBigInteger(ECConstants.ONE);
            eCFieldElement = (ECFieldElement.F2m)f2m4.private.square().add(f2m3.multiply(f2m2.add(eCFieldElement)));
            return new F2m(a.E, f2m3, eCFieldElement, a.withCompression);
        }

        public F2m subtractSimple(F2m a) {
            F2m a2;
            if (a.isInfinity()) {
                return a2;
            }
            return a2.addSimple((F2m)a.negate());
        }

        @Override
        public ECPoint add(ECPoint a) {
            F2m a2;
            F2m f2m = a2;
            F2m.abstract(f2m, a);
            return f2m.addSimple((F2m)a);
        }

        @Override
        public ECPoint subtract(ECPoint a) {
            F2m a2;
            F2m f2m = a2;
            F2m.abstract(f2m, a);
            return f2m.subtractSimple((F2m)a);
        }

        public F2m addSimple(F2m a) {
            F2m a2;
            Object object = a;
            if (a2.isInfinity()) {
                return object;
            }
            if (((ECPoint)object).isInfinity()) {
                return a2;
            }
            ECFieldElement.F2m f2m = (ECFieldElement.F2m)((ECPoint)object).getX();
            object = (ECFieldElement.F2m)((ECPoint)object).getY();
            if (a2.private.equals(f2m)) {
                if (a2.m.equals(object)) {
                    return (F2m)a2.twice();
                }
                return (F2m)a2.E.getInfinity();
            }
            object = (ECFieldElement.F2m)a2.m.add((ECFieldElement)object).divide(a2.private.add(f2m));
            f2m = (ECFieldElement.F2m)((ECFieldElement.F2m)object).square().add((ECFieldElement)object).add(a2.private).add(f2m).add(a2.E.getA());
            object = (ECFieldElement.F2m)((ECFieldElement.F2m)object).multiply(a2.private.add(f2m)).add(f2m).add(a2.m);
            return new F2m(a2.E, f2m, (ECFieldElement)object, a2.withCompression);
        }

        public F2m(ECCurve a, ECFieldElement a2, ECFieldElement a3) {
            a4(a, a2, a3, false);
            F2m a4;
        }

        @Override
        public byte[] getEncoded() {
            F2m a;
            if (a.isInfinity()) {
                return new byte[1];
            }
            int n = K.getByteLength(a.private);
            byte[] byArray = K.integerToBytes(a.getX().toBigInteger(), n);
            if (a.withCompression) {
                byte[] byArray2 = new byte[n + 1];
                byArray2[0] = 2;
                if (!a.getX().toBigInteger().equals(ECConstants.ZERO) && a.getY().multiply(a.getX().invert()).toBigInteger().testBit(0)) {
                    byArray2[0] = 3;
                }
                System.arraycopy(byArray, 0, byArray2, 1, n);
                return byArray2;
            }
            byte[] byArray3 = K.integerToBytes(a.getY().toBigInteger(), n);
            int n2 = n;
            byte[] byArray4 = new byte[n2 + n2 + 1];
            byArray4[0] = 4;
            System.arraycopy(byArray, 0, byArray4, 1, n);
            System.arraycopy(byArray3, 0, byArray4, n + 1, n);
            return byArray4;
        }

        private static /* synthetic */ void abstract(ECPoint a, ECPoint a2) {
            if (!a.E.equals(a2.E)) {
                throw new IllegalArgumentException(LicenseInfo.null("LSu^#MnV}Yg\nc\\%O&\u0015-@`Rq\nkC<\u0006`\u001b`\\ PG~\u0003|TjjU)X|\u0010g_&\u000eTy1\u0018hW"));
            }
        }

        public F2m(ECCurve a, ECFieldElement a2, ECFieldElement a3, boolean a4) {
            F2m a5;
            ECFieldElement eCFieldElement = a2;
            super(a, eCFieldElement, a3);
            if (eCFieldElement != null && a3 == null || a2 == null && a3 != null) {
                throw new IllegalArgumentException(HussarCoreAutoConfiguration.import("Cx,e?'\u007f\u0000\u0002H\u000e\u0015\u0017lgx)nfw5$`GN2vm(<zx2+/\u007fa\u007f)7z"));
            }
            if (a2 != null) {
                F2m f2m = a5;
                ECFieldElement.F2m.checkFieldElements(f2m.private, f2m.m);
                if (a != null) {
                    F2m f2m2 = a5;
                    ECFieldElement.F2m.checkFieldElements(f2m2.private, f2m2.E.getA());
                }
            }
            a5.withCompression = a4;
        }

        @Override
        synchronized void short() {
            F2m a;
            if (a.multiplier == null) {
                if (((ECCurve.F2m)a.E).isKoblitz()) {
                    F2m f2m = a;
                    f2m.multiplier = new prn();
                    return;
                }
                a.multiplier = new cON();
            }
        }

        @Override
        public ECPoint negate() {
            F2m a;
            return new F2m(a.E, a.getX(), a.getY().add(a.getX()), a.withCompression);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class Fp
    extends ECPoint {
        public Fp(ECCurve a, ECFieldElement a2, ECFieldElement a3, boolean a4) {
            Fp a5;
            ECFieldElement eCFieldElement = a2;
            super(a, eCFieldElement, a3);
            if (eCFieldElement != null && a3 == null || a2 == null && a3 != null) {
                throw new IllegalArgumentException(EC5Util.package("W,5|ku`t;QZ\u0019VL\na}v3r}kb:~YPog#(g`4}`3`{(("));
            }
            a5.withCompression = a4;
        }

        public Fp(ECCurve a, ECFieldElement a2, ECFieldElement a3) {
            a4(a, a2, a3, false);
            Fp a4;
        }

        @Override
        public ECPoint add(ECPoint a) {
            Fp a2;
            if (a2.isInfinity()) {
                return a;
            }
            if (a.isInfinity()) {
                return a2;
            }
            if (a2.private.equals(a.private)) {
                if (a2.m.equals(a.m)) {
                    return a2.twice();
                }
                return a2.E.getInfinity();
            }
            ECFieldElement eCFieldElement = a.m.subtract(a2.m).divide(a.private.subtract(a2.private));
            ECFieldElement eCFieldElement2 = eCFieldElement.square().subtract(a2.private).subtract(a.private);
            ECFieldElement eCFieldElement3 = eCFieldElement.multiply(a2.private.subtract(eCFieldElement2)).subtract(a2.m);
            return new Fp(a2.E, eCFieldElement2, eCFieldElement3);
        }

        @Override
        public ECPoint negate() {
            Fp a;
            Fp fp = a;
            return new Fp(fp.E, fp.private, a.m.negate(), a.withCompression);
        }

        @Override
        public ECPoint twice() {
            Fp a;
            if (a.isInfinity()) {
                return a;
            }
            if (a.m.toBigInteger().signum() == 0) {
                return a.E.getInfinity();
            }
            Fp fp = a;
            ECFieldElement eCFieldElement = fp.E.fromBigInteger(BigInteger.valueOf(2L));
            ECFieldElement eCFieldElement2 = fp.E.fromBigInteger(BigInteger.valueOf(3L));
            ECFieldElement eCFieldElement3 = fp.private.square().multiply(eCFieldElement2).add(a.E.m).divide(a.m.multiply(eCFieldElement));
            eCFieldElement2 = eCFieldElement3.square().subtract(a.private.multiply(eCFieldElement));
            ECFieldElement eCFieldElement4 = eCFieldElement3.multiply(a.private.subtract(eCFieldElement2)).subtract(a.m);
            return new Fp(a.E, eCFieldElement2, eCFieldElement4, a.withCompression);
        }

        @Override
        synchronized void short() {
            Fp a;
            if (a.multiplier == null) {
                Fp fp = a;
                fp.multiplier = new cON();
            }
        }

        @Override
        public ECPoint subtract(ECPoint a) {
            Fp a2;
            if (a.isInfinity()) {
                return a2;
            }
            return a2.add(a.negate());
        }

        @Override
        public byte[] getEncoded() {
            Fp a;
            if (a.isInfinity()) {
                return new byte[1];
            }
            int n = K.getByteLength(a.private);
            if (a.withCompression) {
                int n2 = a.getY().toBigInteger().testBit(0) ? 3 : 2;
                byte[] byArray = K.integerToBytes(a.getX().toBigInteger(), n);
                byte[] byArray2 = new byte[byArray.length + 1];
                byArray2[0] = n2;
                System.arraycopy(byArray, 0, byArray2, 1, byArray.length);
                return byArray2;
            }
            byte[] byArray = K.integerToBytes(a.getX().toBigInteger(), n);
            byte[] byArray3 = K.integerToBytes(a.getY().toBigInteger(), n);
            byte[] byArray4 = new byte[byArray.length + byArray3.length + 1];
            byArray4[0] = 4;
            System.arraycopy(byArray, 0, byArray4, 1, byArray.length);
            System.arraycopy(byArray3, 0, byArray4, byArray.length + 1, byArray3.length);
            return byArray4;
        }
    }
}

