/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.core.bouncycastle.math.ec;

import com.jxdinfo.hussar.core.bouncycastle.asn1.ASN1StreamParser;
import com.jxdinfo.hussar.core.bouncycastle.jce.ECGOST3410NamedCurveTable;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.ECConstants;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.coN;
import com.jxdinfo.hussar.core.util.IdGenerator;
import com.jxdinfo.hussar.core.util.LicenseInfo;
import java.math.BigInteger;
import java.util.Random;

public abstract class ECFieldElement
implements ECConstants {
    public abstract ECFieldElement multiply(ECFieldElement var1);

    public abstract ECFieldElement negate();

    public String toString() {
        ECFieldElement a;
        return a.toBigInteger().toString(2);
    }

    public abstract int getFieldSize();

    public abstract ECFieldElement square();

    public abstract ECFieldElement subtract(ECFieldElement var1);

    public abstract BigInteger toBigInteger();

    public ECFieldElement() {
        ECFieldElement a;
    }

    public abstract ECFieldElement add(ECFieldElement var1);

    public abstract ECFieldElement divide(ECFieldElement var1);

    public abstract ECFieldElement invert();

    public abstract String getFieldName();

    public abstract ECFieldElement sqrt();

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class F2m
    extends ECFieldElement {
        private int j;
        private int d;
        private int f;
        private coN E;
        public static final int GNB = 1;
        public static final int TPB = 2;
        public static final int PPB = 3;
        private int K;
        private int m;
        private int extends;

        @Override
        public String getFieldName() {
            return LicenseInfo.null("*?^");
        }

        public int getK1() {
            F2m a;
            return a.m;
        }

        public int getRepresentation() {
            F2m a;
            return a.extends;
        }

        @Override
        public ECFieldElement invert() {
            F2m a;
            coN coN2 = (coN)a.E.clone();
            coN coN3 = new coN(a.j);
            F2m f2m = a;
            coN coN4 = coN3;
            coN4.throws(a.f);
            coN4.throws(0);
            coN3.throws(f2m.m);
            if (f2m.extends == 3) {
                coN coN5 = coN3;
                coN5.throws(a.K);
                coN5.throws(a.d);
            }
            coN coN6 = new coN(a.j);
            coN6.throws(0);
            coN coN7 = new coN(a.j);
            coN coN8 = coN2;
            while (!coN8.volatile()) {
                int n = coN2.interface() - coN3.interface();
                if (n < 0) {
                    coN coN9 = coN2;
                    coN2 = coN3;
                    coN3 = coN9;
                    coN coN10 = coN6;
                    coN6 = coN7;
                    coN7 = coN10;
                    n = -n;
                }
                int n2 = n >> 5;
                coN coN11 = coN3.for(n &= 0x1F);
                coN coN12 = coN2;
                coN8 = coN12;
                coN12.abstract(coN11, n2);
                coN coN13 = coN7.for(n);
                coN6.abstract(coN13, n2);
            }
            F2m f2m2 = a;
            F2m f2m3 = a;
            return new F2m(f2m2.f, f2m2.m, f2m3.K, f2m3.d, coN7);
        }

        public int hashCode() {
            F2m a;
            return a.E.hashCode() ^ a.f ^ a.m ^ a.K ^ a.d;
        }

        public int getK2() {
            F2m a;
            return a.K;
        }

        private /* synthetic */ F2m(int a, int a2, int a3, int a4, coN a5) {
            F2m a6;
            F2m f2m = a6;
            F2m f2m2 = a6;
            F2m f2m3 = a6;
            f2m3.j = a + 31 >> 5;
            f2m3.E = a5;
            f2m2.f = a;
            f2m2.m = a2;
            f2m.K = a3;
            f2m.d = a4;
            if (a3 == 0 && a4 == 0) {
                a6.extends = 2;
                return;
            }
            a6.extends = 3;
        }

        @Override
        public ECFieldElement divide(ECFieldElement a) {
            F2m a2;
            ECFieldElement eCFieldElement = a.invert();
            return a2.multiply(eCFieldElement);
        }

        @Override
        public ECFieldElement add(ECFieldElement a) {
            F2m a2;
            coN coN2 = (coN)a2.E.clone();
            F2m f2m = (F2m)a;
            coN2.abstract(f2m.E, 0);
            F2m f2m2 = a2;
            F2m f2m3 = a2;
            return new F2m(f2m2.f, f2m2.m, f2m3.K, f2m3.d, coN2);
        }

        public F2m(int a, int a2, BigInteger a3) {
            a4(a, a2, 0, 0, a3);
            F2m a4;
        }

        @Override
        public ECFieldElement square() {
            F2m a;
            F2m f2m = a;
            coN coN2 = f2m.E.long(f2m.f);
            int[] nArray = new int[3];
            nArray[0] = a.m;
            nArray[1] = a.K;
            nArray[2] = a.d;
            coN2.protected(a.f, nArray);
            F2m f2m2 = a;
            F2m f2m3 = a;
            return new F2m(f2m2.f, f2m2.m, f2m3.K, f2m3.d, coN2);
        }

        public F2m(int a, int a2, int a3, int a4, BigInteger a5) {
            BigInteger bigInteger;
            F2m a6;
            a6.j = a + 31 >> 5;
            F2m f2m = a6;
            a6.E = new coN(a5, a6.j);
            if (a3 == 0 && a4 == 0) {
                bigInteger = a5;
                a6.extends = 2;
            } else {
                if (a3 >= a4) {
                    throw new IllegalArgumentException(ASN1StreamParser.interface("/\u000bl\\\u0018c0\u0019/UeK Q*W9S,\u0005\u0006rtG.\u000b"));
                }
                if (a3 <= 0) {
                    throw new IllegalArgumentException(LicenseInfo.null("o\b\u0005vyAq\u001boV%WoBsO6ZRp3\u0002-\u0003"));
                }
                a6.extends = 3;
                bigInteger = a5;
            }
            if (bigInteger.signum() < 0) {
                throw new IllegalArgumentException(ASN1StreamParser.interface("<\u0019:P\u0001e!\u0019.Q+V\"DfY9\u0001b\u0014\trn\u000e3]"));
            }
            F2m f2m2 = a6;
            a6.f = a;
            f2m2.m = a2;
            f2m2.K = a3;
            a6.d = a4;
        }

        @Override
        public ECFieldElement sqrt() {
            throw new RuntimeException(LicenseInfo.null("}jO.YyZ(\u001fK}<\u0018hW"));
        }

        @Override
        public ECFieldElement multiply(ECFieldElement a) {
            F2m a2;
            Object object = (F2m)a;
            object = a2.E.final(((F2m)object).E, a2.f);
            int[] nArray = new int[3];
            nArray[0] = a2.m;
            nArray[1] = a2.K;
            nArray[2] = a2.d;
            ((coN)object).protected(a2.f, nArray);
            F2m f2m = a2;
            F2m f2m2 = a2;
            return new F2m(f2m.f, f2m.m, f2m2.K, f2m2.d, (coN)object);
        }

        public int getM() {
            F2m a;
            return a.f;
        }

        @Override
        public ECFieldElement negate() {
            F2m a;
            return a;
        }

        @Override
        public BigInteger toBigInteger() {
            F2m a;
            return a.E.package();
        }

        public boolean equals(Object a) {
            F2m a2;
            if (a == a2) {
                return true;
            }
            if (!(a instanceof F2m)) {
                return false;
            }
            F2m f2m = (F2m)a;
            return a2.f == f2m.f && a2.m == f2m.m && a2.K == f2m.K && a2.d == f2m.d && a2.extends == f2m.extends && a2.E.equals(f2m.E);
        }

        public int getK3() {
            F2m a;
            return a.d;
        }

        public static void checkFieldElements(ECFieldElement a, ECFieldElement a2) {
            if (!(a instanceof F2m) || !(a2 instanceof F2m)) {
                throw new IllegalArgumentException(ASN1StreamParser.interface("g-\\!T&\u001e)]$Q2U3\u001dg\t(\u0010%Yr[\u000f\u007f\u001f~Nz/O9Q*Z)BM\u007f\"\u0019\bs\u0003Q(\\\"~0Da\u0014\u0000g4!wU"));
            }
            F2m f2m = (F2m)a;
            F2m f2m2 = (F2m)a2;
            if (f2m.f != f2m2.f || f2m.m != f2m2.m || f2m.K != f2m2.K || f2m.d != f2m2.d) {
                throw new IllegalArgumentException(LicenseInfo.null("6dVm[4OdS#\u0015kOp\u001d/\u0002@;MrR8l[`Vi\\pI\u0005tj\u0012qSh\u0013vZcU4L-\u001fJ|r*?^"));
            }
            if (f2m.extends != f2m2.extends) {
                throw new IllegalArgumentException(ASN1StreamParser.interface("t%SqC-\u0016=\\>\u0006:H!U)\u0010c\u0017 U,Z(R`\\t\u001em^$B&\u001e\u0001u\u0006s\u0000g2\u001c%Q7\u0019%_\u000e\u007f6K(S1\u0018?U6I9Ri\u001f\u001arn\u000e*V"));
            }
        }

        @Override
        public int getFieldSize() {
            F2m a;
            return a.f;
        }

        @Override
        public ECFieldElement subtract(ECFieldElement a) {
            F2m a2;
            return a2.add(a);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class Fp
    extends ECFieldElement {
        BigInteger m;
        BigInteger byte;

        public Fp(BigInteger a, BigInteger a2) {
            Fp a3;
            a3.m = a2;
            if (a3.m.compareTo(a) >= 0) {
                throw new IllegalArgumentException(ECGOST3410NamedCurveTable.false("q\u0007^gmZm\u0006tAg\u0006oLkP,GBk=U8\u001ahN#HhOtR=\t"));
            }
            a3.byte = a;
        }

        @Override
        public ECFieldElement multiply(ECFieldElement a) {
            Fp a2;
            Fp fp = a2;
            return new Fp(fp.byte, fp.m.multiply(a.toBigInteger()).mod(a2.byte));
        }

        @Override
        public BigInteger toBigInteger() {
            Fp a;
            return a.m;
        }

        @Override
        public String getFieldName() {
            return IdGenerator.protected("w_");
        }

        @Override
        public ECFieldElement negate() {
            Fp a;
            Fp fp = a;
            return new Fp(fp.byte, fp.m.negate().mod(a.byte));
        }

        @Override
        public ECFieldElement divide(ECFieldElement a) {
            Fp a2;
            Fp fp = a2;
            return new Fp(fp.byte, fp.m.multiply(a.toBigInteger().modInverse(a2.byte)).mod(a2.byte));
        }

        public int hashCode() {
            Fp a;
            return a.byte.hashCode() ^ a.m.hashCode();
        }

        @Override
        public ECFieldElement invert() {
            Fp a;
            Fp fp = a;
            return new Fp(fp.byte, fp.m.modInverse(a.byte));
        }

        private static /* synthetic */ BigInteger[] const(BigInteger a, BigInteger a2, BigInteger a3, BigInteger a4) {
            BigInteger bigInteger = a4;
            int n = bigInteger.bitLength();
            int n2 = bigInteger.getLowestSetBit();
            BigInteger bigInteger2 = ECConstants.ONE;
            BigInteger bigInteger3 = ECConstants.TWO;
            BigInteger bigInteger4 = a2;
            BigInteger bigInteger5 = ECConstants.ONE;
            BigInteger bigInteger6 = ECConstants.ONE;
            int n3 = n = n - 1;
            while (n3 >= n2 + 1) {
                bigInteger5 = bigInteger5.multiply(bigInteger6).mod(a);
                if (a4.testBit(n)) {
                    bigInteger6 = bigInteger5.multiply(a3).mod(a);
                    bigInteger2 = bigInteger2.multiply(bigInteger4).mod(a);
                    BigInteger bigInteger7 = bigInteger4;
                    bigInteger3 = bigInteger7.multiply(bigInteger3).subtract(a2.multiply(bigInteger5)).mod(a);
                    bigInteger4 = bigInteger7.multiply(bigInteger7).subtract(bigInteger6.shiftLeft(1)).mod(a);
                } else {
                    bigInteger6 = bigInteger5;
                    bigInteger2 = bigInteger2.multiply(bigInteger3).subtract(bigInteger5).mod(a);
                    bigInteger4 = bigInteger4.multiply(bigInteger3).subtract(a2.multiply(bigInteger5)).mod(a);
                    BigInteger bigInteger8 = bigInteger3;
                    bigInteger3 = bigInteger8.multiply(bigInteger8).subtract(bigInteger5.shiftLeft(1)).mod(a);
                }
                n3 = --n;
            }
            bigInteger5 = bigInteger5.multiply(bigInteger6).mod(a);
            bigInteger6 = bigInteger5.multiply(a3).mod(a);
            bigInteger2 = bigInteger2.multiply(bigInteger3).subtract(bigInteger5).mod(a);
            BigInteger bigInteger9 = bigInteger5;
            bigInteger3 = bigInteger4.multiply(bigInteger3).subtract(a2.multiply(bigInteger9)).mod(a);
            bigInteger5 = bigInteger9.multiply(bigInteger6).mod(a);
            int n4 = n = 1;
            while (n4 <= n2) {
                bigInteger2 = bigInteger2.multiply(bigInteger3).mod(a);
                BigInteger bigInteger10 = bigInteger3;
                bigInteger3 = bigInteger10.multiply(bigInteger10).subtract(bigInteger5.shiftLeft(1)).mod(a);
                BigInteger bigInteger11 = bigInteger5;
                bigInteger5 = bigInteger11.multiply(bigInteger11).mod(a);
                n4 = ++n;
            }
            BigInteger[] bigIntegerArray = new BigInteger[2];
            bigIntegerArray[0] = bigInteger2;
            bigIntegerArray[1] = bigInteger3;
            return bigIntegerArray;
        }

        public boolean equals(Object a) {
            Fp a2;
            if (a == a2) {
                return true;
            }
            if (!(a instanceof Fp)) {
                return false;
            }
            Fp fp = (Fp)a;
            return a2.byte.equals(fp.byte) && a2.m.equals(fp.m);
        }

        @Override
        public ECFieldElement square() {
            Fp a;
            Fp fp = a;
            return new Fp(fp.byte, fp.m.multiply(a.m).mod(a.byte));
        }

        @Override
        public int getFieldSize() {
            Fp a;
            return a.byte.bitLength();
        }

        @Override
        public ECFieldElement sqrt() {
            Fp a;
            if (!a.byte.testBit(0)) {
                throw new RuntimeException(ECGOST3410NamedCurveTable.false("Eji\u0013z_rW?H|C"));
            }
            if (a.byte.testBit(1)) {
                Fp fp = a;
                Fp fp2 = new Fp(fp.byte, fp.m.modPow(a.byte.shiftRight(2).add(ECConstants.ONE), a.byte));
                if (((ECFieldElement)fp2).square().equals(a)) {
                    return fp2;
                }
                return null;
            }
            Fp fp = a;
            BigInteger bigInteger = fp.byte.subtract(ECConstants.ONE);
            BigInteger bigInteger2 = bigInteger.shiftRight(1);
            if (!fp.m.modPow(bigInteger2, a.byte).equals(ECConstants.ONE)) {
                return null;
            }
            BigInteger bigInteger3 = bigInteger.shiftRight(2).shiftLeft(1).add(ECConstants.ONE);
            BigInteger bigInteger4 = a.m;
            BigInteger bigInteger5 = bigInteger4.shiftLeft(2).mod(a.byte);
            Random random = new Random();
            while (true) {
                BigInteger bigInteger6;
                if ((bigInteger6 = new BigInteger(a.byte.bitLength(), random)).compareTo(a.byte) >= 0) {
                    continue;
                }
                BigInteger bigInteger7 = bigInteger6;
                if (!bigInteger7.multiply(bigInteger7).subtract(bigInteger5).modPow(bigInteger2, a.byte).equals(bigInteger)) continue;
                BigInteger[] bigIntegerArray = Fp.const(a.byte, bigInteger6, bigInteger4, bigInteger3);
                BigInteger bigInteger8 = bigIntegerArray[0];
                BigInteger bigInteger9 = bigIntegerArray[1];
                if (bigInteger9.multiply(bigInteger9).mod(a.byte).equals(bigInteger5)) {
                    if (bigInteger9.testBit(0)) {
                        bigInteger9 = bigInteger9.add(a.byte);
                    }
                    bigInteger9 = bigInteger9.shiftRight(1);
                    return new Fp(a.byte, bigInteger9);
                }
                if (!bigInteger8.equals(ECConstants.ONE) && !bigInteger8.equals(bigInteger)) break;
            }
            return null;
        }

        public BigInteger getQ() {
            Fp a;
            return a.byte;
        }

        @Override
        public ECFieldElement subtract(ECFieldElement a) {
            Fp a2;
            Fp fp = a2;
            return new Fp(fp.byte, fp.m.subtract(a.toBigInteger()).mod(a2.byte));
        }

        @Override
        public ECFieldElement add(ECFieldElement a) {
            Fp a2;
            Fp fp = a2;
            return new Fp(fp.byte, fp.m.add(a.toBigInteger()).mod(a2.byte));
        }
    }
}

