/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar;

import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.core.qr.QrImage;
import com.jxdinfo.hussar.core.util.DateTimeUtils;
import com.jxdinfo.hussar.core.util.ProductInfo;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.time.ZonedDateTime;
import java.util.Properties;
import java.util.regex.Pattern;
import java.util.zip.CRC32;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.io.VfsResource;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class CoreVersion {
    public static final String licCusHeaderRegex = "[\\u4E00-\\u9FA5A-Za-z0-9_-]+";
    private static Pattern versionPattern;
    public static String licFileName;
    private static String version;
    public static String licFileNameRegex;
    private static String frameworkVersion;
    private static String hussarFrameworkVersion;
    private static String cus_version;
    public static String licCusHeader;

    public static String getFrameworkVersion() {
        if (frameworkVersion == null) {
            Properties properties = new Properties();
            InputStream inputStream = CoreVersion.class.getClassLoader().getResourceAsStream(HussarException.volatile("\rb\u0013@*i\u0013{\u0000&\u001cw\u0002g\u001fz\u0019"));
            if (inputStream != null) {
                try {
                    properties.load(inputStream);
                    frameworkVersion = properties.getProperty(QrImage.true("bU|EaXg"));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        if (frameworkVersion == null) {
            frameworkVersion = HussarException.volatile("H:E;\u000f");
            return frameworkVersion;
        }
        return frameworkVersion;
    }

    public static String getFolderName() {
        return new StringBuilder().insert(0, HussarException.volatile("0\u0014")).append(Long.toHexString(CoreVersion.boolean(CoreVersion.getLicenseVersion().getBytes()))).toString();
    }

    public CoreVersion() {
        CoreVersion a;
    }

    public static String getVersion() {
        if (version == null) {
            Properties properties;
            Properties properties2 = new Properties();
            InputStream inputStream = CoreVersion.class.getClassLoader().getResourceAsStream(HussarException.volatile("}\u0013{\u000e&\u001cw\u0002g\u001fz\u0019"));
            try {
                properties2.load(inputStream);
                properties = properties2;
            }
            catch (IOException iOException) {
                properties = properties2;
                iOException.printStackTrace();
            }
            version = properties.getProperty(QrImage.true("bU|EaXg"));
        }
        return version;
    }

    private static /* synthetic */ long boolean(byte[] a) {
        CRC32 cRC32 = new CRC32();
        cRC32.update(a);
        return cRC32.getValue();
    }

    public static Pattern getVersionPatern() {
        return versionPattern;
    }

    public static String getDevFolderName() {
        return new StringBuilder().insert(0, QrImage.true("$Tf")).append(Long.toHexString(CoreVersion.boolean(CoreVersion.getLicenseVersion().getBytes()))).toString();
    }

    public static ZonedDateTime getDateTime() {
        URL uRL;
        block6: {
            String string;
            block5: {
                Class<CoreVersion> clazz;
                Class<CoreVersion> clazz2 = clazz = CoreVersion.class;
                Class<CoreVersion> clazz3 = clazz;
                uRL = clazz3.getResource(clazz3.getSimpleName() + ".class");
                if (!"file".equals(uRL.getProtocol())) break block5;
                return DateTimeUtils.zonedDateTimeOf(new File(uRL.toURI()).lastModified());
            }
            if (!"jar".equals(uRL.getProtocol())) break block6;
            String string2 = string = uRL.getPath();
            return DateTimeUtils.zonedDateTimeOf(new File(string2.substring(5, string2.indexOf(33))).lastModified());
        }
        try {
            if ("vfs".equals(uRL.getProtocol())) {
                File file = new VfsResource(uRL.openConnection().getContent()).getFile();
                return DateTimeUtils.zonedDateTimeOf(file.lastModified());
            }
        }
        catch (IOException | NullPointerException | URISyntaxException exception) {
            return ZonedDateTime.now();
        }
        return ZonedDateTime.now();
    }

    public static String getLicenseVersion() {
        if (StringUtils.isNotEmpty((CharSequence)cus_version)) {
            return cus_version;
        }
        return CoreVersion.getVersion();
    }

    public static String getHussaarFrameworkVersion() {
        if (hussarFrameworkVersion == null) {
            Properties properties = new Properties();
            InputStream inputStream = CoreVersion.class.getClassLoader().getResourceAsStream(QrImage.true("s@mbTKmY~\u0004bU|EaXg"));
            if (inputStream != null) {
                try {
                    properties.load(inputStream);
                    hussarFrameworkVersion = properties.getProperty(HussarException.volatile("\u001cw\u0002g\u001fz\u0019"));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        if (hussarFrameworkVersion == null) {
            hussarFrameworkVersion = QrImage.true("6\u0018;\u0019q");
            return hussarFrameworkVersion;
        }
        return hussarFrameworkVersion;
    }

    static {
        version = null;
        cus_version = ProductInfo.getCusVersion();
        frameworkVersion = ProductInfo.getFramewrokVersion();
        hussarFrameworkVersion = null;
        licFileNameRegex = "^[a-zA-Z][a-zA-Z0-9_]+\\.(lic|dat|conf|txt)$";
        licFileName = ProductInfo.getLicFileName();
        licCusHeader = ProductInfo.getLicCusHeader();
        versionPattern = Pattern.compile(HussarException.volatile("!08G+-?*;,w\b!'<)<+%Z+-$Dk\r"), 2);
    }

    public static String getSpecificationVersion() {
        return CoreVersion.class.getPackage().getSpecificationVersion();
    }
}

