/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.core.bouncycastle.math.ec;

import com.jxdinfo.hussar.core.bouncycastle.jce.ECGOST3410NamedCurveTable;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.ECConstants;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.aUX;
import com.jxdinfo.hussar.core.support.StrKit;
import com.jxdinfo.hussar.core.util.FileLoader;
import com.jxdinfo.hussar.core.util.ResKit;
import java.math.BigInteger;
import java.util.Random;

public abstract class ECFieldElement
implements ECConstants {
    public ECFieldElement() {
        ECFieldElement a;
    }

    public String toString() {
        ECFieldElement a;
        return a.toBigInteger().toString(2);
    }

    public abstract ECFieldElement sqrt();

    public abstract int getFieldSize();

    public abstract ECFieldElement invert();

    public abstract ECFieldElement square();

    public abstract ECFieldElement divide(ECFieldElement var1);

    public abstract ECFieldElement negate();

    public abstract String getFieldName();

    public abstract BigInteger toBigInteger();

    public abstract ECFieldElement add(ECFieldElement var1);

    public abstract ECFieldElement subtract(ECFieldElement var1);

    public abstract ECFieldElement multiply(ECFieldElement var1);

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class F2m
    extends ECFieldElement {
        private aUX C;
        private int d;
        private int A;
        public static final int PPB = 3;
        private int m;
        private int E;
        public static final int TPB = 2;
        private int J;
        public static final int GNB = 1;
        private int continue;

        @Override
        public ECFieldElement negate() {
            F2m a;
            return a;
        }

        public int getK3() {
            F2m a;
            return a.m;
        }

        public F2m(int a, int a2, int a3, int a4, BigInteger a5) {
            BigInteger bigInteger;
            F2m a6;
            a6.d = a + 31 >> 5;
            F2m f2m = a6;
            a6.C = new aUX(a5, a6.d);
            if (a3 == 0 && a4 == 0) {
                bigInteger = a5;
                a6.A = 2;
            } else {
                if (a3 >= a4) {
                    throw new IllegalArgumentException(FileLoader.case("_.\u001fzP~\u0001}uZC8Qu\u0001)]b\u001fcPqK-\u0004t"));
                }
                if (a3 <= 0) {
                    throw new IllegalArgumentException(ECGOST3410NamedCurveTable.catch("J\u0002\u001bG\u001e\t}8\u001f\t\u0002_\u0012\u0010ARS\u0010R_ZDQP"));
                }
                a6.A = 3;
                bigInteger = a5;
            }
            if (bigInteger.signum() < 0) {
                throw new IllegalArgumentException(FileLoader.case("L<IvIx\u0010}t^\r%S`M']0Qr_qQd\u0019\""));
            }
            F2m f2m2 = a6;
            a6.J = a;
            f2m2.E = a2;
            f2m2.continue = a3;
            a6.m = a4;
        }

        @Override
        public ECFieldElement add(ECFieldElement a) {
            F2m a2;
            aUX aUX2 = (aUX)a2.C.clone();
            F2m f2m = (F2m)a;
            aUX2.assert(f2m.C, 0);
            F2m f2m2 = a2;
            F2m f2m3 = a2;
            return new F2m(f2m2.J, f2m2.E, f2m3.continue, f2m3.m, aUX2);
        }

        public int getM() {
            F2m a;
            return a.J;
        }

        @Override
        public ECFieldElement sqrt() {
            throw new RuntimeException(ECGOST3410NamedCurveTable.catch("4fl]\u0005OCPHSJSX^N"));
        }

        @Override
        public ECFieldElement square() {
            F2m a;
            F2m f2m = a;
            aUX aUX2 = f2m.C.new(f2m.J);
            int[] nArray = new int[3];
            nArray[0] = a.E;
            nArray[1] = a.continue;
            nArray[2] = a.m;
            aUX2.switch(a.J, nArray);
            F2m f2m2 = a;
            F2m f2m3 = a;
            return new F2m(f2m2.J, f2m2.E, f2m3.continue, f2m3.m, aUX2);
        }

        @Override
        public int getFieldSize() {
            F2m a;
            return a.J;
        }

        @Override
        public ECFieldElement divide(ECFieldElement a) {
            F2m a2;
            ECFieldElement eCFieldElement = a.invert();
            return a2.multiply(eCFieldElement);
        }

        @Override
        public BigInteger toBigInteger() {
            F2m a;
            return a.C.float();
        }

        @Override
        public ECFieldElement subtract(ECFieldElement a) {
            F2m a2;
            return a2.add(a);
        }

        @Override
        public ECFieldElement multiply(ECFieldElement a) {
            F2m a2;
            Object object = (F2m)a;
            object = a2.C.volatile(((F2m)object).C, a2.J);
            int[] nArray = new int[3];
            nArray[0] = a2.E;
            nArray[1] = a2.continue;
            nArray[2] = a2.m;
            ((aUX)object).switch(a2.J, nArray);
            F2m f2m = a2;
            F2m f2m2 = a2;
            return new F2m(f2m.J, f2m.E, f2m2.continue, f2m2.m, (aUX)object);
        }

        private /* synthetic */ F2m(int a, int a2, int a3, int a4, aUX a5) {
            F2m a6;
            F2m f2m = a6;
            F2m f2m2 = a6;
            F2m f2m3 = a6;
            f2m3.d = a + 31 >> 5;
            f2m3.C = a5;
            f2m2.J = a;
            f2m2.E = a2;
            f2m.continue = a3;
            f2m.m = a4;
            if (a3 == 0 && a4 == 0) {
                a6.A = 2;
                return;
            }
            a6.A = 3;
        }

        public int hashCode() {
            F2m a;
            return a.C.hashCode() ^ a.J ^ a.E ^ a.continue ^ a.m;
        }

        public static void checkFieldElements(ECFieldElement a, ECFieldElement a2) {
            if (!(a instanceof F2m) || !(a2 instanceof F2m)) {
                throw new IllegalArgumentException(FileLoader.case("[}YQq\u0014yPqYyQcV-\u0014/r\u001f\r$H4PuMy\u0014u\\iNsy\\]c\u0014s[5p^RUXyPYPqYyQc\u000bK\u0010g"));
            }
            F2m f2m = (F2m)a;
            F2m f2m2 = (F2m)a2;
            if (f2m.J != f2m2.J || f2m.E != f2m2.E || f2m.continue != f2m2.continue || f2m.m != f2m2.m) {
                throw new IllegalArgumentException(ECGOST3410NamedCurveTable.catch("}KVF_\u0001UWO\u0006\u001fgl\u000eLCAI\u001dIY^\u001bIQAXlvRD\nTE\u0012_Ro;PSG^\u0002UC^MT\u001bl\u000e@"));
            }
            if (f2m.A != f2m2.A) {
                throw new IllegalArgumentException(FileLoader.case("s|_7P^0@tX5StqPY5QpYyQrKd\u0005l\u000787Q\f?\u001cq^\u007fTtZhA:Rsd\u001fQ~WsOgP~`\u001cOpDnYgQrKvQdMd"));
            }
        }

        public int getRepresentation() {
            F2m a;
            return a.A;
        }

        public int getK2() {
            F2m a;
            return a.continue;
        }

        @Override
        public String getFieldName() {
            return ECGOST3410NamedCurveTable.catch("u\u0018V");
        }

        @Override
        public ECFieldElement invert() {
            F2m a;
            aUX aUX2 = (aUX)a.C.clone();
            aUX aUX3 = new aUX(a.d);
            F2m f2m = a;
            aUX aUX4 = aUX3;
            aUX4.strictfp(a.J);
            aUX4.strictfp(0);
            aUX3.strictfp(f2m.E);
            if (f2m.A == 3) {
                aUX aUX5 = aUX3;
                aUX5.strictfp(a.continue);
                aUX5.strictfp(a.m);
            }
            aUX aUX6 = new aUX(a.d);
            aUX6.strictfp(0);
            aUX aUX7 = new aUX(a.d);
            aUX aUX8 = aUX2;
            while (!aUX8.transient()) {
                int n = aUX2.native() - aUX3.native();
                if (n < 0) {
                    aUX aUX9 = aUX2;
                    aUX2 = aUX3;
                    aUX3 = aUX9;
                    aUX aUX10 = aUX6;
                    aUX6 = aUX7;
                    aUX7 = aUX10;
                    n = -n;
                }
                int n2 = n >> 5;
                aUX aUX11 = aUX3.extends(n &= 0x1F);
                aUX aUX12 = aUX2;
                aUX8 = aUX12;
                aUX12.assert(aUX11, n2);
                aUX aUX13 = aUX7.extends(n);
                aUX6.assert(aUX13, n2);
            }
            F2m f2m2 = a;
            F2m f2m3 = a;
            return new F2m(f2m2.J, f2m2.E, f2m3.continue, f2m3.m, aUX7);
        }

        public F2m(int a, int a2, BigInteger a3) {
            a4(a, a2, 0, 0, a3);
            F2m a4;
        }

        public boolean equals(Object a) {
            F2m a2;
            if (a == a2) {
                return true;
            }
            if (!(a instanceof F2m)) {
                return false;
            }
            F2m f2m = (F2m)a;
            return a2.J == f2m.J && a2.E == f2m.E && a2.continue == f2m.continue && a2.m == f2m.m && a2.A == f2m.A && a2.C.equals(f2m.C);
        }

        public int getK1() {
            F2m a;
            return a.E;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class Fp
    extends ECFieldElement {
        BigInteger J;
        BigInteger package;

        public BigInteger getQ() {
            Fp a;
            return a.J;
        }

        @Override
        public int getFieldSize() {
            Fp a;
            return a.J.bitLength();
        }

        public boolean equals(Object a) {
            Fp a2;
            if (a == a2) {
                return true;
            }
            if (!(a instanceof Fp)) {
                return false;
            }
            Fp fp = (Fp)a;
            return a2.J.equals(fp.J) && a2.package.equals(fp.package);
        }

        @Override
        public ECFieldElement negate() {
            Fp a;
            Fp fp = a;
            return new Fp(fp.J, fp.package.negate().mod(a.J));
        }

        @Override
        public ECFieldElement invert() {
            Fp a;
            Fp fp = a;
            return new Fp(fp.J, fp.package.modInverse(a.J));
        }

        public Fp(BigInteger a, BigInteger a2) {
            Fp a3;
            a3.package = a2;
            if (a3.package.compareTo(a) >= 0) {
                throw new IllegalArgumentException(StrKit.return("f\u0000nGqVW,JoX)S`lGR)Wn\u0016nWeYo\u000ft\u0013$pFEa"));
            }
            a3.J = a;
        }

        @Override
        public ECFieldElement divide(ECFieldElement a) {
            Fp a2;
            Fp fp = a2;
            return new Fp(fp.J, fp.package.multiply(a.toBigInteger().modInverse(a2.J)).mod(a2.J));
        }

        @Override
        public ECFieldElement multiply(ECFieldElement a) {
            Fp a2;
            Fp fp = a2;
            return new Fp(fp.J, fp.package.multiply(a.toBigInteger()).mod(a2.J));
        }

        @Override
        public ECFieldElement subtract(ECFieldElement a) {
            Fp a2;
            Fp fp = a2;
            return new Fp(fp.J, fp.package.subtract(a.toBigInteger()).mod(a2.J));
        }

        private static /* synthetic */ BigInteger[] this(BigInteger a, BigInteger a2, BigInteger a3, BigInteger a4) {
            BigInteger bigInteger = a4;
            int n = bigInteger.bitLength();
            int n2 = bigInteger.getLowestSetBit();
            BigInteger bigInteger2 = ECConstants.ONE;
            BigInteger bigInteger3 = ECConstants.TWO;
            BigInteger bigInteger4 = a2;
            BigInteger bigInteger5 = ECConstants.ONE;
            BigInteger bigInteger6 = ECConstants.ONE;
            int n3 = n = n - 1;
            while (n3 >= n2 + 1) {
                bigInteger5 = bigInteger5.multiply(bigInteger6).mod(a);
                if (a4.testBit(n)) {
                    bigInteger6 = bigInteger5.multiply(a3).mod(a);
                    bigInteger2 = bigInteger2.multiply(bigInteger4).mod(a);
                    BigInteger bigInteger7 = bigInteger4;
                    bigInteger3 = bigInteger7.multiply(bigInteger3).subtract(a2.multiply(bigInteger5)).mod(a);
                    bigInteger4 = bigInteger7.multiply(bigInteger7).subtract(bigInteger6.shiftLeft(1)).mod(a);
                } else {
                    bigInteger6 = bigInteger5;
                    bigInteger2 = bigInteger2.multiply(bigInteger3).subtract(bigInteger5).mod(a);
                    bigInteger4 = bigInteger4.multiply(bigInteger3).subtract(a2.multiply(bigInteger5)).mod(a);
                    BigInteger bigInteger8 = bigInteger3;
                    bigInteger3 = bigInteger8.multiply(bigInteger8).subtract(bigInteger5.shiftLeft(1)).mod(a);
                }
                n3 = --n;
            }
            bigInteger5 = bigInteger5.multiply(bigInteger6).mod(a);
            bigInteger6 = bigInteger5.multiply(a3).mod(a);
            bigInteger2 = bigInteger2.multiply(bigInteger3).subtract(bigInteger5).mod(a);
            BigInteger bigInteger9 = bigInteger5;
            bigInteger3 = bigInteger4.multiply(bigInteger3).subtract(a2.multiply(bigInteger9)).mod(a);
            bigInteger5 = bigInteger9.multiply(bigInteger6).mod(a);
            int n4 = n = 1;
            while (n4 <= n2) {
                bigInteger2 = bigInteger2.multiply(bigInteger3).mod(a);
                BigInteger bigInteger10 = bigInteger3;
                bigInteger3 = bigInteger10.multiply(bigInteger10).subtract(bigInteger5.shiftLeft(1)).mod(a);
                BigInteger bigInteger11 = bigInteger5;
                bigInteger5 = bigInteger11.multiply(bigInteger11).mod(a);
                n4 = ++n;
            }
            BigInteger[] bigIntegerArray = new BigInteger[2];
            bigIntegerArray[0] = bigInteger2;
            bigIntegerArray[1] = bigInteger3;
            return bigIntegerArray;
        }

        @Override
        public ECFieldElement add(ECFieldElement a) {
            Fp a2;
            Fp fp = a2;
            return new Fp(fp.J, fp.package.add(a.toBigInteger()).mod(a2.J));
        }

        @Override
        public ECFieldElement square() {
            Fp a;
            Fp fp = a;
            return new Fp(fp.J, fp.package.multiply(a.package).mod(a.J));
        }

        @Override
        public ECFieldElement sqrt() {
            Fp a;
            if (!a.J.testBit(0)) {
                throw new RuntimeException(StrKit.return("PoA+K~\u0011$=ZNa"));
            }
            if (a.J.testBit(1)) {
                Fp fp = a;
                Fp fp2 = new Fp(fp.J, fp.package.modPow(a.J.shiftRight(2).add(ECConstants.ONE), a.J));
                if (((ECFieldElement)fp2).square().equals(a)) {
                    return fp2;
                }
                return null;
            }
            Fp fp = a;
            BigInteger bigInteger = fp.J.subtract(ECConstants.ONE);
            BigInteger bigInteger2 = bigInteger.shiftRight(1);
            if (!fp.package.modPow(bigInteger2, a.J).equals(ECConstants.ONE)) {
                return null;
            }
            BigInteger bigInteger3 = bigInteger.shiftRight(2).shiftLeft(1).add(ECConstants.ONE);
            BigInteger bigInteger4 = a.package;
            BigInteger bigInteger5 = bigInteger4.shiftLeft(2).mod(a.J);
            Random random = new Random();
            while (true) {
                BigInteger bigInteger6;
                if ((bigInteger6 = new BigInteger(a.J.bitLength(), random)).compareTo(a.J) >= 0) {
                    continue;
                }
                BigInteger bigInteger7 = bigInteger6;
                if (!bigInteger7.multiply(bigInteger7).subtract(bigInteger5).modPow(bigInteger2, a.J).equals(bigInteger)) continue;
                BigInteger[] bigIntegerArray = Fp.this(a.J, bigInteger6, bigInteger4, bigInteger3);
                BigInteger bigInteger8 = bigIntegerArray[0];
                BigInteger bigInteger9 = bigIntegerArray[1];
                if (bigInteger9.multiply(bigInteger9).mod(a.J).equals(bigInteger5)) {
                    if (bigInteger9.testBit(0)) {
                        bigInteger9 = bigInteger9.add(a.J);
                    }
                    bigInteger9 = bigInteger9.shiftRight(1);
                    return new Fp(a.J, bigInteger9);
                }
                if (!bigInteger8.equals(ECConstants.ONE) && !bigInteger8.equals(bigInteger)) break;
            }
            return null;
        }

        public int hashCode() {
            Fp a;
            return a.J.hashCode() ^ a.package.hashCode();
        }

        @Override
        public String getFieldName() {
            return ResKit.try("5_");
        }

        @Override
        public BigInteger toBigInteger() {
            Fp a;
            return a.package;
        }
    }
}

