/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.core.bouncycastle.math.ec;

import com.jxdinfo.hussar.core.HussarCoreAutoConfiguration;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.ECConstants;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.nul;
import com.jxdinfo.hussar.core.encrypt.file.util.StrKit;
import com.jxdinfo.hussar.core.util.ClassUtil;
import java.math.BigInteger;
import java.util.Random;

public abstract class ECFieldElement
implements ECConstants {
    public ECFieldElement() {
        ECFieldElement a;
    }

    public abstract ECFieldElement add(ECFieldElement var1);

    public abstract ECFieldElement invert();

    public abstract String getFieldName();

    public abstract ECFieldElement square();

    public abstract BigInteger toBigInteger();

    public abstract int getFieldSize();

    public abstract ECFieldElement negate();

    public abstract ECFieldElement multiply(ECFieldElement var1);

    public String toString() {
        ECFieldElement a;
        return a.toBigInteger().toString(2);
    }

    public abstract ECFieldElement subtract(ECFieldElement var1);

    public abstract ECFieldElement sqrt();

    public abstract ECFieldElement divide(ECFieldElement var1);

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class F2m
    extends ECFieldElement {
        private int F;
        private int b;
        private int J;
        private int m;
        public static final int GNB = 1;
        private nul j;
        public static final int TPB = 2;
        private int L;
        private int instanceof;
        public static final int PPB = 3;

        @Override
        public ECFieldElement negate() {
            F2m a;
            return a;
        }

        private /* synthetic */ F2m(int a, int a2, int a3, int a4, nul a5) {
            F2m a6;
            F2m f2m = a6;
            F2m f2m2 = a6;
            F2m f2m3 = a6;
            f2m3.m = a + 31 >> 5;
            f2m3.j = a5;
            f2m2.J = a;
            f2m2.F = a2;
            f2m.b = a3;
            f2m.L = a4;
            if (a3 == 0 && a4 == 0) {
                a6.instanceof = 2;
                return;
            }
            a6.instanceof = 3;
        }

        @Override
        public ECFieldElement square() {
            F2m a;
            F2m f2m = a;
            nul nul2 = f2m.j.void(f2m.J);
            int[] nArray = new int[3];
            nArray[0] = a.F;
            nArray[1] = a.b;
            nArray[2] = a.L;
            nul2.final(a.J, nArray);
            F2m f2m2 = a;
            F2m f2m3 = a;
            return new F2m(f2m2.J, f2m2.F, f2m3.b, f2m3.L, nul2);
        }

        public boolean equals(Object a) {
            F2m a2;
            if (a == a2) {
                return true;
            }
            if (!(a instanceof F2m)) {
                return false;
            }
            F2m f2m = (F2m)a;
            return a2.J == f2m.J && a2.F == f2m.F && a2.b == f2m.b && a2.L == f2m.L && a2.instanceof == f2m.instanceof && a2.j.equals(f2m.j);
        }

        public int getK3() {
            F2m a;
            return a.L;
        }

        @Override
        public ECFieldElement add(ECFieldElement a) {
            F2m a2;
            nul nul2 = (nul)a2.j.clone();
            F2m f2m = (F2m)a;
            nul2.try(f2m.j, 0);
            F2m f2m2 = a2;
            F2m f2m3 = a2;
            return new F2m(f2m2.J, f2m2.F, f2m3.b, f2m3.L, nul2);
        }

        public int getK1() {
            F2m a;
            return a.F;
        }

        public F2m(int a, int a2, int a3, int a4, BigInteger a5) {
            BigInteger bigInteger;
            F2m a6;
            a6.m = a + 31 >> 5;
            F2m f2m = a6;
            a6.j = new nul(a5, a6.m);
            if (a3 == 0 && a4 == 0) {
                bigInteger = a5;
                a6.instanceof = 2;
            } else {
                if (a3 >= a4) {
                    throw new IllegalArgumentException(StrKit.volatile("jd)3]\fuvj: $e>o8|<ijC\u001d1(kd"));
                }
                if (a3 <= 0) {
                    throw new IllegalArgumentException(HussarCoreAutoConfiguration.float("m\u001d\u0007c{Ts\u000emC'BmWqZ4OPe1\u0017/\u0016"));
                }
                a6.instanceof = 3;
                bigInteger = a5;
            }
            if (bigInteger.signum() < 0) {
                throw new IllegalArgumentException(StrKit.volatile("yv\u007f?D\ndvk>n9g+#6|n'{L\u001d+av2"));
            }
            F2m f2m2 = a6;
            a6.J = a;
            f2m2.F = a2;
            f2m2.b = a3;
            a6.L = a4;
        }

        @Override
        public ECFieldElement multiply(ECFieldElement a) {
            F2m a2;
            Object object = (F2m)a;
            object = a2.j.while(((F2m)object).j, a2.J);
            int[] nArray = new int[3];
            nArray[0] = a2.F;
            nArray[1] = a2.b;
            nArray[2] = a2.L;
            ((nul)object).final(a2.J, nArray);
            F2m f2m = a2;
            F2m f2m2 = a2;
            return new F2m(f2m.J, f2m.F, f2m2.b, f2m2.L, (nul)object);
        }

        public int getM() {
            F2m a;
            return a.J;
        }

        public int getK2() {
            F2m a;
            return a.b;
        }

        public F2m(int a, int a2, BigInteger a3) {
            a4(a, a2, 0, 0, a3);
            F2m a4;
        }

        @Override
        public ECFieldElement invert() {
            F2m a;
            nul nul2 = (nul)a.j.clone();
            nul nul3 = new nul(a.m);
            F2m f2m = a;
            nul nul4 = nul3;
            nul4.void(a.J);
            nul4.void(0);
            nul3.void(f2m.F);
            if (f2m.instanceof == 3) {
                nul nul5 = nul3;
                nul5.void(a.b);
                nul5.void(a.L);
            }
            nul nul6 = new nul(a.m);
            nul6.void(0);
            nul nul7 = new nul(a.m);
            nul nul8 = nul2;
            while (!nul8.transient()) {
                int n = nul2.boolean() - nul3.boolean();
                if (n < 0) {
                    nul nul9 = nul2;
                    nul2 = nul3;
                    nul3 = nul9;
                    nul nul10 = nul6;
                    nul6 = nul7;
                    nul7 = nul10;
                    n = -n;
                }
                int n2 = n >> 5;
                nul nul11 = nul3.synchronized(n &= 0x1F);
                nul nul12 = nul2;
                nul8 = nul12;
                nul12.try(nul11, n2);
                nul nul13 = nul7.synchronized(n);
                nul6.try(nul13, n2);
            }
            F2m f2m2 = a;
            F2m f2m3 = a;
            return new F2m(f2m2.J, f2m2.F, f2m3.b, f2m3.L, nul7);
        }

        @Override
        public ECFieldElement sqrt() {
            throw new RuntimeException(HussarCoreAutoConfiguration.float("hhZ,L{O*\nIh>\rjB"));
        }

        @Override
        public ECFieldElement divide(ECFieldElement a) {
            F2m a2;
            ECFieldElement eCFieldElement = a.invert();
            return a2.multiply(eCFieldElement);
        }

        public int getRepresentation() {
            F2m a;
            return a.instanceof;
        }

        @Override
        public ECFieldElement subtract(ECFieldElement a) {
            F2m a2;
            return a2.add(a);
        }

        public int hashCode() {
            F2m a;
            return a.j.hashCode() ^ a.J ^ a.F ^ a.b ^ a.L;
        }

        @Override
        public int getFieldSize() {
            F2m a;
            return a.J;
        }

        @Override
        public String getFieldName() {
            return HussarCoreAutoConfiguration.float("?=K");
        }

        @Override
        public BigInteger toBigInteger() {
            F2m a;
            return a.j.synchronized();
        }

        public static void checkFieldElements(ECFieldElement a, ECFieldElement a2) {
            if (!(a instanceof F2m) || !(a2 instanceof F2m)) {
                throw new IllegalArgumentException(StrKit.volatile("\bh3d;cql2a>w:vr\"fm\u007f`674J\u0010Z\u0011\u000b\u0015j |>o5l-\b\u0010gvM\u001cF>m3g\u0011u+${E\bqN2:"));
            }
            F2m f2m = (F2m)a;
            F2m f2m2 = (F2m)a2;
            if (f2m.J != f2m2.J || f2m.F != f2m2.F || f2m.b != f2m2.b || f2m.L != f2m2.L) {
                throw new IllegalArgumentException(HussarCoreAutoConfiguration.float("#fCoN6ZfF!\u0000iZr\b-\u0017B.OgP-nNbCkIr\\\u0007ah\u0007sFj\u0006tOa@6Y/\nHip?=K"));
            }
            if (f2m.instanceof != f2m2.instanceof) {
                throw new IllegalArgumentException(StrKit.volatile("\u001b`<4,hyx3{i\u007f'd:l\u007f&xe:i5m=%31q(1a-cqD\u001aC\u001cE\bws`>rv`0K\u0010s$m<twz:s&|=,p_\u001d+ao9"));
            }
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class Fp
    extends ECFieldElement {
        BigInteger L;
        BigInteger extends;

        @Override
        public ECFieldElement square() {
            Fp a;
            Fp fp = a;
            return new Fp(fp.L, fp.extends.multiply(a.extends).mod(a.L));
        }

        @Override
        public BigInteger toBigInteger() {
            Fp a;
            return a.extends;
        }

        @Override
        public ECFieldElement sqrt() {
            Fp a;
            if (!a.L.testBit(0)) {
                throw new RuntimeException(ClassUtil.null("|;m\u007fg*=p\u0011\u000eb5"));
            }
            if (a.L.testBit(1)) {
                Fp fp = a;
                Fp fp2 = new Fp(fp.L, fp.extends.modPow(a.L.shiftRight(2).add(ECConstants.ONE), a.L));
                if (((ECFieldElement)fp2).square().equals(a)) {
                    return fp2;
                }
                return null;
            }
            Fp fp = a;
            BigInteger bigInteger = fp.L.subtract(ECConstants.ONE);
            BigInteger bigInteger2 = bigInteger.shiftRight(1);
            if (!fp.extends.modPow(bigInteger2, a.L).equals(ECConstants.ONE)) {
                return null;
            }
            BigInteger bigInteger3 = bigInteger.shiftRight(2).shiftLeft(1).add(ECConstants.ONE);
            BigInteger bigInteger4 = a.extends;
            BigInteger bigInteger5 = bigInteger4.shiftLeft(2).mod(a.L);
            Random random = new Random();
            while (true) {
                BigInteger bigInteger6;
                if ((bigInteger6 = new BigInteger(a.L.bitLength(), random)).compareTo(a.L) >= 0) {
                    continue;
                }
                BigInteger bigInteger7 = bigInteger6;
                if (!bigInteger7.multiply(bigInteger7).subtract(bigInteger5).modPow(bigInteger2, a.L).equals(bigInteger)) continue;
                BigInteger[] bigIntegerArray = Fp.const(a.L, bigInteger6, bigInteger4, bigInteger3);
                BigInteger bigInteger8 = bigIntegerArray[0];
                BigInteger bigInteger9 = bigIntegerArray[1];
                if (bigInteger9.multiply(bigInteger9).mod(a.L).equals(bigInteger5)) {
                    if (bigInteger9.testBit(0)) {
                        bigInteger9 = bigInteger9.add(a.L);
                    }
                    bigInteger9 = bigInteger9.shiftRight(1);
                    return new Fp(a.L, bigInteger9);
                }
                if (!bigInteger8.equals(ECConstants.ONE) && !bigInteger8.equals(bigInteger)) break;
            }
            return null;
        }

        @Override
        public String getFieldName() {
            return HussarCoreAutoConfiguration.float("TK");
        }

        public BigInteger getQ() {
            Fp a;
            return a.L;
        }

        public boolean equals(Object a) {
            Fp a2;
            if (a == a2) {
                return true;
            }
            if (!(a instanceof Fp)) {
                return false;
            }
            Fp fp = (Fp)a;
            return a2.L.equals(fp.L) && a2.extends.equals(fp.extends);
        }

        @Override
        public ECFieldElement divide(ECFieldElement a) {
            Fp a2;
            Fp fp = a2;
            return new Fp(fp.L, fp.extends.multiply(a.toBigInteger().modInverse(a2.L)).mod(a2.L));
        }

        @Override
        public int getFieldSize() {
            Fp a;
            return a.L.bitLength();
        }

        @Override
        public ECFieldElement add(ECFieldElement a) {
            Fp a2;
            Fp fp = a2;
            return new Fp(fp.L, fp.extends.add(a.toBigInteger()).mod(a2.L));
        }

        private static /* synthetic */ BigInteger[] const(BigInteger a, BigInteger a2, BigInteger a3, BigInteger a4) {
            BigInteger bigInteger = a4;
            int n = bigInteger.bitLength();
            int n2 = bigInteger.getLowestSetBit();
            BigInteger bigInteger2 = ECConstants.ONE;
            BigInteger bigInteger3 = ECConstants.TWO;
            BigInteger bigInteger4 = a2;
            BigInteger bigInteger5 = ECConstants.ONE;
            BigInteger bigInteger6 = ECConstants.ONE;
            int n3 = n = n - 1;
            while (n3 >= n2 + 1) {
                bigInteger5 = bigInteger5.multiply(bigInteger6).mod(a);
                if (a4.testBit(n)) {
                    bigInteger6 = bigInteger5.multiply(a3).mod(a);
                    bigInteger2 = bigInteger2.multiply(bigInteger4).mod(a);
                    BigInteger bigInteger7 = bigInteger4;
                    bigInteger3 = bigInteger7.multiply(bigInteger3).subtract(a2.multiply(bigInteger5)).mod(a);
                    bigInteger4 = bigInteger7.multiply(bigInteger7).subtract(bigInteger6.shiftLeft(1)).mod(a);
                } else {
                    bigInteger6 = bigInteger5;
                    bigInteger2 = bigInteger2.multiply(bigInteger3).subtract(bigInteger5).mod(a);
                    bigInteger4 = bigInteger4.multiply(bigInteger3).subtract(a2.multiply(bigInteger5)).mod(a);
                    BigInteger bigInteger8 = bigInteger3;
                    bigInteger3 = bigInteger8.multiply(bigInteger8).subtract(bigInteger5.shiftLeft(1)).mod(a);
                }
                n3 = --n;
            }
            bigInteger5 = bigInteger5.multiply(bigInteger6).mod(a);
            bigInteger6 = bigInteger5.multiply(a3).mod(a);
            bigInteger2 = bigInteger2.multiply(bigInteger3).subtract(bigInteger5).mod(a);
            BigInteger bigInteger9 = bigInteger5;
            bigInteger3 = bigInteger4.multiply(bigInteger3).subtract(a2.multiply(bigInteger9)).mod(a);
            bigInteger5 = bigInteger9.multiply(bigInteger6).mod(a);
            int n4 = n = 1;
            while (n4 <= n2) {
                bigInteger2 = bigInteger2.multiply(bigInteger3).mod(a);
                BigInteger bigInteger10 = bigInteger3;
                bigInteger3 = bigInteger10.multiply(bigInteger10).subtract(bigInteger5.shiftLeft(1)).mod(a);
                BigInteger bigInteger11 = bigInteger5;
                bigInteger5 = bigInteger11.multiply(bigInteger11).mod(a);
                n4 = ++n;
            }
            BigInteger[] bigIntegerArray = new BigInteger[2];
            bigIntegerArray[0] = bigInteger2;
            bigIntegerArray[1] = bigInteger3;
            return bigIntegerArray;
        }

        public int hashCode() {
            Fp a;
            return a.L.hashCode() ^ a.extends.hashCode();
        }

        @Override
        public ECFieldElement subtract(ECFieldElement a) {
            Fp a2;
            Fp fp = a2;
            return new Fp(fp.L, fp.extends.subtract(a.toBigInteger()).mod(a2.L));
        }

        @Override
        public ECFieldElement multiply(ECFieldElement a) {
            Fp a2;
            Fp fp = a2;
            return new Fp(fp.L, fp.extends.multiply(a.toBigInteger()).mod(a2.L));
        }

        @Override
        public ECFieldElement invert() {
            Fp a;
            Fp fp = a;
            return new Fp(fp.L, fp.extends.modInverse(a.L));
        }

        public Fp(BigInteger a, BigInteger a2) {
            Fp a3;
            a3.extends = a2;
            if (a3.extends.compareTo(a) >= 0) {
                throw new IllegalArgumentException(ClassUtil.null("JTB\u0013]\u0002{xf;t}\u007f4@\u0013~}{:::{1u;# ?p\\\u0012i5"));
            }
            a3.L = a;
        }

        @Override
        public ECFieldElement negate() {
            Fp a;
            Fp fp = a;
            return new Fp(fp.L, fp.extends.negate().mod(a.L));
        }
    }
}

