/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.core.bouncycastle.asn1.x509;

import com.jxdinfo.hussar.core.bouncycastle.asn1.ASN1Encodable;
import com.jxdinfo.hussar.core.bouncycastle.asn1.ASN1EncodableVector;
import com.jxdinfo.hussar.core.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.jxdinfo.hussar.core.bouncycastle.asn1.ASN1Sequence;
import com.jxdinfo.hussar.core.bouncycastle.asn1.ASN1TaggedObject;
import com.jxdinfo.hussar.core.bouncycastle.asn1.DEREncodable;
import com.jxdinfo.hussar.core.bouncycastle.asn1.DERNull;
import com.jxdinfo.hussar.core.bouncycastle.asn1.DERObject;
import com.jxdinfo.hussar.core.bouncycastle.asn1.DERObjectIdentifier;
import com.jxdinfo.hussar.core.bouncycastle.asn1.DERSequence;
import com.jxdinfo.hussar.core.encrypt.file.util.StrKit;
import com.jxdinfo.hussar.core.qr.QrImage;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class AlgorithmIdentifier
extends ASN1Encodable {
    private boolean j;
    private DERObjectIdentifier L;
    private DEREncodable int;

    @Override
    public DERObject toASN1Object() {
        AlgorithmIdentifier a;
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        AlgorithmIdentifier algorithmIdentifier = a;
        aSN1EncodableVector.add(algorithmIdentifier.L);
        if (algorithmIdentifier.j) {
            if (a.int != null) {
                aSN1EncodableVector.add(a.int);
            } else {
                aSN1EncodableVector.add(DERNull.INSTANCE);
            }
        }
        return new DERSequence(aSN1EncodableVector);
    }

    public AlgorithmIdentifier(ASN1Sequence a) {
        AlgorithmIdentifier a2;
        a2.j = false;
        if (a.size() < 1 || a.size() > 2) {
            throw new IllegalArgumentException(new StringBuilder().insert(0, StrKit.volatile("1h:(,f%l+j0n|w:r:%h")).append(a.size()).toString());
        }
        a2.L = DERObjectIdentifier.getInstance(a.getObjectAt(0));
        if (a.size() == 2) {
            AlgorithmIdentifier algorithmIdentifier = a2;
            algorithmIdentifier.j = true;
            algorithmIdentifier.int = a.getObjectAt(1);
            return;
        }
        a2.int = null;
    }

    public DEREncodable getParameters() {
        AlgorithmIdentifier a;
        return a.int;
    }

    public static AlgorithmIdentifier getInstance(ASN1TaggedObject a, boolean a2) {
        return AlgorithmIdentifier.getInstance(ASN1Sequence.getInstance(a, a2));
    }

    public static AlgorithmIdentifier getInstance(Object a) {
        if (a == null || a instanceof AlgorithmIdentifier) {
            return (AlgorithmIdentifier)a;
        }
        if (a instanceof DERObjectIdentifier) {
            return new AlgorithmIdentifier((DERObjectIdentifier)a);
        }
        if (a instanceof String) {
            return new AlgorithmIdentifier((String)a);
        }
        if (a instanceof ASN1Sequence) {
            return new AlgorithmIdentifier((ASN1Sequence)a);
        }
        throw new IllegalArgumentException(new StringBuilder().insert(0, QrImage.super(" (2?!35f65\"\u000f\u00169r9!w.#>9=2&|y")).append(a.getClass().getName()).toString());
    }

    public ASN1ObjectIdentifier getAlgorithm() {
        AlgorithmIdentifier a;
        return new ASN1ObjectIdentifier(a.L.getId());
    }

    public AlgorithmIdentifier(DERObjectIdentifier a) {
        AlgorithmIdentifier a2;
        AlgorithmIdentifier algorithmIdentifier = a2;
        algorithmIdentifier.j = false;
        algorithmIdentifier.L = a;
    }

    public AlgorithmIdentifier(String a) {
        AlgorithmIdentifier a2;
        a2.j = false;
        AlgorithmIdentifier algorithmIdentifier = a2;
        a2.L = new DERObjectIdentifier(a);
    }

    public AlgorithmIdentifier(DERObjectIdentifier a, DEREncodable a2) {
        AlgorithmIdentifier a3;
        AlgorithmIdentifier algorithmIdentifier = a3;
        AlgorithmIdentifier algorithmIdentifier2 = a3;
        algorithmIdentifier2.j = false;
        algorithmIdentifier2.j = true;
        algorithmIdentifier.L = a;
        algorithmIdentifier.int = a2;
    }

    public DERObjectIdentifier getObjectId() {
        AlgorithmIdentifier a;
        return a.L;
    }
}

