/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar;

import com.jxdinfo.hussar.core.auto.common.TypeHelper;
import com.jxdinfo.hussar.core.util.DateTimeUtils;
import com.jxdinfo.hussar.core.util.IdGenerator;
import com.jxdinfo.hussar.core.util.ProductInfo;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.time.ZonedDateTime;
import java.util.Properties;
import java.util.regex.Pattern;
import java.util.zip.CRC32;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.VfsResource;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class CoreVersion {
    public static String licFileName;
    private static final Logger LOGGER;
    private static String version;
    public static String licFileNameRegex;
    public static String licCusHeader;
    private static Pattern versionPattern;
    private static String frameworkVersion;
    public static final String licCusHeaderRegex = "[\\u3000-\\u303F\\p{P}\\p{IsHan}\\u4E00-\\u9FA5A-Za-z0-9_-]+";
    private static String cus_version;
    private static String hussarFrameworkVersion;

    private static /* synthetic */ long final(byte[] a) {
        CRC32 cRC32 = new CRC32();
        cRC32.update(a);
        return cRC32.getValue();
    }

    static {
        LOGGER = LoggerFactory.getLogger(CoreVersion.class);
        version = null;
        cus_version = ProductInfo.getCusVersion();
        frameworkVersion = ProductInfo.getFramewrokVersion();
        hussarFrameworkVersion = null;
        licFileNameRegex = "^[a-zA-Z][a-zA-Z0-9_]+\\.(lic|dat|conf|txt)$";
        licFileName = ProductInfo.getLicFileName();
        licCusHeader = ProductInfo.getLicCusHeader();
        versionPattern = Pattern.compile(IdGenerator.instanceof("1o(\u0018;r/u+sgW1x,v,t5\u0005;r4\u001b{R"), 2);
    }

    public static String getFrameworkVersion() {
        if (frameworkVersion == null) {
            Properties properties = new Properties();
            InputStream inputStream = CoreVersion.class.getClassLoader().getResourceAsStream(TypeHelper.while("d\u001dt1C\u0018z\niWu\u0006k\u0016v\u000bp"));
            if (inputStream != null) {
                try {
                    properties.load(inputStream);
                    frameworkVersion = properties.getProperty(IdGenerator.instanceof("Cg]w@jF"));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        if (frameworkVersion == null) {
            frameworkVersion = TypeHelper.while("!K,Jf");
            return frameworkVersion;
        }
        return frameworkVersion;
    }

    public static ZonedDateTime getDateTime() {
        URL uRL;
        block6: {
            String string;
            block5: {
                Class<CoreVersion> clazz;
                Class<CoreVersion> clazz2 = clazz = CoreVersion.class;
                Class<CoreVersion> clazz3 = clazz;
                uRL = clazz3.getResource(clazz3.getSimpleName() + ".class");
                if (!"file".equals(uRL.getProtocol())) break block5;
                return DateTimeUtils.zonedDateTimeOf(new File(uRL.toURI()).lastModified());
            }
            if (!"jar".equals(uRL.getProtocol())) break block6;
            String string2 = string = uRL.getPath();
            return DateTimeUtils.zonedDateTimeOf(new File(string2.substring(5, string2.indexOf(33))).lastModified());
        }
        try {
            if ("vfs".equals(uRL.getProtocol())) {
                File file = new VfsResource(uRL.openConnection().getContent()).getFile();
                return DateTimeUtils.zonedDateTimeOf(file.lastModified());
            }
        }
        catch (IOException | NullPointerException | URISyntaxException exception) {
            return ZonedDateTime.now();
        }
        LOGGER.warn(TypeHelper.while("K\u0002~\u0004q@2\u0007|_p\u000boYs\u0019~\fmG1%\tED\u0003\u007f25.C\u001cz\rp\u001afY9>d\u0019C"), (Object)uRL.getProtocol(), (Object)uRL);
        return ZonedDateTime.now();
    }

    public static String getFolderName() {
        return new StringBuilder().insert(0, TypeHelper.while("Jv")).append(Long.toHexString(CoreVersion.final(CoreVersion.getLicenseVersion().getBytes()))).toString();
    }

    public static String getHussaarFrameworkVersion() {
        if (hussarFrameworkVersion == null) {
            Properties properties = new Properties();
            InputStream inputStream = CoreVersion.class.getClassLoader().getResourceAsStream(IdGenerator.instanceof("RrLPuyLk_6Cg]w@jF"));
            if (inputStream != null) {
                try {
                    properties.load(inputStream);
                    hussarFrameworkVersion = properties.getProperty(TypeHelper.while("u\u0006k\u0016v\u000bp"));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        if (hussarFrameworkVersion == null) {
            hussarFrameworkVersion = IdGenerator.instanceof("\u0017*\u001a+P");
            return hussarFrameworkVersion;
        }
        return hussarFrameworkVersion;
    }

    public static String getLicenseVersion() {
        if (StringUtils.isNotEmpty((CharSequence)cus_version)) {
            return cus_version;
        }
        return CoreVersion.getVersion();
    }

    public CoreVersion() {
        CoreVersion a;
    }

    public static String getSpecificationVersion() {
        return CoreVersion.class.getPackage().getSpecificationVersion();
    }

    public static String getVersion() {
        if (version == null) {
            Properties properties;
            Properties properties2 = new Properties();
            InputStream inputStream = CoreVersion.class.getClassLoader().getResourceAsStream(TypeHelper.while("\fz\ngWu\u0006k\u0016v\u000bp"));
            try {
                properties2.load(inputStream);
                properties = properties2;
            }
            catch (IOException iOException) {
                properties = properties2;
                iOException.printStackTrace();
            }
            version = properties.getProperty(IdGenerator.instanceof("Cg]w@jF"));
        }
        return version;
    }

    public static String getDevFolderName() {
        return new StringBuilder().insert(0, IdGenerator.instanceof("\u0005fG")).append(Long.toHexString(CoreVersion.final(CoreVersion.getLicenseVersion().getBytes()))).toString();
    }

    public static Pattern getVersionPatern() {
        return versionPattern;
    }
}

