/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.core.bouncycastle.math.ec;

import com.jxdinfo.hussar.core.bouncycastle.asn1.ASN1StreamParser;
import com.jxdinfo.hussar.core.bouncycastle.asn1.x9.X9IntegerConverter;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.CON;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.ECConstants;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.ECCurve;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.ECFieldElement;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.NUl;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.nUL;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.nuL;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.nul;
import com.jxdinfo.hussar.core.encrypt.file.util.FileUtil;
import com.jxdinfo.hussar.core.qr.QrImage;
import com.jxdinfo.hussar.core.support.WafKit;
import java.math.BigInteger;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class ECPoint {
    protected nuL multiplier;
    protected CON preCompInfo;
    private static X9IntegerConverter A = new X9IntegerConverter();
    protected boolean withCompression;
    ECFieldElement J;
    ECFieldElement D;
    ECCurve transient;

    public abstract byte[] getEncoded();

    public ECFieldElement getX() {
        ECPoint a;
        return a.D;
    }

    public int hashCode() {
        ECPoint a;
        if (a.isInfinity()) {
            return 0;
        }
        return a.D.hashCode() ^ a.J.hashCode();
    }

    public abstract ECPoint add(ECPoint var1);

    public ECFieldElement getY() {
        ECPoint a;
        return a.J;
    }

    public boolean isCompressed() {
        ECPoint a;
        return a.withCompression;
    }

    public abstract ECPoint subtract(ECPoint var1);

    public abstract ECPoint negate();

    public abstract ECPoint twice();

    public ECCurve getCurve() {
        ECPoint a;
        return a.transient;
    }

    protected ECPoint(ECCurve a, ECFieldElement a2, ECFieldElement a3) {
        ECPoint a4;
        ECPoint eCPoint = a4;
        ECPoint eCPoint2 = a4;
        a4.multiplier = null;
        eCPoint2.preCompInfo = null;
        eCPoint2.transient = a;
        eCPoint.D = a2;
        eCPoint.J = a3;
    }

    void int(CON a) {
        a.preCompInfo = a;
    }

    public boolean equals(Object a) {
        ECPoint a2;
        if (a == a2) {
            return true;
        }
        if (!(a instanceof ECPoint)) {
            return false;
        }
        a = (ECPoint)a;
        if (a2.isInfinity()) {
            return ((ECPoint)a).isInfinity();
        }
        return a2.D.equals(((ECPoint)a).D) && a2.J.equals(((ECPoint)a).J);
    }

    synchronized void char() {
        ECPoint a;
        if (a.multiplier == null) {
            ECPoint eCPoint = a;
            eCPoint.multiplier = new NUl();
        }
    }

    public ECPoint multiply(BigInteger a) {
        ECPoint a2;
        if (a.signum() < 0) {
            throw new IllegalArgumentException(QrImage.for("\u001de%$f:$x-p=|.h\u007f 2$%ce!\u000fPF@\u0010\u0011$k+i?f'p"));
        }
        if (a2.isInfinity()) {
            return a2;
        }
        if (a.signum() == 0) {
            return a2.transient.getInfinity();
        }
        ECPoint eCPoint = a2;
        eCPoint.char();
        ECPoint eCPoint2 = a2;
        return eCPoint.multiplier.enum(eCPoint2, a, eCPoint2.preCompInfo);
    }

    public boolean isInfinity() {
        ECPoint a;
        return a.D == null && a.J == null;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class F2m
    extends ECPoint {
        public F2m(ECCurve a, ECFieldElement a2, ECFieldElement a3, boolean a4) {
            F2m a5;
            ECFieldElement eCFieldElement = a2;
            super(a, eCFieldElement, a3);
            if (eCFieldElement != null && a3 == null || a2 == null && a3 != null) {
                throw new IllegalArgumentException(FileUtil.new("]D2Y!\u001ba<\u001ct\u0010)\tPyD7RxK+\u0018~{P\u000ehQ6\u0000dD,\u00171C\u007fC7\u000bd"));
            }
            if (a2 != null) {
                F2m f2m = a5;
                ECFieldElement.F2m.checkFieldElements(f2m.D, f2m.J);
                if (a != null) {
                    F2m f2m2 = a5;
                    ECFieldElement.F2m.checkFieldElements(f2m2.D, f2m2.transient.getA());
                }
            }
            a5.withCompression = a4;
        }

        public F2m subtractSimple(F2m a) {
            F2m a2;
            if (a.isInfinity()) {
                return a2;
            }
            return a2.addSimple((F2m)a.negate());
        }

        private static /* synthetic */ void this(ECPoint a, ECPoint a2) {
            if (!a.transient.equals(a2.transient)) {
                throw new IllegalArgumentException(ASN1StreamParser.extends("d\u0011]\u001c\u000b\u000fF\u0014U\u001bOHK\u001e\r\r\u000eW\u0005\u0002H\u0010YHC\u0001\u0014DHYH\u001e\b\u0012o<+>|(B\u0017\u0001\u001aTRO\u001d\u000eL|;\u0019Z@\u0015"));
            }
        }

        public F2m(ECCurve a, ECFieldElement a2, ECFieldElement a3) {
            a4(a, a2, a3, false);
            F2m a4;
        }

        @Override
        public ECPoint negate() {
            F2m a;
            return new F2m(a.transient, a.getX(), a.getY().add(a.getX()), a.withCompression);
        }

        @Override
        public ECPoint subtract(ECPoint a) {
            F2m a2;
            F2m f2m = a2;
            F2m.this(f2m, a);
            return f2m.subtractSimple((F2m)a);
        }

        public F2m addSimple(F2m a) {
            F2m a2;
            Object object = a;
            if (a2.isInfinity()) {
                return object;
            }
            if (((ECPoint)object).isInfinity()) {
                return a2;
            }
            ECFieldElement.F2m f2m = (ECFieldElement.F2m)((ECPoint)object).getX();
            object = (ECFieldElement.F2m)((ECPoint)object).getY();
            if (a2.D.equals(f2m)) {
                if (a2.J.equals(object)) {
                    return (F2m)a2.twice();
                }
                return (F2m)a2.transient.getInfinity();
            }
            object = (ECFieldElement.F2m)a2.J.add((ECFieldElement)object).divide(a2.D.add(f2m));
            f2m = (ECFieldElement.F2m)((ECFieldElement.F2m)object).square().add((ECFieldElement)object).add(a2.D).add(f2m).add(a2.transient.getA());
            object = (ECFieldElement.F2m)((ECFieldElement.F2m)object).multiply(a2.D.add(f2m)).add(f2m).add(a2.J);
            return new F2m(a2.transient, f2m, (ECFieldElement)object, a2.withCompression);
        }

        @Override
        public ECPoint twice() {
            F2m a;
            if (a.isInfinity()) {
                return a;
            }
            if (a.D.toBigInteger().signum() == 0) {
                return a.transient.getInfinity();
            }
            F2m f2m = a;
            ECFieldElement.F2m f2m2 = (ECFieldElement.F2m)f2m.D.add(f2m.J.divide(a.D));
            ECFieldElement.F2m f2m3 = (ECFieldElement.F2m)f2m2.square().add(f2m2).add(a.transient.getA());
            F2m f2m4 = a;
            ECFieldElement eCFieldElement = f2m4.transient.fromBigInteger(ECConstants.ONE);
            eCFieldElement = (ECFieldElement.F2m)f2m4.D.square().add(f2m3.multiply(f2m2.add(eCFieldElement)));
            return new F2m(a.transient, f2m3, eCFieldElement, a.withCompression);
        }

        @Override
        synchronized void char() {
            F2m a;
            if (a.multiplier == null) {
                if (((ECCurve.F2m)a.transient).isKoblitz()) {
                    F2m f2m = a;
                    f2m.multiplier = new nul();
                    return;
                }
                a.multiplier = new nUL();
            }
        }

        @Override
        public byte[] getEncoded() {
            F2m a;
            if (a.isInfinity()) {
                return new byte[1];
            }
            int n = A.getByteLength(a.D);
            byte[] byArray = A.integerToBytes(a.getX().toBigInteger(), n);
            if (a.withCompression) {
                byte[] byArray2 = new byte[n + 1];
                byArray2[0] = 2;
                if (!a.getX().toBigInteger().equals(ECConstants.ZERO) && a.getY().multiply(a.getX().invert()).toBigInteger().testBit(0)) {
                    byArray2[0] = 3;
                }
                System.arraycopy(byArray, 0, byArray2, 1, n);
                return byArray2;
            }
            byte[] byArray3 = A.integerToBytes(a.getY().toBigInteger(), n);
            int n2 = n;
            byte[] byArray4 = new byte[n2 + n2 + 1];
            byArray4[0] = 4;
            System.arraycopy(byArray, 0, byArray4, 1, n);
            System.arraycopy(byArray3, 0, byArray4, n + 1, n);
            return byArray4;
        }

        @Override
        public ECPoint add(ECPoint a) {
            F2m a2;
            F2m f2m = a2;
            F2m.this(f2m, a);
            return f2m.addSimple((F2m)a);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class Fp
    extends ECPoint {
        @Override
        synchronized void char() {
            Fp a;
            if (a.multiplier == null) {
                Fp fp = a;
                fp.multiplier = new nUL();
            }
        }

        @Override
        public ECPoint negate() {
            Fp a;
            Fp fp = a;
            return new Fp(fp.transient, fp.D, a.J.negate(), a.withCompression);
        }

        @Override
        public ECPoint subtract(ECPoint a) {
            Fp a2;
            if (a.isInfinity()) {
                return a2;
            }
            return a2.add(a.negate());
        }

        public Fp(ECCurve a, ECFieldElement a2, ECFieldElement a3, boolean a4) {
            Fp a5;
            ECFieldElement eCFieldElement = a2;
            super(a, eCFieldElement, a3);
            if (eCFieldElement != null && a3 == null || a2 == null && a3 != null) {
                throw new IllegalArgumentException(WafKit.synchronized(">O\u0013\u001fMS\u0003\u0013\u0019H\u0006\u001a\u0010\u001a\u0019C\u001aTT\u001aPr>utg+X\u0015^\u0010H\n\u0006\n\u0005\u0013z$N\u000b"));
            }
            a5.withCompression = a4;
        }

        @Override
        public ECPoint add(ECPoint a) {
            Fp a2;
            if (a2.isInfinity()) {
                return a;
            }
            if (a.isInfinity()) {
                return a2;
            }
            if (a2.D.equals(a.D)) {
                if (a2.J.equals(a.J)) {
                    return a2.twice();
                }
                return a2.transient.getInfinity();
            }
            ECFieldElement eCFieldElement = a.J.subtract(a2.J).divide(a.D.subtract(a2.D));
            ECFieldElement eCFieldElement2 = eCFieldElement.square().subtract(a2.D).subtract(a.D);
            ECFieldElement eCFieldElement3 = eCFieldElement.multiply(a2.D.subtract(eCFieldElement2)).subtract(a2.J);
            return new Fp(a2.transient, eCFieldElement2, eCFieldElement3);
        }

        @Override
        public byte[] getEncoded() {
            Fp a;
            if (a.isInfinity()) {
                return new byte[1];
            }
            int n = A.getByteLength(a.D);
            if (a.withCompression) {
                int n2 = a.getY().toBigInteger().testBit(0) ? 3 : 2;
                byte[] byArray = A.integerToBytes(a.getX().toBigInteger(), n);
                byte[] byArray2 = new byte[byArray.length + 1];
                byArray2[0] = n2;
                System.arraycopy(byArray, 0, byArray2, 1, byArray.length);
                return byArray2;
            }
            byte[] byArray = A.integerToBytes(a.getX().toBigInteger(), n);
            byte[] byArray3 = A.integerToBytes(a.getY().toBigInteger(), n);
            byte[] byArray4 = new byte[byArray.length + byArray3.length + 1];
            byArray4[0] = 4;
            System.arraycopy(byArray, 0, byArray4, 1, byArray.length);
            System.arraycopy(byArray3, 0, byArray4, byArray.length + 1, byArray3.length);
            return byArray4;
        }

        @Override
        public ECPoint twice() {
            Fp a;
            if (a.isInfinity()) {
                return a;
            }
            if (a.J.toBigInteger().signum() == 0) {
                return a.transient.getInfinity();
            }
            Fp fp = a;
            ECFieldElement eCFieldElement = fp.transient.fromBigInteger(BigInteger.valueOf(2L));
            ECFieldElement eCFieldElement2 = fp.transient.fromBigInteger(BigInteger.valueOf(3L));
            ECFieldElement eCFieldElement3 = fp.D.square().multiply(eCFieldElement2).add(a.transient.public).divide(a.J.multiply(eCFieldElement));
            eCFieldElement2 = eCFieldElement3.square().subtract(a.D.multiply(eCFieldElement));
            ECFieldElement eCFieldElement4 = eCFieldElement3.multiply(a.D.subtract(eCFieldElement2)).subtract(a.J);
            return new Fp(a.transient, eCFieldElement2, eCFieldElement4, a.withCompression);
        }

        public Fp(ECCurve a, ECFieldElement a2, ECFieldElement a3) {
            a4(a, a2, a3, false);
            Fp a4;
        }
    }
}

