/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.core.bouncycastle.math.ec;

import com.jxdinfo.hussar.core.bouncycastle.math.ec.ECConstants;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.con;
import com.jxdinfo.hussar.core.util.ClassUtil;
import com.jxdinfo.hussar.core.util.DateUtil;
import com.jxdinfo.hussar.core.util.FileLoader;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.math.BigInteger;
import java.util.Random;

public abstract class ECFieldElement
implements ECConstants {
    public abstract BigInteger toBigInteger();

    public abstract ECFieldElement negate();

    public abstract ECFieldElement sqrt();

    public abstract ECFieldElement square();

    public abstract ECFieldElement add(ECFieldElement var1);

    public abstract ECFieldElement invert();

    public String toString() {
        ECFieldElement a;
        return a.toBigInteger().toString(2);
    }

    public abstract ECFieldElement divide(ECFieldElement var1);

    public abstract ECFieldElement multiply(ECFieldElement var1);

    public abstract int getFieldSize();

    public abstract String getFieldName();

    public ECFieldElement() {
        ECFieldElement a;
    }

    public abstract ECFieldElement subtract(ECFieldElement var1);

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class F2m
    extends ECFieldElement {
        private int B;
        public static final int PPB = 3;
        public static final int GNB = 1;
        private int F;
        private int I;
        private con A;
        public static final int TPB = 2;
        private int J;
        private int D;
        private int int;

        public F2m(int a, int a2, BigInteger a3) {
            a4(a, a2, 0, 0, a3);
            F2m a4;
        }

        @Override
        public String getFieldName() {
            return ClassUtil.do("Wa#");
        }

        public int getRepresentation() {
            F2m a;
            return a.I;
        }

        @Override
        public ECFieldElement sqrt() {
            throw new RuntimeException(ClassUtil.do("\u000042p$''vb\u0015\u0000be6*"));
        }

        public F2m(int a, int a2, int a3, int a4, BigInteger a5) {
            BigInteger bigInteger;
            F2m a6;
            a6.B = a + 31 >> 5;
            F2m f2m = a6;
            a6.A = new con(a5, a6.B);
            if (a3 == 0 && a4 == 0) {
                bigInteger = a5;
                a6.I = 2;
            } else {
                if (a3 >= a4) {
                    throw new IllegalArgumentException(FileLoader.throw("R\r\u0011ZeeM\u001fRS\u0018M]WWQDUQ\u0003{t\tAS\r"));
                }
                if (a3 <= 0) {
                    throw new IllegalArgumentException(ClassUtil.do("1u[\u000b'</f1+{*1?-2h'\f\rm\u007fs~"));
                }
                a6.I = 3;
                bigInteger = a5;
            }
            if (bigInteger.signum() < 0) {
                throw new IllegalArgumentException(FileLoader.throw("A\u001fGV|c\\\u001fSWVP_B\u001b_D\u0007\u001f\u0012tt\u0013\bN["));
            }
            F2m f2m2 = a6;
            a6.J = a;
            f2m2.int = a2;
            f2m2.F = a3;
            a6.D = a4;
        }

        @Override
        public ECFieldElement add(ECFieldElement a) {
            F2m a2;
            con con2 = (con)a2.A.clone();
            F2m f2m = (F2m)a;
            con2.for(f2m.A, 0);
            F2m f2m2 = a2;
            F2m f2m3 = a2;
            return new F2m(f2m2.J, f2m2.int, f2m3.F, f2m3.D, con2);
        }

        @Override
        public ECFieldElement negate() {
            F2m a;
            return a;
        }

        public int getK1() {
            F2m a;
            return a.int;
        }

        private /* synthetic */ F2m(int a, int a2, int a3, int a4, con a5) {
            F2m a6;
            F2m f2m = a6;
            F2m f2m2 = a6;
            F2m f2m3 = a6;
            f2m3.B = a + 31 >> 5;
            f2m3.A = a5;
            f2m2.J = a;
            f2m2.int = a2;
            f2m.F = a3;
            f2m.D = a4;
            if (a3 == 0 && a4 == 0) {
                a6.I = 2;
                return;
            }
            a6.I = 3;
        }

        public static void checkFieldElements(ECFieldElement a, ECFieldElement a2) {
            if (!(a instanceof F2m) || !(a2 instanceof F2m)) {
                throw new IllegalArgumentException(FileLoader.throw("aPZ\\R[\u0018T[YWOSN\u001b\u001a\u000fU\u0016X_\u000f]rybx3|RIDWW\\TD0y_\u001fuu~WUZ_xMB\u001c\u0012}aI'\nS"));
            }
            F2m f2m = (F2m)a;
            F2m f2m2 = (F2m)a2;
            if (f2m.J != f2m2.J || f2m.int != f2m2.int || f2m.F != f2m2.F || f2m.D != f2m2.D) {
                throw new IllegalArgumentException(ClassUtil.do("K:+3&j2:.}h52.`q\u007f\u001eF\u0013\u000f\fE2&>+7!.4[\t4o/.6n('=(j1sb\u0014\u0001,Wa#"));
            }
            if (f2m.I != f2m2.I) {
                throw new IllegalArgumentException(FileLoader.throw("rXU\fEP\u0010@ZC\u0000GN\\ST\u0016\u001e\u0011]SQ\\UT\u001dZ\t\u0018\u0010XYD[\u0018|s{u}aO\u001aXWJ\u001fXYsyKMUUL\u001eBSKODT\u0014\u0019gt\u0013\bWP"));
            }
        }

        @Override
        public ECFieldElement square() {
            F2m a;
            F2m f2m = a;
            con con2 = f2m.A.goto(f2m.J);
            int[] nArray = new int[3];
            nArray[0] = a.int;
            nArray[1] = a.F;
            nArray[2] = a.D;
            con2.int(a.J, nArray);
            F2m f2m2 = a;
            F2m f2m3 = a;
            return new F2m(f2m2.J, f2m2.int, f2m3.F, f2m3.D, con2);
        }

        @Override
        public ECFieldElement invert() {
            F2m a;
            con con2 = (con)a.A.clone();
            con con3 = new con(a.B);
            F2m f2m = a;
            con con4 = con3;
            con4.float(a.J);
            con4.float(0);
            con3.float(f2m.int);
            if (f2m.I == 3) {
                con con5 = con3;
                con5.float(a.F);
                con5.float(a.D);
            }
            con con6 = new con(a.B);
            con6.float(0);
            con con7 = new con(a.B);
            con con8 = con2;
            while (!con8.for()) {
                int n = con2.abstract() - con3.abstract();
                if (n < 0) {
                    con con9 = con2;
                    con2 = con3;
                    con3 = con9;
                    con con10 = con6;
                    con6 = con7;
                    con7 = con10;
                    n = -n;
                }
                int n2 = n >> 5;
                con con11 = con3.implements(n &= 0x1F);
                con con12 = con2;
                con8 = con12;
                con12.for(con11, n2);
                con con13 = con7.implements(n);
                con6.for(con13, n2);
            }
            F2m f2m2 = a;
            F2m f2m3 = a;
            return new F2m(f2m2.J, f2m2.int, f2m3.F, f2m3.D, con7);
        }

        @Override
        public ECFieldElement multiply(ECFieldElement a) {
            F2m a2;
            Object object = (F2m)a;
            object = a2.A.float(((F2m)object).A, a2.J);
            int[] nArray = new int[3];
            nArray[0] = a2.int;
            nArray[1] = a2.F;
            nArray[2] = a2.D;
            ((con)object).int(a2.J, nArray);
            F2m f2m = a2;
            F2m f2m2 = a2;
            return new F2m(f2m.J, f2m.int, f2m2.F, f2m2.D, (con)object);
        }

        public int getK2() {
            F2m a;
            return a.F;
        }

        @Override
        public BigInteger toBigInteger() {
            F2m a;
            return a.A.strictfp();
        }

        @Override
        public ECFieldElement divide(ECFieldElement a) {
            F2m a2;
            ECFieldElement eCFieldElement = a.invert();
            return a2.multiply(eCFieldElement);
        }

        public int getM() {
            F2m a;
            return a.J;
        }

        public int getK3() {
            F2m a;
            return a.D;
        }

        @Override
        public int getFieldSize() {
            F2m a;
            return a.J;
        }

        @Override
        public ECFieldElement subtract(ECFieldElement a) {
            F2m a2;
            return a2.add(a);
        }

        public int hashCode() {
            F2m a;
            return a.A.hashCode() ^ a.J ^ a.int ^ a.F ^ a.D;
        }

        public boolean equals(Object a) {
            F2m a2;
            if (a == a2) {
                return true;
            }
            if (!(a instanceof F2m)) {
                return false;
            }
            F2m f2m = (F2m)a;
            return a2.J == f2m.J && a2.int == f2m.int && a2.F == f2m.F && a2.D == f2m.D && a2.I == f2m.I && a2.A.equals(f2m.A);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class Fp
    extends ECFieldElement {
        BigInteger D;
        BigInteger int;

        @Override
        public ECFieldElement multiply(ECFieldElement a) {
            Fp a2;
            Fp fp = a2;
            return new Fp(fp.int, fp.D.multiply(a.toBigInteger()).mod(a2.int));
        }

        public boolean equals(Object a) {
            Fp a2;
            if (a == a2) {
                return true;
            }
            if (!(a instanceof Fp)) {
                return false;
            }
            Fp fp = (Fp)a;
            return a2.int.equals(fp.int) && a2.D.equals(fp.D);
        }

        @Override
        public BigInteger toBigInteger() {
            Fp a;
            return a.D;
        }

        public BigInteger getQ() {
            Fp a;
            return a.int;
        }

        @Override
        public int getFieldSize() {
            Fp a;
            return a.int.bitLength();
        }

        public Fp(BigInteger a, BigInteger a2) {
            Fp a3;
            a3.D = a2;
            if (a3.D.compareTo(a) >= 0) {
                throw new IllegalArgumentException(ToolUtil.native("\ng\u0002 \u001d1;K&\b4N?\u0007\u0000 >N;\tz\t;\u00025\bc\u0013\u007fC\u001c!)\u0006"));
            }
            a3.int = a;
        }

        @Override
        public String getFieldName() {
            return DateUtil.do("\u001e)");
        }

        @Override
        public ECFieldElement subtract(ECFieldElement a) {
            Fp a2;
            Fp fp = a2;
            return new Fp(fp.int, fp.D.subtract(a.toBigInteger()).mod(a2.int));
        }

        @Override
        public ECFieldElement add(ECFieldElement a) {
            Fp a2;
            Fp fp = a2;
            return new Fp(fp.int, fp.D.add(a.toBigInteger()).mod(a2.int));
        }

        public int hashCode() {
            Fp a;
            return a.int.hashCode() ^ a.D.hashCode();
        }

        @Override
        public ECFieldElement sqrt() {
            Fp a;
            if (!a.int.testBit(0)) {
                throw new RuntimeException(ToolUtil.native("<\b-L'\u0019}CQ=\"\u0006"));
            }
            if (a.int.testBit(1)) {
                Fp fp = a;
                Fp fp2 = new Fp(fp.int, fp.D.modPow(a.int.shiftRight(2).add(ECConstants.ONE), a.int));
                if (((ECFieldElement)fp2).square().equals(a)) {
                    return fp2;
                }
                return null;
            }
            Fp fp = a;
            BigInteger bigInteger = fp.int.subtract(ECConstants.ONE);
            BigInteger bigInteger2 = bigInteger.shiftRight(1);
            if (!fp.D.modPow(bigInteger2, a.int).equals(ECConstants.ONE)) {
                return null;
            }
            BigInteger bigInteger3 = bigInteger.shiftRight(2).shiftLeft(1).add(ECConstants.ONE);
            BigInteger bigInteger4 = a.D;
            BigInteger bigInteger5 = bigInteger4.shiftLeft(2).mod(a.int);
            Random random = new Random();
            while (true) {
                BigInteger bigInteger6;
                if ((bigInteger6 = new BigInteger(a.int.bitLength(), random)).compareTo(a.int) >= 0) {
                    continue;
                }
                BigInteger bigInteger7 = bigInteger6;
                if (!bigInteger7.multiply(bigInteger7).subtract(bigInteger5).modPow(bigInteger2, a.int).equals(bigInteger)) continue;
                BigInteger[] bigIntegerArray = Fp.class(a.int, bigInteger6, bigInteger4, bigInteger3);
                BigInteger bigInteger8 = bigIntegerArray[0];
                BigInteger bigInteger9 = bigIntegerArray[1];
                if (bigInteger9.multiply(bigInteger9).mod(a.int).equals(bigInteger5)) {
                    if (bigInteger9.testBit(0)) {
                        bigInteger9 = bigInteger9.add(a.int);
                    }
                    bigInteger9 = bigInteger9.shiftRight(1);
                    return new Fp(a.int, bigInteger9);
                }
                if (!bigInteger8.equals(ECConstants.ONE) && !bigInteger8.equals(bigInteger)) break;
            }
            return null;
        }

        @Override
        public ECFieldElement divide(ECFieldElement a) {
            Fp a2;
            Fp fp = a2;
            return new Fp(fp.int, fp.D.multiply(a.toBigInteger().modInverse(a2.int)).mod(a2.int));
        }

        @Override
        public ECFieldElement square() {
            Fp a;
            Fp fp = a;
            return new Fp(fp.int, fp.D.multiply(a.D).mod(a.int));
        }

        private static /* synthetic */ BigInteger[] class(BigInteger a, BigInteger a2, BigInteger a3, BigInteger a4) {
            BigInteger bigInteger = a4;
            int n = bigInteger.bitLength();
            int n2 = bigInteger.getLowestSetBit();
            BigInteger bigInteger2 = ECConstants.ONE;
            BigInteger bigInteger3 = ECConstants.TWO;
            BigInteger bigInteger4 = a2;
            BigInteger bigInteger5 = ECConstants.ONE;
            BigInteger bigInteger6 = ECConstants.ONE;
            int n3 = n = n - 1;
            while (n3 >= n2 + 1) {
                bigInteger5 = bigInteger5.multiply(bigInteger6).mod(a);
                if (a4.testBit(n)) {
                    bigInteger6 = bigInteger5.multiply(a3).mod(a);
                    bigInteger2 = bigInteger2.multiply(bigInteger4).mod(a);
                    BigInteger bigInteger7 = bigInteger4;
                    bigInteger3 = bigInteger7.multiply(bigInteger3).subtract(a2.multiply(bigInteger5)).mod(a);
                    bigInteger4 = bigInteger7.multiply(bigInteger7).subtract(bigInteger6.shiftLeft(1)).mod(a);
                } else {
                    bigInteger6 = bigInteger5;
                    bigInteger2 = bigInteger2.multiply(bigInteger3).subtract(bigInteger5).mod(a);
                    bigInteger4 = bigInteger4.multiply(bigInteger3).subtract(a2.multiply(bigInteger5)).mod(a);
                    BigInteger bigInteger8 = bigInteger3;
                    bigInteger3 = bigInteger8.multiply(bigInteger8).subtract(bigInteger5.shiftLeft(1)).mod(a);
                }
                n3 = --n;
            }
            bigInteger5 = bigInteger5.multiply(bigInteger6).mod(a);
            bigInteger6 = bigInteger5.multiply(a3).mod(a);
            bigInteger2 = bigInteger2.multiply(bigInteger3).subtract(bigInteger5).mod(a);
            BigInteger bigInteger9 = bigInteger5;
            bigInteger3 = bigInteger4.multiply(bigInteger3).subtract(a2.multiply(bigInteger9)).mod(a);
            bigInteger5 = bigInteger9.multiply(bigInteger6).mod(a);
            int n4 = n = 1;
            while (n4 <= n2) {
                bigInteger2 = bigInteger2.multiply(bigInteger3).mod(a);
                BigInteger bigInteger10 = bigInteger3;
                bigInteger3 = bigInteger10.multiply(bigInteger10).subtract(bigInteger5.shiftLeft(1)).mod(a);
                BigInteger bigInteger11 = bigInteger5;
                bigInteger5 = bigInteger11.multiply(bigInteger11).mod(a);
                n4 = ++n;
            }
            BigInteger[] bigIntegerArray = new BigInteger[2];
            bigIntegerArray[0] = bigInteger2;
            bigIntegerArray[1] = bigInteger3;
            return bigIntegerArray;
        }

        @Override
        public ECFieldElement negate() {
            Fp a;
            Fp fp = a;
            return new Fp(fp.int, fp.D.negate().mod(a.int));
        }

        @Override
        public ECFieldElement invert() {
            Fp a;
            Fp fp = a;
            return new Fp(fp.int, fp.D.modInverse(a.int));
        }
    }
}

