/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.core.bouncycastle.math.ec;

import com.jxdinfo.hussar.core.bouncycastle.asn1.x9.X9IntegerConverter;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.AuX;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.CON;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.COn;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.ECConstants;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.ECCurve;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.ECFieldElement;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.aUX;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.aUx;
import com.jxdinfo.hussar.core.cache.LRULinkedHashMap;
import com.jxdinfo.hussar.core.encrypt.file.util.StrKit;
import com.jxdinfo.hussar.core.util.CookieUtils;
import com.jxdinfo.hussar.core.util.ResKit;
import java.math.BigInteger;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class ECPoint {
    protected boolean withCompression;
    protected AuX multiplier;
    protected aUX preCompInfo;
    ECCurve g;
    ECFieldElement b;
    ECFieldElement j;
    private static X9IntegerConverter new = new X9IntegerConverter();

    public boolean isInfinity() {
        ECPoint a;
        return a.j == null && a.b == null;
    }

    public ECPoint multiply(BigInteger a) {
        ECPoint a2;
        if (a.signum() < 0) {
            throw new IllegalArgumentException(StrKit.finally("3X\u0004\u0016A\u000e+d(f>l\u000e[\u001fS\u001e\u001b\u0015@\u0001V\u0018TN[\u0013\u0001\u0005Y\u0015D\u001aP\rI"));
        }
        if (a2.isInfinity()) {
            return a2;
        }
        if (a.signum() == 0) {
            return a2.g.getInfinity();
        }
        ECPoint eCPoint = a2;
        eCPoint.catch();
        ECPoint eCPoint2 = a2;
        return eCPoint.multiplier.interface(eCPoint2, a, eCPoint2.preCompInfo);
    }

    public abstract ECPoint negate();

    public boolean equals(Object a) {
        ECPoint a2;
        if (a == a2) {
            return true;
        }
        if (!(a instanceof ECPoint)) {
            return false;
        }
        a = (ECPoint)a;
        if (a2.isInfinity()) {
            return ((ECPoint)a).isInfinity();
        }
        return a2.j.equals(((ECPoint)a).j) && a2.b.equals(((ECPoint)a).b);
    }

    synchronized void catch() {
        ECPoint a;
        if (a.multiplier == null) {
            ECPoint eCPoint = a;
            eCPoint.multiplier = new COn();
        }
    }

    public abstract ECPoint subtract(ECPoint var1);

    public boolean isCompressed() {
        ECPoint a;
        return a.withCompression;
    }

    public ECFieldElement getY() {
        ECPoint a;
        return a.b;
    }

    public abstract byte[] getEncoded();

    protected ECPoint(ECCurve a, ECFieldElement a2, ECFieldElement a3) {
        ECPoint a4;
        ECPoint eCPoint = a4;
        ECPoint eCPoint2 = a4;
        a4.multiplier = null;
        eCPoint2.preCompInfo = null;
        eCPoint2.g = a;
        eCPoint.j = a2;
        eCPoint.b = a3;
    }

    void public(aUX a) {
        a.preCompInfo = a;
    }

    public ECFieldElement getX() {
        ECPoint a;
        return a.j;
    }

    public ECCurve getCurve() {
        ECPoint a;
        return a.g;
    }

    public abstract ECPoint add(ECPoint var1);

    public int hashCode() {
        ECPoint a;
        if (a.isInfinity()) {
            return 0;
        }
        return a.j.hashCode() ^ a.b.hashCode();
    }

    public abstract ECPoint twice();

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class F2m
    extends ECPoint {
        public F2m addSimple(F2m a) {
            F2m a2;
            Object object = a;
            if (a2.isInfinity()) {
                return object;
            }
            if (((ECPoint)object).isInfinity()) {
                return a2;
            }
            ECFieldElement.F2m f2m = (ECFieldElement.F2m)((ECPoint)object).getX();
            object = (ECFieldElement.F2m)((ECPoint)object).getY();
            if (a2.j.equals(f2m)) {
                if (a2.b.equals(object)) {
                    return (F2m)a2.twice();
                }
                return (F2m)a2.g.getInfinity();
            }
            object = (ECFieldElement.F2m)a2.b.add((ECFieldElement)object).divide(a2.j.add(f2m));
            f2m = (ECFieldElement.F2m)((ECFieldElement.F2m)object).square().add((ECFieldElement)object).add(a2.j).add(f2m).add(a2.g.getA());
            object = (ECFieldElement.F2m)((ECFieldElement.F2m)object).multiply(a2.j.add(f2m)).add(f2m).add(a2.b);
            return new F2m(a2.g, f2m, (ECFieldElement)object, a2.withCompression);
        }

        @Override
        synchronized void catch() {
            F2m a;
            if (a.multiplier == null) {
                if (((ECCurve.F2m)a.g).isKoblitz()) {
                    F2m f2m = a;
                    f2m.multiplier = new aUx();
                    return;
                }
                a.multiplier = new CON();
            }
        }

        public F2m(ECCurve a, ECFieldElement a2, ECFieldElement a3, boolean a4) {
            F2m a5;
            ECFieldElement eCFieldElement = a2;
            super(a, eCFieldElement, a3);
            if (eCFieldElement != null && a3 == null || a2 == null && a3 != null) {
                throw new IllegalArgumentException(ResKit.interface("X_7B$\u0000d'\u0019o\u00152\fK|_2I}P.\u0003{`U\u0015mJ3\u001ba_)\f4XzX2\u0010a"));
            }
            if (a2 != null) {
                F2m f2m = a5;
                ECFieldElement.F2m.checkFieldElements(f2m.j, f2m.b);
                if (a != null) {
                    F2m f2m2 = a5;
                    ECFieldElement.F2m.checkFieldElements(f2m2.j, f2m2.g.getA());
                }
            }
            a5.withCompression = a4;
        }

        public F2m subtractSimple(F2m a) {
            F2m a2;
            if (a.isInfinity()) {
                return a2;
            }
            return a2.addSimple((F2m)a.negate());
        }

        private static /* synthetic */ void return(ECPoint a, ECPoint a2) {
            if (!a.g.equals(a2.g)) {
                throw new IllegalArgumentException(CookieUtils.final("\f[5VcE.^=Q'\u0002#TeGf\u001dmH Z1\u0002+K|\u000e \u0013 T`X\u0007vCt\u0014b*]iP<\u0018'Wf\u0006\u0014qq\u0010(_"));
            }
        }

        @Override
        public ECPoint add(ECPoint a) {
            F2m a2;
            F2m f2m = a2;
            F2m.return(f2m, a);
            return f2m.addSimple((F2m)a);
        }

        @Override
        public ECPoint negate() {
            F2m a;
            return new F2m(a.g, a.getX(), a.getY().add(a.getX()), a.withCompression);
        }

        public F2m(ECCurve a, ECFieldElement a2, ECFieldElement a3) {
            a4(a, a2, a3, false);
            F2m a4;
        }

        @Override
        public ECPoint twice() {
            F2m a;
            if (a.isInfinity()) {
                return a;
            }
            if (a.j.toBigInteger().signum() == 0) {
                return a.g.getInfinity();
            }
            F2m f2m = a;
            ECFieldElement.F2m f2m2 = (ECFieldElement.F2m)f2m.j.add(f2m.b.divide(a.j));
            ECFieldElement.F2m f2m3 = (ECFieldElement.F2m)f2m2.square().add(f2m2).add(a.g.getA());
            F2m f2m4 = a;
            ECFieldElement eCFieldElement = f2m4.g.fromBigInteger(ECConstants.ONE);
            eCFieldElement = (ECFieldElement.F2m)f2m4.j.square().add(f2m3.multiply(f2m2.add(eCFieldElement)));
            return new F2m(a.g, f2m3, eCFieldElement, a.withCompression);
        }

        @Override
        public byte[] getEncoded() {
            F2m a;
            if (a.isInfinity()) {
                return new byte[1];
            }
            int n = new.getByteLength(a.j);
            byte[] byArray = new.integerToBytes(a.getX().toBigInteger(), n);
            if (a.withCompression) {
                byte[] byArray2 = new byte[n + 1];
                byArray2[0] = 2;
                if (!a.getX().toBigInteger().equals(ECConstants.ZERO) && a.getY().multiply(a.getX().invert()).toBigInteger().testBit(0)) {
                    byArray2[0] = 3;
                }
                System.arraycopy(byArray, 0, byArray2, 1, n);
                return byArray2;
            }
            byte[] byArray3 = new.integerToBytes(a.getY().toBigInteger(), n);
            int n2 = n;
            byte[] byArray4 = new byte[n2 + n2 + 1];
            byArray4[0] = 4;
            System.arraycopy(byArray, 0, byArray4, 1, n);
            System.arraycopy(byArray3, 0, byArray4, n + 1, n);
            return byArray4;
        }

        @Override
        public ECPoint subtract(ECPoint a) {
            F2m a2;
            F2m f2m = a2;
            F2m.return(f2m, a);
            return f2m.subtractSimple((F2m)a);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class Fp
    extends ECPoint {
        @Override
        public ECPoint add(ECPoint a) {
            Fp a2;
            if (a2.isInfinity()) {
                return a;
            }
            if (a.isInfinity()) {
                return a2;
            }
            if (a2.j.equals(a.j)) {
                if (a2.b.equals(a.b)) {
                    return a2.twice();
                }
                return a2.g.getInfinity();
            }
            ECFieldElement eCFieldElement = a.b.subtract(a2.b).divide(a.j.subtract(a2.j));
            ECFieldElement eCFieldElement2 = eCFieldElement.square().subtract(a2.j).subtract(a.j);
            ECFieldElement eCFieldElement3 = eCFieldElement.multiply(a2.j.subtract(eCFieldElement2)).subtract(a2.b);
            return new Fp(a2.g, eCFieldElement2, eCFieldElement3);
        }

        public Fp(ECCurve a, ECFieldElement a2, ECFieldElement a3) {
            a4(a, a2, a3, false);
            Fp a4;
        }

        @Override
        synchronized void catch() {
            Fp a;
            if (a.multiplier == null) {
                Fp fp = a;
                fp.multiplier = new CON();
            }
        }

        @Override
        public byte[] getEncoded() {
            Fp a;
            if (a.isInfinity()) {
                return new byte[1];
            }
            int n = new.getByteLength(a.j);
            if (a.withCompression) {
                int n2 = a.getY().toBigInteger().testBit(0) ? 3 : 2;
                byte[] byArray = new.integerToBytes(a.getX().toBigInteger(), n);
                byte[] byArray2 = new byte[byArray.length + 1];
                byArray2[0] = n2;
                System.arraycopy(byArray, 0, byArray2, 1, byArray.length);
                return byArray2;
            }
            byte[] byArray = new.integerToBytes(a.getX().toBigInteger(), n);
            byte[] byArray3 = new.integerToBytes(a.getY().toBigInteger(), n);
            byte[] byArray4 = new byte[byArray.length + byArray3.length + 1];
            byArray4[0] = 4;
            System.arraycopy(byArray, 0, byArray4, 1, byArray.length);
            System.arraycopy(byArray3, 0, byArray4, byArray.length + 1, byArray3.length);
            return byArray4;
        }

        @Override
        public ECPoint twice() {
            Fp a;
            if (a.isInfinity()) {
                return a;
            }
            if (a.b.toBigInteger().signum() == 0) {
                return a.g.getInfinity();
            }
            Fp fp = a;
            ECFieldElement eCFieldElement = fp.g.fromBigInteger(BigInteger.valueOf(2L));
            ECFieldElement eCFieldElement2 = fp.g.fromBigInteger(BigInteger.valueOf(3L));
            ECFieldElement eCFieldElement3 = fp.j.square().multiply(eCFieldElement2).add(a.g.j).divide(a.b.multiply(eCFieldElement));
            eCFieldElement2 = eCFieldElement3.square().subtract(a.j.multiply(eCFieldElement));
            ECFieldElement eCFieldElement4 = eCFieldElement3.multiply(a.j.subtract(eCFieldElement2)).subtract(a.b);
            return new Fp(a.g, eCFieldElement2, eCFieldElement4, a.withCompression);
        }

        public Fp(ECCurve a, ECFieldElement a2, ECFieldElement a3, boolean a4) {
            Fp a5;
            ECFieldElement eCFieldElement = a2;
            super(a, eCFieldElement, a3);
            if (eCFieldElement != null && a3 == null || a2 == null && a3 != null) {
                throw new IllegalArgumentException(LRULinkedHashMap.throw("k{\t+W\"\\#\u0007\u0006fNj\u001b66A!\u000f%A<^mB\u000el8[t\u00140\\cA7\u000f7G\u007f\u0014"));
            }
            a5.withCompression = a4;
        }

        @Override
        public ECPoint negate() {
            Fp a;
            Fp fp = a;
            return new Fp(fp.g, fp.j, a.b.negate(), a.withCompression);
        }

        @Override
        public ECPoint subtract(ECPoint a) {
            Fp a2;
            if (a.isInfinity()) {
                return a2;
            }
            return a2.add(a.negate());
        }
    }
}

