/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.core.bouncycastle.math.ec;

import com.jxdinfo.hussar.core.bouncycastle.jce.provider.asymmetric.ec.EC5Util;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.CoN;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.ECConstants;
import com.jxdinfo.hussar.core.feign.TicketRequestBody;
import com.jxdinfo.hussar.core.util.NumUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.math.BigInteger;
import java.util.Random;

public abstract class ECFieldElement
implements ECConstants {
    public ECFieldElement() {
        ECFieldElement a;
    }

    public abstract ECFieldElement subtract(ECFieldElement var1);

    public abstract String getFieldName();

    public abstract BigInteger toBigInteger();

    public abstract ECFieldElement multiply(ECFieldElement var1);

    public abstract int getFieldSize();

    public abstract ECFieldElement divide(ECFieldElement var1);

    public abstract ECFieldElement negate();

    public abstract ECFieldElement invert();

    public abstract ECFieldElement square();

    public abstract ECFieldElement sqrt();

    public abstract ECFieldElement add(ECFieldElement var1);

    public String toString() {
        ECFieldElement a;
        return a.toBigInteger().toString(2);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class F2m
    extends ECFieldElement {
        private CoN f;
        public static final int GNB = 1;
        private int K;
        public static final int TPB = 2;
        private int J;
        private int g;
        private int b;
        private int j;
        private int assert;
        public static final int PPB = 3;

        @Override
        public ECFieldElement invert() {
            F2m a;
            CoN coN2 = (CoN)a.f.clone();
            CoN coN3 = new CoN(a.assert);
            F2m f2m = a;
            CoN coN4 = coN3;
            coN4.boolean(a.K);
            coN4.boolean(0);
            coN3.boolean(f2m.J);
            if (f2m.j == 3) {
                CoN coN5 = coN3;
                coN5.boolean(a.b);
                coN5.boolean(a.g);
            }
            CoN coN6 = new CoN(a.assert);
            coN6.boolean(0);
            CoN coN7 = new CoN(a.assert);
            CoN coN8 = coN2;
            while (!coN8.int()) {
                int n = coN2.byte() - coN3.byte();
                if (n < 0) {
                    CoN coN9 = coN2;
                    coN2 = coN3;
                    coN3 = coN9;
                    CoN coN10 = coN6;
                    coN6 = coN7;
                    coN7 = coN10;
                    n = -n;
                }
                int n2 = n >> 5;
                CoN coN11 = coN3.super(n &= 0x1F);
                CoN coN12 = coN2;
                coN8 = coN12;
                coN12.char(coN11, n2);
                CoN coN13 = coN7.super(n);
                coN6.char(coN13, n2);
            }
            F2m f2m2 = a;
            F2m f2m3 = a;
            return new F2m(f2m2.K, f2m2.J, f2m3.b, f2m3.g, coN7);
        }

        public F2m(int a, int a2, int a3, int a4, BigInteger a5) {
            BigInteger bigInteger;
            F2m a6;
            a6.assert = a + 31 >> 5;
            F2m f2m = a6;
            a6.f = new CoN(a5, a6.assert);
            if (a3 == 0 && a4 == 0) {
                bigInteger = a5;
                a6.j = 2;
            } else {
                if (a3 >= a4) {
                    throw new IllegalArgumentException(ToolUtil.short("\u0012IQ\u001e%!\r[\u0012\u0017X\t\u001d\u0013\u0017\u0015\u0004\u0011\u0011G;0I\u0005\u0013I"));
                }
                if (a3 <= 0) {
                    throw new IllegalArgumentException(NumUtil.throw("7'fbc,\u0000\u001db,\u007fzo5<w.5/z'a,u"));
                }
                a6.j = 3;
                bigInteger = a5;
            }
            if (bigInteger.signum() < 0) {
                throw new IllegalArgumentException(ToolUtil.short("\u0001[\u0007\u0012<'\u001c[\u0013\u0013\u0016\u0014\u001f\u0006[\u001b\u0004C_V40SL\u000e\u001f"));
            }
            F2m f2m2 = a6;
            a6.K = a;
            f2m2.J = a2;
            f2m2.b = a3;
            a6.g = a4;
        }

        public int getK1() {
            F2m a;
            return a.J;
        }

        @Override
        public ECFieldElement negate() {
            F2m a;
            return a;
        }

        @Override
        public ECFieldElement subtract(ECFieldElement a) {
            F2m a2;
            return a2.add(a);
        }

        @Override
        public ECFieldElement multiply(ECFieldElement a) {
            F2m a2;
            Object object = (F2m)a;
            object = a2.f.int(((F2m)object).f, a2.K);
            int[] nArray = new int[3];
            nArray[0] = a2.J;
            nArray[1] = a2.b;
            nArray[2] = a2.g;
            ((CoN)object).class(a2.K, nArray);
            F2m f2m = a2;
            F2m f2m2 = a2;
            return new F2m(f2m.K, f2m.J, f2m2.b, f2m2.g, (CoN)object);
        }

        public int getRepresentation() {
            F2m a;
            return a.j;
        }

        @Override
        public ECFieldElement add(ECFieldElement a) {
            F2m a2;
            CoN coN2 = (CoN)a2.f.clone();
            F2m f2m = (F2m)a;
            coN2.char(f2m.f, 0);
            F2m f2m2 = a2;
            F2m f2m3 = a2;
            return new F2m(f2m2.K, f2m2.J, f2m3.b, f2m3.g, coN2);
        }

        @Override
        public ECFieldElement square() {
            F2m a;
            F2m f2m = a;
            CoN coN2 = f2m.f.volatile(f2m.K);
            int[] nArray = new int[3];
            nArray[0] = a.J;
            nArray[1] = a.b;
            nArray[2] = a.g;
            coN2.class(a.K, nArray);
            F2m f2m2 = a;
            F2m f2m3 = a;
            return new F2m(f2m2.K, f2m2.J, f2m3.b, f2m3.g, coN2);
        }

        public F2m(int a, int a2, BigInteger a3) {
            a4(a, a2, 0, 0, a3);
            F2m a4;
        }

        public int getK2() {
            F2m a;
            return a.b;
        }

        public int getK3() {
            F2m a;
            return a.g;
        }

        public static void checkFieldElements(ECFieldElement a, ECFieldElement a2) {
            if (!(a instanceof F2m) || !(a2 instanceof F2m)) {
                throw new IllegalArgumentException(ToolUtil.short("%\u0010\u001e\u001c\u0016\u001b\\\u0014\u001f\u0019\u0013\u000f\u0017\u000e_ZK\u0015R\u0018\u001bO\u00192=\"<s8\u0012\r\u0004\u0013\u0017\u0018\u0014\u0000p=\u001f[51>\u0013\u0015\u001e\u001f<\r\u0006\\V=%\tcJ\u0017"));
            }
            F2m f2m = (F2m)a;
            F2m f2m2 = (F2m)a2;
            if (f2m.K != f2m2.K || f2m.J != f2m2.J || f2m.b != f2m2.b || f2m.g != f2m2.g) {
                throw new IllegalArgumentException(NumUtil.throw("X6s;z|p*j{:\u001aIsi>d484|#>4t<}\u0011S/awq87\"w\u0012\u001e-v:{\u007fp>{0qfIse"));
            }
            if (f2m.j != f2m2.j) {
                throw new IllegalArgumentException(ToolUtil.short("6\u0018\u0011L\u0001\u0010T\u0000\u001e\u0003D\u0007\n\u001c\u0017\u0014R^U\u001d\u0017\u0011\u0018\u0015\u0010]\u001eI\\P\u001c\u0019\u0000\u001b\\<7;1=%\u000f^\u0018\u0013\n[\u0018\u001d3=\u000b\t\u0015\u0011\fZ\u0002\u0017\u000b\u000b\u0004\u0010T]'0SL\u0017\u0014"));
            }
        }

        @Override
        public ECFieldElement divide(ECFieldElement a) {
            F2m a2;
            ECFieldElement eCFieldElement = a.invert();
            return a2.multiply(eCFieldElement);
        }

        public boolean equals(Object a) {
            F2m a2;
            if (a == a2) {
                return true;
            }
            if (!(a instanceof F2m)) {
                return false;
            }
            F2m f2m = (F2m)a;
            return a2.K == f2m.K && a2.J == f2m.J && a2.b == f2m.b && a2.g == f2m.g && a2.j == f2m.j && a2.f.equals(f2m.f);
        }

        @Override
        public ECFieldElement sqrt() {
            throw new RuntimeException(NumUtil.throw("\u0011\u001bI  2f-m.o.}#k"));
        }

        private /* synthetic */ F2m(int a, int a2, int a3, int a4, CoN a5) {
            F2m a6;
            F2m f2m = a6;
            F2m f2m2 = a6;
            F2m f2m3 = a6;
            f2m3.assert = a + 31 >> 5;
            f2m3.f = a5;
            f2m2.K = a;
            f2m2.J = a2;
            f2m.b = a3;
            f2m.g = a4;
            if (a3 == 0 && a4 == 0) {
                a6.j = 2;
                return;
            }
            a6.j = 3;
        }

        public int getM() {
            F2m a;
            return a.K;
        }

        public int hashCode() {
            F2m a;
            return a.f.hashCode() ^ a.K ^ a.J ^ a.b ^ a.g;
        }

        @Override
        public BigInteger toBigInteger() {
            F2m a;
            return a.f.throws();
        }

        @Override
        public String getFieldName() {
            return NumUtil.throw("Pes");
        }

        @Override
        public int getFieldSize() {
            F2m a;
            return a.K;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class Fp
    extends ECFieldElement {
        BigInteger j;
        BigInteger static;

        @Override
        public int getFieldSize() {
            Fp a;
            return a.j.bitLength();
        }

        @Override
        public ECFieldElement negate() {
            Fp a;
            Fp fp = a;
            return new Fp(fp.j, fp.static.negate().mod(a.j));
        }

        @Override
        public ECFieldElement multiply(ECFieldElement a) {
            Fp a2;
            Fp fp = a2;
            return new Fp(fp.j, fp.static.multiply(a.toBigInteger()).mod(a2.j));
        }

        @Override
        public ECFieldElement subtract(ECFieldElement a) {
            Fp a2;
            Fp fp = a2;
            return new Fp(fp.j, fp.static.subtract(a.toBigInteger()).mod(a2.j));
        }

        public boolean equals(Object a) {
            Fp a2;
            if (a == a2) {
                return true;
            }
            if (!(a instanceof Fp)) {
                return false;
            }
            Fp fp = (Fp)a;
            return a2.j.equals(fp.j) && a2.static.equals(fp.static);
        }

        @Override
        public ECFieldElement sqrt() {
            Fp a;
            if (!a.j.testBit(0)) {
                throw new RuntimeException(EC5Util.assert("\u0001\f-u>961{.8%"));
            }
            if (a.j.testBit(1)) {
                Fp fp = a;
                Fp fp2 = new Fp(fp.j, fp.static.modPow(a.j.shiftRight(2).add(ECConstants.ONE), a.j));
                if (((ECFieldElement)fp2).square().equals(a)) {
                    return fp2;
                }
                return null;
            }
            Fp fp = a;
            BigInteger bigInteger = fp.j.subtract(ECConstants.ONE);
            BigInteger bigInteger2 = bigInteger.shiftRight(1);
            if (!fp.static.modPow(bigInteger2, a.j).equals(ECConstants.ONE)) {
                return null;
            }
            BigInteger bigInteger3 = bigInteger.shiftRight(2).shiftLeft(1).add(ECConstants.ONE);
            BigInteger bigInteger4 = a.static;
            BigInteger bigInteger5 = bigInteger4.shiftLeft(2).mod(a.j);
            Random random = new Random();
            while (true) {
                BigInteger bigInteger6;
                if ((bigInteger6 = new BigInteger(a.j.bitLength(), random)).compareTo(a.j) >= 0) {
                    continue;
                }
                BigInteger bigInteger7 = bigInteger6;
                if (!bigInteger7.multiply(bigInteger7).subtract(bigInteger5).modPow(bigInteger2, a.j).equals(bigInteger)) continue;
                BigInteger[] bigIntegerArray = Fp.protected(a.j, bigInteger6, bigInteger4, bigInteger3);
                BigInteger bigInteger8 = bigIntegerArray[0];
                BigInteger bigInteger9 = bigIntegerArray[1];
                if (bigInteger9.multiply(bigInteger9).mod(a.j).equals(bigInteger5)) {
                    if (bigInteger9.testBit(0)) {
                        bigInteger9 = bigInteger9.add(a.j);
                    }
                    bigInteger9 = bigInteger9.shiftRight(1);
                    return new Fp(a.j, bigInteger9);
                }
                if (!bigInteger8.equals(ECConstants.ONE) && !bigInteger8.equals(bigInteger)) break;
            }
            return null;
        }

        @Override
        public BigInteger toBigInteger() {
            Fp a;
            return a.static;
        }

        public int hashCode() {
            Fp a;
            return a.j.hashCode() ^ a.static.hashCode();
        }

        @Override
        public ECFieldElement invert() {
            Fp a;
            Fp fp = a;
            return new Fp(fp.j, fp.static.modInverse(a.j));
        }

        @Override
        public ECFieldElement divide(ECFieldElement a) {
            Fp a2;
            Fp fp = a2;
            return new Fp(fp.j, fp.static.multiply(a.toBigInteger().modInverse(a2.j)).mod(a2.j));
        }

        @Override
        public String getFieldName() {
            return TicketRequestBody.else("a3");
        }

        public BigInteger getQ() {
            Fp a;
            return a.j;
        }

        public Fp(BigInteger a, BigInteger a2) {
            Fp a3;
            a3.static = a2;
            if (a3.static.compareTo(a) >= 0) {
                throw new IllegalArgumentException(EC5Util.assert("5a\u001a\u0001)<)`0'#`+*/6h!\u0006\ry3||,(g.,)04yo"));
            }
            a3.j = a;
        }

        @Override
        public ECFieldElement add(ECFieldElement a) {
            Fp a2;
            Fp fp = a2;
            return new Fp(fp.j, fp.static.add(a.toBigInteger()).mod(a2.j));
        }

        @Override
        public ECFieldElement square() {
            Fp a;
            Fp fp = a;
            return new Fp(fp.j, fp.static.multiply(a.static).mod(a.j));
        }

        private static /* synthetic */ BigInteger[] protected(BigInteger a, BigInteger a2, BigInteger a3, BigInteger a4) {
            BigInteger bigInteger = a4;
            int n = bigInteger.bitLength();
            int n2 = bigInteger.getLowestSetBit();
            BigInteger bigInteger2 = ECConstants.ONE;
            BigInteger bigInteger3 = ECConstants.TWO;
            BigInteger bigInteger4 = a2;
            BigInteger bigInteger5 = ECConstants.ONE;
            BigInteger bigInteger6 = ECConstants.ONE;
            int n3 = n = n - 1;
            while (n3 >= n2 + 1) {
                bigInteger5 = bigInteger5.multiply(bigInteger6).mod(a);
                if (a4.testBit(n)) {
                    bigInteger6 = bigInteger5.multiply(a3).mod(a);
                    bigInteger2 = bigInteger2.multiply(bigInteger4).mod(a);
                    BigInteger bigInteger7 = bigInteger4;
                    bigInteger3 = bigInteger7.multiply(bigInteger3).subtract(a2.multiply(bigInteger5)).mod(a);
                    bigInteger4 = bigInteger7.multiply(bigInteger7).subtract(bigInteger6.shiftLeft(1)).mod(a);
                } else {
                    bigInteger6 = bigInteger5;
                    bigInteger2 = bigInteger2.multiply(bigInteger3).subtract(bigInteger5).mod(a);
                    bigInteger4 = bigInteger4.multiply(bigInteger3).subtract(a2.multiply(bigInteger5)).mod(a);
                    BigInteger bigInteger8 = bigInteger3;
                    bigInteger3 = bigInteger8.multiply(bigInteger8).subtract(bigInteger5.shiftLeft(1)).mod(a);
                }
                n3 = --n;
            }
            bigInteger5 = bigInteger5.multiply(bigInteger6).mod(a);
            bigInteger6 = bigInteger5.multiply(a3).mod(a);
            bigInteger2 = bigInteger2.multiply(bigInteger3).subtract(bigInteger5).mod(a);
            BigInteger bigInteger9 = bigInteger5;
            bigInteger3 = bigInteger4.multiply(bigInteger3).subtract(a2.multiply(bigInteger9)).mod(a);
            bigInteger5 = bigInteger9.multiply(bigInteger6).mod(a);
            int n4 = n = 1;
            while (n4 <= n2) {
                bigInteger2 = bigInteger2.multiply(bigInteger3).mod(a);
                BigInteger bigInteger10 = bigInteger3;
                bigInteger3 = bigInteger10.multiply(bigInteger10).subtract(bigInteger5.shiftLeft(1)).mod(a);
                BigInteger bigInteger11 = bigInteger5;
                bigInteger5 = bigInteger11.multiply(bigInteger11).mod(a);
                n4 = ++n;
            }
            BigInteger[] bigIntegerArray = new BigInteger[2];
            bigIntegerArray[0] = bigInteger2;
            bigIntegerArray[1] = bigInteger3;
            return bigIntegerArray;
        }
    }
}

