/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.core.config;

import com.jxdinfo.hussar.core.config.HussarConfig;
import java.util.List;
import javax.servlet.Servlet;
import org.apache.catalina.startup.Tomcat;
import org.apache.coyote.UpgradeProtocol;
import org.apache.tomcat.util.descriptor.web.SecurityCollection;
import org.apache.tomcat.util.descriptor.web.SecurityConstraint;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.web.embedded.tomcat.TomcatContextCustomizer;
import org.springframework.boot.web.embedded.tomcat.TomcatServletWebServerFactory;
import org.springframework.boot.web.server.WebServerFactoryCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpMethod;

@Configuration(proxyBeanMethods=false)
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
@ConditionalOnClass(value={Servlet.class, Tomcat.class, UpgradeProtocol.class})
public class TomcatWebServerFactoryConfig {
    @Autowired
    private HussarConfig hussarConfig;

    @Bean
    @ConditionalOnClass(value={Servlet.class, Tomcat.class, UpgradeProtocol.class})
    WebServerFactoryCustomizer<TomcatServletWebServerFactory> acoolyWebServerFactoryCustomizer() {
        return tomcatServletWebServerFactory -> tomcatServletWebServerFactory.addContextCustomizers(new TomcatContextCustomizer[]{context -> {
            List<String> list;
            SecurityConstraint securityConstraint = new SecurityConstraint();
            securityConstraint.setAuthConstraint(true);
            SecurityCollection securityCollection = new SecurityCollection();
            securityCollection.addPattern("/*");
            securityCollection.addOmittedMethod(HttpMethod.GET.name());
            securityCollection.addOmittedMethod(HttpMethod.GET.name().toLowerCase());
            securityCollection.addOmittedMethod(HttpMethod.POST.name());
            securityCollection.addOmittedMethod(HttpMethod.POST.name().toLowerCase());
            if (this.hussarConfig != null && (list = this.hussarConfig.getAllowHttpMethods()) != null) {
                for (String string : list) {
                    securityCollection.addOmittedMethod(string);
                }
            }
            securityConstraint.addCollection(securityCollection);
            context.addConstraint(securityConstraint);
        }});
    }
}

