/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.core.bouncycastle.math.ec;

import com.jxdinfo.hussar.core.auto.common.Sets;
import com.jxdinfo.hussar.core.base.tips.Tip;
import com.jxdinfo.hussar.core.bouncycastle.asn1.OIDTokenizer;
import com.jxdinfo.hussar.core.bouncycastle.asn1.x9.X9IntegerConverter;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.AuX;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.ECConstants;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.ECCurve;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.ECFieldElement;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.aux;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.cON;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.cOn;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.nUl;
import com.jxdinfo.hussar.core.bouncycastle.util.Strings;
import java.math.BigInteger;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class ECPoint {
    private static X9IntegerConverter A = new X9IntegerConverter();
    ECFieldElement C;
    ECFieldElement J;
    protected nUl multiplier;
    protected boolean withCompression;
    protected AuX preCompInfo;
    ECCurve super;

    public ECCurve getCurve() {
        ECPoint a;
        return a.super;
    }

    public ECFieldElement getX() {
        ECPoint a;
        return a.J;
    }

    public ECFieldElement getY() {
        ECPoint a;
        return a.C;
    }

    public int hashCode() {
        ECPoint a;
        if (a.isInfinity()) {
            return 0;
        }
        return a.J.hashCode() ^ a.C.hashCode();
    }

    public abstract ECPoint add(ECPoint var1);

    protected ECPoint(ECCurve a, ECFieldElement a2, ECFieldElement a3) {
        ECPoint a4;
        ECPoint eCPoint = a4;
        ECPoint eCPoint2 = a4;
        a4.multiplier = null;
        eCPoint2.preCompInfo = null;
        eCPoint2.super = a;
        eCPoint.J = a2;
        eCPoint.C = a3;
    }

    public abstract ECPoint negate();

    public boolean equals(Object a) {
        ECPoint a2;
        if (a == a2) {
            return true;
        }
        if (!(a instanceof ECPoint)) {
            return false;
        }
        a = (ECPoint)a;
        if (a2.isInfinity()) {
            return ((ECPoint)a).isInfinity();
        }
        return a2.J.equals(((ECPoint)a).J) && a2.C.equals(((ECPoint)a).C);
    }

    public ECPoint multiply(BigInteger a) {
        ECPoint a2;
        if (a.signum() < 0) {
            throw new IllegalArgumentException(Strings.do("Spd>!&KLHN^Dns\u007f{~3uha~x|.ss)equlzxma"));
        }
        if (a2.isInfinity()) {
            return a2;
        }
        if (a.signum() == 0) {
            return a2.super.getInfinity();
        }
        ECPoint eCPoint = a2;
        eCPoint.goto();
        ECPoint eCPoint2 = a2;
        return eCPoint.multiplier.do(eCPoint2, a, eCPoint2.preCompInfo);
    }

    void for(AuX a) {
        a.preCompInfo = a;
    }

    public abstract ECPoint twice();

    public abstract byte[] getEncoded();

    public boolean isInfinity() {
        ECPoint a;
        return a.J == null && a.C == null;
    }

    public boolean isCompressed() {
        ECPoint a;
        return a.withCompression;
    }

    public abstract ECPoint subtract(ECPoint var1);

    synchronized void goto() {
        ECPoint a;
        if (a.multiplier == null) {
            ECPoint eCPoint = a;
            eCPoint.multiplier = new cOn();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class F2m
    extends ECPoint {
        public F2m subtractSimple(F2m a) {
            F2m a2;
            if (a.isInfinity()) {
                return a2;
            }
            return a2.addSimple((F2m)a.negate());
        }

        public F2m addSimple(F2m a) {
            F2m a2;
            Object object = a;
            if (a2.isInfinity()) {
                return object;
            }
            if (((ECPoint)object).isInfinity()) {
                return a2;
            }
            ECFieldElement.F2m f2m = (ECFieldElement.F2m)((ECPoint)object).getX();
            object = (ECFieldElement.F2m)((ECPoint)object).getY();
            if (a2.J.equals(f2m)) {
                if (a2.C.equals(object)) {
                    return (F2m)a2.twice();
                }
                return (F2m)a2.super.getInfinity();
            }
            object = (ECFieldElement.F2m)a2.C.add((ECFieldElement)object).divide(a2.J.add(f2m));
            f2m = (ECFieldElement.F2m)((ECFieldElement.F2m)object).square().add((ECFieldElement)object).add(a2.J).add(f2m).add(a2.super.getA());
            object = (ECFieldElement.F2m)((ECFieldElement.F2m)object).multiply(a2.J.add(f2m)).add(f2m).add(a2.C);
            return new F2m(a2.super, f2m, (ECFieldElement)object, a2.withCompression);
        }

        @Override
        public ECPoint add(ECPoint a) {
            F2m a2;
            F2m f2m = a2;
            F2m.throw(f2m, a);
            return f2m.addSimple((F2m)a);
        }

        @Override
        public byte[] getEncoded() {
            F2m a;
            if (a.isInfinity()) {
                return new byte[1];
            }
            int n = A.getByteLength(a.J);
            byte[] byArray = A.integerToBytes(a.getX().toBigInteger(), n);
            if (a.withCompression) {
                byte[] byArray2 = new byte[n + 1];
                byArray2[0] = 2;
                if (!a.getX().toBigInteger().equals(ECConstants.ZERO) && a.getY().multiply(a.getX().invert()).toBigInteger().testBit(0)) {
                    byArray2[0] = 3;
                }
                System.arraycopy(byArray, 0, byArray2, 1, n);
                return byArray2;
            }
            byte[] byArray3 = A.integerToBytes(a.getY().toBigInteger(), n);
            int n2 = n;
            byte[] byArray4 = new byte[n2 + n2 + 1];
            byArray4[0] = 4;
            System.arraycopy(byArray, 0, byArray4, 1, n);
            System.arraycopy(byArray3, 0, byArray4, n + 1, n);
            return byArray4;
        }

        @Override
        synchronized void goto() {
            F2m a;
            if (a.multiplier == null) {
                if (((ECCurve.F2m)a.super).isKoblitz()) {
                    F2m f2m = a;
                    f2m.multiplier = new aux();
                    return;
                }
                a.multiplier = new cON();
            }
        }

        @Override
        public ECPoint subtract(ECPoint a) {
            F2m a2;
            F2m f2m = a2;
            F2m.throw(f2m, a);
            return f2m.subtractSimple((F2m)a);
        }

        @Override
        public ECPoint negate() {
            F2m a;
            return new F2m(a.super, a.getX(), a.getY().add(a.getX()), a.withCompression);
        }

        public F2m(ECCurve a, ECFieldElement a2, ECFieldElement a3) {
            a4(a, a2, a3, false);
            F2m a4;
        }

        @Override
        public ECPoint twice() {
            F2m a;
            if (a.isInfinity()) {
                return a;
            }
            if (a.J.toBigInteger().signum() == 0) {
                return a.super.getInfinity();
            }
            F2m f2m = a;
            ECFieldElement.F2m f2m2 = (ECFieldElement.F2m)f2m.J.add(f2m.C.divide(a.J));
            ECFieldElement.F2m f2m3 = (ECFieldElement.F2m)f2m2.square().add(f2m2).add(a.super.getA());
            F2m f2m4 = a;
            ECFieldElement eCFieldElement = f2m4.super.fromBigInteger(ECConstants.ONE);
            eCFieldElement = (ECFieldElement.F2m)f2m4.J.square().add(f2m3.multiply(f2m2.add(eCFieldElement)));
            return new F2m(a.super, f2m3, eCFieldElement, a.withCompression);
        }

        public F2m(ECCurve a, ECFieldElement a2, ECFieldElement a3, boolean a4) {
            F2m a5;
            ECFieldElement eCFieldElement = a2;
            super(a, eCFieldElement, a3);
            if (eCFieldElement != null && a3 == null || a2 == null && a3 != null) {
                throw new IllegalArgumentException(Tip.break("\u0018LwQd\u0013$4Y|U!LX<LrZ=Cn\u0010;s\u0015\u0006-Ys\b!Li\u001ftK:Kr\u0003!"));
            }
            if (a2 != null) {
                F2m f2m = a5;
                ECFieldElement.F2m.checkFieldElements(f2m.J, f2m.C);
                if (a != null) {
                    F2m f2m2 = a5;
                    ECFieldElement.F2m.checkFieldElements(f2m2.J, f2m2.super.getA());
                }
            }
            a5.withCompression = a4;
        }

        private static /* synthetic */ void throw(ECPoint a, ECPoint a2) {
            if (!a.super.equals(a2.super)) {
                throw new IllegalArgumentException(Sets.this("T\u0014o\u001b*\u001b.Il\u0017}Ot\u0014'\u0012)E*\u0018m\u0000$\u0000I>^;Z~c\u0000hGc\u0005;\u001b/NL,}SpCh\u000fe\u0012o\u001dc\u0015}\u001d"));
            }
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class Fp
    extends ECPoint {
        @Override
        public ECPoint add(ECPoint a) {
            Fp a2;
            if (a2.isInfinity()) {
                return a;
            }
            if (a.isInfinity()) {
                return a2;
            }
            if (a2.J.equals(a.J)) {
                if (a2.C.equals(a.C)) {
                    return a2.twice();
                }
                return a2.super.getInfinity();
            }
            ECFieldElement eCFieldElement = a.C.subtract(a2.C).divide(a.J.subtract(a2.J));
            ECFieldElement eCFieldElement2 = eCFieldElement.square().subtract(a2.J).subtract(a.J);
            ECFieldElement eCFieldElement3 = eCFieldElement.multiply(a2.J.subtract(eCFieldElement2)).subtract(a2.C);
            return new Fp(a2.super, eCFieldElement2, eCFieldElement3);
        }

        @Override
        synchronized void goto() {
            Fp a;
            if (a.multiplier == null) {
                Fp fp = a;
                fp.multiplier = new cON();
            }
        }

        @Override
        public ECPoint twice() {
            Fp a;
            if (a.isInfinity()) {
                return a;
            }
            if (a.C.toBigInteger().signum() == 0) {
                return a.super.getInfinity();
            }
            Fp fp = a;
            ECFieldElement eCFieldElement = fp.super.fromBigInteger(BigInteger.valueOf(2L));
            ECFieldElement eCFieldElement2 = fp.super.fromBigInteger(BigInteger.valueOf(3L));
            ECFieldElement eCFieldElement3 = fp.J.square().multiply(eCFieldElement2).add(a.super.J).divide(a.C.multiply(eCFieldElement));
            eCFieldElement2 = eCFieldElement3.square().subtract(a.J.multiply(eCFieldElement));
            ECFieldElement eCFieldElement4 = eCFieldElement3.multiply(a.J.subtract(eCFieldElement2)).subtract(a.C);
            return new Fp(a.super, eCFieldElement2, eCFieldElement4, a.withCompression);
        }

        public Fp(ECCurve a, ECFieldElement a2, ECFieldElement a3) {
            a4(a, a2, a3, false);
            Fp a4;
        }

        @Override
        public byte[] getEncoded() {
            Fp a;
            if (a.isInfinity()) {
                return new byte[1];
            }
            int n = A.getByteLength(a.J);
            if (a.withCompression) {
                int n2 = a.getY().toBigInteger().testBit(0) ? 3 : 2;
                byte[] byArray = A.integerToBytes(a.getX().toBigInteger(), n);
                byte[] byArray2 = new byte[byArray.length + 1];
                byArray2[0] = n2;
                System.arraycopy(byArray, 0, byArray2, 1, byArray.length);
                return byArray2;
            }
            byte[] byArray = A.integerToBytes(a.getX().toBigInteger(), n);
            byte[] byArray3 = A.integerToBytes(a.getY().toBigInteger(), n);
            byte[] byArray4 = new byte[byArray.length + byArray3.length + 1];
            byArray4[0] = 4;
            System.arraycopy(byArray, 0, byArray4, 1, byArray.length);
            System.arraycopy(byArray3, 0, byArray4, byArray.length + 1, byArray3.length);
            return byArray4;
        }

        @Override
        public ECPoint negate() {
            Fp a;
            Fp fp = a;
            return new Fp(fp.super, fp.J, a.C.negate(), a.withCompression);
        }

        public Fp(ECCurve a, ECFieldElement a2, ECFieldElement a3, boolean a4) {
            Fp a5;
            ECFieldElement eCFieldElement = a2;
            super(a, eCFieldElement, a3);
            if (eCFieldElement != null && a3 == null || a2 == null && a3 != null) {
                throw new IllegalArgumentException(OIDTokenizer.new("Z=wm)!ga}:bhth}1~&0h4\u0000Z\u0007\u0010\u0015O*q,t:ntnww\b@<o"));
            }
            a5.withCompression = a4;
        }

        @Override
        public ECPoint subtract(ECPoint a) {
            Fp a2;
            if (a.isInfinity()) {
                return a2;
            }
            return a2.add(a.negate());
        }
    }
}

