/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.core.bouncycastle.math.ec;

import com.jxdinfo.hussar.core.bouncycastle.math.ec.ECConstants;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.prn;
import com.jxdinfo.hussar.core.bouncycastle.util.Strings;
import com.jxdinfo.hussar.core.exception.InvalidKaptchaException;
import com.jxdinfo.hussar.core.qr.MatrixToImageConfig;
import com.jxdinfo.hussar.core.support.exception.ToolBoxException;
import java.math.BigInteger;
import java.util.Random;

public abstract class ECFieldElement
implements ECConstants {
    public abstract ECFieldElement invert();

    public abstract ECFieldElement multiply(ECFieldElement var1);

    public abstract ECFieldElement sqrt();

    public abstract ECFieldElement subtract(ECFieldElement var1);

    public abstract ECFieldElement square();

    public abstract String getFieldName();

    public abstract ECFieldElement add(ECFieldElement var1);

    public abstract int getFieldSize();

    public abstract ECFieldElement negate();

    public abstract BigInteger toBigInteger();

    public abstract ECFieldElement divide(ECFieldElement var1);

    public ECFieldElement() {
        ECFieldElement a;
    }

    public String toString() {
        ECFieldElement a;
        return a.toBigInteger().toString(2);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class F2m
    extends ECFieldElement {
        private int a;
        private int k;
        public static final int PPB = 3;
        private int H;
        private int A;
        public static final int TPB = 2;
        private int C;
        private int J;
        public static final int GNB = 1;
        private prn native;

        @Override
        public ECFieldElement negate() {
            F2m a;
            return a;
        }

        @Override
        public ECFieldElement divide(ECFieldElement a) {
            F2m a2;
            ECFieldElement eCFieldElement = a.invert();
            return a2.multiply(eCFieldElement);
        }

        @Override
        public ECFieldElement add(ECFieldElement a) {
            F2m a2;
            prn prn2 = (prn)a2.native.clone();
            F2m f2m = (F2m)a;
            prn2.for(f2m.native, 0);
            F2m f2m2 = a2;
            F2m f2m3 = a2;
            return new F2m(f2m2.C, f2m2.a, f2m3.H, f2m3.A, prn2);
        }

        @Override
        public ECFieldElement invert() {
            F2m a;
            prn prn2 = (prn)a.native.clone();
            prn prn3 = new prn(a.J);
            F2m f2m = a;
            prn prn4 = prn3;
            prn4.synchronized(a.C);
            prn4.synchronized(0);
            prn3.synchronized(f2m.a);
            if (f2m.k == 3) {
                prn prn5 = prn3;
                prn5.synchronized(a.H);
                prn5.synchronized(a.A);
            }
            prn prn6 = new prn(a.J);
            prn6.synchronized(0);
            prn prn7 = new prn(a.J);
            prn prn8 = prn2;
            while (!prn8.int()) {
                int n = prn2.private() - prn3.private();
                if (n < 0) {
                    prn prn9 = prn2;
                    prn2 = prn3;
                    prn3 = prn9;
                    prn prn10 = prn6;
                    prn6 = prn7;
                    prn7 = prn10;
                    n = -n;
                }
                int n2 = n >> 5;
                prn prn11 = prn3.this(n &= 0x1F);
                prn prn12 = prn2;
                prn8 = prn12;
                prn12.for(prn11, n2);
                prn prn13 = prn7.this(n);
                prn6.for(prn13, n2);
            }
            F2m f2m2 = a;
            F2m f2m3 = a;
            return new F2m(f2m2.C, f2m2.a, f2m3.H, f2m3.A, prn7);
        }

        public int getM() {
            F2m a;
            return a.C;
        }

        @Override
        public ECFieldElement sqrt() {
            throw new RuntimeException(MatrixToImageConfig.default("\u0015\u000b'O1\u00182Iw*\u0015]p\t?"));
        }

        public boolean equals(Object a) {
            F2m a2;
            if (a == a2) {
                return true;
            }
            if (!(a instanceof F2m)) {
                return false;
            }
            F2m f2m = (F2m)a;
            return a2.C == f2m.C && a2.a == f2m.a && a2.H == f2m.H && a2.A == f2m.A && a2.k == f2m.k && a2.native.equals(f2m.native);
        }

        public int getRepresentation() {
            F2m a;
            return a.k;
        }

        @Override
        public ECFieldElement multiply(ECFieldElement a) {
            F2m a2;
            Object object = (F2m)a;
            object = a2.native.private(((F2m)object).native, a2.C);
            int[] nArray = new int[3];
            nArray[0] = a2.a;
            nArray[1] = a2.H;
            nArray[2] = a2.A;
            ((prn)object).volatile(a2.C, nArray);
            F2m f2m = a2;
            F2m f2m2 = a2;
            return new F2m(f2m.C, f2m.a, f2m2.H, f2m2.A, (prn)object);
        }

        public int getK3() {
            F2m a;
            return a.A;
        }

        @Override
        public String getFieldName() {
            return MatrixToImageConfig.default("B^6");
        }

        public static void checkFieldElements(ECFieldElement a, ECFieldElement a2) {
            if (!(a instanceof F2m) || !(a2 instanceof F2m)) {
                throw new IllegalArgumentException(InvalidKaptchaException.transient("\u0006?=354\u007f;<60 4!|uh:q78`:\u001d\u001e\r\u001f\\\u001b=.+08;;#_\u001e0x\u001a\u0012\u00110:=0\u001f\"%su\u0012\u0006&@e4"));
            }
            F2m f2m = (F2m)a;
            F2m f2m2 = (F2m)a2;
            if (f2m.C != f2m2.C || f2m.a != f2m2.a || f2m.H != f2m2.H || f2m.A != f2m2.A) {
                throw new IllegalArgumentException(MatrixToImageConfig.default("^\u0005>\f3U'\u0005;B}\n'\u0011uNj!S,\u001a3P\r3\u0001>\b4\u0011!d\u001c\u000bz\u0010;\t{\u00172\u0002=U$Lw+\u0014\u0013B^6"));
            }
            if (f2m.k != f2m2.k) {
                throw new IllegalArgumentException(InvalidKaptchaException.transient("\u001572c\"?w/=,g()34;qqv24>;:3r=f\u007f\u007f?6#4\u007f\u0013\u0014\u0014\u0012\u0012\u0006 }70%x7>\u001c\u001e$*:2#y-4$(+3{~\b\u0013|o87"));
            }
        }

        public F2m(int a, int a2, int a3, int a4, BigInteger a5) {
            BigInteger bigInteger;
            F2m a6;
            a6.J = a + 31 >> 5;
            F2m f2m = a6;
            a6.native = new prn(a5, a6.J);
            if (a3 == 0 && a4 == 0) {
                bigInteger = a5;
                a6.k = 2;
            } else {
                if (a3 >= a4) {
                    throw new IllegalArgumentException(InvalidKaptchaException.transient("=j~=\n\u0002\"x=4w*2086+2>d\u0014\u0013f&<j"));
                }
                if (a3 <= 0) {
                    throw new IllegalArgumentException(MatrixToImageConfig.default("\u000e`d\u001e\u0018)\u0010s\u000e>D?\u000e*\u0012'W23\u0018RjLk"));
                }
                a6.k = 3;
                bigInteger = a5;
            }
            if (bigInteger.signum() < 0) {
                throw new IllegalArgumentException(InvalidKaptchaException.transient(".x(1\u0013\u00043x<0970%t8+`pu\u001b\u0013|o!<"));
            }
            F2m f2m2 = a6;
            a6.C = a;
            f2m2.a = a2;
            f2m2.H = a3;
            a6.A = a4;
        }

        public int getK2() {
            F2m a;
            return a.H;
        }

        public int getK1() {
            F2m a;
            return a.a;
        }

        @Override
        public ECFieldElement subtract(ECFieldElement a) {
            F2m a2;
            return a2.add(a);
        }

        @Override
        public int getFieldSize() {
            F2m a;
            return a.C;
        }

        private /* synthetic */ F2m(int a, int a2, int a3, int a4, prn a5) {
            F2m a6;
            F2m f2m = a6;
            F2m f2m2 = a6;
            F2m f2m3 = a6;
            f2m3.J = a + 31 >> 5;
            f2m3.native = a5;
            f2m2.C = a;
            f2m2.a = a2;
            f2m.H = a3;
            f2m.A = a4;
            if (a3 == 0 && a4 == 0) {
                a6.k = 2;
                return;
            }
            a6.k = 3;
        }

        @Override
        public BigInteger toBigInteger() {
            F2m a;
            return a.native.implements();
        }

        public F2m(int a, int a2, BigInteger a3) {
            a4(a, a2, 0, 0, a3);
            F2m a4;
        }

        @Override
        public ECFieldElement square() {
            F2m a;
            F2m f2m = a;
            prn prn2 = f2m.native.super(f2m.C);
            int[] nArray = new int[3];
            nArray[0] = a.a;
            nArray[1] = a.H;
            nArray[2] = a.A;
            prn2.volatile(a.C, nArray);
            F2m f2m2 = a;
            F2m f2m3 = a;
            return new F2m(f2m2.C, f2m2.a, f2m3.H, f2m3.A, prn2);
        }

        public int hashCode() {
            F2m a;
            return a.native.hashCode() ^ a.C ^ a.a ^ a.H ^ a.A;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class Fp
    extends ECFieldElement {
        BigInteger J;
        BigInteger enum;

        @Override
        public ECFieldElement invert() {
            Fp a;
            Fp fp = a;
            return new Fp(fp.J, fp.enum.modInverse(a.J));
        }

        @Override
        public int getFieldSize() {
            Fp a;
            return a.J.bitLength();
        }

        @Override
        public ECFieldElement square() {
            Fp a;
            Fp fp = a;
            return new Fp(fp.J, fp.enum.multiply(a.enum).mod(a.J));
        }

        @Override
        public ECFieldElement negate() {
            Fp a;
            Fp fp = a;
            return new Fp(fp.J, fp.enum.negate().mod(a.J));
        }

        public boolean equals(Object a) {
            Fp a2;
            if (a == a2) {
                return true;
            }
            if (!(a instanceof Fp)) {
                return false;
            }
            Fp fp = (Fp)a;
            return a2.J.equals(fp.J) && a2.enum.equals(fp.enum);
        }

        public BigInteger getQ() {
            Fp a;
            return a.J;
        }

        @Override
        public ECFieldElement sqrt() {
            Fp a;
            if (!a.J.testBit(0)) {
                throw new RuntimeException(Strings.do("JTf-ua}i0vs}"));
            }
            if (a.J.testBit(1)) {
                Fp fp = a;
                Fp fp2 = new Fp(fp.J, fp.enum.modPow(a.J.shiftRight(2).add(ECConstants.ONE), a.J));
                if (((ECFieldElement)fp2).square().equals(a)) {
                    return fp2;
                }
                return null;
            }
            Fp fp = a;
            BigInteger bigInteger = fp.J.subtract(ECConstants.ONE);
            BigInteger bigInteger2 = bigInteger.shiftRight(1);
            if (!fp.enum.modPow(bigInteger2, a.J).equals(ECConstants.ONE)) {
                return null;
            }
            BigInteger bigInteger3 = bigInteger.shiftRight(2).shiftLeft(1).add(ECConstants.ONE);
            BigInteger bigInteger4 = a.enum;
            BigInteger bigInteger5 = bigInteger4.shiftLeft(2).mod(a.J);
            Random random = new Random();
            while (true) {
                BigInteger bigInteger6;
                if ((bigInteger6 = new BigInteger(a.J.bitLength(), random)).compareTo(a.J) >= 0) {
                    continue;
                }
                BigInteger bigInteger7 = bigInteger6;
                if (!bigInteger7.multiply(bigInteger7).subtract(bigInteger5).modPow(bigInteger2, a.J).equals(bigInteger)) continue;
                BigInteger[] bigIntegerArray = Fp.goto(a.J, bigInteger6, bigInteger4, bigInteger3);
                BigInteger bigInteger8 = bigIntegerArray[0];
                BigInteger bigInteger9 = bigIntegerArray[1];
                if (bigInteger9.multiply(bigInteger9).mod(a.J).equals(bigInteger5)) {
                    if (bigInteger9.testBit(0)) {
                        bigInteger9 = bigInteger9.add(a.J);
                    }
                    bigInteger9 = bigInteger9.shiftRight(1);
                    return new Fp(a.J, bigInteger9);
                }
                if (!bigInteger8.equals(ECConstants.ONE) && !bigInteger8.equals(bigInteger)) break;
            }
            return null;
        }

        @Override
        public ECFieldElement subtract(ECFieldElement a) {
            Fp a2;
            Fp fp = a2;
            return new Fp(fp.J, fp.enum.subtract(a.toBigInteger()).mod(a2.J));
        }

        @Override
        public String getFieldName() {
            return ToolBoxException.try("\u0001\u001d");
        }

        @Override
        public BigInteger toBigInteger() {
            Fp a;
            return a.enum;
        }

        @Override
        public ECFieldElement multiply(ECFieldElement a) {
            Fp a2;
            Fp fp = a2;
            return new Fp(fp.J, fp.enum.multiply(a.toBigInteger()).mod(a2.J));
        }

        public int hashCode() {
            Fp a;
            return a.J.hashCode() ^ a.enum.hashCode();
        }

        private static /* synthetic */ BigInteger[] goto(BigInteger a, BigInteger a2, BigInteger a3, BigInteger a4) {
            BigInteger bigInteger = a4;
            int n = bigInteger.bitLength();
            int n2 = bigInteger.getLowestSetBit();
            BigInteger bigInteger2 = ECConstants.ONE;
            BigInteger bigInteger3 = ECConstants.TWO;
            BigInteger bigInteger4 = a2;
            BigInteger bigInteger5 = ECConstants.ONE;
            BigInteger bigInteger6 = ECConstants.ONE;
            int n3 = n = n - 1;
            while (n3 >= n2 + 1) {
                bigInteger5 = bigInteger5.multiply(bigInteger6).mod(a);
                if (a4.testBit(n)) {
                    bigInteger6 = bigInteger5.multiply(a3).mod(a);
                    bigInteger2 = bigInteger2.multiply(bigInteger4).mod(a);
                    BigInteger bigInteger7 = bigInteger4;
                    bigInteger3 = bigInteger7.multiply(bigInteger3).subtract(a2.multiply(bigInteger5)).mod(a);
                    bigInteger4 = bigInteger7.multiply(bigInteger7).subtract(bigInteger6.shiftLeft(1)).mod(a);
                } else {
                    bigInteger6 = bigInteger5;
                    bigInteger2 = bigInteger2.multiply(bigInteger3).subtract(bigInteger5).mod(a);
                    bigInteger4 = bigInteger4.multiply(bigInteger3).subtract(a2.multiply(bigInteger5)).mod(a);
                    BigInteger bigInteger8 = bigInteger3;
                    bigInteger3 = bigInteger8.multiply(bigInteger8).subtract(bigInteger5.shiftLeft(1)).mod(a);
                }
                n3 = --n;
            }
            bigInteger5 = bigInteger5.multiply(bigInteger6).mod(a);
            bigInteger6 = bigInteger5.multiply(a3).mod(a);
            bigInteger2 = bigInteger2.multiply(bigInteger3).subtract(bigInteger5).mod(a);
            BigInteger bigInteger9 = bigInteger5;
            bigInteger3 = bigInteger4.multiply(bigInteger3).subtract(a2.multiply(bigInteger9)).mod(a);
            bigInteger5 = bigInteger9.multiply(bigInteger6).mod(a);
            int n4 = n = 1;
            while (n4 <= n2) {
                bigInteger2 = bigInteger2.multiply(bigInteger3).mod(a);
                BigInteger bigInteger10 = bigInteger3;
                bigInteger3 = bigInteger10.multiply(bigInteger10).subtract(bigInteger5.shiftLeft(1)).mod(a);
                BigInteger bigInteger11 = bigInteger5;
                bigInteger5 = bigInteger11.multiply(bigInteger11).mod(a);
                n4 = ++n;
            }
            BigInteger[] bigIntegerArray = new BigInteger[2];
            bigIntegerArray[0] = bigInteger2;
            bigIntegerArray[1] = bigInteger3;
            return bigIntegerArray;
        }

        @Override
        public ECFieldElement divide(ECFieldElement a) {
            Fp a2;
            Fp fp = a2;
            return new Fp(fp.J, fp.enum.multiply(a.toBigInteger().modInverse(a2.J)).mod(a2.J));
        }

        public Fp(BigInteger a, BigInteger a2) {
            Fp a3;
            a3.enum = a2;
            if (a3.enum.compareTo(a) >= 0) {
                throw new IllegalArgumentException(Strings.do("~9QYbdb8{\u007fh8`rdn#yMU2k7$gp,vgq{l27"));
            }
            a3.J = a;
        }

        @Override
        public ECFieldElement add(ECFieldElement a) {
            Fp a2;
            Fp fp = a2;
            return new Fp(fp.J, fp.enum.add(a.toBigInteger()).mod(a2.J));
        }
    }
}

