/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.core.bouncycastle.jce.provider.asymmetric.ec;

import com.jxdinfo.hussar.core.bouncycastle.jce.provider.asymmetric.ec.ECUtil;
import com.jxdinfo.hussar.core.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import com.jxdinfo.hussar.core.bouncycastle.jce.spec.ECNamedCurveSpec;
import com.jxdinfo.hussar.core.bouncycastle.jce.spec.ECParameterSpec;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.ECCurve;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.ECPoint;
import java.math.BigInteger;
import java.security.spec.ECField;
import java.security.spec.ECFieldF2m;
import java.security.spec.ECFieldFp;
import java.security.spec.EllipticCurve;

public class EC5Util {
    public EC5Util() {
        EC5Util a;
    }

    public static ECCurve convertCurve(EllipticCurve a) {
        EllipticCurve ellipticCurve = a;
        ECField eCField = ellipticCurve.getField();
        BigInteger bigInteger = ellipticCurve.getA();
        BigInteger bigInteger2 = ellipticCurve.getB();
        if (eCField instanceof ECFieldFp) {
            return new ECCurve.Fp(((ECFieldFp)eCField).getP(), bigInteger, bigInteger2);
        }
        ECFieldF2m eCFieldF2m = (ECFieldF2m)eCField;
        int n = eCFieldF2m.getM();
        int[] nArray = ECUtil.super(eCFieldF2m.getMidTermsOfReductionPolynomial());
        return new ECCurve.F2m(n, nArray[0], nArray[1], nArray[2], bigInteger, bigInteger2);
    }

    public static ECParameterSpec convertSpec(java.security.spec.ECParameterSpec a, boolean a2) {
        ECCurve eCCurve;
        ECCurve eCCurve2 = eCCurve = EC5Util.convertCurve(a.getCurve());
        return new ECParameterSpec(eCCurve2, EC5Util.convertPoint(eCCurve2, a.getGenerator(), a2), a.getOrder(), BigInteger.valueOf(a.getCofactor()), a.getCurve().getSeed());
    }

    public static ECPoint convertPoint(ECCurve a, java.security.spec.ECPoint a2, boolean a3) {
        return a.createPoint(a2.getAffineX(), a2.getAffineY(), a3);
    }

    public static EllipticCurve convertCurve(ECCurve a, byte[] a2) {
        if (a instanceof ECCurve.Fp) {
            return new EllipticCurve(new ECFieldFp(((ECCurve.Fp)a).getQ()), a.getA().toBigInteger(), a.getB().toBigInteger(), null);
        }
        ECCurve.F2m f2m = (ECCurve.F2m)a;
        a2 = f2m;
        if (f2m.isTrinomial()) {
            int[] nArray = new int[1];
            nArray[0] = ((ECCurve.F2m)a2).getK1();
            int[] nArray2 = nArray;
            return new EllipticCurve(new ECFieldF2m(((ECCurve.F2m)a2).getM(), nArray2), a.getA().toBigInteger(), a.getB().toBigInteger(), null);
        }
        int[] nArray = new int[3];
        nArray[0] = ((ECCurve.F2m)a2).getK3();
        nArray[1] = ((ECCurve.F2m)a2).getK2();
        nArray[2] = ((ECCurve.F2m)a2).getK1();
        int[] nArray3 = nArray;
        return new EllipticCurve(new ECFieldF2m(((ECCurve.F2m)a2).getM(), nArray3), a.getA().toBigInteger(), a.getB().toBigInteger(), null);
    }

    public static ECPoint convertPoint(java.security.spec.ECParameterSpec a, java.security.spec.ECPoint a2, boolean a3) {
        return EC5Util.convertPoint(EC5Util.convertCurve(a.getCurve()), a2, a3);
    }

    public static java.security.spec.ECParameterSpec convertSpec(EllipticCurve a, ECParameterSpec a2) {
        if (a2 instanceof ECNamedCurveParameterSpec) {
            return new ECNamedCurveSpec(((ECNamedCurveParameterSpec)a2).getName(), a, new java.security.spec.ECPoint(a2.getG().getX().toBigInteger(), a2.getG().getY().toBigInteger()), a2.getN(), a2.getH());
        }
        return new java.security.spec.ECParameterSpec(a, new java.security.spec.ECPoint(a2.getG().getX().toBigInteger(), a2.getG().getY().toBigInteger()), a2.getN(), a2.getH().intValue());
    }
}

