/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.core.bouncycastle.math.ec;

import com.jxdinfo.hussar.core.bouncycastle.asn1.x9.X9IntegerConverter;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.CON;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.ECConstants;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.ECCurve;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.ECFieldElement;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.NuL;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.Prn;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.nul;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.prn;
import com.jxdinfo.hussar.core.support.WafKit;
import com.jxdinfo.hussar.core.util.IdGenerator;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.math.BigInteger;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class ECPoint {
    protected CON multiplier;
    ECFieldElement C;
    private static X9IntegerConverter G = new X9IntegerConverter();
    protected boolean withCompression;
    protected nul preCompInfo;
    ECCurve b;
    ECFieldElement return;

    public abstract ECPoint negate();

    public abstract ECPoint twice();

    void throws(nul a) {
        a.preCompInfo = a;
    }

    public ECFieldElement getY() {
        ECPoint a;
        return a.return;
    }

    public int hashCode() {
        ECPoint a;
        if (a.isInfinity()) {
            return 0;
        }
        return a.C.hashCode() ^ a.return.hashCode();
    }

    public boolean isCompressed() {
        ECPoint a;
        return a.withCompression;
    }

    synchronized void super() {
        ECPoint a;
        if (a.multiplier == null) {
            ECPoint eCPoint = a;
            eCPoint.multiplier = new prn();
        }
    }

    public ECFieldElement getX() {
        ECPoint a;
        return a.C;
    }

    public abstract byte[] getEncoded();

    public boolean isInfinity() {
        ECPoint a;
        return a.C == null && a.return == null;
    }

    public ECPoint multiply(BigInteger a) {
        ECPoint a2;
        if (a.signum() < 0) {
            throw new IllegalArgumentException(ToolUtil.return("l\u001a[T\u001eLt&w$a.Q\u0019@\u0011AYJ\u0002^\u0014G\u0016\u0011\u0019LCZ\u001bJ\u0006E\u0012R\u000b"));
        }
        if (a2.isInfinity()) {
            return a2;
        }
        if (a.signum() == 0) {
            return a2.b.getInfinity();
        }
        ECPoint eCPoint = a2;
        eCPoint.super();
        ECPoint eCPoint2 = a2;
        return eCPoint.multiplier.this(eCPoint2, a, eCPoint2.preCompInfo);
    }

    public abstract ECPoint add(ECPoint var1);

    public ECCurve getCurve() {
        ECPoint a;
        return a.b;
    }

    public boolean equals(Object a) {
        ECPoint a2;
        if (a == a2) {
            return true;
        }
        if (!(a instanceof ECPoint)) {
            return false;
        }
        a = (ECPoint)a;
        if (a2.isInfinity()) {
            return ((ECPoint)a).isInfinity();
        }
        return a2.C.equals(((ECPoint)a).C) && a2.return.equals(((ECPoint)a).return);
    }

    protected ECPoint(ECCurve a, ECFieldElement a2, ECFieldElement a3) {
        ECPoint a4;
        ECPoint eCPoint = a4;
        ECPoint eCPoint2 = a4;
        a4.multiplier = null;
        eCPoint2.preCompInfo = null;
        eCPoint2.b = a;
        eCPoint.C = a2;
        eCPoint.return = a3;
    }

    public abstract ECPoint subtract(ECPoint var1);

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class F2m
    extends ECPoint {
        public F2m addSimple(F2m a) {
            F2m a2;
            Object object = a;
            if (a2.isInfinity()) {
                return object;
            }
            if (((ECPoint)object).isInfinity()) {
                return a2;
            }
            ECFieldElement.F2m f2m = (ECFieldElement.F2m)((ECPoint)object).getX();
            object = (ECFieldElement.F2m)((ECPoint)object).getY();
            if (a2.C.equals(f2m)) {
                if (a2.return.equals(object)) {
                    return (F2m)a2.twice();
                }
                return (F2m)a2.b.getInfinity();
            }
            object = (ECFieldElement.F2m)a2.return.add((ECFieldElement)object).divide(a2.C.add(f2m));
            f2m = (ECFieldElement.F2m)((ECFieldElement.F2m)object).square().add((ECFieldElement)object).add(a2.C).add(f2m).add(a2.b.getA());
            object = (ECFieldElement.F2m)((ECFieldElement.F2m)object).multiply(a2.C.add(f2m)).add(f2m).add(a2.return);
            return new F2m(a2.b, f2m, (ECFieldElement)object, a2.withCompression);
        }

        public F2m(ECCurve a, ECFieldElement a2, ECFieldElement a3) {
            a4(a, a2, a3, false);
            F2m a4;
        }

        @Override
        public ECPoint add(ECPoint a) {
            F2m a2;
            F2m f2m = a2;
            F2m.class(f2m, a);
            return f2m.addSimple((F2m)a);
        }

        @Override
        public byte[] getEncoded() {
            F2m a;
            if (a.isInfinity()) {
                return new byte[1];
            }
            int n = G.getByteLength(a.C);
            byte[] byArray = G.integerToBytes(a.getX().toBigInteger(), n);
            if (a.withCompression) {
                byte[] byArray2 = new byte[n + 1];
                byArray2[0] = 2;
                if (!a.getX().toBigInteger().equals(ECConstants.ZERO) && a.getY().multiply(a.getX().invert()).toBigInteger().testBit(0)) {
                    byArray2[0] = 3;
                }
                System.arraycopy(byArray, 0, byArray2, 1, n);
                return byArray2;
            }
            byte[] byArray3 = G.integerToBytes(a.getY().toBigInteger(), n);
            int n2 = n;
            byte[] byArray4 = new byte[n2 + n2 + 1];
            byArray4[0] = 4;
            System.arraycopy(byArray, 0, byArray4, 1, n);
            System.arraycopy(byArray3, 0, byArray4, n + 1, n);
            return byArray4;
        }

        public F2m(ECCurve a, ECFieldElement a2, ECFieldElement a3, boolean a4) {
            F2m a5;
            ECFieldElement eCFieldElement = a2;
            super(a, eCFieldElement, a3);
            if (eCFieldElement != null && a3 == null || a2 == null && a3 != null) {
                throw new IllegalArgumentException(X9IntegerConverter.private("d~\u000bc\u0018!X\u0006%N)\u00130j@~\u000ehAq\u0012\"GAi4Qk\u000f:]~\u0015-\byFy\u000e1]"));
            }
            if (a2 != null) {
                F2m f2m = a5;
                ECFieldElement.F2m.checkFieldElements(f2m.C, f2m.return);
                if (a != null) {
                    F2m f2m2 = a5;
                    ECFieldElement.F2m.checkFieldElements(f2m2.C, f2m2.b.getA());
                }
            }
            a5.withCompression = a4;
        }

        public F2m subtractSimple(F2m a) {
            F2m a2;
            if (a.isInfinity()) {
                return a2;
            }
            return a2.addSimple((F2m)a.negate());
        }

        @Override
        synchronized void super() {
            F2m a;
            if (a.multiplier == null) {
                if (((ECCurve.F2m)a.b).isKoblitz()) {
                    F2m f2m = a;
                    f2m.multiplier = new Prn();
                    return;
                }
                a.multiplier = new NuL();
            }
        }

        private static /* synthetic */ void class(ECPoint a, ECPoint a2) {
            if (!a.b.equals(a2.b)) {
                throw new IllegalArgumentException(IdGenerator.interface("\"J\u0019E\\EX\u0017\u001aI\u000b\u0011\u0002JQL_\u001b\\F\u001b^R^?`(e, \u0015^\u001e\u0019\u0015[MEY\u0010:r\u000b\r\u0006\u001d\tF\u0017H\nP\tW\u000fG"));
            }
        }

        @Override
        public ECPoint twice() {
            F2m a;
            if (a.isInfinity()) {
                return a;
            }
            if (a.C.toBigInteger().signum() == 0) {
                return a.b.getInfinity();
            }
            F2m f2m = a;
            ECFieldElement.F2m f2m2 = (ECFieldElement.F2m)f2m.C.add(f2m.return.divide(a.C));
            ECFieldElement.F2m f2m3 = (ECFieldElement.F2m)f2m2.square().add(f2m2).add(a.b.getA());
            F2m f2m4 = a;
            ECFieldElement eCFieldElement = f2m4.b.fromBigInteger(ECConstants.ONE);
            eCFieldElement = (ECFieldElement.F2m)f2m4.C.square().add(f2m3.multiply(f2m2.add(eCFieldElement)));
            return new F2m(a.b, f2m3, eCFieldElement, a.withCompression);
        }

        @Override
        public ECPoint negate() {
            F2m a;
            return new F2m(a.b, a.getX(), a.getY().add(a.getX()), a.withCompression);
        }

        @Override
        public ECPoint subtract(ECPoint a) {
            F2m a2;
            F2m f2m = a2;
            F2m.class(f2m, a);
            return f2m.subtractSimple((F2m)a);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class Fp
    extends ECPoint {
        @Override
        public ECPoint subtract(ECPoint a) {
            Fp a2;
            if (a.isInfinity()) {
                return a2;
            }
            return a2.add(a.negate());
        }

        @Override
        synchronized void super() {
            Fp a;
            if (a.multiplier == null) {
                Fp fp = a;
                fp.multiplier = new NuL();
            }
        }

        public Fp(ECCurve a, ECFieldElement a2, ECFieldElement a3, boolean a4) {
            Fp a5;
            ECFieldElement eCFieldElement = a2;
            super(a, eCFieldElement, a3);
            if (eCFieldElement != null && a3 == null || a2 == null && a3 != null) {
                throw new IllegalArgumentException(WafKit.abstract("Tz6*h#c\"8\u0007YOU\u001a\t7~ 0$~=al}\u000fS9du+1cb~606x~+"));
            }
            a5.withCompression = a4;
        }

        public Fp(ECCurve a, ECFieldElement a2, ECFieldElement a3) {
            a4(a, a2, a3, false);
            Fp a4;
        }

        @Override
        public ECPoint add(ECPoint a) {
            Fp a2;
            if (a2.isInfinity()) {
                return a;
            }
            if (a.isInfinity()) {
                return a2;
            }
            if (a2.C.equals(a.C)) {
                if (a2.return.equals(a.return)) {
                    return a2.twice();
                }
                return a2.b.getInfinity();
            }
            ECFieldElement eCFieldElement = a.return.subtract(a2.return).divide(a.C.subtract(a2.C));
            ECFieldElement eCFieldElement2 = eCFieldElement.square().subtract(a2.C).subtract(a.C);
            ECFieldElement eCFieldElement3 = eCFieldElement.multiply(a2.C.subtract(eCFieldElement2)).subtract(a2.return);
            return new Fp(a2.b, eCFieldElement2, eCFieldElement3);
        }

        @Override
        public byte[] getEncoded() {
            Fp a;
            if (a.isInfinity()) {
                return new byte[1];
            }
            int n = G.getByteLength(a.C);
            if (a.withCompression) {
                int n2 = a.getY().toBigInteger().testBit(0) ? 3 : 2;
                byte[] byArray = G.integerToBytes(a.getX().toBigInteger(), n);
                byte[] byArray2 = new byte[byArray.length + 1];
                byArray2[0] = n2;
                System.arraycopy(byArray, 0, byArray2, 1, byArray.length);
                return byArray2;
            }
            byte[] byArray = G.integerToBytes(a.getX().toBigInteger(), n);
            byte[] byArray3 = G.integerToBytes(a.getY().toBigInteger(), n);
            byte[] byArray4 = new byte[byArray.length + byArray3.length + 1];
            byArray4[0] = 4;
            System.arraycopy(byArray, 0, byArray4, 1, byArray.length);
            System.arraycopy(byArray3, 0, byArray4, byArray.length + 1, byArray3.length);
            return byArray4;
        }

        @Override
        public ECPoint negate() {
            Fp a;
            Fp fp = a;
            return new Fp(fp.b, fp.C, a.return.negate(), a.withCompression);
        }

        @Override
        public ECPoint twice() {
            Fp a;
            if (a.isInfinity()) {
                return a;
            }
            if (a.return.toBigInteger().signum() == 0) {
                return a.b.getInfinity();
            }
            Fp fp = a;
            ECFieldElement eCFieldElement = fp.b.fromBigInteger(BigInteger.valueOf(2L));
            ECFieldElement eCFieldElement2 = fp.b.fromBigInteger(BigInteger.valueOf(3L));
            ECFieldElement eCFieldElement3 = fp.C.square().multiply(eCFieldElement2).add(a.b.else).divide(a.return.multiply(eCFieldElement));
            eCFieldElement2 = eCFieldElement3.square().subtract(a.C.multiply(eCFieldElement));
            ECFieldElement eCFieldElement4 = eCFieldElement3.multiply(a.C.subtract(eCFieldElement2)).subtract(a.return);
            return new Fp(a.b, eCFieldElement2, eCFieldElement4, a.withCompression);
        }
    }
}

