/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.core.bouncycastle.math.ec;

import com.jxdinfo.hussar.core.Contact;
import com.jxdinfo.hussar.core.bouncycastle.jce.ECGOST3410NamedCurveTable;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.ECConstants;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.con;
import com.jxdinfo.hussar.core.encrypt.file.util.StrKit;
import com.jxdinfo.hussar.core.util.CRC32Util;
import java.math.BigInteger;
import java.util.Random;

public abstract class ECFieldElement
implements ECConstants {
    public abstract int getFieldSize();

    public abstract ECFieldElement divide(ECFieldElement var1);

    public abstract ECFieldElement square();

    public abstract ECFieldElement multiply(ECFieldElement var1);

    public abstract ECFieldElement add(ECFieldElement var1);

    public abstract BigInteger toBigInteger();

    public abstract ECFieldElement negate();

    public abstract ECFieldElement subtract(ECFieldElement var1);

    public abstract ECFieldElement invert();

    public ECFieldElement() {
        ECFieldElement a;
    }

    public String toString() {
        ECFieldElement a;
        return a.toBigInteger().toString(2);
    }

    public abstract String getFieldName();

    public abstract ECFieldElement sqrt();

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class F2m
    extends ECFieldElement {
        private int B;
        private int D;
        public static final int TPB = 2;
        private int f;
        public static final int GNB = 1;
        private int C;
        private con G;
        public static final int PPB = 3;
        private int b;
        private int switch;

        private /* synthetic */ F2m(int a, int a2, int a3, int a4, con a5) {
            F2m a6;
            F2m f2m = a6;
            F2m f2m2 = a6;
            F2m f2m3 = a6;
            f2m3.B = a + 31 >> 5;
            f2m3.G = a5;
            f2m2.f = a;
            f2m2.C = a2;
            f2m.switch = a3;
            f2m.b = a4;
            if (a3 == 0 && a4 == 0) {
                a6.D = 2;
                return;
            }
            a6.D = 3;
        }

        @Override
        public BigInteger toBigInteger() {
            F2m a;
            return a.G.final();
        }

        @Override
        public ECFieldElement multiply(ECFieldElement a) {
            F2m a2;
            Object object = (F2m)a;
            object = a2.G.protected(((F2m)object).G, a2.f);
            int[] nArray = new int[3];
            nArray[0] = a2.C;
            nArray[1] = a2.switch;
            nArray[2] = a2.b;
            ((con)object).new(a2.f, nArray);
            F2m f2m = a2;
            F2m f2m2 = a2;
            return new F2m(f2m.f, f2m.C, f2m2.switch, f2m2.b, (con)object);
        }

        @Override
        public ECFieldElement sqrt() {
            throw new RuntimeException(StrKit.int("iI1rX`\u001e\u007f\u0015|\u0017|\u0005q\u0013"));
        }

        @Override
        public int getFieldSize() {
            F2m a;
            return a.f;
        }

        public int getM() {
            F2m a;
            return a.f;
        }

        public int getK1() {
            F2m a;
            return a.C;
        }

        @Override
        public ECFieldElement subtract(ECFieldElement a) {
            F2m a2;
            return a2.add(a);
        }

        public F2m(int a, int a2, BigInteger a3) {
            a4(a, a2, 0, 0, a3);
            F2m a4;
        }

        @Override
        public ECFieldElement negate() {
            F2m a;
            return a;
        }

        @Override
        public ECFieldElement add(ECFieldElement a) {
            F2m a2;
            con con2 = (con)a2.G.clone();
            F2m f2m = (F2m)a;
            con2.const(f2m.G, 0);
            F2m f2m2 = a2;
            F2m f2m3 = a2;
            return new F2m(f2m2.f, f2m2.C, f2m3.switch, f2m3.b, con2);
        }

        @Override
        public ECFieldElement invert() {
            F2m a;
            con con2 = (con)a.G.clone();
            con con3 = new con(a.B);
            F2m f2m = a;
            con con4 = con3;
            con4.private(a.f);
            con4.private(0);
            con3.private(f2m.C);
            if (f2m.D == 3) {
                con con5 = con3;
                con5.private(a.switch);
                con5.private(a.b);
            }
            con con6 = new con(a.B);
            con6.private(0);
            con con7 = new con(a.B);
            con con8 = con2;
            while (!con8.import()) {
                int n = con2.null() - con3.null();
                if (n < 0) {
                    con con9 = con2;
                    con2 = con3;
                    con3 = con9;
                    con con10 = con6;
                    con6 = con7;
                    con7 = con10;
                    n = -n;
                }
                int n2 = n >> 5;
                con con11 = con3.assert(n &= 0x1F);
                con con12 = con2;
                con8 = con12;
                con12.const(con11, n2);
                con con13 = con7.assert(n);
                con6.const(con13, n2);
            }
            F2m f2m2 = a;
            F2m f2m3 = a;
            return new F2m(f2m2.f, f2m2.C, f2m3.switch, f2m3.b, con7);
        }

        public int getK3() {
            F2m a;
            return a.b;
        }

        public boolean equals(Object a) {
            F2m a2;
            if (a == a2) {
                return true;
            }
            if (!(a instanceof F2m)) {
                return false;
            }
            F2m f2m = (F2m)a;
            return a2.f == f2m.f && a2.C == f2m.C && a2.switch == f2m.switch && a2.b == f2m.b && a2.D == f2m.D && a2.G.equals(f2m.G);
        }

        @Override
        public String getFieldName() {
            return StrKit.int("(7\u000b");
        }

        @Override
        public ECFieldElement divide(ECFieldElement a) {
            F2m a2;
            ECFieldElement eCFieldElement = a.invert();
            return a2.multiply(eCFieldElement);
        }

        public int getRepresentation() {
            F2m a;
            return a.D;
        }

        public static void checkFieldElements(ECFieldElement a, ECFieldElement a2) {
            if (!(a instanceof F2m) || !(a2 instanceof F2m)) {
                throw new IllegalArgumentException(CRC32Util.new("\u0002s\u0000_(\u001a ^(W _:Xt\u001av|F\u0003}Fm^,C \u001a,R0@*w\u0005S:\u001a*Ul~\u0007\\\fV ^\u0000^(W _:\u0005\u0012\u001e>"));
            }
            F2m f2m = (F2m)a;
            F2m f2m2 = (F2m)a2;
            if (f2m.f != f2m2.f || f2m.C != f2m2.C || f2m.switch != f2m2.switch || f2m.b != f2m2.b) {
                throw new IllegalArgumentException(StrKit.int(" d\u000bi\u0002.\bx\u0012)BH1!\u0011l\u001cf@f\u0004qFf\fn\u0005C+}\u0019%\tjOp\u000f@f\u007f\u000eh\u0003-\bl\u0003b\t41!\u001d"));
            }
            if (f2m.D != f2m2.D) {
                throw new IllegalArgumentException(CRC32Util.new("*r\u00069\tPiN-Vl]-\u007f\tWl_)W _+E=\u000b5\ta9\b\u0002f\u0012(P&Z-T1Oc\\*jF_'Y*A>^'nEA)J7W>_+E/_=C="));
            }
        }

        public int getK2() {
            F2m a;
            return a.switch;
        }

        public F2m(int a, int a2, int a3, int a4, BigInteger a5) {
            BigInteger bigInteger;
            F2m a6;
            a6.B = a + 31 >> 5;
            F2m f2m = a6;
            a6.G = new con(a5, a6.B);
            if (a3 == 0 && a4 == 0) {
                bigInteger = a5;
                a6.D = 2;
            } else {
                if (a3 >= a4) {
                    throw new IllegalArgumentException(CRC32Util.new("Qw\u0011#^'\u000f${\u0003Ma_,\u000fpS;\u0011:^(Et\n-"));
                }
                if (a3 <= 0) {
                    throw new IllegalArgumentException(StrKit.int("e_4\u001a1TRe0T-\u0002=Mn\u000f|M}\u0002u\u0019~\r"));
                }
                a6.D = 3;
                bigInteger = a5;
            }
            if (bigInteger.signum() < 0) {
                throw new IllegalArgumentException(CRC32Util.new("BeG/G!\u001e$z\u0007\u0003|]9C~Si_+Q(_=\u0017{"));
            }
            F2m f2m2 = a6;
            a6.f = a;
            f2m2.C = a2;
            f2m2.switch = a3;
            a6.b = a4;
        }

        @Override
        public ECFieldElement square() {
            F2m a;
            F2m f2m = a;
            con con2 = f2m.G.byte(f2m.f);
            int[] nArray = new int[3];
            nArray[0] = a.C;
            nArray[1] = a.switch;
            nArray[2] = a.b;
            con2.new(a.f, nArray);
            F2m f2m2 = a;
            F2m f2m3 = a;
            return new F2m(f2m2.f, f2m2.C, f2m3.switch, f2m3.b, con2);
        }

        public int hashCode() {
            F2m a;
            return a.G.hashCode() ^ a.f ^ a.C ^ a.switch ^ a.b;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class Fp
    extends ECFieldElement {
        BigInteger b;
        BigInteger private;

        @Override
        public String getFieldName() {
            return ECGOST3410NamedCurveTable.public("\u0003]");
        }

        public boolean equals(Object a) {
            Fp a2;
            if (a == a2) {
                return true;
            }
            if (!(a instanceof Fp)) {
                return false;
            }
            Fp fp = (Fp)a;
            return a2.private.equals(fp.private) && a2.b.equals(fp.b);
        }

        public int hashCode() {
            Fp a;
            return a.private.hashCode() ^ a.b.hashCode();
        }

        @Override
        public BigInteger toBigInteger() {
            Fp a;
            return a.b;
        }

        @Override
        public ECFieldElement subtract(ECFieldElement a) {
            Fp a2;
            Fp fp = a2;
            return new Fp(fp.private, fp.b.subtract(a.toBigInteger()).mod(a2.private));
        }

        @Override
        public ECFieldElement sqrt() {
            Fp a;
            if (!a.private.testBit(0)) {
                throw new RuntimeException(Contact.short("<#\u0010Z\u0003\u0016\u000b\u001eF\u0001\u0005\n"));
            }
            if (a.private.testBit(1)) {
                Fp fp = a;
                Fp fp2 = new Fp(fp.private, fp.b.modPow(a.private.shiftRight(2).add(ECConstants.ONE), a.private));
                if (((ECFieldElement)fp2).square().equals(a)) {
                    return fp2;
                }
                return null;
            }
            Fp fp = a;
            BigInteger bigInteger = fp.private.subtract(ECConstants.ONE);
            BigInteger bigInteger2 = bigInteger.shiftRight(1);
            if (!fp.b.modPow(bigInteger2, a.private).equals(ECConstants.ONE)) {
                return null;
            }
            BigInteger bigInteger3 = bigInteger.shiftRight(2).shiftLeft(1).add(ECConstants.ONE);
            BigInteger bigInteger4 = a.b;
            BigInteger bigInteger5 = bigInteger4.shiftLeft(2).mod(a.private);
            Random random = new Random();
            while (true) {
                BigInteger bigInteger6;
                if ((bigInteger6 = new BigInteger(a.private.bitLength(), random)).compareTo(a.private) >= 0) {
                    continue;
                }
                BigInteger bigInteger7 = bigInteger6;
                if (!bigInteger7.multiply(bigInteger7).subtract(bigInteger5).modPow(bigInteger2, a.private).equals(bigInteger)) continue;
                BigInteger[] bigIntegerArray = Fp.abstract(a.private, bigInteger6, bigInteger4, bigInteger3);
                BigInteger bigInteger8 = bigIntegerArray[0];
                BigInteger bigInteger9 = bigIntegerArray[1];
                if (bigInteger9.multiply(bigInteger9).mod(a.private).equals(bigInteger5)) {
                    if (bigInteger9.testBit(0)) {
                        bigInteger9 = bigInteger9.add(a.private);
                    }
                    bigInteger9 = bigInteger9.shiftRight(1);
                    return new Fp(a.private, bigInteger9);
                }
                if (!bigInteger8.equals(ECConstants.ONE) && !bigInteger8.equals(bigInteger)) break;
            }
            return null;
        }

        @Override
        public ECFieldElement negate() {
            Fp a;
            Fp fp = a;
            return new Fp(fp.private, fp.b.negate().mod(a.private));
        }

        public Fp(BigInteger a, BigInteger a2) {
            Fp a3;
            a3.b = a2;
            if (a3.b.compareTo(a) >= 0) {
                throw new IllegalArgumentException(Contact.short("\bN'.\u0014\u0013\u0014O\r\b\u001eO\u0016\u0005\u0012\u0019U\u000e;\"D\u001cAS\u0011\u0007Z\u0001\u0011\u0006\r\u001bD@"));
            }
            a3.private = a;
        }

        @Override
        public ECFieldElement invert() {
            Fp a;
            Fp fp = a;
            return new Fp(fp.private, fp.b.modInverse(a.private));
        }

        @Override
        public ECFieldElement square() {
            Fp a;
            Fp fp = a;
            return new Fp(fp.private, fp.b.multiply(a.b).mod(a.private));
        }

        private static /* synthetic */ BigInteger[] abstract(BigInteger a, BigInteger a2, BigInteger a3, BigInteger a4) {
            BigInteger bigInteger = a4;
            int n = bigInteger.bitLength();
            int n2 = bigInteger.getLowestSetBit();
            BigInteger bigInteger2 = ECConstants.ONE;
            BigInteger bigInteger3 = ECConstants.TWO;
            BigInteger bigInteger4 = a2;
            BigInteger bigInteger5 = ECConstants.ONE;
            BigInteger bigInteger6 = ECConstants.ONE;
            int n3 = n = n - 1;
            while (n3 >= n2 + 1) {
                bigInteger5 = bigInteger5.multiply(bigInteger6).mod(a);
                if (a4.testBit(n)) {
                    bigInteger6 = bigInteger5.multiply(a3).mod(a);
                    bigInteger2 = bigInteger2.multiply(bigInteger4).mod(a);
                    BigInteger bigInteger7 = bigInteger4;
                    bigInteger3 = bigInteger7.multiply(bigInteger3).subtract(a2.multiply(bigInteger5)).mod(a);
                    bigInteger4 = bigInteger7.multiply(bigInteger7).subtract(bigInteger6.shiftLeft(1)).mod(a);
                } else {
                    bigInteger6 = bigInteger5;
                    bigInteger2 = bigInteger2.multiply(bigInteger3).subtract(bigInteger5).mod(a);
                    bigInteger4 = bigInteger4.multiply(bigInteger3).subtract(a2.multiply(bigInteger5)).mod(a);
                    BigInteger bigInteger8 = bigInteger3;
                    bigInteger3 = bigInteger8.multiply(bigInteger8).subtract(bigInteger5.shiftLeft(1)).mod(a);
                }
                n3 = --n;
            }
            bigInteger5 = bigInteger5.multiply(bigInteger6).mod(a);
            bigInteger6 = bigInteger5.multiply(a3).mod(a);
            bigInteger2 = bigInteger2.multiply(bigInteger3).subtract(bigInteger5).mod(a);
            BigInteger bigInteger9 = bigInteger5;
            bigInteger3 = bigInteger4.multiply(bigInteger3).subtract(a2.multiply(bigInteger9)).mod(a);
            bigInteger5 = bigInteger9.multiply(bigInteger6).mod(a);
            int n4 = n = 1;
            while (n4 <= n2) {
                bigInteger2 = bigInteger2.multiply(bigInteger3).mod(a);
                BigInteger bigInteger10 = bigInteger3;
                bigInteger3 = bigInteger10.multiply(bigInteger10).subtract(bigInteger5.shiftLeft(1)).mod(a);
                BigInteger bigInteger11 = bigInteger5;
                bigInteger5 = bigInteger11.multiply(bigInteger11).mod(a);
                n4 = ++n;
            }
            BigInteger[] bigIntegerArray = new BigInteger[2];
            bigIntegerArray[0] = bigInteger2;
            bigIntegerArray[1] = bigInteger3;
            return bigIntegerArray;
        }

        @Override
        public ECFieldElement multiply(ECFieldElement a) {
            Fp a2;
            Fp fp = a2;
            return new Fp(fp.private, fp.b.multiply(a.toBigInteger()).mod(a2.private));
        }

        @Override
        public ECFieldElement divide(ECFieldElement a) {
            Fp a2;
            Fp fp = a2;
            return new Fp(fp.private, fp.b.multiply(a.toBigInteger().modInverse(a2.private)).mod(a2.private));
        }

        public BigInteger getQ() {
            Fp a;
            return a.private;
        }

        @Override
        public ECFieldElement add(ECFieldElement a) {
            Fp a2;
            Fp fp = a2;
            return new Fp(fp.private, fp.b.add(a.toBigInteger()).mod(a2.private));
        }

        @Override
        public int getFieldSize() {
            Fp a;
            return a.private.bitLength();
        }
    }
}

