/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.core.config;

import com.jxdinfo.hussar.core.util.HussarHttpRequest;
import com.jxdinfo.hussar.core.util.PropertyUtil;
import com.jxdinfo.hussar.core.util.SecurityUtil;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.context.annotation.DependsOn;
import org.springframework.stereotype.Component;

@Component
@ConfigurationProperties(prefix="hussar")
@DependsOn(value={"springContextHolder"})
public class HussarConfig {
    public static final String PREFIX = "hussar";
    @Deprecated
    private String staticVersion = "8.2.1";
    private Boolean swaggerOpen = false;
    private Boolean kaptchaOpen = false;
    private Boolean totpOpen = false;
    private Boolean showPoweredBy = true;
    private int totpOffsetMin = 0;
    private String fileUploadPathWindows = "";
    private String environment = "maven";
    private String fileUploadPathLinux = "";
    private String fileUploadPathMac = "";
    private Boolean fileDateSplit = true;
    private String firewallXssLevel = "B";
    private List<String> xssWhitelist = new ArrayList<String>();
    private List<String> xssBlacklist = new ArrayList<String>();
    private List<String> csrfWhitelist = new ArrayList<String>();
    private List<String> referWhitelist = new ArrayList<String>();
    private Boolean standAlone = true;
    private Boolean indexConfig = false;
    private String defaultIndex = "/default/index";
    private Boolean loginUpperOpen = false;
    private Boolean useSeparation = true;
    private Boolean openOrgservice = false;
    private Boolean checkCsrfOpen = true;
    private Integer remebermeDays = 7;
    private String volServerName = "lb://hussar-license-server";
    private String volServerContextPath = "/";
    private Boolean useVolServer = false;
    private List<String> allowHttpMethods;
    private List<String> ipHeaderNames;
    private String licFileName = null;
    private String licCusTitle = null;
    private Boolean nameIsSet = false;
    private Boolean pathIsSet = false;
    private Boolean initCheck = false;

    public String getFileUploadPath() {
        File file;
        String string = "";
        boolean bl = this.getFileDateSplit();
        Properties properties = System.getProperties();
        String string2 = properties.getProperty("os.name");
        if (string2 != null && string2.toLowerCase().indexOf("linux") > -1) {
            string = this.fileUploadPathLinux;
        } else if (string2 != null && string2.toLowerCase().indexOf("windows") > -1) {
            string = this.fileUploadPathWindows;
        } else if (string2 != null && string2.toLowerCase().indexOf("mac") > -1) {
            string = this.fileUploadPathMac;
        }
        if (ToolUtil.isEmpty(string)) {
            string = ToolUtil.getTempPath();
        }
        if (bl) {
            string = string + File.separator + new SimpleDateFormat("yyyy/MM/dd").format(new Date());
        }
        if (!string.endsWith(File.separator)) {
            string = string + File.separator;
        }
        if (!(file = new File(string)).exists()) {
            file.mkdirs();
        }
        return string;
    }

    public String getFirewallXssLevel() {
        return this.firewallXssLevel;
    }

    public void setFirewallXssLevel(String string) {
        this.firewallXssLevel = string;
    }

    public List<String> getXssWhitelist() {
        return this.xssWhitelist;
    }

    public void setXssWhitelist(List<String> list) {
        this.xssWhitelist = list;
    }

    public void setFileUploadPathWindows(String string) {
        this.fileUploadPathWindows = string;
    }

    public void setFileUploadPathLinux(String string) {
        this.fileUploadPathLinux = string;
    }

    public String getFileUploadPathMac() {
        return this.fileUploadPathMac;
    }

    public void setFileUploadPathMac(String string) {
        this.fileUploadPathMac = string;
    }

    public Boolean getKaptchaOpen() {
        return this.kaptchaOpen;
    }

    public void setKaptchaOpen(Boolean bl) {
        this.kaptchaOpen = bl;
    }

    public Boolean getTotpOpen() {
        return this.totpOpen;
    }

    public void setTotpOpen(Boolean bl) {
        this.totpOpen = bl;
    }

    public int getTotpOffsetMin() {
        return this.totpOffsetMin;
    }

    public void setTotpOffsetMin(int n) {
        this.totpOffsetMin = n;
    }

    public Boolean getFileDateSplit() {
        return this.fileDateSplit;
    }

    public void setFileDateSplit(Boolean bl) {
        this.fileDateSplit = bl;
    }

    public Boolean getSwaggerOpen() {
        return this.swaggerOpen;
    }

    public void setSwaggerOpen(Boolean bl) {
        this.swaggerOpen = bl;
    }

    public boolean isStandAlone() {
        return this.standAlone;
    }

    public void setStandAlone(boolean bl) {
        this.standAlone = bl;
    }

    public boolean isIndexConfig() {
        return this.indexConfig;
    }

    public void setIndexConfig(boolean bl) {
        this.indexConfig = bl;
    }

    public String getDefaultIndex() {
        return this.defaultIndex;
    }

    public void setDefaultIndex(String string) {
        this.defaultIndex = string;
    }

    public String getStaticVersion() {
        return this.staticVersion;
    }

    public void setStaticVersion(String string) {
        this.staticVersion = string;
    }

    public String getFileUploadPathWindows() {
        return this.fileUploadPathWindows;
    }

    public String getFileUploadPathLinux() {
        return this.fileUploadPathLinux;
    }

    public Boolean getLoginUpperOpen() {
        return this.loginUpperOpen;
    }

    public void setLoginUpperOpen(Boolean bl) {
        this.loginUpperOpen = bl;
    }

    public Boolean getOpenOrgservice() {
        return this.openOrgservice;
    }

    public void setOpenOrgservice(Boolean bl) {
        this.openOrgservice = bl;
    }

    public String getEnvironment() {
        Properties properties = System.getProperties();
        String string = properties.getProperty("hussar.environment");
        if (string == null || "".equals(string)) {
            return this.environment;
        }
        return string;
    }

    public void setEnvironment(String string) {
        this.environment = string;
    }

    public List<String> getCsrfWhitelist() {
        return this.csrfWhitelist;
    }

    public void setCsrfWhitelist(List<String> list) {
        this.csrfWhitelist = list;
    }

    public List<String> getXssBlacklist() {
        return this.xssBlacklist;
    }

    public void setXssBlacklist(List<String> list) {
        this.xssBlacklist = list;
    }

    public boolean isCheckCsrfOpen() {
        return this.checkCsrfOpen;
    }

    public void setCheckCsrfOpen(boolean bl) {
        this.checkCsrfOpen = bl;
    }

    public List<String> getReferWhitelist() {
        return this.referWhitelist;
    }

    public void setReferWhitelist(List<String> list) {
        this.referWhitelist = list;
    }

    @Deprecated
    public Integer getRemebermeDays() {
        return this.remebermeDays;
    }

    @Deprecated
    public void setRemebermeDays(Integer n) {
        this.remebermeDays = n;
    }

    public Boolean getUseSeparation() {
        return this.useSeparation;
    }

    public void setUseSeparation(Boolean bl) {
        if (!bl.booleanValue()) {
            throw new RuntimeException("\u5f53\u524d\u7248\u672c\u5df2\u4e0d\u652f\u6301layui\u6a21\u5f0f\uff01\u8bf7\u4f7f\u7528\u524d\u540e\u5206\u79bb\u6a21\u5f0f\uff01");
        }
        this.useSeparation = true;
    }

    public Boolean getUseVolServer() {
        return this.useVolServer;
    }

    public void setUseVolServer(Boolean bl) {
        this.useVolServer = bl;
    }

    public String getVolServerName() {
        return this.volServerName;
    }

    public void setVolServerName(String string) {
        if (StringUtils.startsWith((CharSequence)string, (CharSequence)"lb://")) {
            HussarHttpRequest.volServerId = StringUtils.removeStart((String)string, (String)"lb://");
            try {
                this.getClass().getClassLoader().loadClass("org.springframework.cloud.client.discovery.DiscoveryClient");
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.err.println("\u5355\u4f53\u6a21\u5f0f\u4e0d\u652f\u6301 lb:// \u683c\u5f0f\u7684\u6279\u91cf\u6388\u6743\u670d\u52a1");
            }
            HussarHttpRequest.client = SpringContextHolder.getBean(DiscoveryClient.class);
            PropertyUtil.setSnapMsg("vol", "hussar.vol.server", string);
        } else if (StringUtils.startsWithAny((CharSequence)string, (CharSequence[])new CharSequence[]{"http://", "https://"})) {
            PropertyUtil.setSnapMsg("vol", "hussar.vol.server", string);
        } else {
            SecurityUtil.exitSystem("\u6388\u6743\u670d\u52a1\u5668\u683c\u5f0f\u4e3a\uff1alb://hussar-license-server", true);
        }
        this.volServerName = string;
        this.nameIsSet = true;
        if (!this.initCheck.booleanValue() && this.pathIsSet.booleanValue()) {
            SecurityUtil.getLicenseType();
            this.initCheck = true;
        }
    }

    public List<String> getIpHeaderNames() {
        return this.ipHeaderNames;
    }

    public void setIpHeaderNames(List<String> list) {
        this.ipHeaderNames = list;
    }

    public String getVolServerContextPath() {
        return this.volServerContextPath;
    }

    public void setVolServerContextPath(String string) {
        if (StringUtils.isBlank((CharSequence)string)) {
            string = "/";
        }
        HussarHttpRequest.volServerContextPath = string;
        this.volServerContextPath = string;
        this.pathIsSet = true;
        if (!this.initCheck.booleanValue() && this.nameIsSet.booleanValue()) {
            SecurityUtil.getLicenseType();
            this.initCheck = true;
        }
    }

    public List<String> getAllowHttpMethods() {
        return this.allowHttpMethods;
    }

    public void setAllowHttpMethods(List<String> list) {
        this.allowHttpMethods = list;
    }

    public Boolean getShowPoweredBy() {
        return this.showPoweredBy;
    }

    public void setShowPoweredBy(Boolean bl) {
        this.showPoweredBy = bl;
    }

    public String getLicFileName() {
        return this.licFileName;
    }

    public void setLicFileName(String string) {
        this.licFileName = string;
    }

    public String getLicCusTitle() {
        return this.licCusTitle;
    }

    public void setLicCusTitle(String string) {
        this.licCusTitle = string;
    }
}

