/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.core.bouncycastle.math.ec;

import com.jxdinfo.hussar.core.banner.EmbeddedContainerUtils;
import com.jxdinfo.hussar.core.bouncycastle.asn1.x9.X9IntegerConverter;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.AUx;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.AuX;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.CoN;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.ECConstants;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.ECCurve;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.ECFieldElement;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.aUX;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.aux;
import com.jxdinfo.hussar.core.encrypt.file.exceptioin.FileEncryptException;
import com.jxdinfo.hussar.core.util.ClassUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.math.BigInteger;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class ECPoint {
    ECFieldElement h;
    ECCurve b;
    protected AuX multiplier;
    protected aUX preCompInfo;
    protected boolean withCompression;
    private static X9IntegerConverter l = new X9IntegerConverter();
    ECFieldElement while;

    synchronized void long() {
        ECPoint a;
        if (a.multiplier == null) {
            ECPoint eCPoint = a;
            eCPoint.multiplier = new CoN();
        }
    }

    public ECPoint multiply(BigInteger a) {
        ECPoint a2;
        if (a.signum() < 0) {
            throw new IllegalArgumentException(EmbeddedContainerUtils.else("\u007f\rGL\u0004RF\u0010O\u0018_\u0014L\u0000\u001dHPLG\u000b\u0007Im8$(ryF\u0003I\u0001]\u000eE\u0018"));
        }
        if (a2.isInfinity()) {
            return a2;
        }
        if (a.signum() == 0) {
            return a2.b.getInfinity();
        }
        ECPoint eCPoint = a2;
        eCPoint.long();
        ECPoint eCPoint2 = a2;
        return eCPoint.multiplier.long(eCPoint2, a, eCPoint2.preCompInfo);
    }

    public boolean isCompressed() {
        ECPoint a;
        return a.withCompression;
    }

    public boolean isInfinity() {
        ECPoint a;
        return a.while == null && a.h == null;
    }

    public boolean equals(Object a) {
        ECPoint a2;
        if (a == a2) {
            return true;
        }
        if (!(a instanceof ECPoint)) {
            return false;
        }
        a = (ECPoint)a;
        if (a2.isInfinity()) {
            return ((ECPoint)a).isInfinity();
        }
        return a2.while.equals(((ECPoint)a).while) && a2.h.equals(((ECPoint)a).h);
    }

    public abstract ECPoint subtract(ECPoint var1);

    public ECFieldElement getX() {
        ECPoint a;
        return a.while;
    }

    public int hashCode() {
        ECPoint a;
        if (a.isInfinity()) {
            return 0;
        }
        return a.while.hashCode() ^ a.h.hashCode();
    }

    public abstract ECPoint add(ECPoint var1);

    public abstract ECPoint negate();

    protected ECPoint(ECCurve a, ECFieldElement a2, ECFieldElement a3) {
        ECPoint a4;
        ECPoint eCPoint = a4;
        ECPoint eCPoint2 = a4;
        a4.multiplier = null;
        eCPoint2.preCompInfo = null;
        eCPoint2.b = a;
        eCPoint.while = a2;
        eCPoint.h = a3;
    }

    public abstract byte[] getEncoded();

    void transient(aUX a) {
        a.preCompInfo = a;
    }

    public ECCurve getCurve() {
        ECPoint a;
        return a.b;
    }

    public ECFieldElement getY() {
        ECPoint a;
        return a.h;
    }

    public abstract ECPoint twice();

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class F2m
    extends ECPoint {
        public F2m(ECCurve a, ECFieldElement a2, ECFieldElement a3) {
            a4(a, a2, a3, false);
            F2m a4;
        }

        @Override
        public ECPoint subtract(ECPoint a) {
            F2m a2;
            F2m f2m = a2;
            F2m.if(f2m, a);
            return f2m.subtractSimple((F2m)a);
        }

        public F2m subtractSimple(F2m a) {
            F2m a2;
            if (a.isInfinity()) {
                return a2;
            }
            return a2.addSimple((F2m)a.negate());
        }

        @Override
        public ECPoint twice() {
            F2m a;
            if (a.isInfinity()) {
                return a;
            }
            if (a.while.toBigInteger().signum() == 0) {
                return a.b.getInfinity();
            }
            F2m f2m = a;
            ECFieldElement.F2m f2m2 = (ECFieldElement.F2m)f2m.while.add(f2m.h.divide(a.while));
            ECFieldElement.F2m f2m3 = (ECFieldElement.F2m)f2m2.square().add(f2m2).add(a.b.getA());
            F2m f2m4 = a;
            ECFieldElement eCFieldElement = f2m4.b.fromBigInteger(ECConstants.ONE);
            eCFieldElement = (ECFieldElement.F2m)f2m4.while.square().add(f2m3.multiply(f2m2.add(eCFieldElement)));
            return new F2m(a.b, f2m3, eCFieldElement, a.withCompression);
        }

        private static /* synthetic */ void if(ECPoint a, ECPoint a2) {
            if (!a.b.equals(a2.b)) {
                throw new IllegalArgumentException(ToolUtil.const("\u001fz&wpd=\u007f.p4#0uvfu<~i3{\"#8jo/323usy\u0014WPU\u0007C9|zq/94vu'\u0007Pb1;~"));
            }
        }

        @Override
        public ECPoint add(ECPoint a) {
            F2m a2;
            F2m f2m = a2;
            F2m.if(f2m, a);
            return f2m.addSimple((F2m)a);
        }

        @Override
        public ECPoint negate() {
            F2m a;
            return new F2m(a.b, a.getX(), a.getY().add(a.getX()), a.withCompression);
        }

        public F2m addSimple(F2m a) {
            F2m a2;
            Object object = a;
            if (a2.isInfinity()) {
                return object;
            }
            if (((ECPoint)object).isInfinity()) {
                return a2;
            }
            ECFieldElement.F2m f2m = (ECFieldElement.F2m)((ECPoint)object).getX();
            object = (ECFieldElement.F2m)((ECPoint)object).getY();
            if (a2.while.equals(f2m)) {
                if (a2.h.equals(object)) {
                    return (F2m)a2.twice();
                }
                return (F2m)a2.b.getInfinity();
            }
            object = (ECFieldElement.F2m)a2.h.add((ECFieldElement)object).divide(a2.while.add(f2m));
            f2m = (ECFieldElement.F2m)((ECFieldElement.F2m)object).square().add((ECFieldElement)object).add(a2.while).add(f2m).add(a2.b.getA());
            object = (ECFieldElement.F2m)((ECFieldElement.F2m)object).multiply(a2.while.add(f2m)).add(f2m).add(a2.h);
            return new F2m(a2.b, f2m, (ECFieldElement)object, a2.withCompression);
        }

        @Override
        public byte[] getEncoded() {
            F2m a;
            if (a.isInfinity()) {
                return new byte[1];
            }
            int n = l.getByteLength(a.while);
            byte[] byArray = l.integerToBytes(a.getX().toBigInteger(), n);
            if (a.withCompression) {
                byte[] byArray2 = new byte[n + 1];
                byArray2[0] = 2;
                if (!a.getX().toBigInteger().equals(ECConstants.ZERO) && a.getY().multiply(a.getX().invert()).toBigInteger().testBit(0)) {
                    byArray2[0] = 3;
                }
                System.arraycopy(byArray, 0, byArray2, 1, n);
                return byArray2;
            }
            byte[] byArray3 = l.integerToBytes(a.getY().toBigInteger(), n);
            int n2 = n;
            byte[] byArray4 = new byte[n2 + n2 + 1];
            byArray4[0] = 4;
            System.arraycopy(byArray, 0, byArray4, 1, n);
            System.arraycopy(byArray3, 0, byArray4, n + 1, n);
            return byArray4;
        }

        public F2m(ECCurve a, ECFieldElement a2, ECFieldElement a3, boolean a4) {
            F2m a5;
            ECFieldElement eCFieldElement = a2;
            super(a, eCFieldElement, a3);
            if (eCFieldElement != null && a3 == null || a2 == null && a3 != null) {
                throw new IllegalArgumentException(ClassUtil.import("b}\r`\u001e\"^\u0005#M/\u00106iF}\bkGr\u0014!ABo7Wh\t9[}\u0013.\u000ez@z\b2["));
            }
            if (a2 != null) {
                F2m f2m = a5;
                ECFieldElement.F2m.checkFieldElements(f2m.while, f2m.h);
                if (a != null) {
                    F2m f2m2 = a5;
                    ECFieldElement.F2m.checkFieldElements(f2m2.while, f2m2.b.getA());
                }
            }
            a5.withCompression = a4;
        }

        @Override
        synchronized void long() {
            F2m a;
            if (a.multiplier == null) {
                if (((ECCurve.F2m)a.b).isKoblitz()) {
                    F2m f2m = a;
                    f2m.multiplier = new AUx();
                    return;
                }
                a.multiplier = new aux();
            }
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class Fp
    extends ECPoint {
        @Override
        public byte[] getEncoded() {
            Fp a;
            if (a.isInfinity()) {
                return new byte[1];
            }
            int n = l.getByteLength(a.while);
            if (a.withCompression) {
                int n2 = a.getY().toBigInteger().testBit(0) ? 3 : 2;
                byte[] byArray = l.integerToBytes(a.getX().toBigInteger(), n);
                byte[] byArray2 = new byte[byArray.length + 1];
                byArray2[0] = n2;
                System.arraycopy(byArray, 0, byArray2, 1, byArray.length);
                return byArray2;
            }
            byte[] byArray = l.integerToBytes(a.getX().toBigInteger(), n);
            byte[] byArray3 = l.integerToBytes(a.getY().toBigInteger(), n);
            byte[] byArray4 = new byte[byArray.length + byArray3.length + 1];
            byArray4[0] = 4;
            System.arraycopy(byArray, 0, byArray4, 1, byArray.length);
            System.arraycopy(byArray3, 0, byArray4, byArray.length + 1, byArray3.length);
            return byArray4;
        }

        public Fp(ECCurve a, ECFieldElement a2, ECFieldElement a3) {
            a4(a, a2, a3, false);
            Fp a4;
        }

        @Override
        public ECPoint twice() {
            Fp a;
            if (a.isInfinity()) {
                return a;
            }
            if (a.h.toBigInteger().signum() == 0) {
                return a.b.getInfinity();
            }
            Fp fp = a;
            ECFieldElement eCFieldElement = fp.b.fromBigInteger(BigInteger.valueOf(2L));
            ECFieldElement eCFieldElement2 = fp.b.fromBigInteger(BigInteger.valueOf(3L));
            ECFieldElement eCFieldElement3 = fp.while.square().multiply(eCFieldElement2).add(a.b.l).divide(a.h.multiply(eCFieldElement));
            eCFieldElement2 = eCFieldElement3.square().subtract(a.while.multiply(eCFieldElement));
            ECFieldElement eCFieldElement4 = eCFieldElement3.multiply(a.while.subtract(eCFieldElement2)).subtract(a.h);
            return new Fp(a.b, eCFieldElement2, eCFieldElement4, a.withCompression);
        }

        @Override
        public ECPoint negate() {
            Fp a;
            Fp fp = a;
            return new Fp(fp.b, fp.while, a.h.negate(), a.withCompression);
        }

        @Override
        synchronized void long() {
            Fp a;
            if (a.multiplier == null) {
                Fp fp = a;
                fp.multiplier = new aux();
            }
        }

        public Fp(ECCurve a, ECFieldElement a2, ECFieldElement a3, boolean a4) {
            Fp a5;
            ECFieldElement eCFieldElement = a2;
            super(a, eCFieldElement, a3);
            if (eCFieldElement != null && a3 == null || a2 == null && a3 != null) {
                throw new IllegalArgumentException(FileEncryptException.false("\u0014nv>(7#6x\u0013\u0019[\u0015\u000eI#>4p0>)!x=\u001b\u0013-$ak%#v>\"p\"8jk"));
            }
            a5.withCompression = a4;
        }

        @Override
        public ECPoint add(ECPoint a) {
            Fp a2;
            if (a2.isInfinity()) {
                return a;
            }
            if (a.isInfinity()) {
                return a2;
            }
            if (a2.while.equals(a.while)) {
                if (a2.h.equals(a.h)) {
                    return a2.twice();
                }
                return a2.b.getInfinity();
            }
            ECFieldElement eCFieldElement = a.h.subtract(a2.h).divide(a.while.subtract(a2.while));
            ECFieldElement eCFieldElement2 = eCFieldElement.square().subtract(a2.while).subtract(a.while);
            ECFieldElement eCFieldElement3 = eCFieldElement.multiply(a2.while.subtract(eCFieldElement2)).subtract(a2.h);
            return new Fp(a2.b, eCFieldElement2, eCFieldElement3);
        }

        @Override
        public ECPoint subtract(ECPoint a) {
            Fp a2;
            if (a.isInfinity()) {
                return a2;
            }
            return a2.add(a.negate());
        }
    }
}

