/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.core.bouncycastle.math.ec;

import com.jxdinfo.hussar.core.HussarCoreAutoConfiguration;
import com.jxdinfo.hussar.core.bouncycastle.jce.provider.asymmetric.ec.ECUtil;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.AUX;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.ECConstants;
import com.jxdinfo.hussar.core.feign.TicketRequestBody;
import com.jxdinfo.hussar.core.support.ObjectKit;
import java.math.BigInteger;
import java.util.Random;

public abstract class ECFieldElement
implements ECConstants {
    public String toString() {
        ECFieldElement a;
        return a.toBigInteger().toString(2);
    }

    public abstract ECFieldElement negate();

    public abstract String getFieldName();

    public abstract BigInteger toBigInteger();

    public abstract ECFieldElement invert();

    public ECFieldElement() {
        ECFieldElement a;
    }

    public abstract ECFieldElement square();

    public abstract ECFieldElement divide(ECFieldElement var1);

    public abstract ECFieldElement subtract(ECFieldElement var1);

    public abstract int getFieldSize();

    public abstract ECFieldElement sqrt();

    public abstract ECFieldElement add(ECFieldElement var1);

    public abstract ECFieldElement multiply(ECFieldElement var1);

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class F2m
    extends ECFieldElement {
        public static final int GNB = 1;
        private int F;
        public static final int PPB = 3;
        private AUX k;
        private int J;
        private int h;
        private int b;
        public static final int TPB = 2;
        private int l;
        private int switch;

        @Override
        public BigInteger toBigInteger() {
            F2m a;
            return a.k.for();
        }

        public int getK2() {
            F2m a;
            return a.b;
        }

        @Override
        public String getFieldName() {
            return HussarCoreAutoConfiguration.final("P`$");
        }

        public int hashCode() {
            F2m a;
            return a.k.hashCode() ^ a.J ^ a.switch ^ a.b ^ a.h;
        }

        @Override
        public ECFieldElement subtract(ECFieldElement a) {
            F2m a2;
            return a2.add(a);
        }

        @Override
        public ECFieldElement invert() {
            F2m a;
            AUX aUX2 = (AUX)a.k.clone();
            AUX aUX3 = new AUX(a.l);
            F2m f2m = a;
            AUX aUX4 = aUX3;
            aUX4.short(a.J);
            aUX4.short(0);
            aUX3.short(f2m.switch);
            if (f2m.F == 3) {
                AUX aUX5 = aUX3;
                aUX5.short(a.b);
                aUX5.short(a.h);
            }
            AUX aUX6 = new AUX(a.l);
            aUX6.short(0);
            AUX aUX7 = new AUX(a.l);
            AUX aUX8 = aUX2;
            while (!aUX8.package()) {
                int n = aUX2.boolean() - aUX3.boolean();
                if (n < 0) {
                    AUX aUX9 = aUX2;
                    aUX2 = aUX3;
                    aUX3 = aUX9;
                    AUX aUX10 = aUX6;
                    aUX6 = aUX7;
                    aUX7 = aUX10;
                    n = -n;
                }
                int n2 = n >> 5;
                AUX aUX11 = aUX3.if(n &= 0x1F);
                AUX aUX12 = aUX2;
                aUX8 = aUX12;
                aUX12.implements(aUX11, n2);
                AUX aUX13 = aUX7.if(n);
                aUX6.implements(aUX13, n2);
            }
            F2m f2m2 = a;
            F2m f2m3 = a;
            return new F2m(f2m2.J, f2m2.switch, f2m3.b, f2m3.h, aUX7);
        }

        public int getK1() {
            F2m a;
            return a.switch;
        }

        @Override
        public ECFieldElement add(ECFieldElement a) {
            F2m a2;
            AUX aUX2 = (AUX)a2.k.clone();
            F2m f2m = (F2m)a;
            aUX2.implements(f2m.k, 0);
            F2m f2m2 = a2;
            F2m f2m3 = a2;
            return new F2m(f2m2.J, f2m2.switch, f2m3.b, f2m3.h, aUX2);
        }

        @Override
        public ECFieldElement multiply(ECFieldElement a) {
            F2m a2;
            Object object = (F2m)a;
            object = a2.k.short(((F2m)object).k, a2.J);
            int[] nArray = new int[3];
            nArray[0] = a2.switch;
            nArray[1] = a2.b;
            nArray[2] = a2.h;
            ((AUX)object).strictfp(a2.J, nArray);
            F2m f2m = a2;
            F2m f2m2 = a2;
            return new F2m(f2m.J, f2m.switch, f2m2.b, f2m2.h, (AUX)object);
        }

        public F2m(int a, int a2, BigInteger a3) {
            a4(a, a2, 0, 0, a3);
            F2m a4;
        }

        @Override
        public int getFieldSize() {
            F2m a;
            return a.J;
        }

        public F2m(int a, int a2, int a3, int a4, BigInteger a5) {
            BigInteger bigInteger;
            F2m a6;
            a6.l = a + 31 >> 5;
            F2m f2m = a6;
            a6.k = new AUX(a5, a6.l);
            if (a3 == 0 && a4 == 0) {
                bigInteger = a5;
                a6.F = 2;
            } else {
                if (a3 >= a4) {
                    throw new IllegalArgumentException(ObjectKit.catch("PX\u0013\u000fg0OJP\u0006\u001a\u0018_\u0002U\u0004F\u0000SVy!\u000b\u0014QX"));
                }
                if (a3 <= 0) {
                    throw new IllegalArgumentException(HussarCoreAutoConfiguration.final("0rZ\f&;.a0,z-08,5i \r\nlxry"));
                }
                a6.F = 3;
                bigInteger = a5;
            }
            if (bigInteger.signum() < 0) {
                throw new IllegalArgumentException(ObjectKit.catch("CJE\u0003~6^JQ\u0002T\u0005]\u0017\u0019\nFR\u001dGv!\u0011]L\u000e"));
            }
            F2m f2m2 = a6;
            a6.J = a;
            f2m2.switch = a2;
            f2m2.b = a3;
            a6.h = a4;
        }

        public int getRepresentation() {
            F2m a;
            return a.F;
        }

        @Override
        public ECFieldElement square() {
            F2m a;
            F2m f2m = a;
            AUX aUX2 = f2m.k.float(f2m.J);
            int[] nArray = new int[3];
            nArray[0] = a.switch;
            nArray[1] = a.b;
            nArray[2] = a.h;
            aUX2.strictfp(a.J, nArray);
            F2m f2m2 = a;
            F2m f2m3 = a;
            return new F2m(f2m2.J, f2m2.switch, f2m3.b, f2m3.h, aUX2);
        }

        public static void checkFieldElements(ECFieldElement a, ECFieldElement a2) {
            if (!(a instanceof F2m) || !(a2 instanceof F2m)) {
                throw new IllegalArgumentException(ObjectKit.catch("4R\u000f^\u0007YMV\u000e[\u0002M\u0006LN\u0018ZWCZ\n\r\bp,`-1)P\u001cF\u0002U\tV\u00112,]Jw |\u0002W\u000f]-O\u0017\u001eG\u007f4Kr\b\u0006"));
            }
            F2m f2m = (F2m)a;
            F2m f2m2 = (F2m)a2;
            if (f2m.J != f2m2.J || f2m.switch != f2m2.switch || f2m.b != f2m2.b || f2m.h != f2m2.h) {
                throw new IllegalArgumentException(HussarCoreAutoConfiguration.final("L;,2!k5;)|o45/gpx\u001fA\u0012\b\rB3!?,6&/3Z\u000e5h.)7i) </k6re\u0015\u0006-P`$"));
            }
            if (f2m.F != f2m2.F) {
                throw new IllegalArgumentException(ObjectKit.catch("'Z\u0000\u000e\u0010REB\u000fAUE\u001b^\u0006VC\u001cD_\u0006S\tW\u0001\u001f\u000f\u000bM\u0012\r[\u0011YM~&y \u007f4MOZ\u0002HJZ\fq,I\u0018W\u0000NK@\u0006I\u001aF\u0001\u0016Le!\u0011]U\u0005"));
            }
        }

        private /* synthetic */ F2m(int a, int a2, int a3, int a4, AUX a5) {
            F2m a6;
            F2m f2m = a6;
            F2m f2m2 = a6;
            F2m f2m3 = a6;
            f2m3.l = a + 31 >> 5;
            f2m3.k = a5;
            f2m2.J = a;
            f2m2.switch = a2;
            f2m.b = a3;
            f2m.h = a4;
            if (a3 == 0 && a4 == 0) {
                a6.F = 2;
                return;
            }
            a6.F = 3;
        }

        public boolean equals(Object a) {
            F2m a2;
            if (a == a2) {
                return true;
            }
            if (!(a instanceof F2m)) {
                return false;
            }
            F2m f2m = (F2m)a;
            return a2.J == f2m.J && a2.switch == f2m.switch && a2.b == f2m.b && a2.h == f2m.h && a2.F == f2m.F && a2.k.equals(f2m.k);
        }

        public int getK3() {
            F2m a;
            return a.h;
        }

        @Override
        public ECFieldElement negate() {
            F2m a;
            return a;
        }

        public int getM() {
            F2m a;
            return a.J;
        }

        @Override
        public ECFieldElement sqrt() {
            throw new RuntimeException(HussarCoreAutoConfiguration.final("\u000755q#& we\u0014\u0007cb7-"));
        }

        @Override
        public ECFieldElement divide(ECFieldElement a) {
            F2m a2;
            ECFieldElement eCFieldElement = a.invert();
            return a2.multiply(eCFieldElement);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class Fp
    extends ECFieldElement {
        BigInteger l;
        BigInteger throws;

        public int hashCode() {
            Fp a;
            return a.l.hashCode() ^ a.throws.hashCode();
        }

        public Fp(BigInteger a, BigInteger a2) {
            Fp a3;
            a3.throws = a2;
            if (a3.throws.compareTo(a) >= 0) {
                throw new IllegalArgumentException(ECUtil.double("'/\bO;r;.\"i1.9d=xzo\u0014Ck}n2>fu`>g\"zk!"));
            }
            a3.l = a;
        }

        @Override
        public BigInteger toBigInteger() {
            Fp a;
            return a.throws;
        }

        @Override
        public ECFieldElement subtract(ECFieldElement a) {
            Fp a2;
            Fp fp = a2;
            return new Fp(fp.l, fp.throws.subtract(a.toBigInteger()).mod(a2.l));
        }

        @Override
        public ECFieldElement multiply(ECFieldElement a) {
            Fp a2;
            Fp fp = a2;
            return new Fp(fp.l, fp.throws.multiply(a.toBigInteger()).mod(a2.l));
        }

        public boolean equals(Object a) {
            Fp a2;
            if (a == a2) {
                return true;
            }
            if (!(a instanceof Fp)) {
                return false;
            }
            Fp fp = (Fp)a;
            return a2.l.equals(fp.l) && a2.throws.equals(fp.throws);
        }

        @Override
        public ECFieldElement invert() {
            Fp a;
            Fp fp = a;
            return new Fp(fp.l, fp.throws.modInverse(a.l));
        }

        @Override
        public ECFieldElement sqrt() {
            Fp a;
            if (!a.l.testBit(0)) {
                throw new RuntimeException(ECUtil.double("\u0013B?;,w$\u007fi`*k"));
            }
            if (a.l.testBit(1)) {
                Fp fp = a;
                Fp fp2 = new Fp(fp.l, fp.throws.modPow(a.l.shiftRight(2).add(ECConstants.ONE), a.l));
                if (((ECFieldElement)fp2).square().equals(a)) {
                    return fp2;
                }
                return null;
            }
            Fp fp = a;
            BigInteger bigInteger = fp.l.subtract(ECConstants.ONE);
            BigInteger bigInteger2 = bigInteger.shiftRight(1);
            if (!fp.throws.modPow(bigInteger2, a.l).equals(ECConstants.ONE)) {
                return null;
            }
            BigInteger bigInteger3 = bigInteger.shiftRight(2).shiftLeft(1).add(ECConstants.ONE);
            BigInteger bigInteger4 = a.throws;
            BigInteger bigInteger5 = bigInteger4.shiftLeft(2).mod(a.l);
            Random random = new Random();
            while (true) {
                BigInteger bigInteger6;
                if ((bigInteger6 = new BigInteger(a.l.bitLength(), random)).compareTo(a.l) >= 0) {
                    continue;
                }
                BigInteger bigInteger7 = bigInteger6;
                if (!bigInteger7.multiply(bigInteger7).subtract(bigInteger5).modPow(bigInteger2, a.l).equals(bigInteger)) continue;
                BigInteger[] bigIntegerArray = Fp.byte(a.l, bigInteger6, bigInteger4, bigInteger3);
                BigInteger bigInteger8 = bigIntegerArray[0];
                BigInteger bigInteger9 = bigIntegerArray[1];
                if (bigInteger9.multiply(bigInteger9).mod(a.l).equals(bigInteger5)) {
                    if (bigInteger9.testBit(0)) {
                        bigInteger9 = bigInteger9.add(a.l);
                    }
                    bigInteger9 = bigInteger9.shiftRight(1);
                    return new Fp(a.l, bigInteger9);
                }
                if (!bigInteger8.equals(ECConstants.ONE) && !bigInteger8.equals(bigInteger)) break;
            }
            return null;
        }

        private static /* synthetic */ BigInteger[] byte(BigInteger a, BigInteger a2, BigInteger a3, BigInteger a4) {
            BigInteger bigInteger = a4;
            int n = bigInteger.bitLength();
            int n2 = bigInteger.getLowestSetBit();
            BigInteger bigInteger2 = ECConstants.ONE;
            BigInteger bigInteger3 = ECConstants.TWO;
            BigInteger bigInteger4 = a2;
            BigInteger bigInteger5 = ECConstants.ONE;
            BigInteger bigInteger6 = ECConstants.ONE;
            int n3 = n = n - 1;
            while (n3 >= n2 + 1) {
                bigInteger5 = bigInteger5.multiply(bigInteger6).mod(a);
                if (a4.testBit(n)) {
                    bigInteger6 = bigInteger5.multiply(a3).mod(a);
                    bigInteger2 = bigInteger2.multiply(bigInteger4).mod(a);
                    BigInteger bigInteger7 = bigInteger4;
                    bigInteger3 = bigInteger7.multiply(bigInteger3).subtract(a2.multiply(bigInteger5)).mod(a);
                    bigInteger4 = bigInteger7.multiply(bigInteger7).subtract(bigInteger6.shiftLeft(1)).mod(a);
                } else {
                    bigInteger6 = bigInteger5;
                    bigInteger2 = bigInteger2.multiply(bigInteger3).subtract(bigInteger5).mod(a);
                    bigInteger4 = bigInteger4.multiply(bigInteger3).subtract(a2.multiply(bigInteger5)).mod(a);
                    BigInteger bigInteger8 = bigInteger3;
                    bigInteger3 = bigInteger8.multiply(bigInteger8).subtract(bigInteger5.shiftLeft(1)).mod(a);
                }
                n3 = --n;
            }
            bigInteger5 = bigInteger5.multiply(bigInteger6).mod(a);
            bigInteger6 = bigInteger5.multiply(a3).mod(a);
            bigInteger2 = bigInteger2.multiply(bigInteger3).subtract(bigInteger5).mod(a);
            BigInteger bigInteger9 = bigInteger5;
            bigInteger3 = bigInteger4.multiply(bigInteger3).subtract(a2.multiply(bigInteger9)).mod(a);
            bigInteger5 = bigInteger9.multiply(bigInteger6).mod(a);
            int n4 = n = 1;
            while (n4 <= n2) {
                bigInteger2 = bigInteger2.multiply(bigInteger3).mod(a);
                BigInteger bigInteger10 = bigInteger3;
                bigInteger3 = bigInteger10.multiply(bigInteger10).subtract(bigInteger5.shiftLeft(1)).mod(a);
                BigInteger bigInteger11 = bigInteger5;
                bigInteger5 = bigInteger11.multiply(bigInteger11).mod(a);
                n4 = ++n;
            }
            BigInteger[] bigIntegerArray = new BigInteger[2];
            bigIntegerArray[0] = bigInteger2;
            bigIntegerArray[1] = bigInteger3;
            return bigIntegerArray;
        }

        @Override
        public ECFieldElement divide(ECFieldElement a) {
            Fp a2;
            Fp fp = a2;
            return new Fp(fp.l, fp.throws.multiply(a.toBigInteger().modInverse(a2.l)).mod(a2.l));
        }

        @Override
        public ECFieldElement add(ECFieldElement a) {
            Fp a2;
            Fp fp = a2;
            return new Fp(fp.l, fp.throws.add(a.toBigInteger()).mod(a2.l));
        }

        @Override
        public ECFieldElement square() {
            Fp a;
            Fp fp = a;
            return new Fp(fp.l, fp.throws.multiply(a.throws).mod(a.l));
        }

        @Override
        public int getFieldSize() {
            Fp a;
            return a.l.bitLength();
        }

        public BigInteger getQ() {
            Fp a;
            return a.l;
        }

        @Override
        public ECFieldElement negate() {
            Fp a;
            Fp fp = a;
            return new Fp(fp.l, fp.throws.negate().mod(a.l));
        }

        @Override
        public String getFieldName() {
            return TicketRequestBody.case("j-");
        }
    }
}

