/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.core.bouncycastle.math.ec;

import com.jxdinfo.hussar.core.auto.common.TypeHelper;
import com.jxdinfo.hussar.core.bouncycastle.asn1.x9.X9ECParametersHolder;
import com.jxdinfo.hussar.core.bouncycastle.asn1.x9.X9IntegerConverter;
import com.jxdinfo.hussar.core.bouncycastle.jce.provider.asymmetric.ec.EC5Util;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.AUx;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.ECConstants;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.ECCurve;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.ECFieldElement;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.NUl;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.aUx;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.auX;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.nUl;
import com.jxdinfo.hussar.core.util.LicenseInfo;
import java.math.BigInteger;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class ECPoint {
    protected auX preCompInfo;
    protected AUx multiplier;
    private static X9IntegerConverter M = new X9IntegerConverter();
    ECFieldElement h;
    ECFieldElement I;
    ECCurve finally;
    protected boolean withCompression;

    synchronized void catch() {
        ECPoint a;
        if (a.multiplier == null) {
            ECPoint eCPoint = a;
            eCPoint.multiplier = new aUx();
        }
    }

    public abstract ECPoint negate();

    public ECFieldElement getX() {
        ECPoint a;
        return a.h;
    }

    public boolean isInfinity() {
        ECPoint a;
        return a.h == null && a.I == null;
    }

    public ECFieldElement getY() {
        ECPoint a;
        return a.I;
    }

    public boolean equals(Object a) {
        ECPoint a2;
        if (a == a2) {
            return true;
        }
        if (!(a instanceof ECPoint)) {
            return false;
        }
        a = (ECPoint)a;
        if (a2.isInfinity()) {
            return ((ECPoint)a).isInfinity();
        }
        return a2.h.equals(((ECPoint)a).h) && a2.I.equals(((ECPoint)a).I);
    }

    public ECCurve getCurve() {
        ECPoint a;
        return a.finally;
    }

    public abstract ECPoint add(ECPoint var1);

    public abstract ECPoint subtract(ECPoint var1);

    void char(auX a) {
        a.preCompInfo = a;
    }

    public int hashCode() {
        ECPoint a;
        if (a.isInfinity()) {
            return 0;
        }
        return a.h.hashCode() ^ a.I.hashCode();
    }

    public boolean isCompressed() {
        ECPoint a;
        return a.withCompression;
    }

    public abstract ECPoint twice();

    public ECPoint multiply(BigInteger a) {
        ECPoint a2;
        if (a.signum() < 0) {
            throw new IllegalArgumentException(LicenseInfo.strictfp("VDn\u0005-\u001boYfQv]eI4\u0001y\u0005nB.\u0000Dq\ra[0oJ`HtGlQ"));
        }
        if (a2.isInfinity()) {
            return a2;
        }
        if (a.signum() == 0) {
            return a2.finally.getInfinity();
        }
        ECPoint eCPoint = a2;
        eCPoint.catch();
        ECPoint eCPoint2 = a2;
        return eCPoint.multiplier.byte(eCPoint2, a, eCPoint2.preCompInfo);
    }

    protected ECPoint(ECCurve a, ECFieldElement a2, ECFieldElement a3) {
        ECPoint a4;
        ECPoint eCPoint = a4;
        ECPoint eCPoint2 = a4;
        a4.multiplier = null;
        eCPoint2.preCompInfo = null;
        eCPoint2.finally = a;
        eCPoint.h = a2;
        eCPoint.I = a3;
    }

    public abstract byte[] getEncoded();

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class F2m
    extends ECPoint {
        @Override
        public ECPoint subtract(ECPoint a) {
            F2m a2;
            F2m f2m = a2;
            F2m.public(f2m, a);
            return f2m.subtractSimple((F2m)a);
        }

        public F2m subtractSimple(F2m a) {
            F2m a2;
            if (a.isInfinity()) {
                return a2;
            }
            return a2.addSimple((F2m)a.negate());
        }

        public F2m(ECCurve a, ECFieldElement a2, ECFieldElement a3) {
            a4(a, a2, a3, false);
            F2m a4;
        }

        public F2m(ECCurve a, ECFieldElement a2, ECFieldElement a3, boolean a4) {
            F2m a5;
            ECFieldElement eCFieldElement = a2;
            super(a, eCFieldElement, a3);
            if (eCFieldElement != null && a3 == null || a2 == null && a3 != null) {
                throw new IllegalArgumentException(EC5Util.public("4\u0013[K\rH\f\u0011\u000fC\u0019KUFQR\u001f\u000e\u001af8c;qdO\u0017I\u0010N\u0014E\u0013AYpr\u0019SD\u0015"));
            }
            if (a2 != null) {
                F2m f2m = a5;
                ECFieldElement.F2m.checkFieldElements(f2m.h, f2m.I);
                if (a != null) {
                    F2m f2m2 = a5;
                    ECFieldElement.F2m.checkFieldElements(f2m2.h, f2m2.finally.getA());
                }
            }
            a5.withCompression = a4;
        }

        @Override
        synchronized void catch() {
            F2m a;
            if (a.multiplier == null) {
                if (((ECCurve.F2m)a.finally).isKoblitz()) {
                    F2m f2m = a;
                    f2m.multiplier = new NUl();
                    return;
                }
                a.multiplier = new nUl();
            }
        }

        @Override
        public ECPoint twice() {
            F2m a;
            if (a.isInfinity()) {
                return a;
            }
            if (a.h.toBigInteger().signum() == 0) {
                return a.finally.getInfinity();
            }
            F2m f2m = a;
            ECFieldElement.F2m f2m2 = (ECFieldElement.F2m)f2m.h.add(f2m.I.divide(a.h));
            ECFieldElement.F2m f2m3 = (ECFieldElement.F2m)f2m2.square().add(f2m2).add(a.finally.getA());
            F2m f2m4 = a;
            ECFieldElement eCFieldElement = f2m4.finally.fromBigInteger(ECConstants.ONE);
            eCFieldElement = (ECFieldElement.F2m)f2m4.h.square().add(f2m3.multiply(f2m2.add(eCFieldElement)));
            return new F2m(a.finally, f2m3, eCFieldElement, a.withCompression);
        }

        @Override
        public byte[] getEncoded() {
            F2m a;
            if (a.isInfinity()) {
                return new byte[1];
            }
            int n = M.getByteLength(a.h);
            byte[] byArray = M.integerToBytes(a.getX().toBigInteger(), n);
            if (a.withCompression) {
                byte[] byArray2 = new byte[n + 1];
                byArray2[0] = 2;
                if (!a.getX().toBigInteger().equals(ECConstants.ZERO) && a.getY().multiply(a.getX().invert()).toBigInteger().testBit(0)) {
                    byArray2[0] = 3;
                }
                System.arraycopy(byArray, 0, byArray2, 1, n);
                return byArray2;
            }
            byte[] byArray3 = M.integerToBytes(a.getY().toBigInteger(), n);
            int n2 = n;
            byte[] byArray4 = new byte[n2 + n2 + 1];
            byArray4[0] = 4;
            System.arraycopy(byArray, 0, byArray4, 1, n);
            System.arraycopy(byArray3, 0, byArray4, n + 1, n);
            return byArray4;
        }

        public F2m addSimple(F2m a) {
            F2m a2;
            Object object = a;
            if (a2.isInfinity()) {
                return object;
            }
            if (((ECPoint)object).isInfinity()) {
                return a2;
            }
            ECFieldElement.F2m f2m = (ECFieldElement.F2m)((ECPoint)object).getX();
            object = (ECFieldElement.F2m)((ECPoint)object).getY();
            if (a2.h.equals(f2m)) {
                if (a2.I.equals(object)) {
                    return (F2m)a2.twice();
                }
                return (F2m)a2.finally.getInfinity();
            }
            object = (ECFieldElement.F2m)a2.I.add((ECFieldElement)object).divide(a2.h.add(f2m));
            f2m = (ECFieldElement.F2m)((ECFieldElement.F2m)object).square().add((ECFieldElement)object).add(a2.h).add(f2m).add(a2.finally.getA());
            object = (ECFieldElement.F2m)((ECFieldElement.F2m)object).multiply(a2.h.add(f2m)).add(f2m).add(a2.I);
            return new F2m(a2.finally, f2m, (ECFieldElement)object, a2.withCompression);
        }

        @Override
        public ECPoint add(ECPoint a) {
            F2m a2;
            F2m f2m = a2;
            F2m.public(f2m, a);
            return f2m.addSimple((F2m)a);
        }

        private static /* synthetic */ void public(ECPoint a, ECPoint a2) {
            if (!a.finally.equals(a2.finally)) {
                throw new IllegalArgumentException(X9ECParametersHolder.float("D]nCi\u0001e[hJ`\u000b`Yi\u0005j_$O(\u001cG:GiEym\u0010mWg\u0011qNc\u001aE}0\t*]e\u000fa_gIyRmBaX"));
            }
        }

        @Override
        public ECPoint negate() {
            F2m a;
            return new F2m(a.finally, a.getX(), a.getY().add(a.getX()), a.withCompression);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class Fp
    extends ECPoint {
        public Fp(ECCurve a, ECFieldElement a2, ECFieldElement a3) {
            a4(a, a2, a3, false);
            Fp a4;
        }

        @Override
        public ECPoint add(ECPoint a) {
            Fp a2;
            if (a2.isInfinity()) {
                return a;
            }
            if (a.isInfinity()) {
                return a2;
            }
            if (a2.h.equals(a.h)) {
                if (a2.I.equals(a.I)) {
                    return a2.twice();
                }
                return a2.finally.getInfinity();
            }
            ECFieldElement eCFieldElement = a.I.subtract(a2.I).divide(a.h.subtract(a2.h));
            ECFieldElement eCFieldElement2 = eCFieldElement.square().subtract(a2.h).subtract(a.h);
            ECFieldElement eCFieldElement3 = eCFieldElement.multiply(a2.h.subtract(eCFieldElement2)).subtract(a2.I);
            return new Fp(a2.finally, eCFieldElement2, eCFieldElement3);
        }

        @Override
        public byte[] getEncoded() {
            Fp a;
            if (a.isInfinity()) {
                return new byte[1];
            }
            int n = M.getByteLength(a.h);
            if (a.withCompression) {
                int n2 = a.getY().toBigInteger().testBit(0) ? 3 : 2;
                byte[] byArray = M.integerToBytes(a.getX().toBigInteger(), n);
                byte[] byArray2 = new byte[byArray.length + 1];
                byArray2[0] = n2;
                System.arraycopy(byArray, 0, byArray2, 1, byArray.length);
                return byArray2;
            }
            byte[] byArray = M.integerToBytes(a.getX().toBigInteger(), n);
            byte[] byArray3 = M.integerToBytes(a.getY().toBigInteger(), n);
            byte[] byArray4 = new byte[byArray.length + byArray3.length + 1];
            byArray4[0] = 4;
            System.arraycopy(byArray, 0, byArray4, 1, byArray.length);
            System.arraycopy(byArray3, 0, byArray4, byArray.length + 1, byArray3.length);
            return byArray4;
        }

        @Override
        public ECPoint negate() {
            Fp a;
            Fp fp = a;
            return new Fp(fp.finally, fp.h, a.I.negate(), a.withCompression);
        }

        @Override
        public ECPoint twice() {
            Fp a;
            if (a.isInfinity()) {
                return a;
            }
            if (a.I.toBigInteger().signum() == 0) {
                return a.finally.getInfinity();
            }
            Fp fp = a;
            ECFieldElement eCFieldElement = fp.finally.fromBigInteger(BigInteger.valueOf(2L));
            ECFieldElement eCFieldElement2 = fp.finally.fromBigInteger(BigInteger.valueOf(3L));
            ECFieldElement eCFieldElement3 = fp.h.square().multiply(eCFieldElement2).add(a.finally.I).divide(a.I.multiply(eCFieldElement));
            eCFieldElement2 = eCFieldElement3.square().subtract(a.h.multiply(eCFieldElement));
            ECFieldElement eCFieldElement4 = eCFieldElement3.multiply(a.h.subtract(eCFieldElement2)).subtract(a.I);
            return new Fp(a.finally, eCFieldElement2, eCFieldElement4, a.withCompression);
        }

        public Fp(ECCurve a, ECFieldElement a2, ECFieldElement a3, boolean a4) {
            Fp a5;
            ECFieldElement eCFieldElement = a2;
            super(a, eCFieldElement, a3);
            if (eCFieldElement != null && a3 == null || a2 == null && a3 != null) {
                throw new IllegalArgumentException(TypeHelper.boolean("\u0016\u0017;Ge\u000b+K1\u0010.B8B1\u001b2\f|Bx*\u0016-\\?\u0003\u0000=\u00068\u0010\"^\"];\"\f\u0016#"));
            }
            a5.withCompression = a4;
        }

        @Override
        synchronized void catch() {
            Fp a;
            if (a.multiplier == null) {
                Fp fp = a;
                fp.multiplier = new nUl();
            }
        }

        @Override
        public ECPoint subtract(ECPoint a) {
            Fp a2;
            if (a.isInfinity()) {
                return a2;
            }
            return a2.add(a.negate());
        }
    }
}

