/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.core.bouncycastle.math.ec;

import com.jxdinfo.hussar.core.banner.EmbeddedContainerUtils;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.ECConstants;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.cOn;
import com.jxdinfo.hussar.core.qr.QrImage;
import com.jxdinfo.hussar.core.support.StrKit;
import com.jxdinfo.hussar.core.support.WafKit;
import java.math.BigInteger;
import java.util.Random;

public abstract class ECFieldElement
implements ECConstants {
    public abstract int getFieldSize();

    public abstract ECFieldElement subtract(ECFieldElement var1);

    public abstract ECFieldElement sqrt();

    public abstract ECFieldElement add(ECFieldElement var1);

    public ECFieldElement() {
        ECFieldElement a;
    }

    public abstract ECFieldElement square();

    public abstract String getFieldName();

    public abstract ECFieldElement invert();

    public abstract ECFieldElement divide(ECFieldElement var1);

    public abstract BigInteger toBigInteger();

    public abstract ECFieldElement multiply(ECFieldElement var1);

    public String toString() {
        ECFieldElement a;
        return a.toBigInteger().toString(2);
    }

    public abstract ECFieldElement negate();

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class F2m
    extends ECFieldElement {
        public static final int GNB = 1;
        private cOn C;
        private int c;
        private int G;
        public static final int TPB = 2;
        private int M;
        private int h;
        public static final int PPB = 3;
        private int I;
        private int implements;

        @Override
        public ECFieldElement invert() {
            F2m a;
            cOn cOn2 = (cOn)a.C.clone();
            cOn cOn3 = new cOn(a.I);
            F2m f2m = a;
            cOn cOn4 = cOn3;
            cOn4.enum(a.M);
            cOn4.enum(0);
            cOn3.enum(f2m.implements);
            if (f2m.c == 3) {
                cOn cOn5 = cOn3;
                cOn5.enum(a.G);
                cOn5.enum(a.h);
            }
            cOn cOn6 = new cOn(a.I);
            cOn6.enum(0);
            cOn cOn7 = new cOn(a.I);
            cOn cOn8 = cOn2;
            while (!cOn8.return()) {
                int n = cOn2.false() - cOn3.false();
                if (n < 0) {
                    cOn cOn9 = cOn2;
                    cOn2 = cOn3;
                    cOn3 = cOn9;
                    cOn cOn10 = cOn6;
                    cOn6 = cOn7;
                    cOn7 = cOn10;
                    n = -n;
                }
                int n2 = n >> 5;
                cOn cOn11 = cOn3.default(n &= 0x1F);
                cOn cOn12 = cOn2;
                cOn8 = cOn12;
                cOn12.switch(cOn11, n2);
                cOn cOn13 = cOn7.default(n);
                cOn6.switch(cOn13, n2);
            }
            F2m f2m2 = a;
            F2m f2m3 = a;
            return new F2m(f2m2.M, f2m2.implements, f2m3.G, f2m3.h, cOn7);
        }

        public int getK3() {
            F2m a;
            return a.h;
        }

        @Override
        public ECFieldElement divide(ECFieldElement a) {
            F2m a2;
            ECFieldElement eCFieldElement = a.invert();
            return a2.multiply(eCFieldElement);
        }

        @Override
        public ECFieldElement negate() {
            F2m a;
            return a;
        }

        public int getK2() {
            F2m a;
            return a.G;
        }

        public int hashCode() {
            F2m a;
            return a.C.hashCode() ^ a.M ^ a.implements ^ a.G ^ a.h;
        }

        @Override
        public ECFieldElement multiply(ECFieldElement a) {
            F2m a2;
            Object object = (F2m)a;
            object = a2.C.void(((F2m)object).C, a2.M);
            int[] nArray = new int[3];
            nArray[0] = a2.implements;
            nArray[1] = a2.G;
            nArray[2] = a2.h;
            ((cOn)object).abstract(a2.M, nArray);
            F2m f2m = a2;
            F2m f2m2 = a2;
            return new F2m(f2m.M, f2m.implements, f2m2.G, f2m2.h, (cOn)object);
        }

        private /* synthetic */ F2m(int a, int a2, int a3, int a4, cOn a5) {
            F2m a6;
            F2m f2m = a6;
            F2m f2m2 = a6;
            F2m f2m3 = a6;
            f2m3.I = a + 31 >> 5;
            f2m3.C = a5;
            f2m2.M = a;
            f2m2.implements = a2;
            f2m.G = a3;
            f2m.h = a4;
            if (a3 == 0 && a4 == 0) {
                a6.c = 2;
                return;
            }
            a6.c = 3;
        }

        public F2m(int a, int a2, int a3, int a4, BigInteger a5) {
            BigInteger bigInteger;
            F2m a6;
            a6.I = a + 31 >> 5;
            F2m f2m = a6;
            a6.C = new cOn(a5, a6.I);
            if (a3 == 0 && a4 == 0) {
                bigInteger = a5;
                a6.c = 2;
            } else {
                if (a3 >= a4) {
                    throw new IllegalArgumentException(StrKit.finally("3Jp\u001d\u0004\",X3\u0014y\n<\u00106\u0016%\u00120D\u001a3h\u00062J"));
                }
                if (a3 <= 0) {
                    throw new IllegalArgumentException(EmbeddedContainerUtils.float("\u0002Kh5\u0014\u0002\u001cX\u0002\u0015H\u0014\u0002\u0001\u001e\f[\u0019?3^A@@"));
                }
                a6.c = 3;
                bigInteger = a5;
            }
            if (bigInteger.signum() < 0) {
                throw new IllegalArgumentException(StrKit.finally(" X&\u0011\u001d$=X2\u00107\u0017>\u0005z\u0018%@~U\u00153rO/\u001c"));
            }
            F2m f2m2 = a6;
            a6.M = a;
            f2m2.implements = a2;
            f2m2.G = a3;
            a6.h = a4;
        }

        @Override
        public int getFieldSize() {
            F2m a;
            return a.M;
        }

        public F2m(int a, int a2, BigInteger a3) {
            a4(a, a2, 0, 0, a3);
            F2m a4;
        }

        public int getRepresentation() {
            F2m a;
            return a.c;
        }

        @Override
        public ECFieldElement square() {
            F2m a;
            F2m f2m = a;
            cOn cOn2 = f2m.C.transient(f2m.M);
            int[] nArray = new int[3];
            nArray[0] = a.implements;
            nArray[1] = a.G;
            nArray[2] = a.h;
            cOn2.abstract(a.M, nArray);
            F2m f2m2 = a;
            F2m f2m3 = a;
            return new F2m(f2m2.M, f2m2.implements, f2m3.G, f2m3.h, cOn2);
        }

        public boolean equals(Object a) {
            F2m a2;
            if (a == a2) {
                return true;
            }
            if (!(a instanceof F2m)) {
                return false;
            }
            F2m f2m = (F2m)a;
            return a2.M == f2m.M && a2.implements == f2m.implements && a2.G == f2m.G && a2.h == f2m.h && a2.c == f2m.c && a2.C.equals(f2m.C);
        }

        @Override
        public ECFieldElement subtract(ECFieldElement a) {
            F2m a2;
            return a2.add(a);
        }

        @Override
        public ECFieldElement add(ECFieldElement a) {
            F2m a2;
            cOn cOn2 = (cOn)a2.C.clone();
            F2m f2m = (F2m)a;
            cOn2.switch(f2m.C, 0);
            F2m f2m2 = a2;
            F2m f2m3 = a2;
            return new F2m(f2m2.M, f2m2.implements, f2m3.G, f2m3.h, cOn2);
        }

        @Override
        public ECFieldElement sqrt() {
            throw new RuntimeException(EmbeddedContainerUtils.float(">\u0007\fC\u001a\u0014\u0019E\\&>Q[\u0005\u0014"));
        }

        public static void checkFieldElements(ECFieldElement a, ECFieldElement a2) {
            if (!(a instanceof F2m) || !(a2 instanceof F2m)) {
                throw new IllegalArgumentException(StrKit.finally("&1\u001d=\u0015:_5\u001c8\u0010.\u0014/\\{H4Q9\u0018n\u001a\u0013>\u0003?R;3\u000e%\u00106\u001b5\u0003Q>>X\u00142\u001f\u00104\u001d>?,\u0005}U\u001c&(`k\u0014"));
            }
            F2m f2m = (F2m)a;
            F2m f2m2 = (F2m)a2;
            if (f2m.M != f2m2.M || f2m.implements != f2m2.implements || f2m.G != f2m2.G || f2m.h != f2m2.h) {
                throw new IllegalArgumentException(EmbeddedContainerUtils.float("u\t\u0015\u0000\u0018Y\f\t\u0010NV\u0006\f\u001d^BA-x 1?{\u0001\u0018\r\u0015\u0004\u001f\u001d\nh7\u0007Q\u001c\u0010\u0005P\u001b\u0019\u000e\u0016Y\u000f@\\'?\u001fiR\u001d"));
            }
            if (f2m.c != f2m2.c) {
                throw new IllegalArgumentException(StrKit.finally("59\u0012m\u00021W!\u001d\"G&\t=\u00145Q\u007fV<\u00140\u001b4\u0013|\u001dh_q\u001f8\u0003:_\u001d4\u001a2\u001c&.]9\u0010+X9\u001e\u0012>*\n4\u0012-Y#\u0014*\b%\u0013u^\u00063rO6\u0017"));
            }
        }

        @Override
        public BigInteger toBigInteger() {
            F2m a;
            return a.C.char();
        }

        public int getM() {
            F2m a;
            return a.M;
        }

        @Override
        public String getFieldName() {
            return EmbeddedContainerUtils.float("iR\u001d");
        }

        public int getK1() {
            F2m a;
            return a.implements;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class Fp
    extends ECFieldElement {
        BigInteger I;
        BigInteger interface;

        @Override
        public ECFieldElement divide(ECFieldElement a) {
            Fp a2;
            Fp fp = a2;
            return new Fp(fp.interface, fp.I.multiply(a.toBigInteger().modInverse(a2.interface)).mod(a2.interface));
        }

        @Override
        public ECFieldElement multiply(ECFieldElement a) {
            Fp a2;
            Fp fp = a2;
            return new Fp(fp.interface, fp.I.multiply(a.toBigInteger()).mod(a2.interface));
        }

        public Fp(BigInteger a, BigInteger a2) {
            Fp a3;
            a3.I = a2;
            if (a3.I.compareTo(a) >= 0) {
                throw new IllegalArgumentException(WafKit.float("_<W{Hjn\u0010sSa\u0015j\\U{k\u0015nR/RnY`S6H*\u0018Iz|]"));
            }
            a3.interface = a;
        }

        @Override
        public String getFieldName() {
            return QrImage.float("[w");
        }

        public BigInteger getQ() {
            Fp a;
            return a.interface;
        }

        @Override
        public BigInteger toBigInteger() {
            Fp a;
            return a.I;
        }

        @Override
        public ECFieldElement square() {
            Fp a;
            Fp fp = a;
            return new Fp(fp.interface, fp.I.multiply(a.I).mod(a.interface));
        }

        public int hashCode() {
            Fp a;
            return a.interface.hashCode() ^ a.I.hashCode();
        }

        private static /* synthetic */ BigInteger[] final(BigInteger a, BigInteger a2, BigInteger a3, BigInteger a4) {
            BigInteger bigInteger = a4;
            int n = bigInteger.bitLength();
            int n2 = bigInteger.getLowestSetBit();
            BigInteger bigInteger2 = ECConstants.ONE;
            BigInteger bigInteger3 = ECConstants.TWO;
            BigInteger bigInteger4 = a2;
            BigInteger bigInteger5 = ECConstants.ONE;
            BigInteger bigInteger6 = ECConstants.ONE;
            int n3 = n = n - 1;
            while (n3 >= n2 + 1) {
                bigInteger5 = bigInteger5.multiply(bigInteger6).mod(a);
                if (a4.testBit(n)) {
                    bigInteger6 = bigInteger5.multiply(a3).mod(a);
                    bigInteger2 = bigInteger2.multiply(bigInteger4).mod(a);
                    BigInteger bigInteger7 = bigInteger4;
                    bigInteger3 = bigInteger7.multiply(bigInteger3).subtract(a2.multiply(bigInteger5)).mod(a);
                    bigInteger4 = bigInteger7.multiply(bigInteger7).subtract(bigInteger6.shiftLeft(1)).mod(a);
                } else {
                    bigInteger6 = bigInteger5;
                    bigInteger2 = bigInteger2.multiply(bigInteger3).subtract(bigInteger5).mod(a);
                    bigInteger4 = bigInteger4.multiply(bigInteger3).subtract(a2.multiply(bigInteger5)).mod(a);
                    BigInteger bigInteger8 = bigInteger3;
                    bigInteger3 = bigInteger8.multiply(bigInteger8).subtract(bigInteger5.shiftLeft(1)).mod(a);
                }
                n3 = --n;
            }
            bigInteger5 = bigInteger5.multiply(bigInteger6).mod(a);
            bigInteger6 = bigInteger5.multiply(a3).mod(a);
            bigInteger2 = bigInteger2.multiply(bigInteger3).subtract(bigInteger5).mod(a);
            BigInteger bigInteger9 = bigInteger5;
            bigInteger3 = bigInteger4.multiply(bigInteger3).subtract(a2.multiply(bigInteger9)).mod(a);
            bigInteger5 = bigInteger9.multiply(bigInteger6).mod(a);
            int n4 = n = 1;
            while (n4 <= n2) {
                bigInteger2 = bigInteger2.multiply(bigInteger3).mod(a);
                BigInteger bigInteger10 = bigInteger3;
                bigInteger3 = bigInteger10.multiply(bigInteger10).subtract(bigInteger5.shiftLeft(1)).mod(a);
                BigInteger bigInteger11 = bigInteger5;
                bigInteger5 = bigInteger11.multiply(bigInteger11).mod(a);
                n4 = ++n;
            }
            BigInteger[] bigIntegerArray = new BigInteger[2];
            bigIntegerArray[0] = bigInteger2;
            bigIntegerArray[1] = bigInteger3;
            return bigIntegerArray;
        }

        @Override
        public ECFieldElement add(ECFieldElement a) {
            Fp a2;
            Fp fp = a2;
            return new Fp(fp.interface, fp.I.add(a.toBigInteger()).mod(a2.interface));
        }

        @Override
        public ECFieldElement subtract(ECFieldElement a) {
            Fp a2;
            Fp fp = a2;
            return new Fp(fp.interface, fp.I.subtract(a.toBigInteger()).mod(a2.interface));
        }

        @Override
        public ECFieldElement invert() {
            Fp a;
            Fp fp = a;
            return new Fp(fp.interface, fp.I.modInverse(a.interface));
        }

        @Override
        public ECFieldElement sqrt() {
            Fp a;
            if (!a.interface.testBit(0)) {
                throw new RuntimeException(WafKit.float("iSx\u0017rB(\u0018\u0004fw]"));
            }
            if (a.interface.testBit(1)) {
                Fp fp = a;
                Fp fp2 = new Fp(fp.interface, fp.I.modPow(a.interface.shiftRight(2).add(ECConstants.ONE), a.interface));
                if (((ECFieldElement)fp2).square().equals(a)) {
                    return fp2;
                }
                return null;
            }
            Fp fp = a;
            BigInteger bigInteger = fp.interface.subtract(ECConstants.ONE);
            BigInteger bigInteger2 = bigInteger.shiftRight(1);
            if (!fp.I.modPow(bigInteger2, a.interface).equals(ECConstants.ONE)) {
                return null;
            }
            BigInteger bigInteger3 = bigInteger.shiftRight(2).shiftLeft(1).add(ECConstants.ONE);
            BigInteger bigInteger4 = a.I;
            BigInteger bigInteger5 = bigInteger4.shiftLeft(2).mod(a.interface);
            Random random = new Random();
            while (true) {
                BigInteger bigInteger6;
                if ((bigInteger6 = new BigInteger(a.interface.bitLength(), random)).compareTo(a.interface) >= 0) {
                    continue;
                }
                BigInteger bigInteger7 = bigInteger6;
                if (!bigInteger7.multiply(bigInteger7).subtract(bigInteger5).modPow(bigInteger2, a.interface).equals(bigInteger)) continue;
                BigInteger[] bigIntegerArray = Fp.final(a.interface, bigInteger6, bigInteger4, bigInteger3);
                BigInteger bigInteger8 = bigIntegerArray[0];
                BigInteger bigInteger9 = bigIntegerArray[1];
                if (bigInteger9.multiply(bigInteger9).mod(a.interface).equals(bigInteger5)) {
                    if (bigInteger9.testBit(0)) {
                        bigInteger9 = bigInteger9.add(a.interface);
                    }
                    bigInteger9 = bigInteger9.shiftRight(1);
                    return new Fp(a.interface, bigInteger9);
                }
                if (!bigInteger8.equals(ECConstants.ONE) && !bigInteger8.equals(bigInteger)) break;
            }
            return null;
        }

        @Override
        public int getFieldSize() {
            Fp a;
            return a.interface.bitLength();
        }

        @Override
        public ECFieldElement negate() {
            Fp a;
            Fp fp = a;
            return new Fp(fp.interface, fp.I.negate().mod(a.interface));
        }

        public boolean equals(Object a) {
            Fp a2;
            if (a == a2) {
                return true;
            }
            if (!(a instanceof Fp)) {
                return false;
            }
            Fp fp = (Fp)a;
            return a2.interface.equals(fp.interface) && a2.I.equals(fp.I);
        }
    }
}

