/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.core.bouncycastle.math.ec;

import com.jxdinfo.hussar.core.auto.common.TypeHelper;
import com.jxdinfo.hussar.core.bouncycastle.asn1.x9.X9IntegerConverter;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.ECConstants;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.ECCurve;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.ECFieldElement;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.Nul;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.Prn;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.aux;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.nuL;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.prn;
import com.jxdinfo.hussar.core.cache.LRULinkedHashMap;
import com.jxdinfo.hussar.core.support.ClassKit;
import com.jxdinfo.hussar.core.util.LicenseInfo;
import java.math.BigInteger;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class ECPoint {
    ECFieldElement c;
    private static X9IntegerConverter F = new X9IntegerConverter();
    protected nuL preCompInfo;
    ECCurve f;
    ECFieldElement protected;
    protected boolean withCompression;
    protected prn multiplier;

    public abstract ECPoint add(ECPoint var1);

    public boolean isInfinity() {
        ECPoint a;
        return a.protected == null && a.c == null;
    }

    public ECFieldElement getY() {
        ECPoint a;
        return a.c;
    }

    public abstract byte[] getEncoded();

    public abstract ECPoint negate();

    public ECFieldElement getX() {
        ECPoint a;
        return a.protected;
    }

    synchronized void private() {
        ECPoint a;
        if (a.multiplier == null) {
            ECPoint eCPoint = a;
            eCPoint.multiplier = new Prn();
        }
    }

    public abstract ECPoint twice();

    public boolean equals(Object a) {
        ECPoint a2;
        if (a == a2) {
            return true;
        }
        if (!(a instanceof ECPoint)) {
            return false;
        }
        a = (ECPoint)a;
        if (a2.isInfinity()) {
            return ((ECPoint)a).isInfinity();
        }
        return a2.protected.equals(((ECPoint)a).protected) && a2.c.equals(((ECPoint)a).c);
    }

    public ECPoint multiply(BigInteger a) {
        ECPoint a2;
        if (a.signum() < 0) {
            throw new IllegalArgumentException(LicenseInfo.while("Yoa.\"0`rizyvjb;*v.ai!+KZ\u0002JT\u001b`aoc{lcz"));
        }
        if (a2.isInfinity()) {
            return a2;
        }
        if (a.signum() == 0) {
            return a2.f.getInfinity();
        }
        ECPoint eCPoint = a2;
        eCPoint.private();
        ECPoint eCPoint2 = a2;
        return eCPoint.multiplier.int(eCPoint2, a, eCPoint2.preCompInfo);
    }

    void default(nuL a) {
        a.preCompInfo = a;
    }

    public abstract ECPoint subtract(ECPoint var1);

    public ECCurve getCurve() {
        ECPoint a;
        return a.f;
    }

    protected ECPoint(ECCurve a, ECFieldElement a2, ECFieldElement a3) {
        ECPoint a4;
        ECPoint eCPoint = a4;
        ECPoint eCPoint2 = a4;
        a4.multiplier = null;
        eCPoint2.preCompInfo = null;
        eCPoint2.f = a;
        eCPoint.protected = a2;
        eCPoint.c = a3;
    }

    public boolean isCompressed() {
        ECPoint a;
        return a.withCompression;
    }

    public int hashCode() {
        ECPoint a;
        if (a.isInfinity()) {
            return 0;
        }
        return a.protected.hashCode() ^ a.c.hashCode();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class F2m
    extends ECPoint {
        public F2m(ECCurve a, ECFieldElement a2, ECFieldElement a3) {
            a4(a, a2, a3, false);
            F2m a4;
        }

        public F2m subtractSimple(F2m a) {
            F2m a2;
            if (a.isInfinity()) {
                return a2;
            }
            return a2.addSimple((F2m)a.negate());
        }

        public F2m(ECCurve a, ECFieldElement a2, ECFieldElement a3, boolean a4) {
            F2m a5;
            ECFieldElement eCFieldElement = a2;
            super(a, eCFieldElement, a3);
            if (eCFieldElement != null && a3 == null || a2 == null && a3 != null) {
                throw new IllegalArgumentException(LRULinkedHashMap.return("Kf${79w\u001e\nV\u0006\u000b\u001frof!pni=:hYF,~s \"rf:5'aia!)r"));
            }
            if (a2 != null) {
                F2m f2m = a5;
                ECFieldElement.F2m.checkFieldElements(f2m.protected, f2m.c);
                if (a != null) {
                    F2m f2m2 = a5;
                    ECFieldElement.F2m.checkFieldElements(f2m2.protected, f2m2.f.getA());
                }
            }
            a5.withCompression = a4;
        }

        @Override
        public ECPoint subtract(ECPoint a) {
            F2m a2;
            F2m f2m = a2;
            F2m.public(f2m, a);
            return f2m.subtractSimple((F2m)a);
        }

        @Override
        public ECPoint negate() {
            F2m a;
            return new F2m(a.f, a.getX(), a.getY().add(a.getX()), a.withCompression);
        }

        @Override
        synchronized void private() {
            F2m a;
            if (a.multiplier == null) {
                if (((ECCurve.F2m)a.f).isKoblitz()) {
                    F2m f2m = a;
                    f2m.multiplier = new Nul();
                    return;
                }
                a.multiplier = new aux();
            }
        }

        @Override
        public ECPoint twice() {
            F2m a;
            if (a.isInfinity()) {
                return a;
            }
            if (a.protected.toBigInteger().signum() == 0) {
                return a.f.getInfinity();
            }
            F2m f2m = a;
            ECFieldElement.F2m f2m2 = (ECFieldElement.F2m)f2m.protected.add(f2m.c.divide(a.protected));
            ECFieldElement.F2m f2m3 = (ECFieldElement.F2m)f2m2.square().add(f2m2).add(a.f.getA());
            F2m f2m4 = a;
            ECFieldElement eCFieldElement = f2m4.f.fromBigInteger(ECConstants.ONE);
            eCFieldElement = (ECFieldElement.F2m)f2m4.protected.square().add(f2m3.multiply(f2m2.add(eCFieldElement)));
            return new F2m(a.f, f2m3, eCFieldElement, a.withCompression);
        }

        @Override
        public ECPoint add(ECPoint a) {
            F2m a2;
            F2m f2m = a2;
            F2m.public(f2m, a);
            return f2m.addSimple((F2m)a);
        }

        public F2m addSimple(F2m a) {
            F2m a2;
            Object object = a;
            if (a2.isInfinity()) {
                return object;
            }
            if (((ECPoint)object).isInfinity()) {
                return a2;
            }
            ECFieldElement.F2m f2m = (ECFieldElement.F2m)((ECPoint)object).getX();
            object = (ECFieldElement.F2m)((ECPoint)object).getY();
            if (a2.protected.equals(f2m)) {
                if (a2.c.equals(object)) {
                    return (F2m)a2.twice();
                }
                return (F2m)a2.f.getInfinity();
            }
            object = (ECFieldElement.F2m)a2.c.add((ECFieldElement)object).divide(a2.protected.add(f2m));
            f2m = (ECFieldElement.F2m)((ECFieldElement.F2m)object).square().add((ECFieldElement)object).add(a2.protected).add(f2m).add(a2.f.getA());
            object = (ECFieldElement.F2m)((ECFieldElement.F2m)object).multiply(a2.protected.add(f2m)).add(f2m).add(a2.c);
            return new F2m(a2.f, f2m, (ECFieldElement)object, a2.withCompression);
        }

        private static /* synthetic */ void public(ECPoint a, ECPoint a2) {
            if (!a.f.equals(a2.f)) {
                throw new IllegalArgumentException(TypeHelper.instanceof("\u001eu'xqk<p/\u007f5,1zwit3\u007ff2t#,9en 2=2zrv\u0015XQZ\u0006L8s{~.65yt(\u0006_c>:q"));
            }
        }

        @Override
        public byte[] getEncoded() {
            F2m a;
            if (a.isInfinity()) {
                return new byte[1];
            }
            int n = F.getByteLength(a.protected);
            byte[] byArray = F.integerToBytes(a.getX().toBigInteger(), n);
            if (a.withCompression) {
                byte[] byArray2 = new byte[n + 1];
                byArray2[0] = 2;
                if (!a.getX().toBigInteger().equals(ECConstants.ZERO) && a.getY().multiply(a.getX().invert()).toBigInteger().testBit(0)) {
                    byArray2[0] = 3;
                }
                System.arraycopy(byArray, 0, byArray2, 1, n);
                return byArray2;
            }
            byte[] byArray3 = F.integerToBytes(a.getY().toBigInteger(), n);
            int n2 = n;
            byte[] byArray4 = new byte[n2 + n2 + 1];
            byArray4[0] = 4;
            System.arraycopy(byArray, 0, byArray4, 1, n);
            System.arraycopy(byArray3, 0, byArray4, n + 1, n);
            return byArray4;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class Fp
    extends ECPoint {
        @Override
        public ECPoint twice() {
            Fp a;
            if (a.isInfinity()) {
                return a;
            }
            if (a.c.toBigInteger().signum() == 0) {
                return a.f.getInfinity();
            }
            Fp fp = a;
            ECFieldElement eCFieldElement = fp.f.fromBigInteger(BigInteger.valueOf(2L));
            ECFieldElement eCFieldElement2 = fp.f.fromBigInteger(BigInteger.valueOf(3L));
            ECFieldElement eCFieldElement3 = fp.protected.square().multiply(eCFieldElement2).add(a.f.f).divide(a.c.multiply(eCFieldElement));
            eCFieldElement2 = eCFieldElement3.square().subtract(a.protected.multiply(eCFieldElement));
            ECFieldElement eCFieldElement4 = eCFieldElement3.multiply(a.protected.subtract(eCFieldElement2)).subtract(a.c);
            return new Fp(a.f, eCFieldElement2, eCFieldElement4, a.withCompression);
        }

        public Fp(ECCurve a, ECFieldElement a2, ECFieldElement a3) {
            a4(a, a2, a3, false);
            Fp a4;
        }

        @Override
        public byte[] getEncoded() {
            Fp a;
            if (a.isInfinity()) {
                return new byte[1];
            }
            int n = F.getByteLength(a.protected);
            if (a.withCompression) {
                int n2 = a.getY().toBigInteger().testBit(0) ? 3 : 2;
                byte[] byArray = F.integerToBytes(a.getX().toBigInteger(), n);
                byte[] byArray2 = new byte[byArray.length + 1];
                byArray2[0] = n2;
                System.arraycopy(byArray, 0, byArray2, 1, byArray.length);
                return byArray2;
            }
            byte[] byArray = F.integerToBytes(a.getX().toBigInteger(), n);
            byte[] byArray3 = F.integerToBytes(a.getY().toBigInteger(), n);
            byte[] byArray4 = new byte[byArray.length + byArray3.length + 1];
            byArray4[0] = 4;
            System.arraycopy(byArray, 0, byArray4, 1, byArray.length);
            System.arraycopy(byArray3, 0, byArray4, byArray.length + 1, byArray3.length);
            return byArray4;
        }

        @Override
        synchronized void private() {
            Fp a;
            if (a.multiplier == null) {
                Fp fp = a;
                fp.multiplier = new aux();
            }
        }

        @Override
        public ECPoint add(ECPoint a) {
            Fp a2;
            if (a2.isInfinity()) {
                return a;
            }
            if (a.isInfinity()) {
                return a2;
            }
            if (a2.protected.equals(a.protected)) {
                if (a2.c.equals(a.c)) {
                    return a2.twice();
                }
                return a2.f.getInfinity();
            }
            ECFieldElement eCFieldElement = a.c.subtract(a2.c).divide(a.protected.subtract(a2.protected));
            ECFieldElement eCFieldElement2 = eCFieldElement.square().subtract(a2.protected).subtract(a.protected);
            ECFieldElement eCFieldElement3 = eCFieldElement.multiply(a2.protected.subtract(eCFieldElement2)).subtract(a2.c);
            return new Fp(a2.f, eCFieldElement2, eCFieldElement3);
        }

        @Override
        public ECPoint subtract(ECPoint a) {
            Fp a2;
            if (a.isInfinity()) {
                return a2;
            }
            return a2.add(a.negate());
        }

        @Override
        public ECPoint negate() {
            Fp a;
            Fp fp = a;
            return new Fp(fp.f, fp.protected, a.c.negate(), a.withCompression);
        }

        public Fp(ECCurve a, ECFieldElement a2, ECFieldElement a3, boolean a4) {
            Fp a5;
            ECFieldElement eCFieldElement = a2;
            super(a, eCFieldElement, a3);
            if (eCFieldElement != null && a3 == null || a2 == null && a3 != null) {
                throw new IllegalArgumentException(ClassKit.static("\u0005\u0006(Vv\u001a8Z\"\u0001=S+S\"\n!\u001doSk;\u0005<O.\u0010\u0011.\u0017+\u00011O1L(3\u001f\u00070"));
            }
            a5.withCompression = a4;
        }
    }
}

