/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.core.bouncycastle.math.ec;

import com.jxdinfo.hussar.core.auto.common.TypeHelper;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.CoN;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.ECConstants;
import com.jxdinfo.hussar.core.support.ClassKit;
import com.jxdinfo.hussar.core.support.ObjectKit;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.math.BigInteger;
import java.util.Random;

public abstract class ECFieldElement
implements ECConstants {
    public abstract String getFieldName();

    public abstract ECFieldElement subtract(ECFieldElement var1);

    public abstract ECFieldElement negate();

    public abstract ECFieldElement square();

    public abstract ECFieldElement divide(ECFieldElement var1);

    public abstract BigInteger toBigInteger();

    public abstract ECFieldElement invert();

    public abstract ECFieldElement add(ECFieldElement var1);

    public abstract int getFieldSize();

    public abstract ECFieldElement multiply(ECFieldElement var1);

    public abstract ECFieldElement sqrt();

    public ECFieldElement() {
        ECFieldElement a;
    }

    public String toString() {
        ECFieldElement a;
        return a.toBigInteger().toString(2);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class F2m
    extends ECFieldElement {
        private int K;
        public static final int TPB = 2;
        private CoN d;
        private int H;
        private int c;
        public static final int PPB = 3;
        private int F;
        private int f;
        private int if;
        public static final int GNB = 1;

        public F2m(int a, int a2, BigInteger a3) {
            a4(a, a2, 0, 0, a3);
            F2m a4;
        }

        @Override
        public ECFieldElement square() {
            F2m a;
            F2m f2m = a;
            CoN coN2 = f2m.d.transient(f2m.if);
            int[] nArray = new int[3];
            nArray[0] = a.H;
            nArray[1] = a.f;
            nArray[2] = a.c;
            coN2.if(a.if, nArray);
            F2m f2m2 = a;
            F2m f2m3 = a;
            return new F2m(f2m2.if, f2m2.H, f2m3.f, f2m3.c, coN2);
        }

        public int hashCode() {
            F2m a;
            return a.d.hashCode() ^ a.if ^ a.H ^ a.f ^ a.c;
        }

        @Override
        public ECFieldElement subtract(ECFieldElement a) {
            F2m a2;
            return a2.add(a);
        }

        @Override
        public ECFieldElement invert() {
            F2m a;
            CoN coN2 = (CoN)a.d.clone();
            CoN coN3 = new CoN(a.K);
            F2m f2m = a;
            CoN coN4 = coN3;
            coN4.boolean(a.if);
            coN4.boolean(0);
            coN3.boolean(f2m.H);
            if (f2m.F == 3) {
                CoN coN5 = coN3;
                coN5.boolean(a.f);
                coN5.boolean(a.c);
            }
            CoN coN6 = new CoN(a.K);
            coN6.boolean(0);
            CoN coN7 = new CoN(a.K);
            CoN coN8 = coN2;
            while (!coN8.implements()) {
                int n = coN2.return() - coN3.return();
                if (n < 0) {
                    CoN coN9 = coN2;
                    coN2 = coN3;
                    coN3 = coN9;
                    CoN coN10 = coN6;
                    coN6 = coN7;
                    coN7 = coN10;
                    n = -n;
                }
                int n2 = n >> 5;
                CoN coN11 = coN3.void(n &= 0x1F);
                CoN coN12 = coN2;
                coN8 = coN12;
                coN12.instanceof(coN11, n2);
                CoN coN13 = coN7.void(n);
                coN6.instanceof(coN13, n2);
            }
            F2m f2m2 = a;
            F2m f2m3 = a;
            return new F2m(f2m2.if, f2m2.H, f2m3.f, f2m3.c, coN7);
        }

        public boolean equals(Object a) {
            F2m a2;
            if (a == a2) {
                return true;
            }
            if (!(a instanceof F2m)) {
                return false;
            }
            F2m f2m = (F2m)a;
            return a2.if == f2m.if && a2.H == f2m.H && a2.f == f2m.f && a2.c == f2m.c && a2.F == f2m.F && a2.d.equals(f2m.d);
        }

        @Override
        public ECFieldElement negate() {
            F2m a;
            return a;
        }

        private /* synthetic */ F2m(int a, int a2, int a3, int a4, CoN a5) {
            F2m a6;
            F2m f2m = a6;
            F2m f2m2 = a6;
            F2m f2m3 = a6;
            f2m3.K = a + 31 >> 5;
            f2m3.d = a5;
            f2m2.if = a;
            f2m2.H = a2;
            f2m.f = a3;
            f2m.c = a4;
            if (a3 == 0 && a4 == 0) {
                a6.F = 2;
                return;
            }
            a6.F = 3;
        }

        @Override
        public String getFieldName() {
            return ToolUtil.extends("Vh\"");
        }

        public F2m(int a, int a2, int a3, int a4, BigInteger a5) {
            BigInteger bigInteger;
            F2m a6;
            a6.K = a + 31 >> 5;
            F2m f2m = a6;
            a6.d = new CoN(a5, a6.K);
            if (a3 == 0 && a4 == 0) {
                bigInteger = a5;
                a6.F = 2;
            } else {
                if (a3 >= a4) {
                    throw new IllegalArgumentException(ObjectKit.instanceof("F7\u0005`q_Y%Fi\fwImCkPoE9oN\u001d{G7"));
                }
                if (a3 <= 0) {
                    throw new IllegalArgumentException(ToolUtil.extends("8tR\n.=&g8*r+8>$3a&\u0005\fd~z\u007f"));
                }
                a6.F = 3;
                bigInteger = a5;
            }
            if (bigInteger.signum() < 0) {
                throw new IllegalArgumentException(ObjectKit.instanceof("U%SlhYH%GmBjKx\u000feP=\u000b(`N\u00072Za"));
            }
            F2m f2m2 = a6;
            a6.if = a;
            f2m2.H = a2;
            f2m2.f = a3;
            a6.c = a4;
        }

        public static void checkFieldElements(ECFieldElement a, ECFieldElement a2) {
            if (!(a instanceof F2m) || !(a2 instanceof F2m)) {
                throw new IllegalArgumentException(ObjectKit.instanceof("[D`HhO\"@aMm[iZ!\u000e5A,Le\u001bgfCvB'FFsPmCf@~$CK%aOjmA`KBYx\b(i[]\u001d\u001ei"));
            }
            F2m f2m = (F2m)a;
            F2m f2m2 = (F2m)a2;
            if (f2m.if != f2m2.if || f2m.H != f2m2.H || f2m.f != f2m2.f || f2m.c != f2m2.c) {
                throw new IllegalArgumentException(ToolUtil.extends("J3*:'c33/ti<3'ax~\u0017G\u001a\u000e\u0005D;'7*> '5R\b=n&/?o!&4)c0zc\u001d\u0000%Vh\""));
            }
            if (f2m.F != f2m2.F) {
                throw new IllegalArgumentException(ObjectKit.instanceof("HLo\u0018\u007fD*T`W:StHi@,\n+IiEfAn\t`\u001d\"\u0004bM~O\"hIoOi[[ Lm^%LcgC_wAoX$Vi_uPn\u0000#sN\u00072Cj"));
            }
        }

        public int getM() {
            F2m a;
            return a.if;
        }

        @Override
        public ECFieldElement add(ECFieldElement a) {
            F2m a2;
            CoN coN2 = (CoN)a2.d.clone();
            F2m f2m = (F2m)a;
            coN2.instanceof(f2m.d, 0);
            F2m f2m2 = a2;
            F2m f2m3 = a2;
            return new F2m(f2m2.if, f2m2.H, f2m3.f, f2m3.c, coN2);
        }

        @Override
        public BigInteger toBigInteger() {
            F2m a;
            return a.d.import();
        }

        @Override
        public ECFieldElement sqrt() {
            throw new RuntimeException(ToolUtil.extends("\u0001=3y%.&\u007fc\u001c\u0001kd?+"));
        }

        public int getK3() {
            F2m a;
            return a.c;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public ECFieldElement divide(ECFieldElement eCFieldElement) {
            F2m a;
            void a2;
            ECFieldElement eCFieldElement2 = a2.invert();
            return a.multiply(eCFieldElement2);
        }

        @Override
        public ECFieldElement multiply(ECFieldElement a) {
            F2m a2;
            Object object = (F2m)a;
            object = a2.d.abstract(((F2m)object).d, a2.if);
            int[] nArray = new int[3];
            nArray[0] = a2.H;
            nArray[1] = a2.f;
            nArray[2] = a2.c;
            ((CoN)object).if(a2.if, nArray);
            F2m f2m = a2;
            F2m f2m2 = a2;
            return new F2m(f2m.if, f2m.H, f2m2.f, f2m2.c, (CoN)object);
        }

        @Override
        public int getFieldSize() {
            F2m a;
            return a.if;
        }

        public int getRepresentation() {
            F2m a;
            return a.F;
        }

        public int getK2() {
            F2m a;
            return a.f;
        }

        public int getK1() {
            F2m a;
            return a.H;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class Fp
    extends ECFieldElement {
        BigInteger f;
        BigInteger public;

        @Override
        public ECFieldElement invert() {
            Fp a;
            Fp fp = a;
            return new Fp(fp.public, fp.f.modInverse(a.public));
        }

        @Override
        public int getFieldSize() {
            Fp a;
            return a.public.bitLength();
        }

        @Override
        public ECFieldElement add(ECFieldElement a) {
            Fp a2;
            Fp fp = a2;
            return new Fp(fp.public, fp.f.add(a.toBigInteger()).mod(a2.public));
        }

        @Override
        public BigInteger toBigInteger() {
            Fp a;
            return a.f;
        }

        @Override
        public ECFieldElement square() {
            Fp a;
            Fp fp = a;
            return new Fp(fp.public, fp.f.multiply(a.f).mod(a.public));
        }

        @Override
        public ECFieldElement negate() {
            Fp a;
            Fp fp = a;
            return new Fp(fp.public, fp.f.negate().mod(a.public));
        }

        @Override
        public ECFieldElement sqrt() {
            Fp a;
            if (!a.public.testBit(0)) {
                throw new RuntimeException(ClassKit.static("\u0010&\u0001b\u000b7Qm}\u0013\u000e("));
            }
            if (a.public.testBit(1)) {
                Fp fp = a;
                Fp fp2 = new Fp(fp.public, fp.f.modPow(a.public.shiftRight(2).add(ECConstants.ONE), a.public));
                if (((ECFieldElement)fp2).square().equals(a)) {
                    return fp2;
                }
                return null;
            }
            Fp fp = a;
            BigInteger bigInteger = fp.public.subtract(ECConstants.ONE);
            BigInteger bigInteger2 = bigInteger.shiftRight(1);
            if (!fp.f.modPow(bigInteger2, a.public).equals(ECConstants.ONE)) {
                return null;
            }
            BigInteger bigInteger3 = bigInteger.shiftRight(2).shiftLeft(1).add(ECConstants.ONE);
            BigInteger bigInteger4 = a.f;
            BigInteger bigInteger5 = bigInteger4.shiftLeft(2).mod(a.public);
            Random random = new Random();
            while (true) {
                BigInteger bigInteger6;
                if ((bigInteger6 = new BigInteger(a.public.bitLength(), random)).compareTo(a.public) >= 0) {
                    continue;
                }
                BigInteger bigInteger7 = bigInteger6;
                if (!bigInteger7.multiply(bigInteger7).subtract(bigInteger5).modPow(bigInteger2, a.public).equals(bigInteger)) continue;
                BigInteger[] bigIntegerArray = Fp.new(a.public, bigInteger6, bigInteger4, bigInteger3);
                BigInteger bigInteger8 = bigIntegerArray[0];
                BigInteger bigInteger9 = bigIntegerArray[1];
                if (bigInteger9.multiply(bigInteger9).mod(a.public).equals(bigInteger5)) {
                    if (bigInteger9.testBit(0)) {
                        bigInteger9 = bigInteger9.add(a.public);
                    }
                    bigInteger9 = bigInteger9.shiftRight(1);
                    return new Fp(a.public, bigInteger9);
                }
                if (!bigInteger8.equals(ECConstants.ONE) && !bigInteger8.equals(bigInteger)) break;
            }
            return null;
        }

        public boolean equals(Object a) {
            Fp a2;
            if (a == a2) {
                return true;
            }
            if (!(a instanceof Fp)) {
                return false;
            }
            Fp fp = (Fp)a;
            return a2.public.equals(fp.public) && a2.f.equals(fp.f);
        }

        @Override
        public ECFieldElement subtract(ECFieldElement a) {
            Fp a2;
            Fp fp = a2;
            return new Fp(fp.public, fp.f.subtract(a.toBigInteger()).mod(a2.public));
        }

        private static /* synthetic */ BigInteger[] new(BigInteger a, BigInteger a2, BigInteger a3, BigInteger a4) {
            BigInteger bigInteger = a4;
            int n = bigInteger.bitLength();
            int n2 = bigInteger.getLowestSetBit();
            BigInteger bigInteger2 = ECConstants.ONE;
            BigInteger bigInteger3 = ECConstants.TWO;
            BigInteger bigInteger4 = a2;
            BigInteger bigInteger5 = ECConstants.ONE;
            BigInteger bigInteger6 = ECConstants.ONE;
            int n3 = n = n - 1;
            while (n3 >= n2 + 1) {
                bigInteger5 = bigInteger5.multiply(bigInteger6).mod(a);
                if (a4.testBit(n)) {
                    bigInteger6 = bigInteger5.multiply(a3).mod(a);
                    bigInteger2 = bigInteger2.multiply(bigInteger4).mod(a);
                    BigInteger bigInteger7 = bigInteger4;
                    bigInteger3 = bigInteger7.multiply(bigInteger3).subtract(a2.multiply(bigInteger5)).mod(a);
                    bigInteger4 = bigInteger7.multiply(bigInteger7).subtract(bigInteger6.shiftLeft(1)).mod(a);
                } else {
                    bigInteger6 = bigInteger5;
                    bigInteger2 = bigInteger2.multiply(bigInteger3).subtract(bigInteger5).mod(a);
                    bigInteger4 = bigInteger4.multiply(bigInteger3).subtract(a2.multiply(bigInteger5)).mod(a);
                    BigInteger bigInteger8 = bigInteger3;
                    bigInteger3 = bigInteger8.multiply(bigInteger8).subtract(bigInteger5.shiftLeft(1)).mod(a);
                }
                n3 = --n;
            }
            bigInteger5 = bigInteger5.multiply(bigInteger6).mod(a);
            bigInteger6 = bigInteger5.multiply(a3).mod(a);
            bigInteger2 = bigInteger2.multiply(bigInteger3).subtract(bigInteger5).mod(a);
            BigInteger bigInteger9 = bigInteger5;
            bigInteger3 = bigInteger4.multiply(bigInteger3).subtract(a2.multiply(bigInteger9)).mod(a);
            bigInteger5 = bigInteger9.multiply(bigInteger6).mod(a);
            int n4 = n = 1;
            while (n4 <= n2) {
                bigInteger2 = bigInteger2.multiply(bigInteger3).mod(a);
                BigInteger bigInteger10 = bigInteger3;
                bigInteger3 = bigInteger10.multiply(bigInteger10).subtract(bigInteger5.shiftLeft(1)).mod(a);
                BigInteger bigInteger11 = bigInteger5;
                bigInteger5 = bigInteger11.multiply(bigInteger11).mod(a);
                n4 = ++n;
            }
            BigInteger[] bigIntegerArray = new BigInteger[2];
            bigIntegerArray[0] = bigInteger2;
            bigIntegerArray[1] = bigInteger3;
            return bigIntegerArray;
        }

        @Override
        public ECFieldElement divide(ECFieldElement a) {
            Fp a2;
            Fp fp = a2;
            return new Fp(fp.public, fp.f.multiply(a.toBigInteger().modInverse(a2.public)).mod(a2.public));
        }

        public BigInteger getQ() {
            Fp a;
            return a.public;
        }

        public int hashCode() {
            Fp a;
            return a.public.hashCode() ^ a.f.hashCode();
        }

        @Override
        public String getFieldName() {
            return TypeHelper.instanceof("\u0004x");
        }

        @Override
        public ECFieldElement multiply(ECFieldElement a) {
            Fp a2;
            Fp fp = a2;
            return new Fp(fp.public, fp.f.multiply(a.toBigInteger()).mod(a2.public));
        }

        public Fp(BigInteger a, BigInteger a2) {
            Fp a3;
            a3.f = a2;
            if (a3.f.compareTo(a) >= 0) {
                throw new IllegalArgumentException(ClassKit.static("&I.\u000e1\u001f\u0017e\n&\u0018`\u0013),\u000e\u0012`\u0017'V'\u0017,\u0019&O=Sm0\u000f\u0005("));
            }
            a3.public = a;
        }
    }
}

