/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.core.banner;

import com.jxdinfo.hussar.core.banner.AbstractHussarBanner;
import java.io.InputStream;
import java.util.Formatter;
import java.util.Properties;
import org.springframework.core.env.Environment;

public class HussarApusicBanner
extends AbstractHussarBanner {
    @Override
    protected void injectEnvironmentInfoIntoBanner(Formatter formatter, Environment environment, Class<?> clazz) {
        formatter.format("Apusic Server Version: %s%n", this.getVersion());
        formatter.format("%s%n", LINE_SEPARATOR);
    }

    @Override
    protected boolean check() {
        try {
            this.getClass().getClassLoader().loadClass("com.apusic.ams.util.ServerInfo");
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
        return true;
    }

    public int getOrder() {
        return 5;
    }

    private String getVersion() {
        String string = null;
        Properties properties = new Properties();
        try (InputStream inputStream = this.getClass().getResourceAsStream("/com/apusic/ams/util/ServerInfo.properties");){
            properties.load(inputStream);
            string = properties.getProperty("server.info");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (string == null) {
            string = "Apusic Server ";
        }
        return string;
    }
}

