/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.core.config;

import com.jxdinfo.hussar.core.config.HussarConfig;
import io.undertow.Undertow;
import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.AllowedMethodsHandler;
import io.undertow.server.handlers.DisallowedMethodsHandler;
import io.undertow.util.HttpString;
import java.util.HashSet;
import java.util.List;
import javax.servlet.Servlet;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.web.embedded.undertow.UndertowDeploymentInfoCustomizer;
import org.springframework.boot.web.embedded.undertow.UndertowServletWebServerFactory;
import org.springframework.boot.web.server.WebServerFactoryCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpMethod;
import org.xnio.SslClientAuthMode;

@Configuration(proxyBeanMethods=false)
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
@ConditionalOnClass(value={Servlet.class, Undertow.class, SslClientAuthMode.class})
public class UndertowWebServerFactoryConfig {
    @Autowired
    private HussarConfig hussarConfig;

    @Bean
    @ConditionalOnClass(value={Servlet.class, Undertow.class, SslClientAuthMode.class})
    WebServerFactoryCustomizer<UndertowServletWebServerFactory> acoolyWebServerFactoryCustomizer() {
        return factory -> factory.addDeploymentInfoCustomizers(new UndertowDeploymentInfoCustomizer[]{deploymentInfo -> {
            deploymentInfo.addInitialHandlerChainWrapper(handler -> this.createDisallowedMethodsHandler(handler));
            deploymentInfo.addInitialHandlerChainWrapper(handler -> this.createAllowedMethodsHandler(handler));
        }});
    }

    private HttpHandler createAllowedMethodsHandler(HttpHandler handler) {
        List<String> methodList;
        HashSet<HttpString> allowedHttpMethods = new HashSet<HttpString>();
        allowedHttpMethods.add(HttpString.tryFromString((String)HttpMethod.GET.name()));
        allowedHttpMethods.add(HttpString.tryFromString((String)HttpMethod.POST.name()));
        if (this.hussarConfig != null && (methodList = this.hussarConfig.getAllowHttpMethods()) != null) {
            for (String method : methodList) {
                allowedHttpMethods.add(HttpString.tryFromString((String)method));
            }
        }
        return new AllowedMethodsHandler(handler, allowedHttpMethods);
    }

    private HttpHandler createDisallowedMethodsHandler(HttpHandler handler) {
        HttpString[] disallowedHttpMethods = new HttpString[]{HttpString.tryFromString((String)HttpMethod.TRACE.name())};
        return new DisallowedMethodsHandler(handler, disallowedHttpMethods);
    }
}

