/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.core.config;

import com.jxdinfo.hussar.core.config.HussarConfig;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.servlet.HttpConstraintElement;
import javax.servlet.HttpMethodConstraintElement;
import javax.servlet.Servlet;
import javax.servlet.ServletSecurityElement;
import javax.servlet.annotation.ServletSecurity;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.util.Loader;
import org.eclipse.jetty.webapp.WebAppContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.web.embedded.jetty.JettyServerCustomizer;
import org.springframework.boot.web.embedded.jetty.JettyServletWebServerFactory;
import org.springframework.boot.web.server.WebServerFactoryCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpMethod;

@Configuration(proxyBeanMethods=false)
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
@ConditionalOnClass(value={Servlet.class, Server.class, Loader.class, WebAppContext.class})
public class JettyServletWebServerFactoryConfig {
    @Autowired
    private HussarConfig hussarConfig;

    @Bean
    @ConditionalOnClass(value={Servlet.class, Server.class, Loader.class, WebAppContext.class})
    WebServerFactoryCustomizer<JettyServletWebServerFactory> acoolyWebServerFactoryCustomizer() {
        return factory -> factory.addServerCustomizers(new JettyServerCustomizer[]{server -> {
            List<String> methodList;
            HttpConstraintElement allow = new HttpConstraintElement(ServletSecurity.EmptyRoleSemantic.PERMIT);
            HttpMethodConstraintElement post = new HttpMethodConstraintElement(HttpMethod.POST.name(), allow);
            HttpMethodConstraintElement get = new HttpMethodConstraintElement(HttpMethod.GET.name(), allow);
            HashSet<HttpMethodConstraintElement> methodConstraints = new HashSet<HttpMethodConstraintElement>();
            methodConstraints.add(get);
            methodConstraints.add(post);
            if (this.hussarConfig != null && (methodList = this.hussarConfig.getAllowHttpMethods()) != null) {
                for (String methodName : methodList) {
                    if (!this.checkMethodNames(methodConstraints, methodName)) continue;
                    methodConstraints.add(new HttpMethodConstraintElement(methodName, allow));
                }
            }
            ServletSecurityElement allowSse = new ServletSecurityElement(methodConstraints);
            List allowMappings = ConstraintSecurityHandler.createConstraintsWithMappingsForPath((String)"allow", (String)"/*", (ServletSecurityElement)allowSse);
            ConstraintSecurityHandler csh = new ConstraintSecurityHandler();
            csh.setDenyUncoveredHttpMethods(true);
            csh.setConstraintMappings(allowMappings);
            server.insertHandler((HandlerWrapper)csh);
        }});
    }

    private boolean checkMethodNames(Collection<HttpMethodConstraintElement> methodConstraints, String methodName) {
        for (HttpMethodConstraintElement methodConstraint : methodConstraints) {
            String mName = methodConstraint.getMethodName();
            if (!mName.equals(methodName)) continue;
            return false;
        }
        return true;
    }
}

