/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.core.config;

import com.jxdinfo.hussar.core.util.HussarHttpRequest;
import com.jxdinfo.hussar.core.util.PropertyUtil;
import com.jxdinfo.hussar.core.util.SecurityUtil;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.context.annotation.DependsOn;
import org.springframework.stereotype.Component;

@Component
@ConfigurationProperties(prefix="hussar")
@DependsOn(value={"springContextHolder"})
public class HussarConfig {
    public static final String PREFIX = "hussar";
    @Deprecated
    private String staticVersion = "8.2.1";
    private Boolean swaggerOpen = false;
    private Boolean kaptchaOpen = false;
    private Boolean totpOpen = false;
    private Boolean showPoweredBy = true;
    private int totpOffsetMin = 0;
    private String fileUploadPathWindows = "";
    private String environment = "maven";
    private String fileUploadPathLinux = "";
    private String fileUploadPathMac = "";
    private Boolean fileDateSplit = true;
    private String firewallXssLevel = "B";
    private List<String> xssWhitelist = new ArrayList<String>();
    private List<String> xssBlacklist = new ArrayList<String>();
    private List<String> csrfWhitelist = new ArrayList<String>();
    private List<String> referWhitelist = new ArrayList<String>();
    private Boolean standAlone = true;
    private Boolean indexConfig = false;
    private String defaultIndex = "/default/index";
    private Boolean loginUpperOpen = false;
    private Boolean useSeparation = true;
    private Boolean openOrgservice = false;
    private Boolean checkCsrfOpen = true;
    private Integer remebermeDays = 7;
    private String volServerName = "lb://hussar-license-server";
    private String volServerContextPath = "/";
    private Boolean useVolServer = false;
    private List<String> allowHttpMethods;
    private List<String> ipHeaderNames;
    private Boolean nameIsSet = false;
    private Boolean pathIsSet = false;
    private Boolean initCheck = false;

    public String getFileUploadPath() {
        File file;
        String fileUploadPath = "";
        boolean fileDateSplit = this.getFileDateSplit();
        Properties prop = System.getProperties();
        String os = prop.getProperty("os.name");
        if (os != null && os.toLowerCase().indexOf("linux") > -1) {
            fileUploadPath = this.fileUploadPathLinux;
        } else if (os != null && os.toLowerCase().indexOf("windows") > -1) {
            fileUploadPath = this.fileUploadPathWindows;
        } else if (os != null && os.toLowerCase().indexOf("mac") > -1) {
            fileUploadPath = this.fileUploadPathMac;
        }
        if (ToolUtil.isEmpty(fileUploadPath)) {
            fileUploadPath = ToolUtil.getTempPath();
        }
        if (fileDateSplit) {
            fileUploadPath = fileUploadPath + File.separator + new SimpleDateFormat("yyyy/MM/dd").format(new Date());
        }
        if (!fileUploadPath.endsWith(File.separator)) {
            fileUploadPath = fileUploadPath + File.separator;
        }
        if (!(file = new File(fileUploadPath)).exists()) {
            file.mkdirs();
        }
        return fileUploadPath;
    }

    public String getFirewallXssLevel() {
        return this.firewallXssLevel;
    }

    public void setFirewallXssLevel(String firewallXssLevel) {
        this.firewallXssLevel = firewallXssLevel;
    }

    public List<String> getXssWhitelist() {
        return this.xssWhitelist;
    }

    public void setXssWhitelist(List<String> xssWhitelist) {
        this.xssWhitelist = xssWhitelist;
    }

    public void setFileUploadPathWindows(String fileUploadPathWindows) {
        this.fileUploadPathWindows = fileUploadPathWindows;
    }

    public void setFileUploadPathLinux(String fileUploadPathLinux) {
        this.fileUploadPathLinux = fileUploadPathLinux;
    }

    public String getFileUploadPathMac() {
        return this.fileUploadPathMac;
    }

    public void setFileUploadPathMac(String fileUploadPathMac) {
        this.fileUploadPathMac = fileUploadPathMac;
    }

    public Boolean getKaptchaOpen() {
        return this.kaptchaOpen;
    }

    public void setKaptchaOpen(Boolean kaptchaOpen) {
        this.kaptchaOpen = kaptchaOpen;
    }

    public Boolean getTotpOpen() {
        return this.totpOpen;
    }

    public void setTotpOpen(Boolean totpOpen) {
        this.totpOpen = totpOpen;
    }

    public int getTotpOffsetMin() {
        return this.totpOffsetMin;
    }

    public void setTotpOffsetMin(int totpOffsetMin) {
        this.totpOffsetMin = totpOffsetMin;
    }

    public Boolean getFileDateSplit() {
        return this.fileDateSplit;
    }

    public void setFileDateSplit(Boolean fileDateSplit) {
        this.fileDateSplit = fileDateSplit;
    }

    public Boolean getSwaggerOpen() {
        return this.swaggerOpen;
    }

    public void setSwaggerOpen(Boolean swaggerOpen) {
        this.swaggerOpen = swaggerOpen;
    }

    public boolean isStandAlone() {
        return this.standAlone;
    }

    public void setStandAlone(boolean standAlone) {
        this.standAlone = standAlone;
    }

    public boolean isIndexConfig() {
        return this.indexConfig;
    }

    public void setIndexConfig(boolean indexConfig) {
        this.indexConfig = indexConfig;
    }

    public String getDefaultIndex() {
        return this.defaultIndex;
    }

    public void setDefaultIndex(String defaultIndex) {
        this.defaultIndex = defaultIndex;
    }

    public String getStaticVersion() {
        return this.staticVersion;
    }

    public void setStaticVersion(String staticVersion) {
        this.staticVersion = staticVersion;
    }

    public String getFileUploadPathWindows() {
        return this.fileUploadPathWindows;
    }

    public String getFileUploadPathLinux() {
        return this.fileUploadPathLinux;
    }

    public Boolean getLoginUpperOpen() {
        return this.loginUpperOpen;
    }

    public void setLoginUpperOpen(Boolean loginUpperOpen) {
        this.loginUpperOpen = loginUpperOpen;
    }

    public Boolean getOpenOrgservice() {
        return this.openOrgservice;
    }

    public void setOpenOrgservice(Boolean openOrgservice) {
        this.openOrgservice = openOrgservice;
    }

    public String getEnvironment() {
        Properties prop = System.getProperties();
        String environment = prop.getProperty("hussar.environment");
        if (environment == null || "".equals(environment)) {
            return this.environment;
        }
        return environment;
    }

    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    public List<String> getCsrfWhitelist() {
        return this.csrfWhitelist;
    }

    public void setCsrfWhitelist(List<String> csrfWhitelist) {
        this.csrfWhitelist = csrfWhitelist;
    }

    public List<String> getXssBlacklist() {
        return this.xssBlacklist;
    }

    public void setXssBlacklist(List<String> xssBlacklist) {
        this.xssBlacklist = xssBlacklist;
    }

    public boolean isCheckCsrfOpen() {
        return this.checkCsrfOpen;
    }

    public void setCheckCsrfOpen(boolean checkCsrfOpen) {
        this.checkCsrfOpen = checkCsrfOpen;
    }

    public List<String> getReferWhitelist() {
        return this.referWhitelist;
    }

    public void setReferWhitelist(List<String> referWhitelist) {
        this.referWhitelist = referWhitelist;
    }

    @Deprecated
    public Integer getRemebermeDays() {
        return this.remebermeDays;
    }

    @Deprecated
    public void setRemebermeDays(Integer remebermeDays) {
        this.remebermeDays = remebermeDays;
    }

    public Boolean getUseSeparation() {
        return this.useSeparation;
    }

    public void setUseSeparation(Boolean useSeparation) {
        if (!useSeparation.booleanValue()) {
            throw new RuntimeException("\u5f53\u524d\u7248\u672c\u5df2\u4e0d\u652f\u6301layui\u6a21\u5f0f\uff01\u8bf7\u4f7f\u7528\u524d\u540e\u5206\u79bb\u6a21\u5f0f\uff01");
        }
        this.useSeparation = true;
    }

    public Boolean getUseVolServer() {
        return this.useVolServer;
    }

    public void setUseVolServer(Boolean useVolServer) {
        this.useVolServer = useVolServer;
    }

    public String getVolServerName() {
        return this.volServerName;
    }

    public void setVolServerName(String volServerName) {
        if (StringUtils.startsWith((CharSequence)volServerName, (CharSequence)"lb://")) {
            HussarHttpRequest.volServerId = StringUtils.removeStart((String)volServerName, (String)"lb://");
            try {
                this.getClass().getClassLoader().loadClass("org.springframework.cloud.client.discovery.DiscoveryClient");
            }
            catch (ClassNotFoundException e) {
                System.err.println("\u5355\u4f53\u6a21\u5f0f\u4e0d\u652f\u6301 lb:// \u683c\u5f0f\u7684\u6279\u91cf\u6388\u6743\u670d\u52a1");
            }
            HussarHttpRequest.client = SpringContextHolder.getBean(DiscoveryClient.class);
            PropertyUtil.setSnapMsg("vol", "hussar.vol.server", volServerName);
        } else if (StringUtils.startsWithAny((CharSequence)volServerName, (CharSequence[])new CharSequence[]{"http://", "https://"})) {
            PropertyUtil.setSnapMsg("vol", "hussar.vol.server", volServerName);
        } else {
            SecurityUtil.exitSystem("\u6388\u6743\u670d\u52a1\u5668\u683c\u5f0f\u4e3a\uff1alb://hussar-license-server", true);
        }
        this.volServerName = volServerName;
        this.nameIsSet = true;
        if (!this.initCheck.booleanValue() && this.pathIsSet.booleanValue()) {
            SecurityUtil.getLicenseType();
            this.initCheck = true;
        }
    }

    public List<String> getIpHeaderNames() {
        return this.ipHeaderNames;
    }

    public void setIpHeaderNames(List<String> ipHeaderNames) {
        this.ipHeaderNames = ipHeaderNames;
    }

    public String getVolServerContextPath() {
        return this.volServerContextPath;
    }

    public void setVolServerContextPath(String volServerContextPath) {
        HussarHttpRequest.volServerContextPath = volServerContextPath;
        this.volServerContextPath = volServerContextPath;
        this.pathIsSet = true;
        if (!this.initCheck.booleanValue() && this.nameIsSet.booleanValue()) {
            SecurityUtil.getLicenseType();
            this.initCheck = true;
        }
    }

    public List<String> getAllowHttpMethods() {
        SecurityUtil.isTrial();
        return this.allowHttpMethods;
    }

    public void setAllowHttpMethods(List<String> allowHttpMethods) {
        this.allowHttpMethods = allowHttpMethods;
    }

    public Boolean getShowPoweredBy() {
        return this.showPoweredBy;
    }

    public void setShowPoweredBy(Boolean showPoweredBy) {
        this.showPoweredBy = showPoweredBy;
    }
}

