/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.core.bouncycastle.math.ec;

import com.jxdinfo.hussar.core.auto.common.TypeHelper;
import com.jxdinfo.hussar.core.bouncycastle.asn1.x9.X9IntegerConverter;
import com.jxdinfo.hussar.core.bouncycastle.jce.ProviderConfigurationPermission;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.ECConstants;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.ECCurve;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.ECFieldElement;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.Prn;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.aUX;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.aUx;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.con;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.nuL;
import com.jxdinfo.hussar.core.util.ResKit;
import com.jxdinfo.hussar.encrypt.file.util.StrKit;
import java.math.BigInteger;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class ECPoint {
    ECCurve c;
    ECFieldElement E;
    private static X9IntegerConverter L = new X9IntegerConverter();
    ECFieldElement throws;
    protected boolean withCompression;
    protected con multiplier;
    protected aUx preCompInfo;

    public abstract ECPoint add(ECPoint var1);

    public ECFieldElement getX() {
        ECPoint a;
        return a.E;
    }

    public int hashCode() {
        ECPoint a;
        if (a.isInfinity()) {
            return 0;
        }
        return a.E.hashCode() ^ a.throws.hashCode();
    }

    synchronized void int() {
        ECPoint a;
        if (a.multiplier == null) {
            ECPoint eCPoint = a;
            eCPoint.multiplier = new Prn();
        }
    }

    public abstract byte[] getEncoded();

    public boolean equals(Object a) {
        ECPoint a2;
        if (a == a2) {
            return true;
        }
        if (!(a instanceof ECPoint)) {
            return false;
        }
        a = (ECPoint)a;
        if (a2.isInfinity()) {
            return ((ECPoint)a).isInfinity();
        }
        return a2.E.equals(((ECPoint)a).E) && a2.throws.equals(((ECPoint)a).throws);
    }

    void enum(aUx a) {
        a.preCompInfo = a;
    }

    public ECCurve getCurve() {
        ECPoint a;
        return a.c;
    }

    public ECFieldElement getY() {
        ECPoint a;
        return a.throws;
    }

    protected ECPoint(ECCurve a, ECFieldElement a2, ECFieldElement a3) {
        ECPoint a4;
        ECPoint eCPoint = a4;
        ECPoint eCPoint2 = a4;
        a4.multiplier = null;
        eCPoint2.preCompInfo = null;
        eCPoint2.c = a;
        eCPoint.E = a2;
        eCPoint.throws = a3;
    }

    public ECPoint multiply(BigInteger a) {
        ECPoint a2;
        if (a.signum() < 0) {
            throw new IllegalArgumentException(StrKit.package("mUZ\u001b\u001f\u0003uivk`aPVA^@\u0016KM_[FY\u0010VM\f[TKID]SD"));
        }
        if (a2.isInfinity()) {
            return a2;
        }
        if (a.signum() == 0) {
            return a2.c.getInfinity();
        }
        ECPoint eCPoint = a2;
        eCPoint.int();
        ECPoint eCPoint2 = a2;
        return eCPoint.multiplier.finally(eCPoint2, a, eCPoint2.preCompInfo);
    }

    public boolean isInfinity() {
        ECPoint a;
        return a.E == null && a.throws == null;
    }

    public abstract ECPoint negate();

    public abstract ECPoint twice();

    public abstract ECPoint subtract(ECPoint var1);

    public boolean isCompressed() {
        ECPoint a;
        return a.withCompression;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class F2m
    extends ECPoint {
        public F2m addSimple(F2m a) {
            F2m a2;
            Object object = a;
            if (a2.isInfinity()) {
                return object;
            }
            if (((ECPoint)object).isInfinity()) {
                return a2;
            }
            ECFieldElement.F2m f2m = (ECFieldElement.F2m)((ECPoint)object).getX();
            object = (ECFieldElement.F2m)((ECPoint)object).getY();
            if (a2.E.equals(f2m)) {
                if (a2.throws.equals(object)) {
                    return (F2m)a2.twice();
                }
                return (F2m)a2.c.getInfinity();
            }
            object = (ECFieldElement.F2m)a2.throws.add((ECFieldElement)object).divide(a2.E.add(f2m));
            f2m = (ECFieldElement.F2m)((ECFieldElement.F2m)object).square().add((ECFieldElement)object).add(a2.E).add(f2m).add(a2.c.getA());
            object = (ECFieldElement.F2m)((ECFieldElement.F2m)object).multiply(a2.E.add(f2m)).add(f2m).add(a2.throws);
            return new F2m(a2.c, f2m, (ECFieldElement)object, a2.withCompression);
        }

        private static /* synthetic */ void const(ECPoint a, ECPoint a2) {
            if (!a.c.equals(a2.c)) {
                throw new IllegalArgumentException(TypeHelper.instanceof("*\u0000\u0013\rE\u001e\b\u0005\u001b\n\u0001Y\u0005\u000fC\u001c@FK\u0013\u0006\u0001\u0017Y\r\u0010ZU\u0006H\u0006\u000fF\u0003!-e/29\f\u0006O\u000b\u001aC\u0001\f@]2*WK\u000e\u0004"));
            }
        }

        public F2m(ECCurve a, ECFieldElement a2, ECFieldElement a3) {
            a4(a, a2, a3, false);
            F2m a4;
        }

        @Override
        public byte[] getEncoded() {
            F2m a;
            if (a.isInfinity()) {
                return new byte[1];
            }
            int n = L.getByteLength(a.E);
            byte[] byArray = L.integerToBytes(a.getX().toBigInteger(), n);
            if (a.withCompression) {
                byte[] byArray2 = new byte[n + 1];
                byArray2[0] = 2;
                if (!a.getX().toBigInteger().equals(ECConstants.ZERO) && a.getY().multiply(a.getX().invert()).toBigInteger().testBit(0)) {
                    byArray2[0] = 3;
                }
                System.arraycopy(byArray, 0, byArray2, 1, n);
                return byArray2;
            }
            byte[] byArray3 = L.integerToBytes(a.getY().toBigInteger(), n);
            int n2 = n;
            byte[] byArray4 = new byte[n2 + n2 + 1];
            byArray4[0] = 4;
            System.arraycopy(byArray, 0, byArray4, 1, n);
            System.arraycopy(byArray3, 0, byArray4, n + 1, n);
            return byArray4;
        }

        @Override
        synchronized void int() {
            F2m a;
            if (a.multiplier == null) {
                if (((ECCurve.F2m)a.c).isKoblitz()) {
                    F2m f2m = a;
                    f2m.multiplier = new nuL();
                    return;
                }
                a.multiplier = new aUX();
            }
        }

        public F2m subtractSimple(F2m a) {
            F2m a2;
            if (a.isInfinity()) {
                return a2;
            }
            return a2.addSimple((F2m)a.negate());
        }

        @Override
        public ECPoint negate() {
            F2m a;
            return new F2m(a.c, a.getX(), a.getY().add(a.getX()), a.withCompression);
        }

        @Override
        public ECPoint subtract(ECPoint a) {
            F2m a2;
            F2m f2m = a2;
            F2m.const(f2m, a);
            return f2m.subtractSimple((F2m)a);
        }

        @Override
        public ECPoint twice() {
            F2m a;
            if (a.isInfinity()) {
                return a;
            }
            if (a.E.toBigInteger().signum() == 0) {
                return a.c.getInfinity();
            }
            F2m f2m = a;
            ECFieldElement.F2m f2m2 = (ECFieldElement.F2m)f2m.E.add(f2m.throws.divide(a.E));
            ECFieldElement.F2m f2m3 = (ECFieldElement.F2m)f2m2.square().add(f2m2).add(a.c.getA());
            F2m f2m4 = a;
            ECFieldElement eCFieldElement = f2m4.c.fromBigInteger(ECConstants.ONE);
            eCFieldElement = (ECFieldElement.F2m)f2m4.E.square().add(f2m3.multiply(f2m2.add(eCFieldElement)));
            return new F2m(a.c, f2m3, eCFieldElement, a.withCompression);
        }

        public F2m(ECCurve a, ECFieldElement a2, ECFieldElement a3, boolean a4) {
            F2m a5;
            ECFieldElement eCFieldElement = a2;
            super(a, eCFieldElement, a3);
            if (eCFieldElement != null && a3 == null || a2 == null && a3 != null) {
                throw new IllegalArgumentException(ProviderConfigurationPermission.true("h\u000e\u0007\u0013\u0014QTv)>%c<\u001aL\u000e\u0002\u0018M\u0001\u001eRK1eD]\u001b\u0003JQ\u000e\u0019]\u0004\tJ\t\u0002AQ"));
            }
            if (a2 != null) {
                F2m f2m = a5;
                ECFieldElement.F2m.checkFieldElements(f2m.E, f2m.throws);
                if (a != null) {
                    F2m f2m2 = a5;
                    ECFieldElement.F2m.checkFieldElements(f2m2.E, f2m2.c.getA());
                }
            }
            a5.withCompression = a4;
        }

        @Override
        public ECPoint add(ECPoint a) {
            F2m a2;
            F2m f2m = a2;
            F2m.const(f2m, a);
            return f2m.addSimple((F2m)a);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class Fp
    extends ECPoint {
        @Override
        synchronized void int() {
            Fp a;
            if (a.multiplier == null) {
                Fp fp = a;
                fp.multiplier = new aUX();
            }
        }

        @Override
        public ECPoint add(ECPoint a) {
            Fp a2;
            if (a2.isInfinity()) {
                return a;
            }
            if (a.isInfinity()) {
                return a2;
            }
            if (a2.E.equals(a.E)) {
                if (a2.throws.equals(a.throws)) {
                    return a2.twice();
                }
                return a2.c.getInfinity();
            }
            ECFieldElement eCFieldElement = a.throws.subtract(a2.throws).divide(a.E.subtract(a2.E));
            ECFieldElement eCFieldElement2 = eCFieldElement.square().subtract(a2.E).subtract(a.E);
            ECFieldElement eCFieldElement3 = eCFieldElement.multiply(a2.E.subtract(eCFieldElement2)).subtract(a2.throws);
            return new Fp(a2.c, eCFieldElement2, eCFieldElement3);
        }

        @Override
        public ECPoint twice() {
            Fp a;
            if (a.isInfinity()) {
                return a;
            }
            if (a.throws.toBigInteger().signum() == 0) {
                return a.c.getInfinity();
            }
            Fp fp = a;
            ECFieldElement eCFieldElement = fp.c.fromBigInteger(BigInteger.valueOf(2L));
            ECFieldElement eCFieldElement2 = fp.c.fromBigInteger(BigInteger.valueOf(3L));
            ECFieldElement eCFieldElement3 = fp.E.square().multiply(eCFieldElement2).add(a.c.finally).divide(a.throws.multiply(eCFieldElement));
            eCFieldElement2 = eCFieldElement3.square().subtract(a.E.multiply(eCFieldElement));
            ECFieldElement eCFieldElement4 = eCFieldElement3.multiply(a.E.subtract(eCFieldElement2)).subtract(a.throws);
            return new Fp(a.c, eCFieldElement2, eCFieldElement4, a.withCompression);
        }

        public Fp(ECCurve a, ECFieldElement a2, ECFieldElement a3, boolean a4) {
            Fp a5;
            ECFieldElement eCFieldElement = a2;
            super(a, eCFieldElement, a3);
            if (eCFieldElement != null && a3 == null || a2 == null && a3 != null) {
                throw new IllegalArgumentException(ResKit.default("]%pu.9`yz\"epspz)y>7p3\u0018]\u001f\u0017\rH2v4s\"iliop\u0010G$h"));
            }
            a5.withCompression = a4;
        }

        @Override
        public ECPoint negate() {
            Fp a;
            Fp fp = a;
            return new Fp(fp.c, fp.E, a.throws.negate(), a.withCompression);
        }

        @Override
        public byte[] getEncoded() {
            Fp a;
            if (a.isInfinity()) {
                return new byte[1];
            }
            int n = L.getByteLength(a.E);
            if (a.withCompression) {
                int n2 = a.getY().toBigInteger().testBit(0) ? 3 : 2;
                byte[] byArray = L.integerToBytes(a.getX().toBigInteger(), n);
                byte[] byArray2 = new byte[byArray.length + 1];
                byArray2[0] = n2;
                System.arraycopy(byArray, 0, byArray2, 1, byArray.length);
                return byArray2;
            }
            byte[] byArray = L.integerToBytes(a.getX().toBigInteger(), n);
            byte[] byArray3 = L.integerToBytes(a.getY().toBigInteger(), n);
            byte[] byArray4 = new byte[byArray.length + byArray3.length + 1];
            byArray4[0] = 4;
            System.arraycopy(byArray, 0, byArray4, 1, byArray.length);
            System.arraycopy(byArray3, 0, byArray4, byArray.length + 1, byArray3.length);
            return byArray4;
        }

        public Fp(ECCurve a, ECFieldElement a2, ECFieldElement a3) {
            a4(a, a2, a3, false);
            Fp a4;
        }

        @Override
        public ECPoint subtract(ECPoint a) {
            Fp a2;
            if (a.isInfinity()) {
                return a2;
            }
            return a2.add(a.negate());
        }
    }
}

