/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.core.bouncycastle.math.ec;

import com.jxdinfo.hussar.core.base.tips.Tip;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.CON;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.ECConstants;
import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.core.support.ObjectKit;
import com.jxdinfo.hussar.core.util.SqlUtil;
import java.math.BigInteger;
import java.util.Random;

public abstract class ECFieldElement
implements ECConstants {
    public abstract ECFieldElement negate();

    public abstract int getFieldSize();

    public abstract ECFieldElement square();

    public abstract ECFieldElement divide(ECFieldElement var1);

    public abstract ECFieldElement invert();

    public ECFieldElement() {
        ECFieldElement a;
    }

    public abstract ECFieldElement sqrt();

    public String toString() {
        ECFieldElement a;
        return a.toBigInteger().toString(2);
    }

    public abstract ECFieldElement subtract(ECFieldElement var1);

    public abstract String getFieldName();

    public abstract ECFieldElement multiply(ECFieldElement var1);

    public abstract BigInteger toBigInteger();

    public abstract ECFieldElement add(ECFieldElement var1);

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class F2m
    extends ECFieldElement {
        private int M;
        public static final int TPB = 2;
        public static final int GNB = 1;
        private int m;
        public static final int PPB = 3;
        private int k;
        private int c;
        private int E;
        private int L;
        private CON package;

        @Override
        public BigInteger toBigInteger() {
            F2m a;
            return a.package.short();
        }

        @Override
        public int getFieldSize() {
            F2m a;
            return a.c;
        }

        @Override
        public ECFieldElement square() {
            F2m a;
            F2m f2m = a;
            CON cON2 = f2m.package.assert(f2m.c);
            int[] nArray = new int[3];
            nArray[0] = a.k;
            nArray[1] = a.m;
            nArray[2] = a.E;
            cON2.throw(a.c, nArray);
            F2m f2m2 = a;
            F2m f2m3 = a;
            return new F2m(f2m2.c, f2m2.k, f2m3.m, f2m3.E, cON2);
        }

        @Override
        public ECFieldElement divide(ECFieldElement a) {
            F2m a2;
            ECFieldElement eCFieldElement = a.invert();
            return a2.multiply(eCFieldElement);
        }

        public static void checkFieldElements(ECFieldElement a, ECFieldElement a2) {
            if (!(a instanceof F2m) || !(a2 instanceof F2m)) {
                throw new IllegalArgumentException(ObjectKit.try("U=n1f6,9o4c\"g#/w;8\"5kbi\u001fM\u000fL^H?})c:h9p]M2+\u0018A\u0013c8n2L vq&\u0010U$\u0013gg"));
            }
            F2m f2m = (F2m)a;
            F2m f2m2 = (F2m)a2;
            if (f2m.c != f2m2.c || f2m.k != f2m2.k || f2m.m != f2m2.m || f2m.E != f2m2.E) {
                throw new IllegalArgumentException(HussarException.if("v\u000e\u0016\u0007\u001b^\u000f\u000e\u0013IU\u0001\u000f\u001a]EB*{'28x\u0006\u001b\n\u0016\u0003\u001c\u001a\to4\u0000R\u001b\u0013\u0002S\u001c\u001a\t\u0015^\fG_ <\u0018jU\u001e"));
            }
            if (f2m.M != f2m2.M) {
                throw new IllegalArgumentException(ObjectKit.try("F5aaq=$-n.4*z1g9\"s%0g<h8`pnd,}l4p6,\u0011G\u0016A\u0010U\".5c'+5m\u001eM&y8a!*/g&{)`y-\n@~<:d"));
            }
        }

        @Override
        public ECFieldElement add(ECFieldElement a) {
            F2m a2;
            CON cON2 = (CON)a2.package.clone();
            F2m f2m = (F2m)a;
            cON2.for(f2m.package, 0);
            F2m f2m2 = a2;
            F2m f2m3 = a2;
            return new F2m(f2m2.c, f2m2.k, f2m3.m, f2m3.E, cON2);
        }

        public int hashCode() {
            F2m a;
            return a.package.hashCode() ^ a.c ^ a.k ^ a.m ^ a.E;
        }

        public int getK1() {
            F2m a;
            return a.k;
        }

        public int getK3() {
            F2m a;
            return a.E;
        }

        @Override
        public ECFieldElement subtract(ECFieldElement a) {
            F2m a2;
            return a2.add(a);
        }

        @Override
        public ECFieldElement multiply(ECFieldElement a) {
            F2m a2;
            Object object = (F2m)a;
            object = a2.package.void(((F2m)object).package, a2.c);
            int[] nArray = new int[3];
            nArray[0] = a2.k;
            nArray[1] = a2.m;
            nArray[2] = a2.E;
            ((CON)object).throw(a2.c, nArray);
            F2m f2m = a2;
            F2m f2m2 = a2;
            return new F2m(f2m.c, f2m.k, f2m2.m, f2m2.E, (CON)object);
        }

        public F2m(int a, int a2, BigInteger a3) {
            a4(a, a2, 0, 0, a3);
            F2m a4;
        }

        @Override
        public ECFieldElement invert() {
            F2m a;
            CON cON2 = (CON)a.package.clone();
            CON cON3 = new CON(a.L);
            F2m f2m = a;
            CON cON4 = cON3;
            cON4.if(a.c);
            cON4.if(0);
            cON3.if(f2m.k);
            if (f2m.M == 3) {
                CON cON5 = cON3;
                cON5.if(a.m);
                cON5.if(a.E);
            }
            CON cON6 = new CON(a.L);
            cON6.if(0);
            CON cON7 = new CON(a.L);
            CON cON8 = cON2;
            while (!cON8.abstract()) {
                int n = cON2.synchronized() - cON3.synchronized();
                if (n < 0) {
                    CON cON9 = cON2;
                    cON2 = cON3;
                    cON3 = cON9;
                    CON cON10 = cON6;
                    cON6 = cON7;
                    cON7 = cON10;
                    n = -n;
                }
                int n2 = n >> 5;
                CON cON11 = cON3.try(n &= 0x1F);
                CON cON12 = cON2;
                cON8 = cON12;
                cON12.for(cON11, n2);
                CON cON13 = cON7.try(n);
                cON6.for(cON13, n2);
            }
            F2m f2m2 = a;
            F2m f2m3 = a;
            return new F2m(f2m2.c, f2m2.k, f2m3.m, f2m3.E, cON7);
        }

        @Override
        public ECFieldElement negate() {
            F2m a;
            return a;
        }

        public int getM() {
            F2m a;
            return a.c;
        }

        public boolean equals(Object a) {
            F2m a2;
            if (a == a2) {
                return true;
            }
            if (!(a instanceof F2m)) {
                return false;
            }
            F2m f2m = (F2m)a;
            return a2.c == f2m.c && a2.k == f2m.k && a2.m == f2m.m && a2.E == f2m.E && a2.M == f2m.M && a2.package.equals(f2m.package);
        }

        private /* synthetic */ F2m(int a, int a2, int a3, int a4, CON a5) {
            F2m a6;
            F2m f2m = a6;
            F2m f2m2 = a6;
            F2m f2m3 = a6;
            f2m3.L = a + 31 >> 5;
            f2m3.package = a5;
            f2m2.c = a;
            f2m2.k = a2;
            f2m.m = a3;
            f2m.E = a4;
            if (a3 == 0 && a4 == 0) {
                a6.M = 2;
                return;
            }
            a6.M = 3;
        }

        public int getRepresentation() {
            F2m a;
            return a.M;
        }

        @Override
        public String getFieldName() {
            return HussarException.if("jU\u001e");
        }

        public F2m(int a, int a2, int a3, int a4, BigInteger a5) {
            BigInteger bigInteger;
            F2m a6;
            a6.L = a + 31 >> 5;
            F2m f2m = a6;
            a6.package = new CON(a5, a6.L);
            if (a3 == 0 && a4 == 0) {
                bigInteger = a5;
                a6.M = 2;
            } else {
                if (a3 >= a4) {
                    throw new IllegalArgumentException(ObjectKit.try("?9|n\bQ +?guy0c:e)a<7\u0016@du>9"));
                }
                if (a3 <= 0) {
                    throw new IllegalArgumentException(HussarException.if("\u0005Ho6\u0013\u0001\u001b[\u0005\u0016O\u0017\u0005\u0002\u0019\u000f\\\u001a80YBGC"));
                }
                a6.M = 3;
                bigInteger = a5;
            }
            if (bigInteger.signum() < 0) {
                throw new IllegalArgumentException(ObjectKit.try(",+*b\u0011W1+>c;d2vvk)3r&\u0019@~<#o"));
            }
            F2m f2m2 = a6;
            a6.c = a;
            f2m2.k = a2;
            f2m2.m = a3;
            a6.E = a4;
        }

        @Override
        public ECFieldElement sqrt() {
            throw new RuntimeException(HussarException.if("=\u0000\u000fD\u0019\u0013\u001aB_!=VX\u0002\u0017"));
        }

        public int getK2() {
            F2m a;
            return a.m;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class Fp
    extends ECFieldElement {
        BigInteger L;
        BigInteger final;

        public int hashCode() {
            Fp a;
            return a.final.hashCode() ^ a.L.hashCode();
        }

        public Fp(BigInteger a, BigInteger a2) {
            Fp a3;
            a3.L = a2;
            if (a3.L.compareTo(a) >= 0) {
                throw new IllegalArgumentException(SqlUtil.int("a$icvrP\bMK_\rTDkcU\rPJ\u0011JPA^K\bP\u0014\u0000wbBE"));
            }
            a3.final = a;
        }

        @Override
        public ECFieldElement negate() {
            Fp a;
            Fp fp = a;
            return new Fp(fp.final, fp.L.negate().mod(a.final));
        }

        public boolean equals(Object a) {
            Fp a2;
            if (a == a2) {
                return true;
            }
            if (!(a instanceof Fp)) {
                return false;
            }
            Fp fp = (Fp)a;
            return a2.final.equals(fp.final) && a2.L.equals(fp.L);
        }

        @Override
        public int getFieldSize() {
            Fp a;
            return a.final.bitLength();
        }

        @Override
        public ECFieldElement subtract(ECFieldElement a) {
            Fp a2;
            Fp fp = a2;
            return new Fp(fp.final, fp.L.subtract(a.toBigInteger()).mod(a2.final));
        }

        @Override
        public ECFieldElement square() {
            Fp a;
            Fp fp = a;
            return new Fp(fp.final, fp.L.multiply(a.L).mod(a.final));
        }

        @Override
        public ECFieldElement divide(ECFieldElement a) {
            Fp a2;
            Fp fp = a2;
            return new Fp(fp.final, fp.L.multiply(a.toBigInteger().modInverse(a2.final)).mod(a2.final));
        }

        @Override
        public ECFieldElement sqrt() {
            Fp a;
            if (!a.final.testBit(0)) {
                throw new RuntimeException(SqlUtil.int("WKF\u000fLZ\u0016\u0000:~IE"));
            }
            if (a.final.testBit(1)) {
                Fp fp = a;
                Fp fp2 = new Fp(fp.final, fp.L.modPow(a.final.shiftRight(2).add(ECConstants.ONE), a.final));
                if (((ECFieldElement)fp2).square().equals(a)) {
                    return fp2;
                }
                return null;
            }
            Fp fp = a;
            BigInteger bigInteger = fp.final.subtract(ECConstants.ONE);
            BigInteger bigInteger2 = bigInteger.shiftRight(1);
            if (!fp.L.modPow(bigInteger2, a.final).equals(ECConstants.ONE)) {
                return null;
            }
            BigInteger bigInteger3 = bigInteger.shiftRight(2).shiftLeft(1).add(ECConstants.ONE);
            BigInteger bigInteger4 = a.L;
            BigInteger bigInteger5 = bigInteger4.shiftLeft(2).mod(a.final);
            Random random = new Random();
            while (true) {
                BigInteger bigInteger6;
                if ((bigInteger6 = new BigInteger(a.final.bitLength(), random)).compareTo(a.final) >= 0) {
                    continue;
                }
                BigInteger bigInteger7 = bigInteger6;
                if (!bigInteger7.multiply(bigInteger7).subtract(bigInteger5).modPow(bigInteger2, a.final).equals(bigInteger)) continue;
                BigInteger[] bigIntegerArray = Fp.instanceof(a.final, bigInteger6, bigInteger4, bigInteger3);
                BigInteger bigInteger8 = bigIntegerArray[0];
                BigInteger bigInteger9 = bigIntegerArray[1];
                if (bigInteger9.multiply(bigInteger9).mod(a.final).equals(bigInteger5)) {
                    if (bigInteger9.testBit(0)) {
                        bigInteger9 = bigInteger9.add(a.final);
                    }
                    bigInteger9 = bigInteger9.shiftRight(1);
                    return new Fp(a.final, bigInteger9);
                }
                if (!bigInteger8.equals(ECConstants.ONE) && !bigInteger8.equals(bigInteger)) break;
            }
            return null;
        }

        public BigInteger getQ() {
            Fp a;
            return a.final;
        }

        @Override
        public ECFieldElement multiply(ECFieldElement a) {
            Fp a2;
            Fp fp = a2;
            return new Fp(fp.final, fp.L.multiply(a.toBigInteger()).mod(a2.final));
        }

        @Override
        public ECFieldElement invert() {
            Fp a;
            Fp fp = a;
            return new Fp(fp.final, fp.L.modInverse(a.final));
        }

        private static /* synthetic */ BigInteger[] instanceof(BigInteger a, BigInteger a2, BigInteger a3, BigInteger a4) {
            BigInteger bigInteger = a4;
            int n = bigInteger.bitLength();
            int n2 = bigInteger.getLowestSetBit();
            BigInteger bigInteger2 = ECConstants.ONE;
            BigInteger bigInteger3 = ECConstants.TWO;
            BigInteger bigInteger4 = a2;
            BigInteger bigInteger5 = ECConstants.ONE;
            BigInteger bigInteger6 = ECConstants.ONE;
            int n3 = n = n - 1;
            while (n3 >= n2 + 1) {
                bigInteger5 = bigInteger5.multiply(bigInteger6).mod(a);
                if (a4.testBit(n)) {
                    bigInteger6 = bigInteger5.multiply(a3).mod(a);
                    bigInteger2 = bigInteger2.multiply(bigInteger4).mod(a);
                    BigInteger bigInteger7 = bigInteger4;
                    bigInteger3 = bigInteger7.multiply(bigInteger3).subtract(a2.multiply(bigInteger5)).mod(a);
                    bigInteger4 = bigInteger7.multiply(bigInteger7).subtract(bigInteger6.shiftLeft(1)).mod(a);
                } else {
                    bigInteger6 = bigInteger5;
                    bigInteger2 = bigInteger2.multiply(bigInteger3).subtract(bigInteger5).mod(a);
                    bigInteger4 = bigInteger4.multiply(bigInteger3).subtract(a2.multiply(bigInteger5)).mod(a);
                    BigInteger bigInteger8 = bigInteger3;
                    bigInteger3 = bigInteger8.multiply(bigInteger8).subtract(bigInteger5.shiftLeft(1)).mod(a);
                }
                n3 = --n;
            }
            bigInteger5 = bigInteger5.multiply(bigInteger6).mod(a);
            bigInteger6 = bigInteger5.multiply(a3).mod(a);
            bigInteger2 = bigInteger2.multiply(bigInteger3).subtract(bigInteger5).mod(a);
            BigInteger bigInteger9 = bigInteger5;
            bigInteger3 = bigInteger4.multiply(bigInteger3).subtract(a2.multiply(bigInteger9)).mod(a);
            bigInteger5 = bigInteger9.multiply(bigInteger6).mod(a);
            int n4 = n = 1;
            while (n4 <= n2) {
                bigInteger2 = bigInteger2.multiply(bigInteger3).mod(a);
                BigInteger bigInteger10 = bigInteger3;
                bigInteger3 = bigInteger10.multiply(bigInteger10).subtract(bigInteger5.shiftLeft(1)).mod(a);
                BigInteger bigInteger11 = bigInteger5;
                bigInteger5 = bigInteger11.multiply(bigInteger11).mod(a);
                n4 = ++n;
            }
            BigInteger[] bigIntegerArray = new BigInteger[2];
            bigIntegerArray[0] = bigInteger2;
            bigIntegerArray[1] = bigInteger3;
            return bigIntegerArray;
        }

        @Override
        public String getFieldName() {
            return Tip.public("?\u0012");
        }

        @Override
        public BigInteger toBigInteger() {
            Fp a;
            return a.L;
        }

        @Override
        public ECFieldElement add(ECFieldElement a) {
            Fp a2;
            Fp fp = a2;
            return new Fp(fp.final, fp.L.add(a.toBigInteger()).mod(a2.final));
        }
    }
}

