/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.core.bouncycastle.asn1.x509;

import com.jxdinfo.hussar.core.bouncycastle.asn1.ASN1Encodable;
import com.jxdinfo.hussar.core.bouncycastle.asn1.ASN1EncodableVector;
import com.jxdinfo.hussar.core.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.jxdinfo.hussar.core.bouncycastle.asn1.ASN1Sequence;
import com.jxdinfo.hussar.core.bouncycastle.asn1.ASN1TaggedObject;
import com.jxdinfo.hussar.core.bouncycastle.asn1.DEREncodable;
import com.jxdinfo.hussar.core.bouncycastle.asn1.DERNull;
import com.jxdinfo.hussar.core.bouncycastle.asn1.DERObject;
import com.jxdinfo.hussar.core.bouncycastle.asn1.DERObjectIdentifier;
import com.jxdinfo.hussar.core.bouncycastle.asn1.DERSequence;
import com.jxdinfo.hussar.core.util.LicenseModuleBody;
import com.jxdinfo.hussar.core.util.ToolUtil;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class AlgorithmIdentifier
extends ASN1Encodable {
    private DERObjectIdentifier E;
    private DEREncodable L;
    private boolean extends;

    public ASN1ObjectIdentifier getAlgorithm() {
        AlgorithmIdentifier a;
        return new ASN1ObjectIdentifier(a.E.getId());
    }

    public AlgorithmIdentifier(DERObjectIdentifier a) {
        AlgorithmIdentifier a2;
        AlgorithmIdentifier algorithmIdentifier = a2;
        algorithmIdentifier.extends = false;
        algorithmIdentifier.E = a;
    }

    @Override
    public DERObject toASN1Object() {
        AlgorithmIdentifier a;
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        AlgorithmIdentifier algorithmIdentifier = a;
        aSN1EncodableVector.add(algorithmIdentifier.E);
        if (algorithmIdentifier.extends) {
            if (a.L != null) {
                aSN1EncodableVector.add(a.L);
            } else {
                aSN1EncodableVector.add(DERNull.INSTANCE);
            }
        }
        return new DERSequence(aSN1EncodableVector);
    }

    public AlgorithmIdentifier(DERObjectIdentifier a, DEREncodable a2) {
        AlgorithmIdentifier a3;
        AlgorithmIdentifier algorithmIdentifier = a3;
        AlgorithmIdentifier algorithmIdentifier2 = a3;
        algorithmIdentifier2.extends = false;
        algorithmIdentifier2.extends = true;
        algorithmIdentifier.E = a;
        algorithmIdentifier.L = a2;
    }

    public DERObjectIdentifier getObjectId() {
        AlgorithmIdentifier a;
        return a.E;
    }

    public AlgorithmIdentifier(ASN1Sequence a) {
        AlgorithmIdentifier a2;
        a2.extends = false;
        if (a.size() < 1 || a.size() > 2) {
            throw new IllegalArgumentException(new StringBuilder().insert(0, ToolUtil.int("\\\u001euSn\u0001{_!\u0011r\u001d6\fx\u0018i\u0012f")).append(a.size()).toString());
        }
        a2.E = DERObjectIdentifier.getInstance(a.getObjectAt(0));
        if (a.size() == 2) {
            AlgorithmIdentifier algorithmIdentifier = a2;
            algorithmIdentifier.extends = true;
            algorithmIdentifier.L = a.getObjectAt(1);
            return;
        }
        a2.L = null;
    }

    public static AlgorithmIdentifier getInstance(Object a) {
        if (a == null || a instanceof AlgorithmIdentifier) {
            return (AlgorithmIdentifier)a;
        }
        if (a instanceof DERObjectIdentifier) {
            return new AlgorithmIdentifier((DERObjectIdentifier)a);
        }
        if (a instanceof String) {
            return new AlgorithmIdentifier((String)a);
        }
        if (a instanceof ASN1Sequence) {
            return new AlgorithmIdentifier((ASN1Sequence)a);
        }
        throw new IllegalArgumentException(new StringBuilder().insert(0, LicenseModuleBody.synchronized("'z$f<z8\t\u001df5`=zu}!)4g>}=w'(i")).append(a.getClass().getName()).toString());
    }

    public AlgorithmIdentifier(String a) {
        AlgorithmIdentifier a2;
        a2.extends = false;
        AlgorithmIdentifier algorithmIdentifier = a2;
        a2.E = new DERObjectIdentifier(a);
    }

    public static AlgorithmIdentifier getInstance(ASN1TaggedObject a, boolean a2) {
        return AlgorithmIdentifier.getInstance(ASN1Sequence.getInstance(a, a2));
    }

    public DEREncodable getParameters() {
        AlgorithmIdentifier a;
        return a.L;
    }
}

