/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.core.banner;

import com.jxdinfo.hussar.core.banner.AbstractHussarBanner;
import java.io.InputStream;
import java.util.Formatter;
import java.util.Properties;
import org.springframework.core.env.Environment;

public class HussarTongWebBanner
extends AbstractHussarBanner {
    @Override
    protected void injectEnvironmentInfoIntoBanner(Formatter formatter, Environment environment, Class<?> sourceClass) {
        formatter.format("TongWeb Version: %s%n", this.getVersion());
        formatter.format("%s%n", LINE_SEPARATOR);
    }

    @Override
    protected boolean check() {
        try {
            this.getClass().getClassLoader().loadClass("com.tongweb.container.util.ServerInfo");
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        return true;
    }

    public int getOrder() {
        return 4;
    }

    private String getVersion() {
        String info = null;
        try {
            Properties props = new Properties();
            InputStream is = this.getClass().getResourceAsStream("/com/tongweb/container/util/ServerInfo.properties");
            props.load(is);
            info = props.getProperty("server.info");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (info == null || info.equals("PRODUCT_VERSION")) {
            info = "TongWeb/7.0.0";
        }
        return info;
    }
}

