/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.base.config.baseconfig.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.jxdinfo.hussar.base.config.baseconfig.model.SysBaseConfig;
import com.jxdinfo.hussar.base.config.baseconfig.service.ISysBaseConfigService;
import com.jxdinfo.hussar.platform.core.annotation.Inner;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.support.mp.base.controller.HussarBaseController;
import com.jxdinfo.hussar.support.security.core.annotation.CheckPermission;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/sysBaseConfigFront"})
@Api(tags={"\u8fd0\u884c\u53c2\u6570\u914d\u7f6e"})
public class SysBaseConfigFrontController
extends HussarBaseController<SysBaseConfig, ISysBaseConfigService> {
    private ISysBaseConfigService sysBaseConfigService;

    @Autowired
    public SysBaseConfigFrontController(ISysBaseConfigService sysBaseConfigService) {
        this.sysBaseConfigService = sysBaseConfigService;
    }

    @ApiOperation(value="\u83b7\u53d6\u8fd0\u884c\u53c2\u6570\u5217\u8868", notes="\u5206\u9875\u83b7\u53d6\u8fd0\u884c\u53c2\u6570\u5217\u8868")
    @GetMapping(value={"/getList"})
    @AuditLog(moduleName="\u8fd0\u884c\u53c2\u6570\u914d\u7f6e", eventDesc="\u83b7\u53d6\u8fd0\u884c\u53c2\u6570\u5217\u8868", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @ApiOperationSupport(ignoreParameters={"records", "orders", "total", "optimizeCountSql", "searchCount", "optimizeJoinOfCountSql", "countId", "maxLimit", "pages"})
    public ApiResponse<IPage<SysBaseConfig>> list(@ApiParam(value="\u5206\u9875\u4fe1\u606f") Page page, @ApiParam(value="\u914d\u7f6e\u9879\u5b9e\u4f53") SysBaseConfig sysBaseConfig) {
        return this.sysBaseConfigService.queryList(page, sysBaseConfig);
    }

    @ApiOperation(value="\u4fee\u6539\u8fd0\u884c\u53c2\u6570", notes="\u4fee\u6539\u914d\u7f6e\u9879\u4e0b\u7684\u8fd0\u884c\u53c2\u6570")
    @PostMapping(value={"/update"})
    @CheckPermission(value={"sysBaseConfigFront:update"})
    @CacheEvict(value={"base_config"}, allEntries=true)
    @AuditLog(moduleName="\u8fd0\u884c\u53c2\u6570\u914d\u7f6e", eventDesc="\u4fee\u6539\u8fd0\u884c\u53c2\u6570", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse update(@ApiParam(value="\u8fd0\u884c\u53c2\u6570\u96c6\u5408") @RequestBody List<SysBaseConfig> baseConfigList) {
        return this.sysBaseConfigService.updateBatchBaseConfig(baseConfigList);
    }

    @ApiOperation(value="\u83b7\u53d6\u914d\u7f6e\u9879\u4e0b\u7684\u8fd0\u884c\u53c2\u6570", notes="\u83b7\u53d6\u914d\u7f6e\u9879\u4e0b\u7684\u6240\u6709\u8fd0\u884c\u53c2\u6570")
    @GetMapping(value={"/configList"})
    @CheckPermission(value={"sysBaseConfigFront:configList"})
    @AuditLog(moduleName="\u8fd0\u884c\u53c2\u6570\u914d\u7f6e", eventDesc="\u83b7\u53d6\u914d\u7f6e\u9879\u4e0b\u7684\u8fd0\u884c\u53c2\u6570", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<SysBaseConfig>> configList(@ApiParam(value="\u914d\u7f6e\u9879id") @RequestParam String sysBaseConfigId) {
        return this.sysBaseConfigService.queryBaseConfigListByParentId(sysBaseConfigId);
    }

    @ApiOperation(value="\u83b7\u53d6\u767b\u5f55\u9875/\u6b22\u8fce\u9875\u53ef\u89c6\u5316\u914d\u7f6e\u4fe1\u606f", notes="\u83b7\u53d6\u767b\u5f55\u9875/\u6b22\u8fce\u9875\u53ef\u89c6\u5316\u914d\u7f6e\u4fe1\u606f")
    @GetMapping(value={"/viewList"})
    @AuditLog(moduleName="\u8fd0\u884c\u53c2\u6570\u914d\u7f6e", eventDesc="\u83b7\u53d6\u767b\u5f55\u9875/\u6b22\u8fce\u9875\u53ef\u89c6\u5316\u914d\u7f6e\u4fe1\u606f", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<Map<String, Object>> viewList(@ApiParam(value="\u4e2a\u6027\u5316\u914d\u7f6e\u7c7b\u578b") @RequestParam String personalizedType) {
        return this.sysBaseConfigService.queryPersonalBaseConfigList(personalizedType);
    }

    @ApiOperation(value="\u4fee\u6539\u767b\u5f55\u9875/\u6b22\u8fce\u9875\u53ef\u89c6\u5316\u914d\u7f6e\u4fe1\u606f", notes="\u4fee\u6539\u767b\u5f55\u9875/\u6b22\u8fce\u9875\u53ef\u89c6\u5316\u914d\u7f6e\u4fe1\u606f")
    @PostMapping(value={"/viewUpdate"})
    @CacheEvict(value={"base_config"}, allEntries=true)
    @AuditLog(moduleName="\u8fd0\u884c\u53c2\u6570\u914d\u7f6e", eventDesc="\u4fee\u6539\u767b\u5f55\u9875/\u6b22\u8fce\u9875\u53ef\u89c6\u5316\u914d\u7f6e\u4fe1\u606f", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    @CheckPermission(value={"sysBaseConfigFront:viewUpdate"})
    public ApiResponse viewUpdate(@ApiParam(value="\u767b\u5f55\u9875/\u6b22\u8fce\u9875\u914d\u7f6e\u4fe1\u606f\u96c6\u5408") @RequestBody List<SysBaseConfig> baseConfigList) {
        return this.sysBaseConfigService.updateBatchPersonalBaseConfig(baseConfigList);
    }

    @ApiOperation(value="\u4e0a\u4f20\u56fe\u7247", notes="\u4e0a\u4f20\u56fe\u7247")
    @PostMapping(value={"/getImageUrl"}, headers={"content-type=multipart/*"})
    @AuditLog(moduleName="\u8fd0\u884c\u53c2\u6570\u914d\u7f6e", eventDesc="\u4e0a\u4f20\u56fe\u7247", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<Long> imageUtils(@ApiParam(value="\u4e0a\u4f20\u7684\u56fe\u7247") @RequestParam(value="file") MultipartFile file) throws IOException {
        return this.sysBaseConfigService.uploadImage(file);
    }

    @ApiOperation(value="\u663e\u793a\u56fe\u7247", notes="\u663e\u793a\u56fe\u7247")
    @GetMapping(value={"/showPicture"})
    @Inner
    public void showImage(@ApiParam(value="\u6587\u4ef6id") @RequestParam Long id, HttpServletResponse response) {
        this.sysBaseConfigService.showImage(id, response);
    }

    @ApiOperation(value="\u767b\u5f55\u52a8\u6001\u5bc6\u7801\u662f\u5426\u5f00\u542f", notes="\u767b\u5f55\u52a8\u6001\u5bc6\u7801\u662f\u5426\u5f00\u542f")
    @GetMapping(value={"/getTotpOpen"})
    @CheckPermission(value={"sysBaseConfigFront:getTotpOpen"})
    @AuditLog(moduleName="\u8fd0\u884c\u53c2\u6570\u914d\u7f6e", eventDesc="\u767b\u5f55\u52a8\u6001\u5bc6\u7801\u662f\u5426\u5f00\u542f", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<Integer> getTotpOpen() {
        return this.sysBaseConfigService.getTotpOpen();
    }
}

