/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.base.config.welcome.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.base.config.baseconfig.service.IHussarLoginConfigService;
import com.jxdinfo.hussar.base.config.enums.BaseConfigEnum;
import com.jxdinfo.hussar.base.config.welcome.dao.SysWelcomeMapper;
import com.jxdinfo.hussar.base.config.welcome.dto.SysWelcomeDto;
import com.jxdinfo.hussar.base.config.welcome.model.SysWelcome;
import com.jxdinfo.hussar.base.config.welcome.service.ISysWelcomeService;
import com.jxdinfo.hussar.base.config.welcome.vo.SysWelcomeVo;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.core.config.HussarConfig;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class SysWelcomeServiceImpl
extends HussarServiceImpl<SysWelcomeMapper, SysWelcome>
implements ISysWelcomeService {
    @Resource
    private SysWelcomeMapper sysWelcomeMapper;
    @Resource
    private IHussarLoginConfigService hussarLoginConfigService;
    @Resource
    private HussarConfig hussarConfig;

    @HussarTransactional
    public ApiResponse saveRoleDataVue(SysWelcomeDto sysWelcomeDto) {
        if (ToolUtil.isEmpty((Object)sysWelcomeDto)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)BaseConfigEnum.BASE_CONFIG_ENTITY_NEW_USER_WELCOME_EMPTY.getValue()));
        }
        List<String> list = Arrays.asList(sysWelcomeDto.getUserId().split(","));
        ArrayList idList = new ArrayList();
        list.forEach(id -> idList.add(Long.valueOf(id)));
        ArrayList<SysWelcome> listOfSysWelcome = new ArrayList<SysWelcome>();
        String result = this.insertCheckVue(idList, "");
        if (!"".equals(result)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)BaseConfigEnum.BASE_CONFIG_CONFLICT_BETWEEN_ROLE_AND_USER.getValue()));
        }
        for (String s : list) {
            SysWelcome sysWelcome1 = new SysWelcome();
            sysWelcome1.setId(Long.valueOf(s));
            sysWelcome1.setWelcomeUrl(sysWelcomeDto.getWelcomeUrl());
            sysWelcome1.setTypes(sysWelcomeDto.getTypes());
            listOfSysWelcome.add(sysWelcome1);
        }
        if (!this.saveBatch(listOfSysWelcome, listOfSysWelcome.size())) {
            throw new BaseException(TranslateUtil.getTranslateName((String)BaseConfigEnum.BASE_CONFIG_SAVE_FAIL.getValue()));
        }
        return ApiResponse.success((String)TranslateUtil.getTranslateName((String)BaseConfigEnum.BASE_CONFIG_SAVE_SUCCESS.getValue()));
    }

    public Map<String, Object> queryList(Page page, SysWelcome sysWelcome) {
        if (ToolUtil.isEmpty((Object)page)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)BaseConfigEnum.BASE_CONFIG_PAGING_INFO_EMPTY.getValue()));
        }
        List<SysWelcomeVo> list = this.sysWelcomeMapper.getWelcomeList();
        ArrayList<SysWelcomeVo> newList = new ArrayList<SysWelcomeVo>();
        ArrayList<SysWelcomeVo> listZero = new ArrayList<SysWelcomeVo>();
        ArrayList<SysWelcomeVo> listOne = new ArrayList<SysWelcomeVo>();
        for (SysWelcomeVo s : list) {
            if ("1".equals(s.getTypes())) {
                listOne.add(s);
                continue;
            }
            listZero.add(s);
        }
        newList.addAll(this.returnMap(listZero));
        newList.addAll(this.returnMap(listOne));
        HashMap<String, Object> result = new HashMap<String, Object>(4);
        result.put("count", newList.size());
        result.put("data", newList.stream().skip((page.getCurrent() - 1L) * page.getSize()).limit(page.getSize()).collect(Collectors.toList()));
        return result;
    }

    public ApiResponse deleteWelcome(String ids) {
        if (ToolUtil.isEmpty((Object)ids)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)BaseConfigEnum.BASE_CONFIG_DEL_IDS_EMPTY.getValue()));
        }
        List<String> list = Arrays.asList(ids.split(","));
        LambdaQueryWrapper ew = new LambdaQueryWrapper();
        ew.in(ToolUtil.isNotEmpty(list), SysWelcome::getId, list);
        this.remove((Wrapper)ew);
        return ApiResponse.success((String)TranslateUtil.getTranslateName((String)BaseConfigEnum.BASE_CONFIG_DELETE_SUCCESS.getValue()));
    }

    public String getUserIndex(List<Long> roleList) {
        if (!this.hussarConfig.isIndexConfig()) {
            return this.hussarConfig.getDefaultIndex();
        }
        List<SysWelcome> sysWelcomeList = this.sysWelcomeMapper.getUserIndex(roleList);
        if (ToolUtil.isNotEmpty(sysWelcomeList)) {
            for (SysWelcome sysWelcome : sysWelcomeList) {
                if (!"2".equals(sysWelcome.getTypes())) continue;
                return sysWelcome.getWelcomeUrl();
            }
            return sysWelcomeList.get(0).getWelcomeUrl();
        }
        return this.hussarConfig.getDefaultIndex();
    }

    public SysWelcome selectByUrl(String sysWelcomeUrl, String types) {
        if (ToolUtil.isEmpty((Object)sysWelcomeUrl) || ToolUtil.isEmpty((Object)types)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)BaseConfigEnum.BASE_CONFIG_WELCOME_PAGE_ADDRESS_AND_TYPE_EMPTY.getValue()));
        }
        List<SysWelcomeVo> list = this.sysWelcomeMapper.selectByUrl(sysWelcomeUrl, types);
        list = this.returnMap(list);
        return (SysWelcome)list.get(0);
    }

    @HussarTransactional
    public ApiResponse updateDataVue(SysWelcomeDto sysWelcomeDto) {
        if (ToolUtil.isEmpty((Object)sysWelcomeDto)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)BaseConfigEnum.BASE_CONFIG_MODIFY_USER_WELCOME_EMPTY.getValue()));
        }
        SysWelcome sysWelcome = new SysWelcome();
        BeanUtils.copyProperties((Object)sysWelcomeDto, (Object)sysWelcome);
        String userIds = sysWelcomeDto.getUserId();
        ArrayList idList = new ArrayList();
        List<String> idStrList = Arrays.asList(userIds.split(","));
        idStrList.forEach(id -> idList.add(Long.valueOf(id)));
        String result = this.insertCheckVue(idList, sysWelcomeDto.getOldUrl());
        if (!"".equals(result)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)BaseConfigEnum.BASE_CONFIG_CONFLICT_BETWEEN_ROLE_AND_USER.getValue()));
        }
        String url = sysWelcome.getWelcomeUrl();
        LambdaQueryWrapper ew = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)ew.eq(SysWelcome::getTypes, (Object)sysWelcome.getTypes())).eq(SysWelcome::getWelcomeUrl, (Object)sysWelcomeDto.getOldUrl());
        this.remove((Wrapper)ew);
        this.sysWelcomeMapper.deleteBatchIds(idList);
        ArrayList<SysWelcome> list = new ArrayList<SysWelcome>();
        for (Long userId : idList) {
            SysWelcome s = new SysWelcome();
            s.setId(userId);
            s.setWelcomeUrl(url);
            s.setTypes(sysWelcome.getTypes());
            list.add(s);
        }
        if (!super.saveBatch(list, list.size())) {
            throw new BaseException(TranslateUtil.getTranslateName((String)BaseConfigEnum.BASE_CONFIG_UPDATE_FAIL.getValue()));
        }
        return ApiResponse.success((String)TranslateUtil.getTranslateName((String)BaseConfigEnum.BASE_CONFIG_UPDATE_SUCCESS.getValue()));
    }

    private List<SysWelcomeVo> returnMap(List<SysWelcomeVo> list) {
        HashMap<String, SysWelcomeVo> map = new HashMap<String, SysWelcomeVo>();
        for (SysWelcomeVo sysWelcome : list) {
            if (map.get(sysWelcome.getWelcomeUrl()) != null) {
                String userId = ((SysWelcomeVo)map.get(sysWelcome.getWelcomeUrl())).getUserId();
                String userName = ((SysWelcomeVo)map.get(sysWelcome.getWelcomeUrl())).getUserName();
                String userIds = userId + "," + sysWelcome.getUserId();
                String userNames = userName + "," + sysWelcome.getUserName();
                sysWelcome.setUserId(userIds);
                sysWelcome.setUserName(userNames);
                map.put(sysWelcome.getWelcomeUrl(), sysWelcome);
                continue;
            }
            map.put(sysWelcome.getWelcomeUrl(), sysWelcome);
        }
        ArrayList<SysWelcomeVo> newList = new ArrayList<SysWelcomeVo>();
        for (Map.Entry entry : map.entrySet()) {
            newList.add((SysWelcomeVo)entry.getValue());
        }
        return newList;
    }

    private String insertCheckVue(List idList, String oldUrl) {
        List<SysWelcome> list = this.sysWelcomeMapper.insertCheck(idList, oldUrl);
        StringBuilder resultBuilder = new StringBuilder();
        if (list != null && list.size() > 0) {
            for (SysWelcome s : list) {
                if (!idList.contains(s.getId())) continue;
                resultBuilder.append(s.getUserName());
                resultBuilder.append(",");
            }
            String result = resultBuilder.toString();
            return result.trim().substring(0, result.length() - 1);
        }
        return "";
    }
}

