/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.base.config.baseconfig.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.common.collect.ImmutableSet;
import com.jxdinfo.hussar.authentication.service.SysAuthClientModelService;
import com.jxdinfo.hussar.authorization.audit.model.SysStaffAudit;
import com.jxdinfo.hussar.authorization.audit.model.SysStruAudit;
import com.jxdinfo.hussar.authorization.audit.model.SysUsersAudit;
import com.jxdinfo.hussar.authorization.audit.service.ISysOfficeAuditService;
import com.jxdinfo.hussar.authorization.audit.service.ISysOrganAuditService;
import com.jxdinfo.hussar.authorization.audit.service.ISysStaffAuditService;
import com.jxdinfo.hussar.authorization.audit.service.ISysStruAssistOrganAuditService;
import com.jxdinfo.hussar.authorization.audit.service.ISysStruAuditService;
import com.jxdinfo.hussar.authorization.audit.service.ISysUserIpAuditService;
import com.jxdinfo.hussar.authorization.audit.service.ISysUsersAuditService;
import com.jxdinfo.hussar.authorization.permit.model.SysStruRoleAudit;
import com.jxdinfo.hussar.authorization.permit.model.SysUserroleAudit;
import com.jxdinfo.hussar.authorization.permit.service.ISysStruRoleAuditService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUserroleAuditService;
import com.jxdinfo.hussar.authorization.post.model.SysPostAudit;
import com.jxdinfo.hussar.authorization.post.service.ISysPostAuditService;
import com.jxdinfo.hussar.authorization.relational.model.SysPostRoleAudit;
import com.jxdinfo.hussar.authorization.relational.model.SysStruPostAudit;
import com.jxdinfo.hussar.authorization.relational.model.SysStruStaffAudit;
import com.jxdinfo.hussar.authorization.relational.model.SysStruUserAudit;
import com.jxdinfo.hussar.authorization.relational.model.SysUserPostAudit;
import com.jxdinfo.hussar.authorization.relational.service.ISysPostRoleAuditService;
import com.jxdinfo.hussar.authorization.relational.service.ISysStruPostAuditService;
import com.jxdinfo.hussar.authorization.relational.service.ISysStruStaffAuditService;
import com.jxdinfo.hussar.authorization.relational.service.ISysStruUserAuditService;
import com.jxdinfo.hussar.authorization.relational.service.ISysUserPostAuditService;
import com.jxdinfo.hussar.base.cloud.model.client.SysAuthClientModel;
import com.jxdinfo.hussar.base.config.baseconfig.dao.SysBaseConfigMapper;
import com.jxdinfo.hussar.base.config.baseconfig.enums.PersonalizedTypeEnum;
import com.jxdinfo.hussar.base.config.baseconfig.model.SysBaseConfig;
import com.jxdinfo.hussar.base.config.baseconfig.service.IHussarLoginConfigService;
import com.jxdinfo.hussar.base.config.baseconfig.service.IHussarPwdConfigService;
import com.jxdinfo.hussar.base.config.baseconfig.service.ISysAuditConfigService;
import com.jxdinfo.hussar.base.config.baseconfig.service.ISysBaseConfigService;
import com.jxdinfo.hussar.base.config.constants.BaseConstans;
import com.jxdinfo.hussar.base.config.enums.BaseConfigEnum;
import com.jxdinfo.hussar.base.config.enums.SysBaseConfigEnum;
import com.jxdinfo.hussar.common.base.HussarBaseServiceImpl;
import com.jxdinfo.hussar.common.constant.state.UserRoleStatus;
import com.jxdinfo.hussar.common.datasource.service.IDynamicDataSourceService;
import com.jxdinfo.hussar.common.dto.SysBaseConfigDto;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.properties.HussarCacheProperties;
import com.jxdinfo.hussar.common.properties.SecureAssesmentProperties;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.common.utils.CopyPropertieUtils;
import com.jxdinfo.hussar.core.config.HussarConfig;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.mail.GlobalMailAccount;
import com.jxdinfo.hussar.mail.MailAccount;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.oss.api.service.OssService;
import com.jxdinfo.hussar.support.oss.core.support.entity.AttachmentManagerModel;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@HussarTokenDs
@Service
public class SysBaseConfigServiceImpl
extends HussarBaseServiceImpl<SysBaseConfigMapper, SysBaseConfig>
implements ISysBaseConfigService {
    @Resource
    private ISysAuditConfigService auditConfigService;
    @Resource
    private HussarCacheProperties hussarCacheProperties;
    @Resource
    private IHussarLoginConfigService hussarLoginConfigService;
    @Resource
    private HussarConfig hussarConfig;
    private IDynamicDataSourceService dynamicDataSourceService;
    private static Logger logger = LoggerFactory.getLogger(SysBaseConfigServiceImpl.class);
    private static final String POSITIVE_INTEGER = "^(0|[1-9][0-9]*)$";
    private static final String NUM_UPPER_LOWER_SPE = "^[A-Za-z0-9`~!@#$%^&*()_\\|+<>?:\"{},.\\/;'\\[\\]-]+$";
    private static final String POSITIVE_INTEGER_100 = "^([1-9]|[1-9]\\d|100)$";
    private static final ImmutableSet<String> PAGE_HOME_CONFIG_SET = ImmutableSet.of((Object)"home_page_type", (Object)"home_page_sysname", (Object)"home_page_logo", (Object)"relation_icon", (Object)"home_page_menu");
    private static final ImmutableSet<String> PAGE_CONSOLE_CONFIG_SET = ImmutableSet.of((Object)"console_page_sysname", (Object)"console_page_logo", (Object)"console_browser_name", (Object)"console_browser_icon", (Object)"console_text_logo");
    private static final ImmutableSet<String> TOTP_CAPTCHA_CONFIG_SET = ImmutableSet.of((Object)"totp_open", (Object)"kaptcha_open", (Object)"login_view_kaptcha");
    @Resource
    private ISysOfficeAuditService sysOfficeAuditService;
    @Resource
    private ISysOrganAuditService sysOrganAuditService;
    @Resource
    private ISysStaffAuditService sysStaffAuditService;
    @Resource
    private ISysStruAssistOrganAuditService sysStruAssistOrganAuditService;
    @Resource
    private ISysStruAuditService sysStruAuditService;
    @Resource
    private ISysStruRoleAuditService sysStruRoleAuditService;
    @Resource
    private ISysUserIpAuditService sysUserIpAuditService;
    @Resource
    private ISysUserroleAuditService sysUserroleAuditService;
    @Resource
    private ISysUsersAuditService sysUsersAuditService;
    @Resource
    private SysBaseConfigMapper baseConfigMapper;
    @Resource
    private OssService ossService;
    @Resource
    private ISysPostAuditService sysPostAuditService;
    @Resource
    private ISysUserPostAuditService sysUserPostAuditService;
    @Resource
    private ISysStruUserAuditService sysStruUserAuditService;
    @Resource
    private ISysStruPostAuditService sysStruPostAuditService;
    @Resource
    private ISysStruStaffAuditService sysStruStaffAuditService;
    @Resource
    private ISysPostRoleAuditService sysPostRoleAuditService;
    @Resource
    private SecureAssesmentProperties secureAssesmentProperties;
    @Resource
    private IHussarPwdConfigService hussarPwdConfigService;
    private static final String OPEN = "0";
    private static final String CLOSE = "1";
    @Resource
    private SysAuthClientModelService sysAuthClientModelService;

    @Autowired
    @Lazy
    public SysBaseConfigServiceImpl(IHussarLoginConfigService hussarLoginConfigService, IDynamicDataSourceService dynamicDataSourceService) {
        this.hussarLoginConfigService = hussarLoginConfigService;
        this.dynamicDataSourceService = dynamicDataSourceService;
    }

    public SysBaseConfig getSysBaseConfig(String configKey) {
        return this.getSysBaseConfig("master", configKey);
    }

    @HussarDs(value="#connName")
    public SysBaseConfig getSysBaseConfig(String connName, String configKey) {
        SysBaseConfig sysBaseConfig;
        String key = "base_config:" + configKey;
        Object obj = HussarCacheUtil.get((String)"base_config", (Object)key);
        if (ToolUtil.isEmpty((Object)obj)) {
            SysBaseConfig baseConfig = (SysBaseConfig)super.getOne((Wrapper)new LambdaQueryWrapper().eq(SysBaseConfig::getConfigKey, (Object)configKey), false);
            if (ToolUtil.isNotEmpty((Object)baseConfig)) {
                HussarCacheUtil.put((String)"base_config", (Object)key, (Object)baseConfig);
            }
            sysBaseConfig = baseConfig;
        } else {
            sysBaseConfig = (SysBaseConfig)obj;
        }
        return sysBaseConfig;
    }

    public SysBaseConfigDto getSysBaseConfigCom(String configKey) {
        return this.getSysBaseConfigWithUserCom(configKey, null);
    }

    public void setSysBaseConfigCache(String configKey, SysBaseConfig baseConfig) {
        String key = "base_config:" + configKey;
        HussarCacheUtil.put((String)"base_config", (Object)key, (Object)baseConfig);
    }

    public SysBaseConfig getSysBaseConfigWithUser(String configKey, SecurityUser shiroUser) {
        SysBaseConfig sysBaseConfig;
        String key = "base_config:" + configKey;
        Object obj = HussarCacheUtil.get((String)"base_config", (Object)key);
        if (ToolUtil.isEmpty((Object)obj)) {
            SysBaseConfig baseConfig = (SysBaseConfig)super.getOne((Wrapper)new LambdaQueryWrapper().eq(SysBaseConfig::getConfigKey, (Object)configKey), false);
            if (ToolUtil.isNotEmpty((Object)baseConfig)) {
                HussarCacheUtil.put((String)"base_config", (Object)key, (Object)baseConfig);
            }
            sysBaseConfig = baseConfig;
        } else {
            sysBaseConfig = (SysBaseConfig)obj;
        }
        return sysBaseConfig;
    }

    private SysBaseConfigDto getSysBaseConfigWithUserCom(String configKey, SecurityUser shiroUser) {
        String key = "base_config:" + configKey;
        Object obj = HussarCacheUtil.get((String)"base_config", (Object)key);
        SysBaseConfigDto sysBaseConfigDto = new SysBaseConfigDto();
        if (ToolUtil.isEmpty((Object)obj)) {
            SysBaseConfig baseConfig;
            SysBaseConfig sysBaseConfig = baseConfig = (SysBaseConfig)super.getOne((Wrapper)new LambdaQueryWrapper().eq(SysBaseConfig::getConfigKey, (Object)configKey), false);
            CopyPropertieUtils.copyProperties((Object)sysBaseConfigDto, (Object)sysBaseConfig);
            HussarCacheUtil.put((String)"base_config", (Object)key, (Object)sysBaseConfig);
        } else {
            try {
                PropertyUtils.copyProperties((Object)sysBaseConfigDto, (Object)obj);
            }
            catch (IllegalAccessException e) {
                logger.error("\u5bf9\u8c61\u590d\u5236\u9519\u8bef");
            }
            catch (InvocationTargetException e) {
                logger.error("\u5bf9\u8c61\u590d\u5236\u9519\u8bef");
            }
            catch (NoSuchMethodException e) {
                logger.error("\u5bf9\u8c61\u590d\u5236\u65b9\u6cd5\u9519\u8bef");
            }
        }
        return sysBaseConfigDto;
    }

    public ApiResponse<IPage<SysBaseConfig>> queryList(Page page, SysBaseConfig sysBaseConfig) {
        if (ToolUtil.isEmpty((Object)page)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)BaseConfigEnum.BASE_CONFIG_PAGING_INFO_EMPTY.getValue()));
        }
        LambdaQueryWrapper ew = new LambdaQueryWrapper((Object)sysBaseConfig);
        ew.eq(SysBaseConfig::getParentId, (Object)1);
        ew.orderByAsc(SysBaseConfig::getId);
        return ApiResponse.success((Object)this.page((IPage)page, (Wrapper)ew));
    }

    @HussarTransactional
    public ApiResponse updateBatchBaseConfig(List<SysBaseConfig> baseConfigList) {
        LambdaQueryWrapper wrapper9;
        LambdaQueryWrapper wrapper8;
        if (ToolUtil.isEmpty(baseConfigList)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)BaseConfigEnum.BASE_CONFIG_RUNNING_PARAM_EMPTY.getValue()));
        }
        this.getMailConfig(baseConfigList);
        boolean openAudit = false;
        boolean notOpenAudit = false;
        boolean isUserConfig = false;
        boolean isLoginTimeLimit = false;
        boolean isChangeAccessTokenValidTime = false;
        long accessTokenValidTime = 1800L;
        String startTime = "";
        String endTime = "";
        for (SysBaseConfig sysBaseConfig : baseConfigList) {
            if (sysBaseConfig.getId().toString().equals("9991")) {
                if (sysBaseConfig.getConfigValue().equals(OPEN)) {
                    openAudit = true;
                    break;
                }
                if (sysBaseConfig.getConfigValue().equals(CLOSE)) {
                    notOpenAudit = true;
                    break;
                }
            }
            if (sysBaseConfig.getId().toString().equals("7775") && sysBaseConfig.getConfigValue().equals(OPEN)) {
                isUserConfig = true;
            }
            if (sysBaseConfig.getId().toString().equals("3331") && sysBaseConfig.getConfigValue().equals(OPEN)) {
                isLoginTimeLimit = true;
            }
            if (!sysBaseConfig.getId().toString().equals("1212125")) continue;
            SysBaseConfig config = (SysBaseConfig)this.getById(sysBaseConfig.getId());
            if (sysBaseConfig.getConfigValue().equals(config.getConfigValue())) continue;
            isChangeAccessTokenValidTime = true;
            accessTokenValidTime = Long.parseLong(sysBaseConfig.getConfigValue());
        }
        if (isLoginTimeLimit) {
            for (SysBaseConfig baseConfig : baseConfigList) {
                if (baseConfig.getId().toString().equals("3332") && StringUtils.isNotBlank((CharSequence)baseConfig.getConfigValue())) {
                    startTime = baseConfig.getConfigValue();
                }
                if (!baseConfig.getId().toString().equals("3333")) continue;
                endTime = baseConfig.getConfigValue();
            }
            if (!this.checkTimeBefore(startTime, endTime, "HH:mm:ss")) {
                throw new BaseException(TranslateUtil.getTranslateName((String)BaseConfigEnum.BASE_CONFIG_START_TIME_EARLIER_END_TIME.getValue()));
            }
        }
        if (isUserConfig && this.auditConfigService.isCriticalOperationsAudit()) {
            throw new BaseException(TranslateUtil.getTranslateName((String)BaseConfigEnum.BASE_CONFIG_OPENING_REVIEW_NOT_ALLOWED_OPERATOR_USER.getValue()));
        }
        if (notOpenAudit) {
            LambdaQueryWrapper wrapper4 = new LambdaQueryWrapper();
            this.sysStruAssistOrganAuditService.remove((Wrapper)wrapper4);
            LambdaQueryWrapper wrapper5 = new LambdaQueryWrapper();
            wrapper5.eq(SysStruAudit::getState, (Object)OPEN);
            this.sysStruAuditService.remove((Wrapper)wrapper5);
            LambdaQueryWrapper wrapper6 = new LambdaQueryWrapper();
            wrapper6.eq(SysStruRoleAudit::getStatus, (Object)UserRoleStatus.LOCKED.getCode());
            this.sysStruRoleAuditService.remove((Wrapper)wrapper6);
            LambdaQueryWrapper wrapper7 = new LambdaQueryWrapper();
            this.sysUserIpAuditService.remove((Wrapper)wrapper7);
            wrapper8 = new LambdaQueryWrapper();
            wrapper8.eq(SysUserroleAudit::getStatus, (Object)UserRoleStatus.LOCKED.getCode());
            this.sysUserroleAuditService.remove((Wrapper)wrapper8);
            wrapper9 = new LambdaQueryWrapper();
            wrapper9.eq(SysUsersAudit::getIsAudit, (Object)OPEN);
            this.sysUsersAuditService.remove((Wrapper)wrapper9);
            this.sysStruUserAuditService.remove((Wrapper)new LambdaQueryWrapper().eq(SysStruUserAudit::getAuditStatus, (Object)OPEN));
            this.sysPostAuditService.remove((Wrapper)new LambdaQueryWrapper().eq(SysPostAudit::getAuditStatus, (Object)OPEN));
            this.sysUserPostAuditService.remove((Wrapper)new LambdaQueryWrapper().eq(SysUserPostAudit::getAuditStatus, (Object)OPEN));
            this.sysPostRoleAuditService.remove((Wrapper)new LambdaQueryWrapper().eq(SysPostRoleAudit::getAuditStatus, (Object)OPEN));
            this.sysStruPostAuditService.remove((Wrapper)new LambdaQueryWrapper().eq(SysStruPostAudit::getAuditStatus, (Object)OPEN));
            this.sysStaffAuditService.remove((Wrapper)new LambdaQueryWrapper().eq(SysStaffAudit::getAuditStatus, (Object)OPEN));
            this.sysStruStaffAuditService.remove((Wrapper)new LambdaQueryWrapper().eq(SysStruStaffAudit::getAuditStatus, (Object)OPEN));
        }
        if (openAudit) {
            SysBaseConfig config = new SysBaseConfig();
            config.setId(Long.valueOf(7775L));
            config.setConfigValue(CLOSE);
            this.saveOrUpdate((BaseEntity)config);
            int num = 0;
            for (SysBaseConfig sysBaseConfig : baseConfigList) {
                if (!sysBaseConfig.getConfigValue().equals(CLOSE)) continue;
                if (sysBaseConfig.getId().toString().equals("9992")) {
                    LambdaQueryWrapper wrapper4 = new LambdaQueryWrapper();
                    this.sysStruAssistOrganAuditService.remove((Wrapper)wrapper4);
                    LambdaQueryWrapper wrapper5 = new LambdaQueryWrapper();
                    wrapper5.eq(SysStruAudit::getState, (Object)OPEN);
                    List sysStruAuditList = this.sysStruAuditService.list((Wrapper)wrapper5);
                    if (HussarUtils.isNotEmpty((Object)sysStruAuditList)) {
                        List struIds = sysStruAuditList.stream().map(SysStruAudit::getId).collect(Collectors.toList());
                        this.sysStruPostAuditService.remove((Wrapper)new LambdaQueryWrapper().in(SysStruPostAudit::getStruId, struIds));
                    }
                    this.sysStruAuditService.remove((Wrapper)wrapper5);
                    LambdaQueryWrapper wrapper6 = new LambdaQueryWrapper();
                    wrapper6.eq(SysStruRoleAudit::getStatus, (Object)UserRoleStatus.LOCKED.getCode());
                    this.sysStruRoleAuditService.remove((Wrapper)wrapper6);
                    continue;
                }
                if (sysBaseConfig.getId().toString().equals("9993")) {
                    ++num;
                    LambdaQueryWrapper wrapper7 = new LambdaQueryWrapper();
                    this.sysUserIpAuditService.remove((Wrapper)wrapper7);
                    wrapper9 = new LambdaQueryWrapper();
                    wrapper9.eq(SysUsersAudit::getIsAudit, (Object)OPEN);
                    this.sysUsersAuditService.remove((Wrapper)wrapper9);
                    this.sysStruUserAuditService.remove((Wrapper)new LambdaQueryWrapper().eq(SysStruUserAudit::getAuditStatus, (Object)OPEN));
                    continue;
                }
                if (sysBaseConfig.getId().toString().equals("9994")) {
                    wrapper8 = new LambdaQueryWrapper();
                    wrapper8.eq(SysUserroleAudit::getStatus, (Object)UserRoleStatus.LOCKED.getCode());
                    this.sysUserroleAuditService.remove((Wrapper)wrapper8);
                    continue;
                }
                if (sysBaseConfig.getId().toString().equals("99910")) {
                    ++num;
                    LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
                    lambdaQueryWrapper.eq(SysPostAudit::getAuditStatus, (Object)OPEN);
                    List sysPostAudits = this.sysPostAuditService.list((Wrapper)lambdaQueryWrapper);
                    if (HussarUtils.isNotEmpty((Object)sysPostAudits)) {
                        List postIds = sysPostAudits.stream().map(SysPostAudit::getPostId).collect(Collectors.toList());
                        this.sysStruPostAuditService.remove((Wrapper)new LambdaQueryWrapper().in(SysStruPostAudit::getPostId, postIds));
                    }
                    this.sysPostAuditService.remove((Wrapper)lambdaQueryWrapper);
                    this.sysPostRoleAuditService.remove((Wrapper)new LambdaQueryWrapper().eq(SysPostRoleAudit::getAuditStatus, (Object)OPEN));
                    continue;
                }
                if (!sysBaseConfig.getId().toString().equals("99911")) continue;
                this.sysStaffAuditService.remove((Wrapper)new LambdaQueryWrapper().eq(SysStaffAudit::getAuditStatus, (Object)OPEN));
                this.sysStruStaffAuditService.remove((Wrapper)new LambdaQueryWrapper().eq(SysStruStaffAudit::getAuditStatus, (Object)OPEN));
            }
            if (num == 2) {
                this.sysUserPostAuditService.remove((Wrapper)new LambdaQueryWrapper().eq(SysUserPostAudit::getAuditStatus, (Object)OPEN));
            }
        }
        if (isChangeAccessTokenValidTime) {
            SysAuthClientModel sysAuthClientModel = (SysAuthClientModel)this.sysAuthClientModelService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysAuthClientModel::getClientId, (Object)"hussar-base"));
            sysAuthClientModel.setAccessTokenValidTime(accessTokenValidTime);
            this.sysAuthClientModelService.updateAuthClientModel(sysAuthClientModel);
        }
        this.checkTotpOffsetMin(baseConfigList);
        this.checkByRegular(baseConfigList, "1115", "\u4f11\u7720\u81ea\u52a8\u6ce8\u9500\u5929\u6570\u8bf7\u8f93\u5165\u6b63\u6574\u6570", POSITIVE_INTEGER);
        this.checkByRegular(baseConfigList, "1116", "\u6ce8\u9500\u524d\u53d1\u9001\u90ae\u4ef6\u5929\u6570\u8bf7\u8f93\u5165\u6b63\u6574\u6570", POSITIVE_INTEGER);
        this.checkByRegular(baseConfigList, "2221", "\u8fde\u7eed\u5931\u8d25\u65f6\u95f4\u8bf7\u8f93\u5165\u6b63\u6574\u6570", POSITIVE_INTEGER);
        this.checkByRegular(baseConfigList, "2222", "\u8fde\u7eed\u5931\u8d25\u6b21\u6570\u8bf7\u8f93\u5165\u6b63\u6574\u6570", POSITIVE_INTEGER);
        this.checkByRegular(baseConfigList, "2223", "\u8fde\u7eed\u5931\u8d25\u9501\u5b9a\u65f6\u95f4\u8bf7\u8f93\u5165\u6b63\u6574\u6570", POSITIVE_INTEGER);
        this.checkByRegular(baseConfigList, "6667", "\u5bc6\u7801\u751f\u547d\u5468\u671f\u8bf7\u8f93\u5165\u6b63\u6574\u6570", POSITIVE_INTEGER);
        this.checkByRegular(baseConfigList, "6668", "\u5bc6\u7801\u91cd\u590d\u6b21\u6570\u8bf7\u8f93\u5165\u6b63\u6574\u6570", POSITIVE_INTEGER);
        this.checkByRegular(baseConfigList, "7773", "\u7528\u6237\u9ed8\u8ba4\u5bc6\u7801\u8bf7\u8f93\u5165\u6570\u5b57\u3001\u5927\u5199\u5b57\u6bcd\u3001\u5c0f\u5199\u5b57\u6bcd\u3001\u82f1\u6587\u7279\u6b8a\u5b57\u7b26", NUM_UPPER_LOWER_SPE);
        this.checkByRegular(baseConfigList, "1010101", "\u5ba1\u8ba1\u65e5\u5fd7\u62a5\u8b66\u6761\u6570\u8bf7\u8f93\u5165\u6b63\u6574\u6570", POSITIVE_INTEGER);
        this.checkByRegular(baseConfigList, "1123", "\u5ba1\u8ba1\u65e5\u5fd7\u8868\u7a7a\u95f4\u6700\u5927\u503c\u8bf7\u8f93\u5165\u6b63\u6574\u6570", POSITIVE_INTEGER);
        this.checkByRegular(baseConfigList, "1124", "\u5ba1\u8ba1\u65e5\u5fd7\u9608\u503c\u8bf7\u8f93\u51651-100\u7684\u6b63\u6574\u6570", POSITIVE_INTEGER_100);
        this.checkByRegular(baseConfigList, "1132", "\u6d88\u606f\u9ed8\u8ba4\u4fdd\u5b58\u65f6\u95f4\u8bf7\u8f93\u5165\u6b63\u6574\u6570", POSITIVE_INTEGER);
        if (this.secureAssesmentProperties.isOpen()) {
            this.checkNoLoginDay(baseConfigList);
            this.checkPasswordConfig(baseConfigList);
            this.checkFailNumber(baseConfigList);
            this.checkPasswordLoclTime(baseConfigList);
            this.checkPaaswordHist(baseConfigList);
            this.checkRepeatTime(baseConfigList);
        }
        this.isUpdatePasswordConfig(baseConfigList);
        this.checkOrgInOutNameIsSame(baseConfigList);
        boolean result = this.saveOrUpdateBatch(baseConfigList, 1000);
        if (!result) {
            throw new BaseException(TranslateUtil.getTranslateName((String)BaseConfigEnum.BASE_CONFIG_UPDATE_FAIL.getValue()));
        }
        return ApiResponse.success((String)TranslateUtil.getTranslateName((String)BaseConfigEnum.BASE_CONFIG_UPDATE_SUCCESS.getValue()));
    }

    public void checkOrgInOutNameIsSame(List<SysBaseConfig> baseConfigList) {
        List orgInNameConfig = baseConfigList.stream().filter(r -> SysBaseConfigEnum.ORG_IN_NAME.getConfigId().equals(String.valueOf(r.getId()))).collect(Collectors.toList());
        List orgOutNameConfig = baseConfigList.stream().filter(r -> SysBaseConfigEnum.ORG_OUT_NAME.getConfigId().equals(String.valueOf(r.getId()))).collect(Collectors.toList());
        if (HussarUtils.isNotEmpty(orgInNameConfig) && HussarUtils.isNotEmpty(orgOutNameConfig)) {
            String orgInName = "";
            String orgOutName = "";
            SysBaseConfig inConfig = (SysBaseConfig)orgInNameConfig.get(0);
            SysBaseConfig outConfig = (SysBaseConfig)orgOutNameConfig.get(0);
            if ("".equals(inConfig.getConfigValue())) {
                throw new BaseException(TranslateUtil.getTranslateName((String)BaseConfigEnum.BASE_CONFIG_ORG_IN_NAME_EMPTY.getValue()));
            }
            orgInName = inConfig.getConfigValue();
            if ("".equals(outConfig.getConfigValue())) {
                throw new BaseException(TranslateUtil.getTranslateName((String)BaseConfigEnum.BASE_CONFIG_ORG_OUT_NAME_EMPTY.getValue()));
            }
            orgOutName = outConfig.getConfigValue();
            if (orgInName.equals(orgOutName)) {
                throw new BaseException(TranslateUtil.getTranslateName((String)BaseConfigEnum.BASE_CONFIG_ORG_IN_OUT_NAME_DUPLICATE.getValue()));
            }
            if (orgInName.length() > 255) {
                throw new BaseException(TranslateUtil.getTranslateName((String)BaseConfigEnum.BASE_CONFIG_ORG_IN_NAME_MAX_255.getValue()));
            }
            if (orgOutName.length() > 255) {
                throw new BaseException(TranslateUtil.getTranslateName((String)BaseConfigEnum.BASE_CONFIG_ORG_OUT_NAME_MAX_255.getValue()));
            }
        }
    }

    public void isUpdatePasswordConfig(List<SysBaseConfig> baseConfigList) {
        String unmatchedHint;
        String pwdComplexityRegular;
        List pwdRuleCustom;
        List pwdRule = baseConfigList.stream().filter(r -> "6661".equals(String.valueOf(r.getId()))).collect(Collectors.toList());
        if (pwdRule != null) {
            this.saveOrUpdateBatch(pwdRule);
        }
        if ((pwdRuleCustom = baseConfigList.stream().filter(r -> "6663".equals(String.valueOf(r.getId()))).collect(Collectors.toList())) != null) {
            this.saveOrUpdateBatch(pwdRuleCustom);
        }
        if ((pwdComplexityRegular = this.getPwdComplexityRegular(baseConfigList)) != null) {
            for (SysBaseConfig sysBaseConfig : baseConfigList) {
                if (!"6664".equals(String.valueOf(sysBaseConfig.getId()))) continue;
                sysBaseConfig.setConfigValue(pwdComplexityRegular);
            }
        }
        if ((unmatchedHint = this.getUnmatchedHint(baseConfigList)) != null) {
            for (SysBaseConfig sysBaseConfig : baseConfigList) {
                if (!"6665".equals(String.valueOf(sysBaseConfig.getId()))) continue;
                sysBaseConfig.setConfigValue(unmatchedHint);
            }
        }
    }

    public String getUnmatchedHint(List<SysBaseConfig> baseConfigList) {
        boolean pwdRuleCustom;
        String unmatchedHint = null;
        List sysBaseConfigs = baseConfigList.stream().filter(r -> "6665".equals(String.valueOf(r.getId()))).collect(Collectors.toList());
        if (sysBaseConfigs != null && sysBaseConfigs.size() > 0 && !(pwdRuleCustom = this.hussarPwdConfigService.isPwdRuleCustom())) {
            unmatchedHint = this.hussarPwdConfigService.getUnmatchedHint();
        }
        return unmatchedHint;
    }

    public String getPwdComplexityRegular(List<SysBaseConfig> baseConfigList) {
        boolean pwdRuleCustom;
        String regular = null;
        List sysBaseConfigs = baseConfigList.stream().filter(r -> "6664".equals(String.valueOf(r.getId()))).collect(Collectors.toList());
        if (sysBaseConfigs != null && sysBaseConfigs.size() > 0 && !(pwdRuleCustom = this.hussarPwdConfigService.isPwdRuleCustom())) {
            regular = this.hussarPwdConfigService.getPwdComplexityRegular().replaceAll("/", "");
        }
        return regular;
    }

    private void checkTotpOffsetMin(List<SysBaseConfig> baseConfigList) {
        List configIds = baseConfigList.stream().map(SysBaseConfig::getId).collect(Collectors.toList());
        Optional<SysBaseConfig> baseConfigOptional = super.list((Wrapper)new LambdaQueryWrapper().in(SysBaseConfig::getId, configIds)).stream().filter(v -> "totp_offset_min".equals(v.getConfigKey())).findFirst();
        if (baseConfigOptional.isPresent()) {
            SysBaseConfig totpOffsetMin = baseConfigOptional.get();
            Boolean isValid = baseConfigList.stream().filter(v -> Objects.equals(v.getId(), totpOffsetMin.getId())).anyMatch(v -> {
                Integer configValue = Integer.valueOf(v.getConfigValue());
                return 0 <= configValue && configValue <= 6;
            });
            if (!isValid.booleanValue()) {
                throw new BaseException(TranslateUtil.getTranslateName((String)BaseConfigEnum.BASE_CONFIG_DYNAMIC_PASSWORD_BETWEEN.getValue()));
            }
        }
    }

    public ApiResponse<List<SysBaseConfig>> queryBaseConfigListByParentId(String sysBaseConfigId) {
        if (ToolUtil.isEmpty((Object)sysBaseConfigId)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)BaseConfigEnum.BASE_CONFIG_CONFIG_ITEM_ID_EMPTY.getValue()));
        }
        List sysBaseConfigList = this.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysBaseConfig::getParentId, (Object)Long.valueOf(sysBaseConfigId))).notIn(SysBaseConfig::getId, new Object[]{1010102, 1212121})).orderByAsc(true, SysBaseConfig::getId));
        if (HussarUtils.isNotEmpty((Object)sysBaseConfigList)) {
            for (SysBaseConfig sysBaseConfig : sysBaseConfigList) {
                String configKey = sysBaseConfig.getConfigKey();
                SysBaseConfig configCache = (SysBaseConfig)HussarCacheUtil.get((String)"base_config", (Object)("base_config:" + configKey));
                if (!HussarUtils.isNotEmpty((Object)configCache)) continue;
                BeanUtil.copy((Object)configCache, (Object)sysBaseConfig);
            }
        }
        if (this.secureAssesmentProperties.isOpen()) {
            sysBaseConfigList.stream().forEach(r -> {
                if ("nologin_day".equals(r.getConfigKey())) {
                    r.setExample("\u5355\u4f4d\u5929\u3002\u8d85\u8fc7\u914d\u7f6e\u5929\u6570\u8d26\u53f7\u4f1a\u4f11\u7720");
                }
            });
        }
        return ApiResponse.success((Object)sysBaseConfigList);
    }

    public ApiResponse<Map<String, Object>> queryPersonalBaseConfigList(String personalizedType) {
        if (ToolUtil.isEmpty((Object)personalizedType)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)BaseConfigEnum.BASE_CONFIG_PERSONALIZED_CONFIG_TYPE_EMPTY.getValue()));
        }
        LambdaQueryWrapper ew = new LambdaQueryWrapper();
        ew.orderByAsc(SysBaseConfig::getId);
        String parentId = PersonalizedTypeEnum.getParentIdByType((String)personalizedType);
        ew.eq(SysBaseConfig::getParentId, (Object)Long.valueOf(parentId));
        List list = this.list((Wrapper)ew);
        HashMap<String, String> dataMap = new HashMap<String, String>();
        for (SysBaseConfig s : list) {
            dataMap.put(s.getConfigKey(), s.getConfigValue());
        }
        return ApiResponse.success(dataMap);
    }

    @HussarTransactional
    public ApiResponse updateBatchPersonalBaseConfig(List<SysBaseConfig> baseConfigList) {
        if (ToolUtil.isEmpty(baseConfigList)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)BaseConfigEnum.BASE_CONFIG_PERSONALIZED_CONFIG_TYPE_LIST_EMPTY.getValue()));
        }
        ArrayList configKeyList = new ArrayList();
        HashMap map = new HashMap();
        baseConfigList.forEach(bc -> {
            configKeyList.add(bc.getConfigKey());
            map.put(bc.getConfigKey(), bc.getConfigValue());
        });
        List updateList = this.list((Wrapper)new LambdaQueryWrapper().in(SysBaseConfig::getConfigKey, configKeyList));
        updateList.forEach(bc -> bc.setConfigValue((String)map.get(bc.getConfigKey())));
        boolean result = this.saveOrUpdateBatch(updateList);
        if (!result) {
            throw new BaseException(TranslateUtil.getTranslateName((String)BaseConfigEnum.BASE_CONFIG_UPDATE_FAIL.getValue()));
        }
        return ApiResponse.success((String)TranslateUtil.getTranslateName((String)BaseConfigEnum.BASE_CONFIG_UPDATE_SUCCESS.getValue()));
    }

    public ApiResponse<Long> uploadImage(MultipartFile image) throws IOException {
        if (image.isEmpty()) {
            throw new BaseException(TranslateUtil.getTranslateName((String)BaseConfigEnum.BASE_CONFIG_FILE_EMPTY.getValue()));
        }
        String path = this.hussarConfig.getFileUploadPath().replace("\\", "/");
        File folder = new File(path);
        if (!folder.isDirectory()) {
            folder.mkdirs();
        }
        String oldName = image.getOriginalFilename();
        String fileType = oldName.substring(oldName.lastIndexOf("."));
        String newName = UUID.randomUUID().toString() + fileType;
        image.transferTo(new File(folder, newName));
        AttachmentManagerModel attachment = new AttachmentManagerModel();
        attachment.setAttachmentName(newName);
        attachment.setAttachmentType(fileType);
        attachment.setUploadPer(BaseSecurityUtil.getUser().getId());
        attachment.setAttachmentDir(path);
        attachment.setUploadDate(LocalDateTime.now());
        return ApiResponse.success((Object)attachment.getId());
    }

    public void showImage(Long id, HttpServletResponse response) {
        if (ToolUtil.isEmpty((Object)id)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)BaseConfigEnum.BASE_CONFIG_IMAGE_ID_EMPTY.getValue()));
        }
        response.setContentType("text/html; charset=UTF-8");
        response.setContentType("image/jpeg");
        byte[] image = (byte[])this.ossService.backgroundDownload(id).getData();
        try (ServletOutputStream outputStream = response.getOutputStream();){
            outputStream.write(image);
            outputStream.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public SysBaseConfigDto getSysBaseConfigDtoWithUser(String key, SecurityUser shiroUser) {
        SysBaseConfig baseConfig = this.getSysBaseConfigWithUser(key, shiroUser);
        SysBaseConfigDto dto = new SysBaseConfigDto();
        BeanUtils.copyProperties((Object)baseConfig, (Object)dto);
        return dto;
    }

    public SysBaseConfigDto getSysBaseConfigDto(String key) {
        return this.getSysBaseConfigDto("master", key);
    }

    public SysBaseConfigDto getSysBaseConfigDto(String connName, String key) {
        SysBaseConfig baseConfig = this.getSysBaseConfig(connName, key);
        SysBaseConfigDto dto = new SysBaseConfigDto();
        if (ToolUtil.isNotEmpty((Object)baseConfig)) {
            BeanUtils.copyProperties((Object)baseConfig, (Object)dto);
        }
        return dto;
    }

    public void setSysBaseConfigDtoCache(String key, SysBaseConfigDto baseConfigDto) {
        SysBaseConfig baseConfig = new SysBaseConfig();
        BeanUtils.copyProperties((Object)baseConfigDto, (Object)baseConfig);
        this.setSysBaseConfigCache(key, baseConfig);
    }

    public boolean checkTimeBefore(String starTime, String endTime, String format) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        Date start = null;
        Date end = null;
        if (HussarUtils.isBlank((CharSequence)starTime) || HussarUtils.isBlank((CharSequence)endTime)) {
            logger.error("\u5f00\u59cb\u65f6\u95f4\u548c\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            throw new BaseException(TranslateUtil.getTranslateName((String)BaseConfigEnum.BASE_CONFIG_START_AND_END_EMPTY.getValue()));
        }
        try {
            start = sdf.parse(starTime);
            end = sdf.parse(endTime);
        }
        catch (ParseException e) {
            logger.error("\u65f6\u95f4\u8f6c\u6362\u5931\u8d25");
            throw new BaseException(TranslateUtil.getTranslateName((String)BaseConfigEnum.BASE_CONFIG_DATE_FORMAT_CONVERSION_EXCEPTION.getValue()));
        }
        if (HussarUtils.isNotEmpty((Object)start) && HussarUtils.isNotEmpty((Object)end)) {
            return start.before(end);
        }
        return false;
    }

    public boolean isNotRedis() {
        return !"redis".equals(this.hussarCacheProperties.getCacheType());
    }

    public List<SysBaseConfig> getHomePageBaseConfigList() {
        return this.getBaseConfigListByConfigKeys("home_page", (Collection<String>)PAGE_HOME_CONFIG_SET);
    }

    public List<SysBaseConfig> getConsolePageBaseConfigList() {
        return this.getBaseConfigListByConfigKeys("console_page", (Collection<String>)PAGE_CONSOLE_CONFIG_SET);
    }

    public List<SysBaseConfig> getTotpCaptchaConfigList() {
        return this.getBaseConfigListByConfigKeys("totp_captcha", (Collection<String>)TOTP_CAPTCHA_CONFIG_SET);
    }

    public ApiResponse<Integer> getTotpOpen() {
        Integer value = Integer.parseInt(((SysBaseConfig)this.baseConfigMapper.selectById(BaseConstans.TOTP_OPEN_ID)).getConfigValue());
        return ApiResponse.success((Object)value);
    }

    private List<SysBaseConfig> getBaseConfigListByConfigKeys(String cacheKey, Collection<String> configKeys) {
        List sysBaseConfigs;
        String key = "base_config:" + cacheKey;
        Object obj = HussarCacheUtil.get((String)"base_config", (Object)key);
        if (ToolUtil.isEmpty((Object)obj)) {
            sysBaseConfigs = super.list((Wrapper)new LambdaQueryWrapper().in(SysBaseConfig::getConfigKey, configKeys));
            if (ToolUtil.isNotEmpty((Object)sysBaseConfigs)) {
                HussarCacheUtil.put((String)"base_config", (Object)key, (Object)sysBaseConfigs);
            }
        } else {
            sysBaseConfigs = (List)obj;
        }
        return sysBaseConfigs;
    }

    protected void getMailConfig(List<SysBaseConfig> baseConfigList) {
        MailAccount mailAccount = GlobalMailAccount.INSTANCE.getAccount();
        boolean mailIsEmpty = ToolUtil.isEmpty((Object)mailAccount.getFrom());
        boolean flag = false;
        long id = baseConfigList.get(0).getId();
        if (id == BaseConstans.NOLOGIN_DAY_ID) {
            flag = Integer.parseInt(baseConfigList.get(0).getConfigValue()) > 0;
        } else if (id == BaseConstans.FAIL_TIME_ID) {
            flag = baseConfigList.get(3).getConfigValue() != null && !"".equals(baseConfigList.get(3).getConfigValue());
        } else if (id == BaseConstans.LOGIN_IP_LIMIT_ID) {
            flag = Integer.parseInt(baseConfigList.get(0).getConfigValue()) == 0 && baseConfigList.get(3).getConfigValue() != null && !"".equals(baseConfigList.get(3).getConfigValue());
        } else if (id == BaseConstans.CREATE_USER_ID) {
            flag = Integer.parseInt(baseConfigList.get(0).getConfigValue()) == 0;
        } else if (id == BaseConstans.SECURITYLOG_COUNT_ALERT_ID) {
            boolean bl = flag = baseConfigList.get(1).getConfigValue() != null && !"".equals(baseConfigList.get(1).getConfigValue());
        }
        if (mailIsEmpty && flag) {
            throw new BaseException(TranslateUtil.getTranslateName((String)BaseConfigEnum.BASE_CONFIG_CONFIG_MONITORING_EMAIL.getValue()));
        }
    }

    public void checkPasswordConfig(List<SysBaseConfig> baseConfigList) {
        List sysBaseConfigs = baseConfigList.stream().filter(r -> "6661".equals(String.valueOf(r.getId()))).collect(Collectors.toList());
        if (sysBaseConfigs != null && sysBaseConfigs.size() > 0) {
            SysBaseConfig sysBaseConfig = (SysBaseConfig)sysBaseConfigs.get(0);
            String regFormat = "^[1-9]\\d*,[1-9]\\d*,[1-9]\\d*$";
            Pattern r2 = Pattern.compile(regFormat);
            Matcher m = r2.matcher(sysBaseConfig.getConfigValue());
            if (m.matches()) {
                String[] configValue = sysBaseConfig.getConfigValue().split(",");
                Integer smallValue = Integer.valueOf(configValue[0]);
                Integer bigValue = Integer.valueOf(configValue[1]);
                Integer strengthValue = Integer.valueOf(configValue[2]);
                if (smallValue > bigValue) {
                    throw new BaseException(TranslateUtil.getTranslateName((String)BaseConfigEnum.BASE_CONFIG_MIN_LENGTH_MAX_LENGTH.getValue()));
                }
                if (smallValue < 8) {
                    throw new BaseException(TranslateUtil.getTranslateName((String)BaseConfigEnum.BASE_CONFIG_MIN_LENGTH_EIGHT.getValue()));
                }
                if (bigValue > 20) {
                    throw new BaseException(TranslateUtil.getTranslateName((String)BaseConfigEnum.BASE_CONFIG_MAX_LENGTH_TWENTY.getValue()));
                }
                if (strengthValue != 3) {
                    throw new BaseException(TranslateUtil.getTranslateName((String)BaseConfigEnum.BASE_CONFIG_PASSWORD_STRENGTH.getValue()));
                }
            } else {
                throw new BaseException(TranslateUtil.getTranslateName((String)BaseConfigEnum.BASE_CONFIG_POSITIVE_INTEGER.getValue()));
            }
        }
    }

    public void checkPasswordLoclTime(List<SysBaseConfig> baseConfigList) {
        SysBaseConfig sysBaseConfig;
        List sysBaseConfigs = baseConfigList.stream().filter(r -> "2223".equals(String.valueOf(r.getId()))).collect(Collectors.toList());
        if (sysBaseConfigs != null && sysBaseConfigs.size() > 0 && Integer.valueOf((sysBaseConfig = (SysBaseConfig)sysBaseConfigs.get(0)).getConfigValue()) < 20) {
            throw new BaseException(TranslateUtil.getTranslateName((String)BaseConfigEnum.BASE_CONFIG_LOCK_TWENTY_MINUTES.getValue()));
        }
    }

    public void checkFailNumber(List<SysBaseConfig> baseConfigList) {
        SysBaseConfig sysBaseConfig;
        List sysBaseConfigs = baseConfigList.stream().filter(r -> "2222".equals(String.valueOf(r.getId()))).collect(Collectors.toList());
        if (sysBaseConfigs != null && sysBaseConfigs.size() > 0 && (Integer.valueOf((sysBaseConfig = (SysBaseConfig)sysBaseConfigs.get(0)).getConfigValue()) < 1 || Integer.valueOf(sysBaseConfig.getConfigValue()) > 10)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)BaseConfigEnum.BASE_CONFIG_NUMBER_OF_LOGIN_FAILURES.getValue()));
        }
    }

    public void checkPaaswordHist(List<SysBaseConfig> baseConfigList) {
        SysBaseConfig sysBaseConfig;
        List sysBaseConfigs = baseConfigList.stream().filter(r -> "6667".equals(String.valueOf(r.getId()))).collect(Collectors.toList());
        if (sysBaseConfigs != null && sysBaseConfigs.size() > 0 && Integer.valueOf((sysBaseConfig = (SysBaseConfig)sysBaseConfigs.get(0)).getConfigValue()) > 90) {
            throw new BaseException(TranslateUtil.getTranslateName((String)BaseConfigEnum.BASE_CONFIG_PASSWORD_LIFECYCLE.getValue()));
        }
    }

    public void checkRepeatTime(List<SysBaseConfig> baseConfigList) {
        SysBaseConfig sysBaseConfig;
        List sysBaseConfigs = baseConfigList.stream().filter(r -> "6668".equals(String.valueOf(r.getId()))).collect(Collectors.toList());
        if (sysBaseConfigs != null && sysBaseConfigs.size() > 0 && Integer.valueOf((sysBaseConfig = (SysBaseConfig)sysBaseConfigs.get(0)).getConfigValue()) < 1) {
            throw new BaseException(TranslateUtil.getTranslateName((String)BaseConfigEnum.BASE_CONFIG_PASSWORD_SAME.getValue()));
        }
    }

    public void checkNoLoginDay(List<SysBaseConfig> baseConfigList) {
        List sysBaseConfigs = baseConfigList.stream().filter(r -> "1111".equals(String.valueOf(r.getId()))).collect(Collectors.toList());
        if (sysBaseConfigs != null && sysBaseConfigs.size() > 0) {
            Pattern r2;
            SysBaseConfig sysBaseConfig = (SysBaseConfig)sysBaseConfigs.get(0);
            if (!"-1".equals(sysBaseConfig.getConfigValue()) && !(r2 = Pattern.compile(POSITIVE_INTEGER)).matcher(sysBaseConfig.getConfigValue()).matches()) {
                throw new BaseException(TranslateUtil.getTranslateName((String)BaseConfigEnum.BASE_CONFIG_UN_LOGGED_DAYS.getValue()));
            }
            if (Integer.valueOf(sysBaseConfig.getConfigValue()) < 90) {
                throw new BaseException(TranslateUtil.getTranslateName((String)BaseConfigEnum.BASE_CONFIG_MIN_LOGGED_DAYS.getValue()));
            }
        }
    }

    public void checkByRegular(List<SysBaseConfig> baseConfigList, String id, String message, String regular) {
        List sysBaseConfigs = baseConfigList.stream().filter(r -> id.equals(String.valueOf(r.getId()))).collect(Collectors.toList());
        if (sysBaseConfigs != null && sysBaseConfigs.size() > 0) {
            SysBaseConfig sysBaseConfig = (SysBaseConfig)sysBaseConfigs.get(0);
            Pattern r2 = Pattern.compile(regular);
            if (!r2.matcher(sysBaseConfig.getConfigValue()).matches()) {
                throw new BaseException(message);
            }
        }
    }
}

