/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.base.config.baseconfig.service.impl;

import com.jxdinfo.hussar.base.config.baseconfig.model.SysBaseConfig;
import com.jxdinfo.hussar.base.config.baseconfig.service.IPageViewConfigService;
import com.jxdinfo.hussar.base.config.baseconfig.service.ISysBaseConfigService;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class PageViewConfigServiceImpl
implements IPageViewConfigService {
    @Resource
    private ISysBaseConfigService sysBaseConfigService;

    public String getLoginViewType() {
        SysBaseConfig baseConfig = this.sysBaseConfigService.getSysBaseConfig("login_view_type");
        return baseConfig.getConfigValue();
    }

    public String getLoginViewSysname() {
        SysBaseConfig baseConfig = this.sysBaseConfigService.getSysBaseConfig("login_view_sysname");
        return baseConfig.getConfigValue();
    }

    public String getLoginViewLogo() {
        SysBaseConfig baseConfig = this.sysBaseConfigService.getSysBaseConfig("login_view_logo");
        return baseConfig.getConfigValue();
    }

    public String getLoginViewBackground() {
        SysBaseConfig baseConfig = this.sysBaseConfigService.getSysBaseConfig("login_view_background");
        return baseConfig.getConfigValue();
    }

    public String getLoginViewInnerBackground() {
        SysBaseConfig baseConfig = this.sysBaseConfigService.getSysBaseConfig("login_view_innerBackground");
        return baseConfig.getConfigValue();
    }

    public String getLoginViewCopyright() {
        SysBaseConfig baseConfig = this.sysBaseConfigService.getSysBaseConfig("login_view_copyright");
        return baseConfig.getConfigValue();
    }

    public boolean isLoginViewKaptcha() {
        SysBaseConfig baseConfig = this.sysBaseConfigService.getSysBaseConfig("login_view_kaptcha");
        return "0".equals(baseConfig.getConfigValue());
    }

    public boolean isLoginViewKaptcha(String connName) {
        SysBaseConfig baseConfig = this.sysBaseConfigService.getSysBaseConfig(connName, "login_view_kaptcha");
        return "0".equals(baseConfig.getConfigValue());
    }

    public boolean isLoginRememberpwd() {
        SysBaseConfig baseConfig = this.sysBaseConfigService.getSysBaseConfig("login_rememberpwd");
        return "0".equals(baseConfig.getConfigValue());
    }

    public String getHomePageType() {
        SysBaseConfig baseConfig = this.sysBaseConfigService.getSysBaseConfig("home_page_type");
        return baseConfig.getConfigValue();
    }

    public String getHomePageSysname() {
        SysBaseConfig baseConfig = this.sysBaseConfigService.getSysBaseConfig("home_page_sysname");
        return baseConfig.getConfigValue();
    }

    public String getHomePageLogo() {
        SysBaseConfig baseConfig = this.sysBaseConfigService.getSysBaseConfig("home_page_logo");
        return baseConfig.getConfigValue();
    }

    public String getRelationIcon() {
        SysBaseConfig baseConfig = this.sysBaseConfigService.getSysBaseConfig("relation_icon");
        return baseConfig.getConfigValue();
    }

    public Map<String, Object> getHomePageInfo() {
        List sysBaseConfigs = this.sysBaseConfigService.getHomePageBaseConfigList();
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (ToolUtil.isNotEmpty((Object)sysBaseConfigs)) {
            Map configMap = sysBaseConfigs.stream().collect(Collectors.toMap(SysBaseConfig::getConfigKey, Function.identity()));
            map.put("type", configMap.getOrDefault("home_page_type", new SysBaseConfig()).getConfigValue());
            map.put("sysname", configMap.getOrDefault("home_page_sysname", new SysBaseConfig()).getConfigValue());
            map.put("logo", configMap.getOrDefault("home_page_logo", new SysBaseConfig()).getConfigValue());
            map.put("relationIcon", configMap.getOrDefault("relation_icon", new SysBaseConfig()).getConfigValue());
            map.put("menu", configMap.getOrDefault("home_page_menu", new SysBaseConfig()).getConfigValue());
        }
        return map;
    }

    public Map<String, Object> getConsolePageInfo() {
        List sysBaseConfigs = this.sysBaseConfigService.getConsolePageBaseConfigList();
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (ToolUtil.isNotEmpty((Object)sysBaseConfigs)) {
            Map configMap = sysBaseConfigs.stream().collect(Collectors.toMap(SysBaseConfig::getConfigKey, Function.identity()));
            map.put("sysname", configMap.getOrDefault("console_page_sysname", new SysBaseConfig()).getConfigValue());
            map.put("logo", configMap.getOrDefault("console_page_logo", new SysBaseConfig()).getConfigValue());
            map.put("icon", configMap.getOrDefault("console_browser_icon", new SysBaseConfig()).getConfigValue());
            map.put("name", configMap.getOrDefault("console_browser_name", new SysBaseConfig()).getConfigValue());
            map.put("textLogo", configMap.getOrDefault("console_text_logo", new SysBaseConfig()).getConfigValue());
            map.put("loginViewSysName", this.getLoginViewSysname());
        }
        return map;
    }
}

