/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.base.config.shortcutconfig.controller;

import com.jxdinfo.hussar.base.config.shortcutconfig.model.ShortCutConfig;
import com.jxdinfo.hussar.base.config.shortcutconfig.service.IShortCutConfigService;
import com.jxdinfo.hussar.base.config.shortcutconfig.vo.ShortCutConfigVO;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.support.mp.base.controller.HussarBaseController;
import com.jxdinfo.hussar.support.security.core.annotation.CheckPermission;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5feb\u6377\u5165\u53e3\u914d\u7f6e"})
@RestController
@RequestMapping(value={"/shortcutConfig"})
public class ShortCutConfigController
extends HussarBaseController<ShortCutConfig, IShortCutConfigService> {
    @Resource
    private IShortCutConfigService shortCutConfigService;

    @ApiOperation(value="\u5feb\u6377\u5165\u53e3\u83b7\u53d6\u5173\u8054\u529f\u80fd", notes="\u5feb\u6377\u5165\u53e3\u83b7\u53d6\u5173\u8054\u529f\u80fd")
    @GetMapping(value={"/shortCutMenuTree"})
    @AuditLog(moduleName="\u5feb\u6377\u5165\u53e3\u914d\u7f6e", eventDesc="\u5feb\u6377\u5165\u53e3\u83b7\u53d6\u5173\u8054\u529f\u80fd", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<JSTreeModel>> shortCutMenuTree() {
        return ApiResponse.success((Object)this.shortCutConfigService.getShortCutMenuTree());
    }

    @ApiOperation(value="\u63a7\u5236\u53f0\u4fdd\u5b58\u65b0\u589e\u7684\u5feb\u6377\u5165\u53e3", notes="\u63a7\u5236\u53f0\u4fdd\u5b58\u65b0\u589e\u7684\u5feb\u6377\u5165\u53e3")
    @AuditLog(moduleName="\u5feb\u6377\u5165\u53e3\u914d\u7f6e", eventDesc="\u63a7\u5236\u53f0\u4fdd\u5b58\u65b0\u589e\u7684\u5feb\u6377\u5165\u53e3", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.INSERT)
    @PostMapping(value={"/add"})
    @CheckPermission(value={"shortcutConfig:add"})
    public ApiResponse add(@ApiParam(value="\u5feb\u6377\u5165\u53e3\u5b9e\u4f53") @RequestBody ShortCutConfig shortCutConfig) {
        return this.shortCutConfigService.saveShortCutConfig(shortCutConfig);
    }

    @ApiOperation(value="\u63a7\u5236\u53f0\u83b7\u53d6\u5feb\u6377\u5165\u53e3\u5217\u8868", notes="\u83b7\u53d6\u5feb\u6377\u5165\u53e3\u5217\u8868")
    @AuditLog(moduleName="\u5feb\u6377\u5165\u53e3\u914d\u7f6e", eventDesc="\u83b7\u53d6\u5feb\u6377\u5165\u53e3\u5217\u8868", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @GetMapping(value={"/getList"})
    public ApiResponse<List<ShortCutConfigVO>> list() {
        return ApiResponse.success((Object)this.shortCutConfigService.queryShortCutConfig());
    }

    @ApiOperation(value="\u4fee\u6539\u5feb\u6377\u5165\u53e3\u914d\u7f6e", notes="\u4fee\u6539\u5feb\u6377\u5165\u53e3\u914d\u7f6e")
    @AuditLog(moduleName="\u5feb\u6377\u5165\u53e3\u914d\u7f6e", eventDesc="\u4fee\u6539\u5feb\u6377\u5165\u53e3\u914d\u7f6e", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    @PostMapping(value={"/update"})
    public ApiResponse update(@ApiParam(value="\u5feb\u6377\u5165\u53e3\u5b9e\u4f53") @RequestBody ShortCutConfig shortCutConfig) {
        return this.shortCutConfigService.updateShortCutConfig(shortCutConfig);
    }

    @ApiOperation(value="\u5220\u9664\u5feb\u6377\u5165\u53e3", notes="\u5220\u9664\u5feb\u6377\u5165\u53e3")
    @AuditLog(moduleName="\u5feb\u6377\u5165\u53e3\u914d\u7f6e", eventDesc="\u5220\u9664\u5feb\u6377\u5165\u53e3", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.DELETE)
    @PostMapping(value={"/delete"})
    @CheckPermission(value={"shortcutConfig:delete"})
    public ApiResponse delete(@ApiParam(value="\u5220\u9664\u5feb\u6377\u5165\u53e3id") @RequestBody String id) {
        return this.shortCutConfigService.deleteShortCutConfig(id);
    }

    @ApiOperation(value="\u67e5\u770b\u5feb\u6377\u5165\u53e3\u8be6\u60c5", notes="\u67e5\u770b\u5feb\u6377\u5165\u53e3\u8be6\u60c5")
    @AuditLog(moduleName="\u5feb\u6377\u5165\u53e3\u914d\u7f6e", eventDesc="\u67e5\u770b\u5feb\u6377\u5165\u53e3\u8be6\u60c5", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @GetMapping(value={"/view"})
    public ApiResponse<ShortCutConfig> view(@ApiParam(value="\u5feb\u6377\u914d\u7f6e\u5b9e\u4f53id") @RequestParam Long id) {
        return ApiResponse.success((Object)this.shortCutConfigService.viewShortCutConfig(id));
    }

    @ApiOperation(value="\u95e8\u6237\u7aef\u83b7\u53d6\u7528\u6237\u5907\u9009\u5feb\u6377\u65b9\u5f0f\u5217\u8868", notes="\u95e8\u6237\u7aef\u83b7\u53d6\u7528\u6237\u5907\u9009\u5feb\u6377\u65b9\u5f0f\u5217\u8868")
    @AuditLog(moduleName="\u5feb\u6377\u5165\u53e3\u914d\u7f6e", eventDesc="\u95e8\u6237\u7aef\u83b7\u53d6\u7528\u6237\u5907\u9009\u5feb\u6377\u65b9\u5f0f\u5217\u8868", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @GetMapping(value={"/userList"})
    public ApiResponse<List<ShortCutConfig>> userList() {
        return ApiResponse.success((Object)this.shortCutConfigService.queryShortCutConfigUserList());
    }

    @ApiOperation(value="\u7528\u6237\u4fdd\u5b58\u5feb\u6377\u65b9\u5f0f", notes="\u7528\u6237\u4fdd\u5b58\u5feb\u6377\u65b9\u5f0f")
    @AuditLog(moduleName="\u5feb\u6377\u5165\u53e3\u914d\u7f6e", eventDesc="\u7528\u6237\u4fdd\u5b58\u5feb\u6377\u65b9\u5f0f", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.INSERT)
    @PostMapping(value={"/saveByIds"})
    public ApiResponse batchAdd(@ApiParam(value="\u5feb\u6377\u65b9\u5f0fid\u96c6\u5408", required=false) @RequestBody(required=false) String ids) {
        return this.shortCutConfigService.saveShortCutUserConfig(ids);
    }

    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u5feb\u6377\u65b9\u5f0f\u5217\u8868", notes="\u83b7\u53d6\u7528\u6237\u5feb\u6377\u65b9\u5f0f\u5217\u8868")
    @AuditLog(moduleName="\u5feb\u6377\u5165\u53e3\u914d\u7f6e", eventDesc="\u83b7\u53d6\u7528\u6237\u5feb\u6377\u65b9\u5f0f\u5217\u8868", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @GetMapping(value={"/customList"})
    public ApiResponse<List<ShortCutConfig>> customList() {
        return ApiResponse.success((Object)this.shortCutConfigService.queryUserShortCut());
    }
}

