/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.base.config.baseconfig.service.impl;

import com.jxdinfo.hussar.base.config.baseconfig.model.SysBaseConfig;
import com.jxdinfo.hussar.base.config.baseconfig.service.IHussarPwdConfigService;
import com.jxdinfo.hussar.base.config.baseconfig.service.ISysBaseConfigService;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class HussarPwdConfigServiceImpl
implements IHussarPwdConfigService {
    @Resource
    private ISysBaseConfigService sysBaseConfigService;

    public String getDefaultPassword() {
        SysBaseConfig baseConfig = this.sysBaseConfigService.getSysBaseConfig("default_password");
        return baseConfig.getConfigValue();
    }

    public String getPwdComplexityRegular() {
        String secretComplexityRegular;
        if (this.isPwdRuleCustom()) {
            secretComplexityRegular = this.sysBaseConfigService.getSysBaseConfig("pwd_complexity_regular").getConfigValue();
        } else {
            this.setRule();
            secretComplexityRegular = this.sysBaseConfigService.getSysBaseConfig("pwd_complexity_regular").getConfigValue();
        }
        return secretComplexityRegular;
    }

    public String getUnmatchedHint() {
        this.setRule();
        return this.sysBaseConfigService.getSysBaseConfig("unmatched_hint").getConfigValue();
    }

    public boolean isPwdRuleCustom() {
        SysBaseConfig baseConfig = this.sysBaseConfigService.getSysBaseConfig("pwd_rule_custom");
        return "0".equals(baseConfig.getConfigValue());
    }

    public String getPwdRule() {
        SysBaseConfig baseConfig = this.sysBaseConfigService.getSysBaseConfig("pwd_rule");
        return baseConfig.getConfigValue();
    }

    public String getPwdRuleMessage() {
        SysBaseConfig baseConfig = this.sysBaseConfigService.getSysBaseConfig("pwd_rule_message");
        if (baseConfig != null) {
            return baseConfig.getConfigValue();
        }
        return "\u5bc6\u7801\u6700\u5c0f\u4e0d\u80fd\u5c0f\u4e8e%s\u4f4d\uff0c\u6700\u5927\u4e0d\u80fd\u5927\u4e8e%s\u4f4d\uff0c\u5f3a\u5ea6\u9700\u9ad8\u4e8e\u7ea7\u522b%s\u8981\u6c42!";
    }

    public String getPwdRuleMessage(int levelInt) {
        String pwdRuleMessage = this.getPwdRuleMessage();
        if (!this.isPwdRuleCustom()) {
            switch (levelInt) {
                case 1: {
                    pwdRuleMessage = new StringBuffer(pwdRuleMessage).append(" <br>\u7ea7\u522b1\uff1a\u5bc6\u7801\u53ea\u7531\u6570\u5b57\u3001\u5c0f\u5199\u5b57\u6bcd\u3001\u5927\u5199\u5b57\u6bcd\u6216\u5176\u5b83\u7279\u6b8a\u7b26\u53f7\u5f53\u4e2d\u7684\u4e00\u79cd\u7ec4\u6210\u3002").toString();
                    break;
                }
                case 2: {
                    pwdRuleMessage = new StringBuffer(pwdRuleMessage).append(" <br>\u7ea7\u522b2\uff1a\u5bc6\u7801\u7531\u6570\u5b57\u3001\u5c0f\u5199\u5b57\u6bcd\u3001\u5927\u5199\u5b57\u6bcd\u6216\u5176\u5b83\u7279\u6b8a\u7b26\u53f7\u5f53\u4e2d\u7684\u4e24\u79cd\u7ec4\u6210\u3002").toString();
                    break;
                }
                case 3: {
                    pwdRuleMessage = new StringBuffer(pwdRuleMessage).append(" <br>\u7ea7\u522b3\uff1a\u5bc6\u7801\u7531\u6570\u5b57\u3001\u5c0f\u5199\u5b57\u6bcd\u3001\u5927\u5199\u5b57\u6bcd\u6216\u5176\u5b83\u7279\u6b8a\u7b26\u53f7\u5f53\u4e2d\u7684\u4e09\u79cd\u4ee5\u4e0a\u7ec4\u6210\u3002").toString();
                    break;
                }
            }
        }
        return pwdRuleMessage;
    }

    private synchronized void setRule() {
        if (!this.isPwdRuleCustom()) {
            String regex;
            String pwdRule = this.getPwdRule();
            Object[] regArray = pwdRule.split(",");
            String minLength = regArray[0];
            String maxLength = regArray[1];
            String level = regArray[2];
            int minInt = 4;
            int maxInt = 16;
            int levelInt = 1;
            if (StringUtils.isNumeric((CharSequence)minLength) && StringUtils.isNumeric((CharSequence)maxLength) && StringUtils.isNumeric((CharSequence)level)) {
                minInt = Integer.parseInt(minLength);
                maxInt = Integer.parseInt(maxLength);
                levelInt = Integer.parseInt(level);
            }
            String pwdRuleMessage = this.getPwdRuleMessage(levelInt);
            switch (levelInt) {
                case 1: {
                    regex = new StringBuffer("^[A-Z]{%d,%d}$|^[a-z]{%d,%d}$|^[0-9]{%d,%d}$|^[\\W_]{%d,%d}$").append("|").append("^(?!\\d+$)(?![\\W_]+$)[\\d\\W_]{%d,%d}$|^(?!\\d+$)(?![a-z]+$)[\\da-z]{%d,%d}$|^(?!\\d+$)(?![A-Z]+$)[\\dA-Z]{%d,%d}$|^(?![a-z]+$)(?![A-Z]+$)[a-zA-Z]{%d,%d}$|^(?![a-z]+$)(?![\\W_]+$)[a-z\\W]{%d,%d}$|^(?![A-Z]+$)(?![\\W_]+$)[A-Z\\W]{%d,%d}$").append("|").append("^(?=.*[0-9])(?=.*[a-z])(?=.*[\\W_]).{%d,%d}$|^(?=.*[0-9])(?=.*[A-Z])(?=.*[\\W_]).{%d,%d}$|^(?=.*[a-z])(?=.*[A-Z])(?=.*[\\W_]).{%d,%d}$|^(?=.*[a-z])(?=.*[A-Z])(?=.*[0-9]).{%d,%d}$").toString();
                    break;
                }
                case 2: {
                    regex = new StringBuffer("^(?!\\d+$)(?![\\W_]+$)[\\d\\W_]{%d,%d}$|^(?!\\d+$)(?![a-z]+$)[\\da-z]{%d,%d}$|^(?!\\d+$)(?![A-Z]+$)[\\dA-Z]{%d,%d}$|^(?![a-z]+$)(?![A-Z]+$)[a-zA-Z]{%d,%d}$|^(?![a-z]+$)(?![\\W_]+$)[a-z\\W]{%d,%d}$|^(?![A-Z]+$)(?![\\W_]+$)[A-Z\\W]{%d,%d}$").append("|").append("^(?=.*[0-9])(?=.*[a-z])(?=.*[\\W_]).{%d,%d}$|^(?=.*[0-9])(?=.*[A-Z])(?=.*[\\W_]).{%d,%d}$|^(?=.*[a-z])(?=.*[A-Z])(?=.*[\\W_]).{%d,%d}$|^(?=.*[a-z])(?=.*[A-Z])(?=.*[0-9]).{%d,%d}$").toString();
                    break;
                }
                case 3: {
                    regex = "^(?=.*[0-9])(?=.*[a-z])(?=.*[\\W_]).{%d,%d}$|^(?=.*[0-9])(?=.*[A-Z])(?=.*[\\W_]).{%d,%d}$|^(?=.*[a-z])(?=.*[A-Z])(?=.*[\\W_]).{%d,%d}$|^(?=.*[a-z])(?=.*[A-Z])(?=.*[0-9]).{%d,%d}$";
                    break;
                }
                default: {
                    regex = "^[A-Z]{%d,%d}$|^[a-z]{%d,%d}$|^[0-9]{%d,%d}$|^[\\W_]{%d,%d}$";
                }
            }
            Object[] args = new Object[28];
            for (int i = 0; i < args.length; ++i) {
                args[i] = i % 2 == 0 ? Integer.valueOf(minInt) : Integer.valueOf(maxInt);
            }
            regex = String.format(regex, args);
            regex = new StringBuffer("/").append(regex).append("/").toString();
            String message = String.format(pwdRuleMessage, regArray);
            SysBaseConfig regularBaseConfig = this.sysBaseConfigService.getSysBaseConfig("pwd_complexity_regular");
            regularBaseConfig.setConfigValue(regex);
            this.sysBaseConfigService.setSysBaseConfigCache("pwd_complexity_regular", regularBaseConfig);
            SysBaseConfig unmatchedHintBaseConfig = this.sysBaseConfigService.getSysBaseConfig("unmatched_hint");
            if (ToolUtil.isEmpty((Object)unmatchedHintBaseConfig)) {
                unmatchedHintBaseConfig = new SysBaseConfig();
            }
            unmatchedHintBaseConfig.setConfigValue(message);
            this.sysBaseConfigService.setSysBaseConfigCache("unmatched_hint", unmatchedHintBaseConfig);
        }
    }

    public String getUnmatchedHintMark() {
        if (this.isPwdRuleCustom()) {
            SysBaseConfig unmatchedHintConfig = this.sysBaseConfigService.getSysBaseConfig("unmatched_hint");
            if (ToolUtil.isEmpty((Object)unmatchedHintConfig) || ToolUtil.isEmpty((Object)unmatchedHintConfig.getConfigValue())) {
                return "defaultRule";
            }
            return "customRule";
        }
        return "levelRule";
    }

    public long getPasswordHist() {
        SysBaseConfig baseConfig = this.sysBaseConfigService.getSysBaseConfig("password_hist");
        return Long.valueOf(baseConfig.getConfigValue());
    }

    public int getPwdRepeatTime() {
        SysBaseConfig baseConfig = this.sysBaseConfigService.getSysBaseConfig("pwd_repeat_time");
        return Integer.valueOf(baseConfig.getConfigValue());
    }

    public boolean isAllowChangePwd() {
        SysBaseConfig baseConfig = this.sysBaseConfigService.getSysBaseConfig("allow_change_pwd");
        return "0".equals(baseConfig.getConfigValue());
    }

    public boolean isForceChangePwd() {
        SysBaseConfig baseConfig = this.sysBaseConfigService.getSysBaseConfig("force_change_pwd");
        return "0".equals(baseConfig.getConfigValue());
    }
}

