/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.base.config.baseconfig.service.impl;

import com.jxdinfo.hussar.base.config.baseconfig.model.SysBaseConfig;
import com.jxdinfo.hussar.base.config.baseconfig.service.IGlobalService;
import com.jxdinfo.hussar.base.config.baseconfig.service.ISysBaseConfigService;
import com.jxdinfo.hussar.common.dto.SysBaseConfigDto;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class GlobalServiceImpl
implements IGlobalService {
    @Resource
    ISysBaseConfigService sysBaseConfigService;
    private String title = "HussarV8";
    private boolean treeLazyLoad = true;

    public String getTitle() {
        return this.title;
    }

    public boolean isTreeLazyLoad() {
        return this.treeLazyLoad;
    }

    public boolean isTabSwitchover() {
        SysBaseConfig baseConfig = this.sysBaseConfigService.getSysBaseConfig("tab_switchover");
        return "0".equals(baseConfig.getConfigValue());
    }

    public String getExceptionAlertEmail() {
        SysBaseConfigDto baseConfig = this.sysBaseConfigService.getSysBaseConfigDto("exception_alert_email");
        return baseConfig.getConfigValue();
    }

    public String getExceptionAlertEmail(SecurityUser shiroUser) {
        SysBaseConfig baseConfig = null;
        baseConfig = ToolUtil.isNotEmpty((Object)shiroUser) ? this.sysBaseConfigService.getSysBaseConfigWithUser("exception_alert_email", shiroUser) : this.sysBaseConfigService.getSysBaseConfig("exception_alert_email");
        if (HussarUtils.isEmpty((Object)baseConfig)) {
            throw new BaseException("\u83b7\u53d6\u53d1\u9001\u90ae\u4ef6\u5f02\u5e38\u63d0\u793a\u4fe1\u606f\u5931\u8d25\uff01");
        }
        return baseConfig.getConfigValue();
    }

    public int getSecuritylogCountAlert() {
        String countAlertStr = this.sysBaseConfigService.getSysBaseConfigDto("securitylog_count_alert").getConfigValue();
        return ToolUtil.isNotEmpty((Object)countAlertStr) ? Integer.valueOf(countAlertStr) : -1;
    }

    public int getSecuritylogCountAlert(SecurityUser shiroUser) {
        SysBaseConfig baseConfig = null;
        baseConfig = ToolUtil.isNotEmpty((Object)shiroUser) ? this.sysBaseConfigService.getSysBaseConfigWithUser("securitylog_count_alert", shiroUser) : this.sysBaseConfigService.getSysBaseConfig("securitylog_count_alert");
        if (HussarUtils.isEmpty((Object)baseConfig)) {
            throw new BaseException("\u83b7\u53d6\u5ba1\u8ba1\u65e5\u5fd7\u62a5\u8b66\u6761\u6570\u4fe1\u606f\u5931\u8d25\uff01");
        }
        return Integer.valueOf(baseConfig.getConfigValue());
    }
}

