/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.base.config.shortcutconfig.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.authorization.menu.model.MenuInfo;
import com.jxdinfo.hussar.authorization.menu.service.ISysMenuManageService;
import com.jxdinfo.hussar.base.config.shortcutconfig.dao.ShortCutConfigMapper;
import com.jxdinfo.hussar.base.config.shortcutconfig.model.ShortCutConfig;
import com.jxdinfo.hussar.base.config.shortcutconfig.service.IShortCutConfigService;
import com.jxdinfo.hussar.base.config.shortcutconfig.vo.ShortCutConfigVO;
import com.jxdinfo.hussar.common.constant.factory.IConstantFactory;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.properties.HussarBaseProperties;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.base.entity.HussarBaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ShortCutConfigServiceImpl
extends HussarServiceImpl<ShortCutConfigMapper, ShortCutConfig>
implements IShortCutConfigService {
    @Resource
    private HussarBaseProperties hussarBaseProperties;
    @Resource
    private ISysMenuManageService iSysMenuManageService;
    @Value(value="${spring.profiles.active}")
    private String profiles;
    @Resource
    private IConstantFactory constantFactory;

    public List<ShortCutConfigVO> queryShortCutConfig() {
        return ((ShortCutConfigMapper)this.baseMapper).selectGroupAndShoortCut();
    }

    public List<ShortCutConfig> queryShortCutConfigUserList() {
        SecurityUser shiroUser = BaseSecurityUtil.getUser();
        List<ShortCutConfig> list = ((ShortCutConfigMapper)this.baseMapper).selectOrderShortCut();
        List<Long> menuIds = this.getMenuIds();
        Iterator<ShortCutConfig> iterator = list.iterator();
        while (iterator.hasNext()) {
            ShortCutConfig shortCutConfig2 = iterator.next();
            if (menuIds.contains(shortCutConfig2.getMenuId()) || !"1".equals(shortCutConfig2.getOpenType())) continue;
            iterator.remove();
        }
        List userShortCutConfigList = this.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(HussarBaseEntity::getCreator, (Object)shiroUser.getId())).ne(ShortCutConfig::getParentId, (Object)0L));
        if (userShortCutConfigList.size() > 0) {
            Set userShortSet = userShortCutConfigList.parallelStream().map(ShortCutConfig::getParentId).collect(Collectors.toSet());
            list.parallelStream().forEach(shortCutConfig -> shortCutConfig.setShowAdd(!userShortSet.contains(shortCutConfig.getId())));
        } else {
            list.parallelStream().forEach(shortCutConfig -> shortCutConfig.setShowAdd(!"1".equals(shortCutConfig.getIsDefault())));
        }
        return list;
    }

    public ApiResponse updateShortCutConfig(ShortCutConfig shortCutConfig) {
        if (ToolUtil.isEmpty((Object)shortCutConfig)) {
            throw new BaseException("\u5feb\u6377\u65b9\u5f0f\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        boolean result = this.saveOrUpdate((BaseEntity)shortCutConfig);
        if (!result) {
            throw new HussarException("\u4fee\u6539\u5931\u8d25\uff01");
        }
        return ApiResponse.success((String)"\u4fee\u6539\u6210\u529f\uff01");
    }

    public ApiResponse saveShortCutConfig(ShortCutConfig shortCutConfig) {
        boolean result;
        if (ToolUtil.isEmpty((Object)shortCutConfig)) {
            throw new BaseException("\u5feb\u6377\u65b9\u5f0f\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        shortCutConfig.setParentId(Long.valueOf(0L));
        if (ToolUtil.isEmpty((Object)shortCutConfig.getMenuId())) {
            shortCutConfig.setMenuId(null);
        }
        if (!(result = this.save((BaseEntity)shortCutConfig))) {
            throw new BaseException("\u65b0\u589e\u5931\u8d25\uff01");
        }
        return ApiResponse.success((String)"\u65b0\u589e\u6210\u529f\uff01");
    }

    public List<Long> getMenuIds() {
        List menus;
        SecurityUser shiroUser = BaseSecurityUtil.getUser();
        List roleIdList = this.constantFactory.getRolesIdByShiroUser(shiroUser);
        if (roleIdList != null && roleIdList.size() > 0) {
            menus = this.hussarBaseProperties.isTenantOpen() ? this.iSysMenuManageService.getTenantMenuByRoles(shiroUser.getId(), roleIdList, this.profiles, shiroUser.getConnName(), null) : this.iSysMenuManageService.getMenuByRoles(shiroUser.getId(), roleIdList, this.profiles, null);
        } else {
            return new ArrayList<Long>();
        }
        ArrayList<Long> menuInfoList = new ArrayList<Long>();
        this.getMenuInfo(menuInfoList, menus);
        return menuInfoList;
    }

    public List<ShortCutConfig> queryUserShortCut(Long userId) {
        List list = ((ShortCutConfigMapper)this.baseMapper).selectShortCutListByUserId(userId);
        if (list.size() == 1 && "1450785648213684226".equals(list.get(0).getParentId())) {
            list.remove(0);
        } else if (list.size() <= 0) {
            list = this.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ShortCutConfig::getParentId, (Object)0)).eq(ShortCutConfig::getIsDefault, (Object)"1"));
            List<Long> menuIds = this.getMenuIds();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                ShortCutConfig shortCutConfig = (ShortCutConfig)iterator.next();
                if (menuIds.contains(shortCutConfig.getMenuId()) || !"1".equals(shortCutConfig.getOpenType())) continue;
                iterator.remove();
            }
        }
        return list;
    }

    private void getMenuInfo(List<Long> menuInfoList, List<MenuInfo> menuInfos) {
        for (MenuInfo menuInfo : menuInfos) {
            menuInfoList.add(menuInfo.getMenuId());
            if (menuInfo.getChildMenus().size() <= 0) continue;
            this.getMenuInfo(menuInfoList, menuInfo.getChildMenus());
        }
    }

    @HussarTransactional
    public ApiResponse saveShortCutUserConfig(String ids) {
        SecurityUser shiroUser = BaseSecurityUtil.getUser();
        this.remove((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(HussarBaseEntity::getCreator, (Object)shiroUser.getId())).ne(ShortCutConfig::getParentId, (Object)0));
        if (HussarUtils.isBlank((CharSequence)ids)) {
            ShortCutConfig shortCutConfig = new ShortCutConfig();
            shortCutConfig.setParentId(Long.valueOf(1450785648213684226L));
            this.save((BaseEntity)shortCutConfig);
            return ApiResponse.success((String)"\u65b0\u589e\u6210\u529f\uff01");
        }
        List<String> idList = Arrays.asList(ids.split(","));
        ArrayList<ShortCutConfig> shortCutConfigList = new ArrayList<ShortCutConfig>();
        for (int i = 0; i < idList.size(); ++i) {
            String id = idList.get(i);
            ShortCutConfig shortCutConfig = new ShortCutConfig();
            shortCutConfig.setParentId(Long.valueOf(Long.parseLong(id)));
            shortCutConfig.setSeq(Integer.valueOf(i + 1));
            shortCutConfigList.add(shortCutConfig);
        }
        boolean flag = this.saveBatch(shortCutConfigList);
        if (!flag) {
            throw new BaseException("\u65b0\u589e\u5931\u8d25\uff01");
        }
        return ApiResponse.success((String)"\u65b0\u589e\u6210\u529f\uff01");
    }

    public ApiResponse deleteShortCutConfig(String id) {
        if (ToolUtil.isEmpty((Object)id)) {
            throw new BaseException("\u5220\u9664\u7684\u5feb\u6377\u65b9\u5f0fid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        boolean result = this.removeById(Long.valueOf(Long.parseLong(id)));
        if (!result) {
            throw new BaseException("\u5220\u9664\u5931\u8d25\uff01");
        }
        return ApiResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }
}

