/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.base.config.baseconfig.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.common.collect.ImmutableSet;
import com.jxdinfo.hussar.authorization.audit.model.SysStruAudit;
import com.jxdinfo.hussar.authorization.audit.model.SysUsersAudit;
import com.jxdinfo.hussar.authorization.audit.service.ISysOfficeAuditService;
import com.jxdinfo.hussar.authorization.audit.service.ISysOrganAuditService;
import com.jxdinfo.hussar.authorization.audit.service.ISysStaffAuditService;
import com.jxdinfo.hussar.authorization.audit.service.ISysStruAssistOrganAuditService;
import com.jxdinfo.hussar.authorization.audit.service.ISysStruAuditService;
import com.jxdinfo.hussar.authorization.audit.service.ISysUserIpAuditService;
import com.jxdinfo.hussar.authorization.audit.service.ISysUsersAuditService;
import com.jxdinfo.hussar.authorization.permit.model.SysStruRoleAudit;
import com.jxdinfo.hussar.authorization.permit.model.SysUserroleAudit;
import com.jxdinfo.hussar.authorization.permit.service.ISysStruRoleAuditService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUserroleAuditService;
import com.jxdinfo.hussar.base.config.baseconfig.dao.SysBaseConfigMapper;
import com.jxdinfo.hussar.base.config.baseconfig.model.SysBaseConfig;
import com.jxdinfo.hussar.base.config.baseconfig.service.IHussarLoginConfigService;
import com.jxdinfo.hussar.base.config.baseconfig.service.ISysAuditConfigService;
import com.jxdinfo.hussar.base.config.baseconfig.service.ISysBaseConfigService;
import com.jxdinfo.hussar.base.config.constants.BaseConstans;
import com.jxdinfo.hussar.common.constant.state.UserRoleStatus;
import com.jxdinfo.hussar.common.datasource.service.IDynamicDataSourceService;
import com.jxdinfo.hussar.common.dto.SysBaseConfigDto;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.properties.HussarBaseProperties;
import com.jxdinfo.hussar.common.properties.HussarCacheProperties;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.common.utils.CopyPropertieUtils;
import com.jxdinfo.hussar.core.config.HussarConfig;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.mail.GlobalMailAccount;
import com.jxdinfo.hussar.mail.MailAccount;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.oss.api.service.OssService;
import com.jxdinfo.hussar.support.oss.core.support.entity.AttachmentManagerModel;
import com.jxdinfo.hussar.support.oss.core.support.service.AttachmentManagerService;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
@HussarDs
public class SysBaseConfigServiceImpl
extends HussarServiceImpl<SysBaseConfigMapper, SysBaseConfig>
implements ISysBaseConfigService {
    @Resource
    private ISysAuditConfigService auditConfigService;
    @Resource
    private HussarCacheProperties hussarCacheProperties;
    @Resource
    private IHussarLoginConfigService hussarLoginConfigService;
    @Resource
    private HussarConfig hussarConfig;
    private AttachmentManagerService baseAttachmentManagerService;
    private IDynamicDataSourceService dynamicDataSourceService;
    private static Logger logger = LoggerFactory.getLogger(SysBaseConfigServiceImpl.class);
    private static final ImmutableSet<String> PAGE_HOME_CONFIG_SET = ImmutableSet.of((Object)"home_page_type", (Object)"home_page_sysname", (Object)"home_page_logo", (Object)"relation_icon");
    private static final ImmutableSet<String> TOTP_CAPTCHA_CONFIG_SET = ImmutableSet.of((Object)"totp_open", (Object)"kaptcha_open", (Object)"login_view_kaptcha");
    @Resource
    private ISysOfficeAuditService sysOfficeAuditService;
    @Resource
    private ISysOrganAuditService sysOrganAuditService;
    @Resource
    private ISysStaffAuditService sysStaffAuditService;
    @Resource
    private ISysStruAssistOrganAuditService sysStruAssistOrganAuditService;
    @Resource
    private ISysStruAuditService sysStruAuditService;
    @Resource
    private ISysStruRoleAuditService sysStruRoleAuditService;
    @Resource
    private ISysUserIpAuditService sysUserIpAuditService;
    @Resource
    private ISysUserroleAuditService sysUserroleAuditService;
    @Resource
    private ISysUsersAuditService sysUsersAuditService;
    @Resource
    private HussarBaseProperties hussarBaseProperties;
    @Resource
    private SysBaseConfigMapper baseConfigMapper;
    @Resource
    private OssService ossService;
    private static final String OPEN = "0";
    private static final String CLOSE = "1";

    @Autowired
    @Lazy
    public SysBaseConfigServiceImpl(IHussarLoginConfigService hussarLoginConfigService, AttachmentManagerService baseAttachmentManagerService, IDynamicDataSourceService dynamicDataSourceService) {
        this.hussarLoginConfigService = hussarLoginConfigService;
        this.baseAttachmentManagerService = baseAttachmentManagerService;
        this.dynamicDataSourceService = dynamicDataSourceService;
    }

    public SysBaseConfig getSysBaseConfig(String configKey) {
        return this.getSysBaseConfigWithUser(configKey, null);
    }

    public SysBaseConfigDto getSysBaseConfigCom(String configKey) {
        return this.getSysBaseConfigWithUserCom(configKey, null);
    }

    public void setSysBaseConfigCache(String configKey, SysBaseConfig baseConfig) {
        String key = "base_config:" + configKey;
        if (this.hussarBaseProperties.isTenantOpen()) {
            key = "base_config:" + this.dynamicDataSourceService.currentDsName() + ":" + configKey;
        }
        HussarCacheUtil.put((String)"base_config", (Object)key, (Object)baseConfig);
    }

    public SysBaseConfig getSysBaseConfigWithUser(String configKey, SecurityUser shiroUser) {
        SysBaseConfig sysBaseConfig;
        Object obj;
        String key = "base_config:" + configKey;
        if (this.hussarBaseProperties.isTenantOpen()) {
            key = "base_config:" + this.dynamicDataSourceService.currentDsName() + ":" + configKey;
        }
        if (ToolUtil.isEmpty((Object)(obj = HussarCacheUtil.get((String)"base_config", (Object)key)))) {
            SysBaseConfig baseConfig = (SysBaseConfig)super.getOne((Wrapper)new LambdaQueryWrapper().eq(SysBaseConfig::getConfigKey, (Object)configKey), false);
            if (ToolUtil.isNotEmpty((Object)baseConfig)) {
                HussarCacheUtil.put((String)"base_config", (Object)key, (Object)baseConfig);
            }
            sysBaseConfig = baseConfig;
        } else {
            sysBaseConfig = (SysBaseConfig)obj;
        }
        return sysBaseConfig;
    }

    private SysBaseConfigDto getSysBaseConfigWithUserCom(String configKey, SecurityUser shiroUser) {
        String key = "base_config:" + configKey;
        if (this.hussarBaseProperties.isTenantOpen()) {
            key = "base_config:" + this.dynamicDataSourceService.currentDsName() + ":" + configKey;
        }
        Object obj = HussarCacheUtil.get((String)"base_config", (Object)key);
        SysBaseConfigDto sysBaseConfigDto = new SysBaseConfigDto();
        if (ToolUtil.isEmpty((Object)obj)) {
            SysBaseConfig baseConfig;
            SysBaseConfig sysBaseConfig = baseConfig = (SysBaseConfig)super.getOne((Wrapper)new LambdaQueryWrapper().eq(SysBaseConfig::getConfigKey, (Object)configKey), false);
            CopyPropertieUtils.copyProperties((Object)sysBaseConfigDto, (Object)sysBaseConfig);
            HussarCacheUtil.put((String)"base_config", (Object)key, (Object)sysBaseConfigDto);
        } else {
            try {
                PropertyUtils.copyProperties((Object)sysBaseConfigDto, (Object)obj);
            }
            catch (IllegalAccessException e) {
                logger.error("\u5bf9\u8c61\u590d\u5236\u9519\u8bef");
            }
            catch (InvocationTargetException e) {
                logger.error("\u5bf9\u8c61\u590d\u5236\u9519\u8bef");
            }
            catch (NoSuchMethodException e) {
                logger.error("\u5bf9\u8c61\u590d\u5236\u65b9\u6cd5\u9519\u8bef");
            }
        }
        return sysBaseConfigDto;
    }

    public ApiResponse<IPage<SysBaseConfig>> queryList(Page page, SysBaseConfig sysBaseConfig) {
        if (ToolUtil.isEmpty((Object)page)) {
            throw new BaseException("\u5206\u9875\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        LambdaQueryWrapper ew = new LambdaQueryWrapper((Object)sysBaseConfig);
        ew.eq(SysBaseConfig::getParentId, (Object)1);
        ew.orderByAsc(SysBaseConfig::getId);
        return ApiResponse.success((Object)this.page((IPage)page, (Wrapper)ew));
    }

    @HussarTransactional
    public ApiResponse updateBatchBaseConfig(List<SysBaseConfig> baseConfigList) {
        LambdaQueryWrapper wrapper7;
        if (ToolUtil.isEmpty(baseConfigList)) {
            throw new BaseException("\u8fd0\u884c\u53c2\u6570\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.getMailConfig(baseConfigList);
        boolean openAudit = false;
        boolean notOpenAudit = false;
        boolean isUserConfig = false;
        boolean isLoginTimeLimit = false;
        String startTime = "";
        String endTime = "";
        for (SysBaseConfig sysBaseConfig : baseConfigList) {
            if (sysBaseConfig.getId().toString().equals("9991")) {
                if (sysBaseConfig.getConfigValue().equals(OPEN)) {
                    openAudit = true;
                    break;
                }
                if (sysBaseConfig.getConfigValue().equals(CLOSE)) {
                    notOpenAudit = true;
                    break;
                }
            }
            if (sysBaseConfig.getId().toString().equals("7775") && sysBaseConfig.getConfigValue().equals(OPEN)) {
                isUserConfig = true;
            }
            if (!sysBaseConfig.getId().toString().equals("3331") || !sysBaseConfig.getConfigValue().equals(OPEN)) continue;
            isLoginTimeLimit = true;
        }
        if (isLoginTimeLimit) {
            for (SysBaseConfig baseConfig : baseConfigList) {
                if (baseConfig.getId().toString().equals("3332") && StringUtils.isNotBlank((CharSequence)baseConfig.getConfigValue())) {
                    startTime = baseConfig.getConfigValue();
                }
                if (!baseConfig.getId().toString().equals("3333")) continue;
                endTime = baseConfig.getConfigValue();
            }
            if (!this.checkTimeBefore(startTime, endTime, "HH:mm:ss")) {
                throw new BaseException("\u5f00\u59cb\u65f6\u95f4\u5fc5\u987b\u65e9\u4e8e\u7ed3\u675f\u65f6\u95f4");
            }
        }
        if (isUserConfig && this.auditConfigService.isCriticalOperationsAudit()) {
            throw new BaseException("\u5f00\u542f\u5ba1\u6838\u65f6\uff0c\u4e0d\u5141\u8bb8\u5f00\u542f\u64cd\u4f5c\u4eba\u5458\u540c\u6b65\u64cd\u4f5c\u7528\u6237\uff01");
        }
        if (notOpenAudit) {
            LambdaQueryWrapper wrapper4 = new LambdaQueryWrapper();
            this.sysStruAssistOrganAuditService.remove((Wrapper)wrapper4);
            LambdaQueryWrapper wrapper5 = new LambdaQueryWrapper();
            wrapper5.eq(SysStruAudit::getState, (Object)OPEN);
            this.sysStruAuditService.remove((Wrapper)wrapper5);
            LambdaQueryWrapper wrapper6 = new LambdaQueryWrapper();
            wrapper6.eq(SysStruRoleAudit::getStatus, (Object)UserRoleStatus.LOCKED.getCode());
            this.sysStruRoleAuditService.remove((Wrapper)wrapper6);
            wrapper7 = new LambdaQueryWrapper();
            this.sysUserIpAuditService.remove((Wrapper)wrapper7);
            LambdaQueryWrapper wrapper8 = new LambdaQueryWrapper();
            wrapper8.eq(SysUserroleAudit::getStatus, (Object)UserRoleStatus.LOCKED.getCode());
            this.sysUserroleAuditService.remove((Wrapper)wrapper8);
            LambdaQueryWrapper wrapper9 = new LambdaQueryWrapper();
            wrapper9.eq(SysUsersAudit::getIsAudit, (Object)OPEN);
            this.sysUsersAuditService.remove((Wrapper)wrapper9);
        }
        if (openAudit) {
            SysBaseConfig config = new SysBaseConfig();
            config.setId(Long.valueOf(7775L));
            config.setConfigValue(CLOSE);
            this.saveOrUpdate((BaseEntity)config);
            for (SysBaseConfig sysBaseConfig : baseConfigList) {
                if (!sysBaseConfig.getConfigValue().equals(CLOSE)) continue;
                if (sysBaseConfig.getId().toString().equals("9992")) {
                    LambdaQueryWrapper wrapper4 = new LambdaQueryWrapper();
                    this.sysStruAssistOrganAuditService.remove((Wrapper)wrapper4);
                    LambdaQueryWrapper wrapper5 = new LambdaQueryWrapper();
                    wrapper5.eq(SysStruAudit::getState, (Object)OPEN);
                    this.sysStruAuditService.remove((Wrapper)wrapper5);
                    LambdaQueryWrapper wrapper6 = new LambdaQueryWrapper();
                    wrapper6.eq(SysStruRoleAudit::getStatus, (Object)UserRoleStatus.LOCKED.getCode());
                    this.sysStruRoleAuditService.remove((Wrapper)wrapper6);
                    continue;
                }
                if (sysBaseConfig.getId().toString().equals("9993")) {
                    wrapper7 = new LambdaQueryWrapper();
                    this.sysUserIpAuditService.remove((Wrapper)wrapper7);
                    LambdaQueryWrapper wrapper9 = new LambdaQueryWrapper();
                    wrapper9.eq(SysUsersAudit::getIsAudit, (Object)OPEN);
                    this.sysUsersAuditService.remove((Wrapper)wrapper9);
                    continue;
                }
                if (!sysBaseConfig.getId().toString().equals("9994")) continue;
                LambdaQueryWrapper wrapper8 = new LambdaQueryWrapper();
                wrapper8.eq(SysUserroleAudit::getStatus, (Object)UserRoleStatus.LOCKED.getCode());
                this.sysUserroleAuditService.remove((Wrapper)wrapper8);
            }
        }
        this.checkTotpOffsetMin(baseConfigList);
        boolean result = this.saveOrUpdateBatch(baseConfigList, 1000);
        if (!result) {
            throw new BaseException("\u4fee\u6539\u5931\u8d25\uff01");
        }
        return ApiResponse.success((String)"\u4fee\u6539\u6210\u529f\uff01");
    }

    private void checkTotpOffsetMin(List<SysBaseConfig> baseConfigList) {
        List configIds = baseConfigList.stream().map(SysBaseConfig::getId).collect(Collectors.toList());
        Optional<SysBaseConfig> baseConfigOptional = super.list((Wrapper)new LambdaQueryWrapper().in(SysBaseConfig::getId, configIds)).stream().filter(v -> "totp_offset_min".equals(v.getConfigKey())).findFirst();
        if (baseConfigOptional.isPresent()) {
            SysBaseConfig totpOffsetMin = baseConfigOptional.get();
            Boolean isValid = baseConfigList.stream().filter(v -> Objects.equals(v.getId(), totpOffsetMin.getId())).anyMatch(v -> {
                Integer configValue = Integer.valueOf(v.getConfigValue());
                return 0 <= configValue && configValue <= 6;
            });
            if (!isValid.booleanValue()) {
                throw new BaseException("\u52a8\u6001\u53e3\u4ee4\u6709\u6548\u671f\u9519\u8bef\uff0c\u987b\u57280-6\u4e4b\u95f4");
            }
        }
    }

    public ApiResponse<List<SysBaseConfig>> queryBaseConfigListByParentId(String sysBaseConfigId) {
        if (ToolUtil.isEmpty((Object)sysBaseConfigId)) {
            throw new BaseException("\u914d\u7f6e\u9879id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return ApiResponse.success((Object)this.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysBaseConfig::getParentId, (Object)Long.valueOf(sysBaseConfigId))).ne(SysBaseConfig::getId, (Object)1010102)).orderByAsc(true, SysBaseConfig::getId)));
    }

    public ApiResponse<Map<String, Object>> queryPersonalBaseConfigList(String personalizedType) {
        if (ToolUtil.isEmpty((Object)personalizedType)) {
            throw new BaseException("\u4e2a\u6027\u5316\u914d\u7f6e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        LambdaQueryWrapper ew = new LambdaQueryWrapper();
        ew.orderByAsc(SysBaseConfig::getId);
        String parentId = personalizedType.equals("login") ? "202020" : "212121";
        ew.eq(SysBaseConfig::getParentId, (Object)Long.valueOf(parentId));
        List list = this.list((Wrapper)ew);
        HashMap<String, String> dataMap = new HashMap<String, String>();
        for (SysBaseConfig s : list) {
            dataMap.put(s.getConfigKey(), s.getConfigValue());
        }
        return ApiResponse.success(dataMap);
    }

    @HussarTransactional
    public ApiResponse updateBatchPersonalBaseConfig(List<SysBaseConfig> baseConfigList) {
        if (ToolUtil.isEmpty(baseConfigList)) {
            throw new BaseException("\u4e2a\u6027\u5316\u914d\u7f6e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ArrayList configKeyList = new ArrayList();
        HashMap map = new HashMap();
        baseConfigList.forEach(bc -> {
            configKeyList.add(bc.getConfigKey());
            map.put(bc.getConfigKey(), bc.getConfigValue());
        });
        List updateList = this.list((Wrapper)new LambdaQueryWrapper().in(SysBaseConfig::getConfigKey, configKeyList));
        updateList.forEach(bc -> bc.setConfigValue((String)map.get(bc.getConfigKey())));
        boolean result = this.saveOrUpdateBatch(updateList);
        if (!result) {
            throw new BaseException("\u4fee\u6539\u5931\u8d25\uff01");
        }
        return ApiResponse.success((String)"\u4fee\u6539\u6210\u529f\uff01");
    }

    public ApiResponse<Long> uploadImage(MultipartFile image) throws IOException {
        if (image.isEmpty()) {
            throw new BaseException("\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String path = this.hussarConfig.getFileUploadPath().replace("\\", "/");
        File folder = new File(path);
        if (!folder.isDirectory()) {
            folder.mkdirs();
        }
        String oldName = image.getOriginalFilename();
        String fileType = oldName.substring(oldName.lastIndexOf("."));
        String newName = UUID.randomUUID().toString() + fileType;
        image.transferTo(new File(folder, newName));
        AttachmentManagerModel attachment = new AttachmentManagerModel();
        attachment.setAttachmentName(newName);
        attachment.setAttachmentType(fileType);
        attachment.setUploadPer(BaseSecurityUtil.getUser().getId());
        attachment.setAttachmentDir(path);
        attachment.setUploadDate(LocalDateTime.now());
        this.baseAttachmentManagerService.save((Object)attachment);
        return ApiResponse.success((Object)attachment.getId());
    }

    public void showImage(Long id, HttpServletResponse response) {
        if (ToolUtil.isEmpty((Object)id)) {
            throw new BaseException("\u56fe\u7247id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        response.setContentType("text/html; charset=UTF-8");
        response.setContentType("image/jpeg");
        byte[] image = (byte[])this.ossService.backgroundDownload(id).getData();
        try (ServletOutputStream outputStream = response.getOutputStream();){
            outputStream.write(image);
            outputStream.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public SysBaseConfigDto getSysBaseConfigDtoWithUser(String key, SecurityUser shiroUser) {
        SysBaseConfig baseConfig = this.getSysBaseConfigWithUser(key, shiroUser);
        SysBaseConfigDto dto = new SysBaseConfigDto();
        BeanUtils.copyProperties((Object)baseConfig, (Object)dto);
        return dto;
    }

    public SysBaseConfigDto getSysBaseConfigDto(String key) {
        SysBaseConfig baseConfig = this.getSysBaseConfig(key);
        SysBaseConfigDto dto = new SysBaseConfigDto();
        if (ToolUtil.isNotEmpty((Object)baseConfig)) {
            BeanUtils.copyProperties((Object)baseConfig, (Object)dto);
        }
        return dto;
    }

    public void setSysBaseConfigDtoCache(String key, SysBaseConfigDto baseConfigDto) {
        SysBaseConfig baseConfig = new SysBaseConfig();
        BeanUtils.copyProperties((Object)baseConfigDto, (Object)baseConfig);
        this.setSysBaseConfigCache(key, baseConfig);
    }

    public boolean checkTimeBefore(String starTime, String endTime, String format) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        Date start = null;
        Date end = null;
        if (HussarUtils.isBlank((CharSequence)starTime) || HussarUtils.isBlank((CharSequence)endTime)) {
            logger.error("\u5f00\u59cb\u65f6\u95f4\u548c\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            throw new BaseException("\u5f00\u59cb\u65f6\u95f4\u548c\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        try {
            start = sdf.parse(starTime);
            end = sdf.parse(endTime);
        }
        catch (ParseException e) {
            logger.error("\u65f6\u95f4\u8f6c\u6362\u5931\u8d25");
            throw new BaseException("\u65e5\u671f\u683c\u5f0f\u8f6c\u6362\u5f02\u5e38\uff01");
        }
        if (HussarUtils.isNotEmpty((Object)start) && HussarUtils.isNotEmpty((Object)end)) {
            return start.before(end);
        }
        return false;
    }

    public boolean isNotRedis() {
        return !"redis".equals(this.hussarCacheProperties.getCacheType());
    }

    public List<SysBaseConfig> getHomePageBaseConfigList() {
        return this.getBaseConfigListByConfigKeys("home_page", (Collection<String>)PAGE_HOME_CONFIG_SET);
    }

    public List<SysBaseConfig> getTotpCaptchaConfigList() {
        return this.getBaseConfigListByConfigKeys("totp_captcha", (Collection<String>)TOTP_CAPTCHA_CONFIG_SET);
    }

    public ApiResponse<Integer> getTotpOpen() {
        Integer value = Integer.parseInt(((SysBaseConfig)this.baseConfigMapper.selectById(BaseConstans.TOTP_OPEN_ID)).getConfigValue());
        return ApiResponse.success((Object)value);
    }

    private List<SysBaseConfig> getBaseConfigListByConfigKeys(String cacheKey, Collection<String> configKeys) {
        List sysBaseConfigs;
        String key = this.hussarBaseProperties.isTenantOpen() ? "base_config:" + this.dynamicDataSourceService.currentDsName() + ":" + cacheKey : "base_config:" + cacheKey;
        Object obj = HussarCacheUtil.get((String)"base_config", (Object)key);
        if (ToolUtil.isEmpty((Object)obj)) {
            sysBaseConfigs = super.list((Wrapper)new LambdaQueryWrapper().in(SysBaseConfig::getConfigKey, configKeys));
            if (ToolUtil.isNotEmpty((Object)sysBaseConfigs)) {
                HussarCacheUtil.put((String)"base_config", (Object)key, (Object)sysBaseConfigs);
            }
        } else {
            sysBaseConfigs = (List)obj;
        }
        return sysBaseConfigs;
    }

    protected void getMailConfig(List<SysBaseConfig> baseConfigList) {
        MailAccount mailAccount = GlobalMailAccount.INSTANCE.getAccount();
        boolean mailIsEmpty = ToolUtil.isEmpty((Object)mailAccount.getFrom());
        boolean flag = false;
        long id = baseConfigList.get(0).getId();
        if (id == BaseConstans.NOLOGIN_DAY_ID) {
            flag = Integer.parseInt(baseConfigList.get(0).getConfigValue()) > 0;
        } else if (id == BaseConstans.FAIL_TIME_ID) {
            flag = baseConfigList.get(3).getConfigValue() != null && !"".equals(baseConfigList.get(3).getConfigValue());
        } else if (id == BaseConstans.LOGIN_IP_LIMIT_ID) {
            flag = Integer.parseInt(baseConfigList.get(0).getConfigValue()) == 0 && baseConfigList.get(3).getConfigValue() != null && !"".equals(baseConfigList.get(3).getConfigValue());
        } else if (id == BaseConstans.CREATE_USER_ID) {
            flag = Integer.parseInt(baseConfigList.get(0).getConfigValue()) == 0;
        } else if (id == BaseConstans.SECURITYLOG_COUNT_ALERT_ID) {
            boolean bl = flag = baseConfigList.get(1).getConfigValue() != null && !"".equals(baseConfigList.get(1).getConfigValue());
        }
        if (mailIsEmpty && flag) {
            throw new BaseException("\u8bf7\u4e8emain.setting\u6587\u4ef6\u4e2d\u914d\u7f6e\u76d1\u63a7\u90ae\u7bb1");
        }
    }
}

