/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.base.config.sysvisualizeconfig.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.jxdinfo.hussar.authorization.organ.service.ISysStruService;
import com.jxdinfo.hussar.base.config.sysvisualizeconfig.dao.SysWelcomeConfigMapper;
import com.jxdinfo.hussar.base.config.sysvisualizeconfig.model.SysComponentsArr;
import com.jxdinfo.hussar.base.config.sysvisualizeconfig.model.SysWelcomeConfig;
import com.jxdinfo.hussar.base.config.sysvisualizeconfig.service.ISysComponentsArrService;
import com.jxdinfo.hussar.base.config.sysvisualizeconfig.service.ISysVisualizeConfigService;
import com.jxdinfo.hussar.base.config.sysvisualizeconfig.service.ISysWelcomeConfigService;
import com.jxdinfo.hussar.base.config.sysvisualizeconfig.vo.SysWelcomeParamVO;
import com.jxdinfo.hussar.base.config.sysvisualizeconfig.vo.WelcomeConfigTreeModelVo;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class SysWelcomeConfigServiceImpl
extends HussarServiceImpl<SysWelcomeConfigMapper, SysWelcomeConfig>
implements ISysWelcomeConfigService {
    @Resource
    private ISysComponentsArrService sysComponentsArrService;
    @Resource
    private ISysStruService sysStruService;
    @Resource
    private ISysVisualizeConfigService sysVisualizeConfigService;

    @HussarTransactional
    public boolean saveWelcome(SysWelcomeParamVO sysWelcomeParamVO) {
        if (ToolUtil.isEmpty((Object)sysWelcomeParamVO)) {
            throw new BaseException("\u6b22\u8fce\u9875\u914d\u7f6evo\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String userId = sysWelcomeParamVO.getUserId();
        String roleId = sysWelcomeParamVO.getRoleId();
        String organId = sysWelcomeParamVO.getOrganId();
        String positionId = sysWelcomeParamVO.getPositionId();
        if (ToolUtil.isEmpty((Object)userId) && ToolUtil.isEmpty((Object)roleId) && ToolUtil.isEmpty((Object)organId) && ToolUtil.isEmpty((Object)positionId)) {
            sysWelcomeParamVO.setRoleId(Long.toString(1450785135866925064L));
        }
        SysWelcomeConfig oldSysWelcomeConfig = ((SysWelcomeConfigMapper)this.getBaseMapper()).getWelcomeConfig(sysWelcomeParamVO);
        SysWelcomeConfig sysWelcomeConfig = sysWelcomeParamVO.gainWelcomeConfig();
        if (ToolUtil.isNotEmpty((Object)oldSysWelcomeConfig)) {
            sysWelcomeConfig.setId(oldSysWelcomeConfig.getId());
            UpdateWrapper sysComponentsArrWrapper = new UpdateWrapper();
            sysComponentsArrWrapper.eq((Object)"CONFIG_ID", (Object)oldSysWelcomeConfig.getId());
            this.sysComponentsArrService.remove((Wrapper)sysComponentsArrWrapper);
        }
        this.saveOrUpdate((BaseEntity)sysWelcomeConfig);
        List sysComponentsArrs = sysWelcomeParamVO.getComponentsArr();
        if (ToolUtil.isNotEmpty((Object)sysComponentsArrs)) {
            for (SysComponentsArr sysComponentsArr : sysComponentsArrs) {
                sysComponentsArr.setConfigId(sysWelcomeConfig.getId());
            }
            this.sysComponentsArrService.saveOrUpdateBatch((Collection)sysComponentsArrs);
        }
        return true;
    }

    @HussarTransactional
    public boolean saveWelcomeConfig(Long oldRoleId, Long newRoleId, Long oldOrganId, Long newOrganId, Long oldPositionId, Long newPositionId) {
        SysWelcomeParamVO sysWelcomeParamVO = new SysWelcomeParamVO();
        sysWelcomeParamVO.setRoleId(ToolUtil.isNotEmpty((Object)oldRoleId) ? oldRoleId.toString() : null);
        sysWelcomeParamVO.setOrganId(ToolUtil.isNotEmpty((Object)oldOrganId) ? oldOrganId.toString() : null);
        sysWelcomeParamVO.setPositionId(ToolUtil.isNotEmpty((Object)oldPositionId) ? oldPositionId.toString() : null);
        SysWelcomeConfig sysWelcomeConfig = ((SysWelcomeConfigMapper)this.getBaseMapper()).getWelcomeConfig(sysWelcomeParamVO);
        if (ToolUtil.isNotEmpty((Object)sysWelcomeConfig)) {
            sysWelcomeConfig.setRoleId(newRoleId);
            sysWelcomeConfig.setOrganId(newOrganId);
            sysWelcomeConfig.setPositionId(newPositionId);
            this.updateById((BaseEntity)sysWelcomeConfig);
            return true;
        }
        return false;
    }

    @HussarTransactional
    public boolean removeWelcomeConfig(Long roleId, Long organId, Long positionId) {
        SysWelcomeParamVO sysWelcomeParamVO = new SysWelcomeParamVO();
        sysWelcomeParamVO.setRoleId(ToolUtil.isNotEmpty((Object)roleId) ? roleId.toString() : null);
        sysWelcomeParamVO.setOrganId(ToolUtil.isNotEmpty((Object)organId) ? organId.toString() : null);
        sysWelcomeParamVO.setPositionId(ToolUtil.isNotEmpty((Object)positionId) ? positionId.toString() : null);
        SysWelcomeConfig sysWelcomeConfig = ((SysWelcomeConfigMapper)this.getBaseMapper()).getWelcomeConfig(sysWelcomeParamVO);
        if (ToolUtil.isNotEmpty((Object)sysWelcomeConfig)) {
            UpdateWrapper sysComponentsArrWrapper = new UpdateWrapper();
            sysComponentsArrWrapper.eq((Object)"CONFIG_ID", (Object)sysWelcomeConfig.getId());
            this.sysComponentsArrService.remove((Wrapper)sysComponentsArrWrapper);
        }
        this.removeById((BaseEntity)sysWelcomeConfig);
        return true;
    }

    public List<WelcomeConfigTreeModelVo> queryWelcomeConfigList() {
        List<WelcomeConfigTreeModelVo> welcomeConfigTreeModelVos = ((SysWelcomeConfigMapper)this.getBaseMapper()).getWelcomeConfigTree();
        ArrayList<WelcomeConfigTreeModelVo> welcomeConfigTreeModelDtos = new ArrayList<WelcomeConfigTreeModelVo>(welcomeConfigTreeModelVos);
        for (WelcomeConfigTreeModelVo welcomeConfigTreeModelVo : welcomeConfigTreeModelVos) {
            if (!ToolUtil.isEmpty((Object)welcomeConfigTreeModelVo)) continue;
            welcomeConfigTreeModelDtos.remove(welcomeConfigTreeModelVo);
        }
        for (WelcomeConfigTreeModelVo welcomeConfigTreeModelVo : welcomeConfigTreeModelDtos) {
            welcomeConfigTreeModelVo.setConfig(true);
        }
        return welcomeConfigTreeModelDtos;
    }

    public SysWelcomeParamVO queryWelcomeList(Long roleId, Long organId, Long positionId, Long userId) {
        SecurityUser user = BaseSecurityUtil.getUser();
        SysWelcomeConfig sysWelcomeConfig = null;
        List contents = new ArrayList();
        HashMap<String, String> params = new HashMap<String, String>();
        if (ToolUtil.isEmpty((Object)userId)) {
            if (ToolUtil.isEmpty((Object)organId) && ToolUtil.isEmpty((Object)roleId) && ToolUtil.isEmpty((Object)positionId)) {
                sysWelcomeConfig = (SysWelcomeConfig)this.getOne((Wrapper)new LambdaQueryWrapper().eq(SysWelcomeConfig::getRoleId, (Object)1450785135866925064L));
                contents = this.sysVisualizeConfigService.getAllContents(params);
            } else {
                SysWelcomeParamVO welcomeParamVO = new SysWelcomeParamVO();
                String oId = ToolUtil.isEmpty((Object)organId) ? null : organId.toString();
                String pId = ToolUtil.isEmpty((Object)positionId) ? null : positionId.toString();
                String uId = ToolUtil.isEmpty((Object)userId) ? null : userId.toString();
                String rId = ToolUtil.isEmpty((Object)roleId) ? null : roleId.toString();
                welcomeParamVO.setOrganId(oId);
                welcomeParamVO.setPositionId(pId);
                welcomeParamVO.setUserId(uId);
                welcomeParamVO.setRoleId(rId);
                sysWelcomeConfig = ((SysWelcomeConfigMapper)this.getBaseMapper()).getWelcomeConfig(welcomeParamVO);
                if (ToolUtil.isEmpty((Object)sysWelcomeConfig)) {
                    sysWelcomeConfig = (SysWelcomeConfig)this.getOne((Wrapper)new LambdaQueryWrapper().eq(SysWelcomeConfig::getRoleId, (Object)1450785135866925064L));
                    contents = this.sysVisualizeConfigService.getAllContents(params);
                } else {
                    params.put("roleId", rId);
                    params.put("organId", oId);
                    params.put("positionId", pId);
                    params.put("userId", uId);
                    contents = this.sysVisualizeConfigService.getAllContents(params);
                }
            }
        } else {
            sysWelcomeConfig = (SysWelcomeConfig)this.getOne((Wrapper)new LambdaQueryWrapper().eq(SysWelcomeConfig::getUserId, (Object)userId));
            if (ToolUtil.isEmpty((Object)sysWelcomeConfig)) {
                Long masterOrganId = user.getDeptId();
                List organIds = this.sysStruService.getOrganIds(masterOrganId);
                List roles = user.getRolesList();
                if (ToolUtil.isNotEmpty((Object)roles)) {
                    Collections.sort(roles, (o1, o2) -> {
                        if (o1 < o2) {
                            return -1;
                        }
                        return 1;
                    });
                }
                ArrayList<Long> positionIds = new ArrayList<Long>();
                positionId = ToolUtil.isEmpty((Object)user.getExtendUserMap("postCurrent")) ? null : Long.valueOf(String.valueOf(user.getExtendUserMap("postCurrent")));
                positionIds.add(positionId);
                List<SysWelcomeConfig> allSysWelcomeConfigs = ((SysWelcomeConfigMapper)this.getBaseMapper()).getWelcomeConfigs(organIds, roles, positionIds);
                for (Long organId1 : organIds) {
                    if (!ToolUtil.isEmpty((Object)sysWelcomeConfig) || !ToolUtil.isNotEmpty((Object)positionId)) break;
                    for (SysWelcomeConfig sysWelcomeConfig1 : allSysWelcomeConfigs) {
                        if (!organId1.equals(sysWelcomeConfig1.getOrganId()) || !positionId.equals(sysWelcomeConfig1.getPositionId())) continue;
                        sysWelcomeConfig = sysWelcomeConfig1;
                        params.put("organId", ToolUtil.isEmpty((Object)organId1) ? null : organId1.toString());
                        params.put("positionId", ToolUtil.isEmpty((Object)positionId) ? null : positionId.toString());
                        contents = this.sysVisualizeConfigService.getAllContents(params);
                    }
                }
                if (ToolUtil.isEmpty((Object)sysWelcomeConfig) && ToolUtil.isNotEmpty((Object)roles)) {
                    block2: for (Long role : roles) {
                        if (!ToolUtil.isEmpty((Object)sysWelcomeConfig)) break;
                        for (Long organId1 : organIds) {
                            if (!ToolUtil.isEmpty((Object)sysWelcomeConfig)) continue block2;
                            for (SysWelcomeConfig sysWelcomeConfig1 : allSysWelcomeConfigs) {
                                if (!organId1.equals(sysWelcomeConfig1.getOrganId()) || !role.equals(sysWelcomeConfig1.getRoleId())) continue;
                                sysWelcomeConfig = sysWelcomeConfig1;
                                params.put("organId", ToolUtil.isEmpty((Object)organId1) ? null : organId1.toString());
                                params.put("roleId", ToolUtil.isEmpty((Object)role) ? null : role.toString());
                                contents = this.sysVisualizeConfigService.getAllContents(params);
                            }
                        }
                    }
                }
                if (ToolUtil.isEmpty((Object)sysWelcomeConfig)) {
                    for (Long organId1 : organIds) {
                        if (!ToolUtil.isEmpty((Object)sysWelcomeConfig)) break;
                        for (SysWelcomeConfig sysWelcomeConfig1 : allSysWelcomeConfigs) {
                            if (!organId1.equals(sysWelcomeConfig1.getOrganId()) || !ToolUtil.isEmpty((Object)sysWelcomeConfig1.getPositionId()) || !ToolUtil.isEmpty((Object)sysWelcomeConfig1.getRoleId())) continue;
                            sysWelcomeConfig = sysWelcomeConfig1;
                            params.put("organId", ToolUtil.isEmpty((Object)organId1) ? null : organId1.toString());
                            contents = this.sysVisualizeConfigService.getAllContents(params);
                        }
                    }
                }
                if (ToolUtil.isEmpty((Object)sysWelcomeConfig) && ToolUtil.isNotEmpty((Object)positionId)) {
                    for (SysWelcomeConfig sysWelcomeConfig1 : allSysWelcomeConfigs) {
                        if (!positionId.equals(sysWelcomeConfig1.getPositionId()) || !ToolUtil.isEmpty((Object)sysWelcomeConfig1.getOrganId()) || !ToolUtil.isEmpty((Object)sysWelcomeConfig1.getRoleId())) continue;
                        sysWelcomeConfig = sysWelcomeConfig1;
                        params.put("positionId", ToolUtil.isEmpty((Object)positionId) ? null : positionId.toString());
                        contents = this.sysVisualizeConfigService.getAllContents(params);
                    }
                }
                if (ToolUtil.isEmpty((Object)sysWelcomeConfig) && ToolUtil.isNotEmpty((Object)roles)) {
                    for (Long role : roles) {
                        if (!ToolUtil.isEmpty((Object)sysWelcomeConfig) || role.equals(1450785135866925064L)) break;
                        for (SysWelcomeConfig sysWelcomeConfig1 : allSysWelcomeConfigs) {
                            if (!role.equals(sysWelcomeConfig1.getRoleId()) || !ToolUtil.isEmpty((Object)sysWelcomeConfig1.getOrganId()) || !ToolUtil.isEmpty((Object)sysWelcomeConfig1.getPositionId())) continue;
                            sysWelcomeConfig = sysWelcomeConfig1;
                            params.put("roleId", ToolUtil.isEmpty((Object)role) ? null : role.toString());
                            contents = this.sysVisualizeConfigService.getAllContents(params);
                        }
                    }
                }
                if (ToolUtil.isEmpty((Object)sysWelcomeConfig) && ToolUtil.isNotEmpty((Object)roles)) {
                    sysWelcomeConfig = (SysWelcomeConfig)this.getOne((Wrapper)new LambdaQueryWrapper().eq(SysWelcomeConfig::getRoleId, (Object)1450785135866925064L));
                    contents = this.sysVisualizeConfigService.getAllContents(params);
                }
            } else {
                params.put("userId", ToolUtil.isEmpty((Object)userId) ? null : userId.toString());
                contents = this.sysVisualizeConfigService.getAllContents(params);
            }
        }
        List sysComponentsArrs = null;
        SysWelcomeParamVO welcomeParamVO = new SysWelcomeParamVO();
        if (ToolUtil.isNotEmpty((Object)sysWelcomeConfig)) {
            sysComponentsArrs = this.sysComponentsArrService.list((Wrapper)new LambdaQueryWrapper().eq(SysComponentsArr::getConfigId, (Object)sysWelcomeConfig.getId()));
            ArrayList oldSysComponentsArrs = new ArrayList(sysComponentsArrs);
            for (SysComponentsArr sysComponentsArr : oldSysComponentsArrs) {
                boolean delFlag = true;
                for (String content : contents) {
                    if (!sysComponentsArr.getName().equals(content)) continue;
                    delFlag = false;
                    break;
                }
                if (!delFlag) continue;
                sysComponentsArrs.remove(sysComponentsArr);
            }
            BeanUtils.copyProperties((Object)sysWelcomeConfig, (Object)welcomeParamVO);
        }
        welcomeParamVO.setComponentsArr(sysComponentsArrs);
        return welcomeParamVO;
    }
}

