/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.base.config.sysvisualizeconfig.service.impl;

import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.authorization.permit.service.ISysResourcesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleGroupService;
import com.jxdinfo.hussar.authorization.post.model.SysUserPostConcurrently;
import com.jxdinfo.hussar.authorization.post.service.ISysPostService;
import com.jxdinfo.hussar.authorization.post.service.UserPostConcurrentlyService;
import com.jxdinfo.hussar.base.config.sysvisualizeconfig.dao.SysVisualizeConfigMapper;
import com.jxdinfo.hussar.base.config.sysvisualizeconfig.model.SysVisualizeConfig;
import com.jxdinfo.hussar.base.config.sysvisualizeconfig.service.ISysVisualizeConfigService;
import com.jxdinfo.hussar.base.config.sysvisualizeconfig.vo.SysVisualizeParamVO;
import com.jxdinfo.hussar.base.config.sysvisualizeconfig.vo.WelcomeJSTreeModelVo;
import com.jxdinfo.hussar.common.constant.enums.SysUserAndRole;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class SysVisualizeConfigServiceImpl
extends HussarServiceImpl<SysVisualizeConfigMapper, SysVisualizeConfig>
implements ISysVisualizeConfigService {
    @Resource
    private ISysRoleGroupService sysRoleGroupService;
    @Resource
    private ISysPostService sysPostService;
    @Resource
    private UserPostConcurrentlyService userPostConcurrentlyService;
    @Resource
    private ISysResourcesService sysResourcesService;
    @Resource
    private SysVisualizeConfigMapper sysVisualizeConfigMapper;

    @HussarTransactional
    public boolean saveVisualize(SysVisualizeParamVO sysVisualizeParamVO) {
        String types;
        if (ToolUtil.isEmpty((Object)sysVisualizeParamVO)) {
            throw new BaseException("\u6b22\u8fce\u9875\u914d\u7f6evo\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ArrayList<SysVisualizeConfig> list = new ArrayList<SysVisualizeConfig>();
        List roleIds = sysVisualizeParamVO.getRoleIds();
        SecurityUser shiroUser = BaseSecurityUtil.getUser();
        String string = types = roleIds.size() <= 0 ? "0" : "1";
        if ("0".equals(types)) {
            roleIds.add(shiroUser.getId());
        }
        for (Long roleId : roleIds) {
            String key = "welcome_config" + roleId + ":" + types;
            HussarCacheUtil.evict((String)"welcome_config", (Object)key);
        }
        this.remove((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(SysVisualizeConfig::getUserId, (Collection)roleIds)).eq(SysVisualizeConfig::getTypes, (Object)types));
        this.setLeftComList(sysVisualizeParamVO.getLeftComList1(), roleIds, types, 1, list);
        this.setLeftComList(sysVisualizeParamVO.getLeftComList2(), roleIds, types, 2, list);
        this.setLeftComList(sysVisualizeParamVO.getLeftComList3(), roleIds, types, 3, list);
        this.setLeftComList(sysVisualizeParamVO.getLeftComList4(), roleIds, types, 4, list);
        this.setLeftComList(sysVisualizeParamVO.getWelcomeBg(), roleIds, types, 5, list);
        if (list.size() == 0) {
            return true;
        }
        return this.saveBatch(list);
    }

    private void setLeftComList(List<SysVisualizeConfig> leftComList, List<Long> roles, String types, Integer listId, List<SysVisualizeConfig> sysVisualizeConfigs) {
        for (int i = 0; i < leftComList.size(); ++i) {
            SysVisualizeConfig sysVisualizeConfig = leftComList.get(i);
            sysVisualizeConfig.setTypes(types);
            sysVisualizeConfig.setListId(listId);
            sysVisualizeConfig.setSEQ(Integer.valueOf(i));
            roles.parallelStream().forEach(str -> {
                sysVisualizeConfig.setUserId(str);
                sysVisualizeConfigs.add(sysVisualizeConfig);
            });
        }
    }

    public SysVisualizeParamVO queryVisualizeList(Long roleId) {
        ArrayList<Long> roles = new ArrayList<Long>();
        SecurityUser user = BaseSecurityUtil.getUser();
        Long userId = ToolUtil.isEmpty((Object)roleId) ? user.getId() : roleId;
        String type = ToolUtil.isEmpty((Object)roleId) ? "0" : "1";
        String key = "welcome_config" + userId + ":" + type;
        SysVisualizeParamVO visualizeVo = null;
        Object object = HussarCacheUtil.get((String)"welcome_config", (Object)key);
        if (ToolUtil.isEmpty((Object)object)) {
            List list = this.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysVisualizeConfig::getTypes, (Object)type)).eq(SysVisualizeConfig::getUserId, (Object)userId));
            if (list.size() <= 0 && ToolUtil.isEmpty((Object)roleId)) {
                list = HussarUtils.isNotEmpty((Object)user.getRolesList()) ? this.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysVisualizeConfig::getTypes, (Object)"1")).eq(SysVisualizeConfig::getUserId, user.getRolesList().get(0))) : this.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysVisualizeConfig::getTypes, (Object)"1")).eq(SysVisualizeConfig::getUserId, (Object)SysUserAndRole.PUBLIC_ROLE.getValue()));
            }
            if (ToolUtil.isNotEmpty((Object)roleId)) {
                roles.add(userId);
            }
            SysVisualizeParamVO sysVisualizeParamVO = new SysVisualizeParamVO();
            sysVisualizeParamVO.setRoleIds(roles);
            sysVisualizeParamVO.setLeftComList1(this.getLeftComList(list, 1));
            sysVisualizeParamVO.setLeftComList2(this.getLeftComList(list, 2));
            sysVisualizeParamVO.setLeftComList3(this.getLeftComList(list, 3));
            sysVisualizeParamVO.setLeftComList4(this.getLeftComList(list, 4));
            sysVisualizeParamVO.setWelcomeBg(this.getLeftComList(list, 5));
            visualizeVo = sysVisualizeParamVO;
        } else {
            visualizeVo = (SysVisualizeParamVO)object;
        }
        return visualizeVo;
    }

    public ApiResponse recoveryDefault() {
        SecurityUser user = BaseSecurityUtil.getUser();
        boolean result = this.remove((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysVisualizeConfig::getTypes, (Object)"0")).eq(SysVisualizeConfig::getUserId, (Object)user.getId()));
        if (!result) {
            throw new BaseException("\u5f53\u524d\u7528\u6237\u672a\u914d\u7f6e\u4e2a\u6027\u5316\u6b22\u8fce\u9875\uff01");
        }
        String key = "welcome_config" + user.getId() + ":" + "0";
        HussarCacheUtil.evict((String)"welcome_config", (Object)key);
        return ApiResponse.success((String)"\u4e2a\u6027\u5316\u6b22\u8fce\u9875\u914d\u7f6e\u91cd\u7f6e\u6210\u529f");
    }

    private List<SysVisualizeConfig> getLeftComList(List<SysVisualizeConfig> list, Integer index) {
        return list.parallelStream().filter(sysVisualizeConfig -> sysVisualizeConfig.getListId() == index).sorted(Comparator.comparing(SysVisualizeConfig::getSEQ)).collect(Collectors.toList());
    }

    public List<String> queryUserIds() {
        return ((SysVisualizeConfigMapper)this.baseMapper).selectUserIdsByTypes();
    }

    public List<WelcomeJSTreeModelVo> queryLazyRoleTree(Long nodeId) {
        if (ToolUtil.isEmpty((Object)nodeId)) {
            throw new BaseException("\u8282\u70b9id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List jsTreeModels = this.sysRoleGroupService.getLazyRoleTree(nodeId);
        ArrayList<WelcomeJSTreeModelVo> welcomeJSTreeModelVos = new ArrayList<WelcomeJSTreeModelVo>();
        List<String> userIds = this.queryUserIds();
        jsTreeModels.stream().forEach(jsTreeModel -> {
            WelcomeJSTreeModelVo welcomeJSTreeModelVo = new WelcomeJSTreeModelVo();
            BeanUtils.copyProperties((Object)jsTreeModel, (Object)welcomeJSTreeModelVo);
            welcomeJSTreeModelVo.setShowAdd(userIds.contains(jsTreeModel.getId().toString()));
            welcomeJSTreeModelVos.add(welcomeJSTreeModelVo);
        });
        return welcomeJSTreeModelVos;
    }

    public List<String> getAllContents(Map<String, String> params) {
        Long positionId;
        List<Long> roleIds = new ArrayList<Long>();
        if (ToolUtil.isNotEmpty((Object)params.get("roleId"))) {
            Long roleId = Long.valueOf(params.get("roleId"));
            roleIds.add(roleId);
        }
        if (roleIds.size() > 0 && ToolUtil.isNotEmpty((Object)params.get("positionId"))) {
            throw new BaseException("\u5c97\u4f4d\u548c\u89d2\u8272\u4fe1\u606f\u5f02\u5e38");
        }
        if (ToolUtil.isNotEmpty((Object)params.get("positionId"))) {
            positionId = Long.valueOf(params.get("positionId"));
            Long organId = ToolUtil.isNotEmpty((Object)params.get("organId")) ? Long.valueOf(params.get("organId")) : null;
            List roleId = this.sysPostService.getRoleIdByPostAndStru(positionId, organId);
            roleIds.addAll(roleId);
        }
        if (ToolUtil.isNotEmpty((Object)params.get("userId"))) {
            SecurityUser currentUser = BaseSecurityUtil.getUser();
            assert (currentUser != null);
            roleIds = currentUser.getRolesList();
            roleIds.add(SysUserAndRole.PUBLIC_ROLE.getValue());
            Long l = positionId = ToolUtil.isEmpty((Object)currentUser.getExtendUserMap("postCurrent")) ? null : Long.valueOf(String.valueOf(currentUser.getExtendUserMap("postCurrent")));
            if (ToolUtil.isNotEmpty((Object)positionId)) {
                Long mainPositionId = ToolUtil.isEmpty((Object)currentUser.getExtendUserMap("postMain")) ? null : Long.valueOf(String.valueOf(currentUser.getExtendUserMap("postMain")));
                Long struId = null;
                if (!positionId.equals(mainPositionId)) {
                    Long currentId = ToolUtil.isEmpty((Object)currentUser.getExtendUserMap("postCurrentId")) ? null : Long.valueOf(String.valueOf(currentUser.getExtendUserMap("postCurrentId")));
                    SysUserPostConcurrently userPostConcurrently = (SysUserPostConcurrently)this.userPostConcurrentlyService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysUserPostConcurrently::getUpId, (Object)currentId));
                    if (ToolUtil.isNotEmpty((Object)userPostConcurrently)) {
                        struId = userPostConcurrently.getUpStruId();
                    }
                } else {
                    struId = currentUser.getDeptId();
                }
                List roleId = this.sysPostService.getRoleIdByPostAndStru(positionId, struId);
                roleIds.addAll(roleId);
            }
            return this.sysResourcesService.getAllContents(roleIds);
        }
        roleIds.add(SysUserAndRole.PUBLIC_ROLE.getValue());
        return this.sysResourcesService.getAllContents(roleIds);
    }

    @DSTransactional
    public ApiResponse recoverWelcome() {
        SecurityUser user = BaseSecurityUtil.getUser();
        String configId = "";
        try {
            configId = this.sysVisualizeConfigMapper.getConfigIdByUserId(user.getId());
        }
        catch (Exception e) {
            throw new BaseException("\u7528\u6237\u5b58\u5728\u591a\u6761\u6b22\u8fce\u9875\u914d\u7f6e\u4fe1\u606f");
        }
        if (configId == null || "".equals(configId)) {
            return ApiResponse.success();
        }
        this.sysVisualizeConfigMapper.deleteConfigByUserId(user.getId());
        this.sysVisualizeConfigMapper.deleteVisualizeByConfigId(Long.valueOf(configId));
        return ApiResponse.success((String)"\u6b22\u8fce\u9875\u914d\u7f6e\u521d\u59cb\u5316\u6210\u529f");
    }
}

