/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.base.config.baseconfig.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.base.config.baseconfig.dao.SysBaseConfigMapper;
import com.jxdinfo.hussar.base.config.baseconfig.model.SysBaseConfig;
import com.jxdinfo.hussar.base.config.baseconfig.service.ISysBaseConfigService;
import com.jxdinfo.hussar.base.config.baseconfig.service.SysBaseConfigService;
import com.jxdinfo.hussar.base.config.baseconfig.vo.TextValueVo;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class BaseConfigServiceImpl
extends HussarServiceImpl<SysBaseConfigMapper, SysBaseConfig>
implements SysBaseConfigService {
    @Resource
    private SysBaseConfigMapper baseConfigMapper;
    @Resource
    private SysBaseConfigService sysBaseConfigService;
    @Resource
    private ISysBaseConfigService iSysBaseConfigService;

    public ApiResponse<Map<String, Object>> queryPersonalBaseConfigList(String personalizedType) {
        String type;
        if (ToolUtil.isEmpty((Object)personalizedType)) {
            throw new BaseException("\u4e2a\u6027\u5316\u914d\u7f6e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        LambdaQueryWrapper ew = new LambdaQueryWrapper();
        ew.orderByAsc(SysBaseConfig::getId);
        String parentId = "login".equals(personalizedType) ? "202020" : "212121";
        ew.eq(SysBaseConfig::getParentId, (Object)Long.valueOf(parentId));
        List list = this.list((Wrapper)ew);
        HashMap<String, String> dataMap = new HashMap<String, String>();
        for (SysBaseConfig s : list) {
            dataMap.put(s.getConfigKey(), s.getConfigValue());
        }
        if ("202020".equals(parentId) && ("2".equals(type = dataMap.get("login_view_type").toString()) || "3".equals(type))) {
            TextValueVo sysName = this.sysBaseConfigService.getSysName();
            TextValueVo congratulation = this.sysBaseConfigService.getCongratulations();
            dataMap.put("login_view_sysname", sysName == null ? "" : sysName.getTextValue());
            dataMap.put("sysnameType", sysName == null ? "" : sysName.getTextType());
            dataMap.put("login_congratulations", congratulation == null ? "" : congratulation.getTextValue());
            dataMap.put("congratulationType", congratulation == null ? "" : congratulation.getTextType());
        }
        return ApiResponse.success(dataMap);
    }

    @HussarTransactional
    public ApiResponse updateBatchPersonalBaseConfig(List<SysBaseConfig> baseConfigList) {
        ISysBaseConfigService iSysBaseConfigService;
        SysBaseConfig failNumberConfig;
        String tryLoginTime;
        int lockNum;
        int codeNum;
        if (ToolUtil.isEmpty(baseConfigList)) {
            throw new BaseException("\u4e2a\u6027\u5316\u914d\u7f6e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ArrayList configKeyList = new ArrayList();
        ArrayList<Map<String, String>> upList = new ArrayList<Map<String, String>>();
        for (SysBaseConfig sysBaseConfig : baseConfigList) {
            HashMap<String, String> mapText;
            if ("login_view_sysname".equals(sysBaseConfig.getConfigKey())) {
                mapText = new HashMap<String, String>();
                mapText.put("textKey", "login_view_sysname");
                mapText.put("textValue", sysBaseConfig.getConfigValue());
                mapText.put("textType", sysBaseConfig.getExample());
                if (ToolUtil.isNotEmpty((Object)sysBaseConfig.getConfigValue())) {
                    upList.add(mapText);
                }
            }
            if (!"login_congratulations".equals(sysBaseConfig.getConfigKey())) continue;
            mapText = new HashMap();
            mapText.put("textKey", "login_congratulations");
            mapText.put("textValue", sysBaseConfig.getConfigValue());
            mapText.put("textType", sysBaseConfig.getExample());
            upList.add(mapText);
        }
        this.baseConfigMapper.updateNewText(upList);
        HashMap map = new HashMap();
        baseConfigList.forEach(bc -> {
            configKeyList.add(bc.getConfigKey());
            map.put(bc.getConfigKey(), bc.getConfigValue());
        });
        if (ToolUtil.isNotEmpty(map.get("login_wrong_time")) && (codeNum = Integer.parseInt((String)map.get("login_wrong_time"))) > (lockNum = Integer.parseInt(tryLoginTime = (failNumberConfig = (iSysBaseConfigService = (ISysBaseConfigService)SpringContextHolder.getBean(ISysBaseConfigService.class)).getSysBaseConfig("fail_number")).getConfigValue()))) {
            String msg = "\u4e0d\u80fd\u5927\u4e8e\u8d26\u53f7\u5bc6\u7801\u9501\u5b9a\u7684\u6b21\u6570\uff0c" + lockNum + "\u6b21";
            return ApiResponse.fail((String)msg);
        }
        configKeyList.remove("login_view_sysname");
        configKeyList.remove("login_congratulations");
        List updateList = this.list((Wrapper)new LambdaQueryWrapper().in(SysBaseConfig::getConfigKey, configKeyList));
        updateList.forEach(bc -> bc.setConfigValue((String)map.get(bc.getConfigKey())));
        boolean result = this.saveOrUpdateBatch(updateList);
        if (!result) {
            throw new BaseException("\u4fee\u6539\u5931\u8d25\uff01");
        }
        return ApiResponse.success((String)"\u4fee\u6539\u6210\u529f\uff01");
    }

    public String getLoginWrongTime() {
        SysBaseConfig baseConfig = this.iSysBaseConfigService.getSysBaseConfig("login_wrong_time");
        return baseConfig.getConfigValue();
    }

    public TextValueVo getSysName() {
        return this.baseConfigMapper.selectText("login_view_sysname");
    }

    public TextValueVo getCongratulations() {
        return this.baseConfigMapper.selectText("login_congratulations");
    }
}

