/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.base.config.baseconfig.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jxdinfo.hussar.authentication.dto.AuthcDto;
import com.jxdinfo.hussar.authentication.lock.LoginLock;
import com.jxdinfo.hussar.authorization.enums.UserStatus;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.base.config.baseconfig.model.SysBaseConfig;
import com.jxdinfo.hussar.base.config.baseconfig.service.IHussarLoginConfigService;
import com.jxdinfo.hussar.base.config.baseconfig.service.IPageViewConfigService;
import com.jxdinfo.hussar.base.config.baseconfig.service.SysBaseConfigService;
import com.jxdinfo.hussar.base.config.baseconfig.vo.TextValueVo;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.annotation.Inner;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.support.mp.base.controller.HussarBaseController;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/baseConfigFront"})
@Api(tags={"\u8fd0\u884c\u53c2\u6570\u914d\u7f6e"})
public class BaseConfigFrontController
extends HussarBaseController<SysBaseConfig, SysBaseConfigService> {
    @Resource
    private SysBaseConfigService sysBaseConfigService;
    @Resource
    private IPageViewConfigService pageViewConfigService;
    @Resource
    private ISysUsersService iSysUsersService;
    @Resource
    private IHussarLoginConfigService hussarLoginConfigService;
    private static final String[] EXCLUDE_USER = new String[]{"superadmin", "businessadmin", "auditadmin", "reviewadmin", "systemadmin", "hussar"};

    @ApiOperation(value="\u4fee\u6539\u767b\u5f55\u9875/\u6b22\u8fce\u9875\u53ef\u89c6\u5316\u914d\u7f6e\u4fe1\u606f", notes="\u4fee\u6539\u767b\u5f55\u9875/\u6b22\u8fce\u9875\u53ef\u89c6\u5316\u914d\u7f6e\u4fe1\u606f")
    @PostMapping(value={"/viewUpdate"})
    @CacheEvict(value={"base_config"}, allEntries=true)
    @AuditLog(moduleName="\u8fd0\u884c\u53c2\u6570\u914d\u7f6e", eventDesc="\u4fee\u6539\u767b\u5f55\u9875/\u6b22\u8fce\u9875\u53ef\u89c6\u5316\u914d\u7f6e\u4fe1\u606f", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse viewUpdate(@ApiParam(value="\u767b\u5f55\u9875/\u6b22\u8fce\u9875\u914d\u7f6e\u4fe1\u606f\u96c6\u5408") @RequestBody List<SysBaseConfig> baseConfigList) {
        return this.sysBaseConfigService.updateBatchPersonalBaseConfig(baseConfigList);
    }

    @ApiOperation(value="\u83b7\u53d6\u767b\u5f55\u9875/\u6b22\u8fce\u9875\u53ef\u89c6\u5316\u914d\u7f6e\u4fe1\u606f", notes="\u83b7\u53d6\u767b\u5f55\u9875/\u6b22\u8fce\u9875\u53ef\u89c6\u5316\u914d\u7f6e\u4fe1\u606f")
    @GetMapping(value={"/viewList"})
    @AuditLog(moduleName="\u8fd0\u884c\u53c2\u6570\u914d\u7f6e", eventDesc="\u83b7\u53d6\u767b\u5f55\u9875/\u6b22\u8fce\u9875\u53ef\u89c6\u5316\u914d\u7f6e\u4fe1\u606f", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<Map<String, Object>> viewList(@ApiParam(value="\u4e2a\u6027\u5316\u914d\u7f6e\u7c7b\u578b") @RequestParam String personalizedType) {
        return this.sysBaseConfigService.queryPersonalBaseConfigList(personalizedType);
    }

    @GetMapping(value={"/getLoginViewInfo"})
    @ApiOperation(value="\u83b7\u53d6\u767b\u5f55\u9875\u52a8\u6001\u53ef\u89c6\u5316\u914d\u7f6e\u4fe1\u606f", notes="\u83b7\u53d6\u767b\u5f55\u9875\u52a8\u6001\u53ef\u89c6\u5316\u914d\u7f6e\u4fe1\u606f")
    @Inner
    public ApiResponse<Map<String, Object>> loginViewInfo() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String type = this.pageViewConfigService.getLoginViewType();
        map.put("type", type);
        map.put("copyright", this.pageViewConfigService.getLoginViewCopyright());
        map.put("logo", this.pageViewConfigService.getLoginViewLogo());
        map.put("kaptcha", this.pageViewConfigService.isLoginViewKaptcha());
        map.put("rememberpwd", this.pageViewConfigService.isLoginRememberpwd());
        map.put("background", this.pageViewConfigService.getLoginViewBackground());
        map.put("innerBackground", this.pageViewConfigService.getLoginViewInnerBackground());
        map.put("wrongTime", this.sysBaseConfigService.getLoginWrongTime());
        if (type.equals("2") || type.equals("3")) {
            TextValueVo sysName = this.sysBaseConfigService.getSysName();
            map.put("sysname", sysName.getTextValue());
            map.put("sysnameType", sysName.getTextType());
            TextValueVo congratulation = this.sysBaseConfigService.getCongratulations();
            map.put("congratulation", congratulation.getTextValue());
            map.put("congratulationType", congratulation.getTextType());
        } else {
            map.put("sysname", this.pageViewConfigService.getLoginViewSysname());
        }
        return ApiResponse.success(map);
    }

    @PostMapping(value={"/getWrongTime"})
    @Inner
    public ApiResponse<Map> getWrongTime(@RequestBody AuthcDto authcDto) {
        String account = authcDto.getUsername();
        if (!this.hussarLoginConfigService.getLoginUpperOpen().booleanValue() && !ArrayUtils.contains((Object[])EXCLUDE_USER, (Object)authcDto.getUsername())) {
            account = authcDto.getUsername().toUpperCase();
        }
        SysUsers sysUsers = (SysUsers)this.iSysUsersService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(SysUsers::getUserAccount, (Object)account)).ne(SysUsers::getAccountStatus, (Object)UserStatus.DELETE.getCode())).ne(SysUsers::getAccountStatus, (Object)UserStatus.CANCEL.getCode()), false);
        LoginLock loginLock = (LoginLock)SpringContextHolder.getBean(LoginLock.class);
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        String userId = "";
        if (ToolUtil.isEmpty((Object)sysUsers)) {
            map.put("wrongTime", 0);
            return ApiResponse.success(map);
        }
        userId = String.valueOf(sysUsers.getId());
        int num = loginLock.userLockNum(userId);
        map.put("wrongTime", num);
        return ApiResponse.success(map);
    }
}

