/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.config.extend.migration.service.impl;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.config.extend.migration.dto.ConfigExcelCheckResult;
import com.jxdinfo.hussar.config.extend.migration.dto.ConfigFormatCheckResult;
import com.jxdinfo.hussar.config.extend.migration.excel.entity.ConfigInfoExcel;
import com.jxdinfo.hussar.config.extend.migration.util.ConfigFormatCheckUtil;
import com.jxdinfo.hussar.config.manager.plugin.mybatis.dto.GetConfigInfoDto;
import com.jxdinfo.hussar.config.manager.plugin.mybatis.service.ConfigInfoDaoService;
import com.jxdinfo.hussar.excel.model.ExcelCheckResult;
import com.jxdinfo.hussar.excel.model.ExcelImportMsg;
import com.jxdinfo.hussar.excel.service.IHussarBaseCustomExcelService;
import com.jxdinfo.hussar.excel.validate.HussarBaseExcelValidateHelper;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.config.manager.core.service.HussarConfigImportService;
import com.jxdinfo.hussar.support.config.manager.core.vo.ConfigImportDto;
import com.jxdinfo.hussar.support.config.manager.entity.ConfigInfoEntity;
import com.jxdinfo.hussar.support.config.manager.entity.ConfigOptionEntity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="com.jxdinfo.hussar.config.extend.migration.service.impl.HussarConfigCustomExcelServiceImpl")
public class HussarConfigCustomExcelServiceImpl
implements IHussarBaseCustomExcelService<ConfigInfoExcel> {
    @Autowired
    private ConfigInfoDaoService configInfoDaoService;
    @Autowired
    private HussarConfigImportService configImportService;

    public ExcelCheckResult check(List<ConfigInfoExcel> datas, Long taskId, List<Object> otherParams) throws Exception {
        ArrayList<ConfigInfoExcel> rootDataList = new ArrayList<ConfigInfoExcel>(datas);
        ArrayList<ConfigInfoExcel> successDataList = new ArrayList<ConfigInfoExcel>();
        ArrayList<ExcelImportMsg<ConfigInfoExcel>> newDataList = new ArrayList<ExcelImportMsg<ConfigInfoExcel>>();
        ArrayList<ExcelImportMsg<ConfigInfoExcel>> updateDataList = new ArrayList<ExcelImportMsg<ConfigInfoExcel>>();
        ArrayList<ExcelImportMsg<ConfigInfoExcel>> existDataList = new ArrayList<ExcelImportMsg<ConfigInfoExcel>>();
        ArrayList<ExcelImportMsg<ConfigInfoExcel>> errorDataList = new ArrayList<ExcelImportMsg<ConfigInfoExcel>>();
        ConfigExcelCheckResult configExcelCheckResult = new ConfigExcelCheckResult();
        this.configCheck(rootDataList, successDataList, newDataList, updateDataList, existDataList, errorDataList);
        configExcelCheckResult.setRootNum(datas.size());
        configExcelCheckResult.setErrorNum(errorDataList.size());
        if (HussarUtils.isNotEmpty(errorDataList)) {
            configExcelCheckResult.setNewNum(newDataList.size());
            configExcelCheckResult.setUpdateNum(updateDataList.size());
            configExcelCheckResult.setExistNum(existDataList.size());
        }
        ExcelCheckResult excelCheckResult = new ExcelCheckResult(rootDataList, successDataList, errorDataList, newDataList, updateDataList, existDataList);
        excelCheckResult.setCheckMsg((Object)configExcelCheckResult);
        return excelCheckResult;
    }

    private void configCheck(List<ConfigInfoExcel> rootDataList, List<ConfigInfoExcel> successDataList, List<ExcelImportMsg<ConfigInfoExcel>> newDataList, List<ExcelImportMsg<ConfigInfoExcel>> updateDataList, List<ExcelImportMsg<ConfigInfoExcel>> existDataList, List<ExcelImportMsg<ConfigInfoExcel>> errorDataList) {
        List result = this.configInfoDaoService.getConfigInfo(new GetConfigInfoDto());
        ArrayList<ConfigInfoExcel> configInfoExcels = new ArrayList<ConfigInfoExcel>();
        for (ConfigInfoEntity configInfoEntity : result) {
            ConfigInfoExcel configInfoExcel = (ConfigInfoExcel)BeanUtil.copyProperties((Object)configInfoEntity, ConfigInfoExcel.class);
            List configOptions = configInfoEntity.getConfigOptions();
            if (HussarUtils.isNotEmpty((Object)configOptions)) {
                List OptionValues = configOptions.stream().map(ConfigOptionEntity::getOptionValue).collect(Collectors.toList());
                configInfoExcel.setConfigOptionValues(JSON.toJSONString(OptionValues));
            }
            configInfoExcels.add(configInfoExcel);
        }
        Map<String, ConfigInfoExcel> configKey2Excel = configInfoExcels.stream().collect(Collectors.toMap(ConfigInfoExcel::getConfigKey, Function.identity()));
        HashSet<String> configKeyRecord = new HashSet<String>();
        for (int i = 0; i < rootDataList.size(); ++i) {
            HashMap<Integer, Map<Integer, String>> cellErrColMap = new HashMap<Integer, Map<Integer, String>>();
            HashMap<Integer, Map<Integer, String>> cellUpdateColMap = new HashMap<Integer, Map<Integer, String>>();
            HashMap<Integer, Map<Integer, String>> cellNewColMap = new HashMap<Integer, Map<Integer, String>>();
            HashMap<Integer, Map<Integer, String>> cellExitColMap = new HashMap<Integer, Map<Integer, String>>();
            ConfigInfoExcel configInfoExcel = rootDataList.get(i);
            this.checkFormat(i, cellErrColMap, configInfoExcel, configKeyRecord);
            if (HussarUtils.isNotEmpty(cellErrColMap)) {
                errorDataList.add((ExcelImportMsg<ConfigInfoExcel>)new ExcelImportMsg((Object)configInfoExcel, cellErrColMap));
                continue;
            }
            this.checkContactInfoForExit(i, cellNewColMap, cellExitColMap, cellUpdateColMap, configKey2Excel, configInfoExcel);
            if (HussarUtils.isNotEmpty(cellExitColMap)) {
                existDataList.add((ExcelImportMsg<ConfigInfoExcel>)new ExcelImportMsg((Object)configInfoExcel, cellExitColMap));
                continue;
            }
            if (HussarUtils.isNotEmpty(cellUpdateColMap)) {
                updateDataList.add((ExcelImportMsg<ConfigInfoExcel>)new ExcelImportMsg((Object)configInfoExcel, cellUpdateColMap));
                continue;
            }
            if (!HussarUtils.isNotEmpty(cellNewColMap)) continue;
            newDataList.add((ExcelImportMsg<ConfigInfoExcel>)new ExcelImportMsg((Object)configInfoExcel, cellNewColMap));
        }
    }

    private void checkFormat(int i, Map<Integer, Map<Integer, String>> cellErrColMap, ConfigInfoExcel configInfoExcel, Set<String> configKeyRecord) {
        ConfigFormatCheckResult checkConfigOption;
        ConfigFormatCheckResult checkConfigDesc;
        ConfigFormatCheckResult checkConfigValueWithType;
        ConfigFormatCheckResult checkValueType;
        ConfigFormatCheckResult checkConfigValue;
        ConfigFormatCheckResult checkConfigName;
        if (configKeyRecord.contains(configInfoExcel.getConfigKey())) {
            HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)0, (String)"\u914d\u7f6e\u6807\u8bc6\u91cd\u590d", cellErrColMap);
        }
        configKeyRecord.add(configInfoExcel.getConfigKey());
        ConfigFormatCheckResult checkConfigKey = ConfigFormatCheckUtil.checkConfigKey((String)configInfoExcel.getConfigKey());
        if (!checkConfigKey.isSuccess()) {
            HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)0, (String)checkConfigKey.getMsg(), cellErrColMap);
        }
        if (!(checkConfigName = ConfigFormatCheckUtil.checkConfigName((String)configInfoExcel.getConfigName())).isSuccess()) {
            HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)1, (String)checkConfigName.getMsg(), cellErrColMap);
        }
        if (!(checkConfigValue = ConfigFormatCheckUtil.checkConfigValue((String)configInfoExcel.getConfigValue())).isSuccess()) {
            HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)2, (String)checkConfigValue.getMsg(), cellErrColMap);
        }
        if (!(checkValueType = ConfigFormatCheckUtil.checkValueType((String)configInfoExcel.getValueType())).isSuccess()) {
            HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)3, (String)checkValueType.getMsg(), cellErrColMap);
        }
        if (checkConfigValue.isSuccess() && checkValueType.isSuccess() && !(checkConfigValueWithType = ConfigFormatCheckUtil.checkConfigValueWithType((String)configInfoExcel.getConfigValue(), (String)configInfoExcel.getValueType())).isSuccess()) {
            HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)2, (String)checkConfigValueWithType.getMsg(), cellErrColMap);
            HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)3, (String)checkConfigValueWithType.getMsg(), cellErrColMap);
        }
        if (!(checkConfigDesc = ConfigFormatCheckUtil.checkConfigDisc((String)configInfoExcel.getConfigDesc())).isSuccess()) {
            HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)4, (String)checkConfigDesc.getMsg(), cellErrColMap);
        }
        if (!(checkConfigOption = ConfigFormatCheckUtil.checkConfigOption((String)configInfoExcel.getConfigOptionValues())).isSuccess()) {
            HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)5, (String)checkConfigOption.getMsg(), cellErrColMap);
        }
        ConfigFormatCheckResult optionContainValue = ConfigFormatCheckUtil.checkOptionContainValue((String)configInfoExcel.getConfigKey(), (String)configInfoExcel.getConfigOptionValues());
        if (!checkConfigOption.isSuccess()) {
            HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)3, (String)optionContainValue.getMsg(), cellErrColMap);
            HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)5, (String)optionContainValue.getMsg(), cellErrColMap);
        }
    }

    private void checkContactInfoForExit(int i, Map<Integer, Map<Integer, String>> cellNewColMap, Map<Integer, Map<Integer, String>> cellExitColMap, Map<Integer, Map<Integer, String>> cellUpdateColMap, Map<String, ConfigInfoExcel> configKey2Excel, ConfigInfoExcel configInfoExcel) {
        int[] indexArrAdd = new int[]{0};
        if (!configKey2Excel.containsKey(configInfoExcel.getConfigKey())) {
            HussarBaseExcelValidateHelper.addMsgBatch((int)i, (String)"add", cellNewColMap, (int[])indexArrAdd, ConfigInfoExcel.class);
            return;
        }
        ConfigInfoExcel exitConfig = configKey2Excel.get(configInfoExcel.getConfigKey());
        if (exitConfig.equals((Object)configInfoExcel)) {
            HussarBaseExcelValidateHelper.addMsgBatch((int)i, (String)"exit", cellExitColMap, (int[])indexArrAdd, ConfigInfoExcel.class);
            return;
        }
        if (!Objects.equals(exitConfig.getConfigName(), configInfoExcel.getConfigName())) {
            HussarBaseExcelValidateHelper.addUpdateMsg((int)i, (int)1, (String)"\u66f4\u65b0\u914d\u7f6e\u540d\u79f0", cellUpdateColMap);
        }
        if (!Objects.equals(exitConfig.getConfigValue(), configInfoExcel.getConfigValue())) {
            HussarBaseExcelValidateHelper.addUpdateMsg((int)i, (int)2, (String)"\u66f4\u65b0\u914d\u7f6e\u503c", cellUpdateColMap);
        }
        if (!Objects.equals(exitConfig.getValueType(), configInfoExcel.getValueType())) {
            HussarBaseExcelValidateHelper.addUpdateMsg((int)i, (int)3, (String)"\u66f4\u65b0\u914d\u7f6e\u503c\u7c7b\u578b", cellUpdateColMap);
        }
        if (!Objects.equals(exitConfig.getConfigDesc(), configInfoExcel.getConfigDesc())) {
            HussarBaseExcelValidateHelper.addUpdateMsg((int)i, (int)4, (String)"\u66f4\u65b0\u914d\u7f6e\u63cf\u8ff0", cellUpdateColMap);
        }
        if (!Objects.equals(exitConfig.getConfigOptionValues(), configInfoExcel.getConfigOptionValues())) {
            HussarBaseExcelValidateHelper.addUpdateMsg((int)i, (int)5, (String)"\u66f4\u65b0\u914d\u7f6e\u53ef\u9009\u9879", cellUpdateColMap);
        }
    }

    public void saveData(List<ConfigInfoExcel> datas, List<Object> otherParams) {
        List importDtoList = BeanUtil.copyProperties(datas, ConfigImportDto.class);
        this.configImportService.importDate(importDtoList, Boolean.valueOf(true), Boolean.valueOf(false));
    }

    public void updateData(List<ConfigInfoExcel> datas, List<Object> otherParams) {
        List importDtoList = BeanUtil.copyProperties(datas, ConfigImportDto.class);
        this.configImportService.importDate(importDtoList, Boolean.valueOf(false), Boolean.valueOf(true));
    }
}

