/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.config.extend.migration.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.jxdinfo.hussar.config.extend.migration.dto.ConfigExcelCheckResult;
import com.jxdinfo.hussar.config.extend.migration.dto.ConfigFormatCheckResult;
import com.jxdinfo.hussar.config.extend.migration.excel.entity.ConfigInfoExcel;
import com.jxdinfo.hussar.config.extend.migration.util.ConfigFormatCheckUtil;
import com.jxdinfo.hussar.config.manager.plugin.mybatis.dto.GetConfigGroupDto;
import com.jxdinfo.hussar.config.manager.plugin.mybatis.dto.GetConfigInfoDto;
import com.jxdinfo.hussar.config.manager.plugin.mybatis.service.ConfigInfoDaoMigrationService;
import com.jxdinfo.hussar.config.manager.plugin.mybatis.service.ConfigInfoDaoService;
import com.jxdinfo.hussar.config.manager.plugin.mybatis.service.ConfigOptionDaoService;
import com.jxdinfo.hussar.config.manager.plugin.mybatis.service.impl.ConfigGroupDaoServiceImpl;
import com.jxdinfo.hussar.excel.model.ExcelCheckResult;
import com.jxdinfo.hussar.excel.model.ExcelImportMsg;
import com.jxdinfo.hussar.excel.service.IHussarBaseCustomExcelService;
import com.jxdinfo.hussar.excel.validate.HussarBaseExcelValidateHelper;
import com.jxdinfo.hussar.platform.core.base.entity.HussarTenantEntity;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.DigestUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.IdUtil;
import com.jxdinfo.hussar.platform.core.utils.IpUtils;
import com.jxdinfo.hussar.support.config.manager.core.constants.ConfigConstant;
import com.jxdinfo.hussar.support.config.manager.core.dto.ConfigGroupDto;
import com.jxdinfo.hussar.support.config.manager.core.enums.ValueSourceEnum;
import com.jxdinfo.hussar.support.config.manager.core.util.SetTenantUtil;
import com.jxdinfo.hussar.support.config.manager.entity.ConfigGroupEntity;
import com.jxdinfo.hussar.support.config.manager.entity.ConfigInfoEntity;
import com.jxdinfo.hussar.support.config.manager.entity.ConfigOptionEntity;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="com.jxdinfo.hussar.config.extend.migration.service.impl.HussarConfigCustomExcelServiceImpl")
public class HussarConfigCustomExcelServiceImpl
implements IHussarBaseCustomExcelService<ConfigInfoExcel> {
    @Autowired
    private ConfigInfoDaoService configInfoDaoService;
    @Autowired
    private ConfigGroupDaoServiceImpl configGroupDaoService;
    @Autowired
    private ConfigOptionDaoService configOptionDaoService;
    @Autowired
    private ConfigInfoDaoMigrationService configInfoDaoMigrationService;

    public ExcelCheckResult check(List<ConfigInfoExcel> datas, Long taskId, List<Object> otherParams) throws Exception {
        ArrayList<ConfigInfoExcel> rootDataList = new ArrayList<ConfigInfoExcel>(datas);
        ArrayList<ConfigInfoExcel> successDataList = new ArrayList<ConfigInfoExcel>();
        ArrayList<ExcelImportMsg<ConfigInfoExcel>> newDataList = new ArrayList<ExcelImportMsg<ConfigInfoExcel>>();
        ArrayList<ExcelImportMsg<ConfigInfoExcel>> updateDataList = new ArrayList<ExcelImportMsg<ConfigInfoExcel>>();
        ArrayList<ExcelImportMsg<ConfigInfoExcel>> existDataList = new ArrayList<ExcelImportMsg<ConfigInfoExcel>>();
        ArrayList<ExcelImportMsg<ConfigInfoExcel>> errorDataList = new ArrayList<ExcelImportMsg<ConfigInfoExcel>>();
        ConfigExcelCheckResult configExcelCheckResult = new ConfigExcelCheckResult();
        this.configCheck(rootDataList, successDataList, newDataList, updateDataList, existDataList, errorDataList);
        configExcelCheckResult.setRootNum(datas.size());
        configExcelCheckResult.setErrorNum(errorDataList.size());
        if (HussarUtils.isNotEmpty(errorDataList)) {
            configExcelCheckResult.setNewNum(newDataList.size());
            configExcelCheckResult.setUpdateNum(updateDataList.size());
            configExcelCheckResult.setExistNum(existDataList.size());
        }
        ExcelCheckResult excelCheckResult = new ExcelCheckResult(rootDataList, successDataList, errorDataList, newDataList, updateDataList, existDataList);
        excelCheckResult.setCheckMsg((Object)configExcelCheckResult);
        return excelCheckResult;
    }

    private void configCheck(List<ConfigInfoExcel> rootDataList, List<ConfigInfoExcel> successDataList, List<ExcelImportMsg<ConfigInfoExcel>> newDataList, List<ExcelImportMsg<ConfigInfoExcel>> updateDataList, List<ExcelImportMsg<ConfigInfoExcel>> existDataList, List<ExcelImportMsg<ConfigInfoExcel>> errorDataList) {
        List result = this.configInfoDaoService.getConfigInfo(new GetConfigInfoDto());
        ArrayList<ConfigInfoExcel> configInfoExcels = new ArrayList<ConfigInfoExcel>();
        for (ConfigInfoEntity configInfoEntity : result) {
            ConfigInfoExcel configInfoExcel = (ConfigInfoExcel)BeanUtil.copyProperties((Object)configInfoEntity, ConfigInfoExcel.class);
            List configOptions = configInfoEntity.getConfigOptions();
            if (HussarUtils.isNotEmpty((Object)configOptions)) {
                List OptionValues = configOptions.stream().map(ConfigOptionEntity::getOptionValue).collect(Collectors.toList());
                configInfoExcel.setConfigOptionValues(JSON.toJSONString(OptionValues));
            }
            configInfoExcels.add(configInfoExcel);
        }
        Map<String, ConfigInfoExcel> configKey2Excel = configInfoExcels.stream().collect(Collectors.toMap(ConfigInfoExcel::getConfigKey, Function.identity()));
        HashSet<String> configKeyRecord = new HashSet<String>();
        for (int i = 0; i < rootDataList.size(); ++i) {
            HashMap<Integer, Map<Integer, String>> cellErrColMap = new HashMap<Integer, Map<Integer, String>>();
            HashMap<Integer, Map<Integer, String>> cellUpdateColMap = new HashMap<Integer, Map<Integer, String>>();
            HashMap<Integer, Map<Integer, String>> cellNewColMap = new HashMap<Integer, Map<Integer, String>>();
            HashMap<Integer, Map<Integer, String>> cellExitColMap = new HashMap<Integer, Map<Integer, String>>();
            ConfigInfoExcel configInfoExcel = rootDataList.get(i);
            this.checkFormat(i, cellErrColMap, configInfoExcel, configKeyRecord);
            if (HussarUtils.isNotEmpty(cellErrColMap)) {
                errorDataList.add((ExcelImportMsg<ConfigInfoExcel>)new ExcelImportMsg((Object)configInfoExcel, cellErrColMap));
                continue;
            }
            this.checkContactInfoForExit(i, cellNewColMap, cellExitColMap, cellUpdateColMap, configKey2Excel, configInfoExcel);
            if (HussarUtils.isNotEmpty(cellExitColMap)) {
                existDataList.add((ExcelImportMsg<ConfigInfoExcel>)new ExcelImportMsg((Object)configInfoExcel, cellExitColMap));
                continue;
            }
            if (HussarUtils.isNotEmpty(cellUpdateColMap)) {
                updateDataList.add((ExcelImportMsg<ConfigInfoExcel>)new ExcelImportMsg((Object)configInfoExcel, cellUpdateColMap));
                continue;
            }
            if (!HussarUtils.isNotEmpty(cellNewColMap)) continue;
            newDataList.add((ExcelImportMsg<ConfigInfoExcel>)new ExcelImportMsg((Object)configInfoExcel, cellNewColMap));
        }
    }

    private void checkFormat(int i, Map<Integer, Map<Integer, String>> cellErrColMap, ConfigInfoExcel configInfoExcel, Set<String> configKeyRecord) {
        ConfigFormatCheckResult checkConfigOption;
        ConfigFormatCheckResult checkConfigDesc;
        ConfigFormatCheckResult checkConfigValueWithType;
        ConfigFormatCheckResult checkValueType;
        ConfigFormatCheckResult checkConfigValue;
        ConfigFormatCheckResult checkConfigName;
        if (configKeyRecord.contains(configInfoExcel.getConfigKey())) {
            HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)0, (String)"\u914d\u7f6e\u6807\u8bc6\u91cd\u590d", cellErrColMap);
        }
        configKeyRecord.add(configInfoExcel.getConfigKey());
        ConfigFormatCheckResult checkConfigKey = ConfigFormatCheckUtil.checkConfigKey((String)configInfoExcel.getConfigKey());
        if (!checkConfigKey.isSuccess()) {
            HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)0, (String)checkConfigKey.getMsg(), cellErrColMap);
        }
        if (!(checkConfigName = ConfigFormatCheckUtil.checkConfigName((String)configInfoExcel.getConfigName())).isSuccess()) {
            HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)1, (String)checkConfigName.getMsg(), cellErrColMap);
        }
        if (!(checkConfigValue = ConfigFormatCheckUtil.checkConfigValue((String)configInfoExcel.getConfigValue())).isSuccess()) {
            HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)2, (String)checkConfigValue.getMsg(), cellErrColMap);
        }
        if (!(checkValueType = ConfigFormatCheckUtil.checkValueType((String)configInfoExcel.getValueType())).isSuccess()) {
            HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)3, (String)checkValueType.getMsg(), cellErrColMap);
        }
        if (checkConfigValue.isSuccess() && checkValueType.isSuccess() && !(checkConfigValueWithType = ConfigFormatCheckUtil.checkConfigValueWithType((String)configInfoExcel.getConfigValue(), (String)configInfoExcel.getValueType())).isSuccess()) {
            HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)2, (String)checkConfigValueWithType.getMsg(), cellErrColMap);
            HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)3, (String)checkConfigValueWithType.getMsg(), cellErrColMap);
        }
        if (!(checkConfigDesc = ConfigFormatCheckUtil.checkConfigDisc((String)configInfoExcel.getConfigDesc())).isSuccess()) {
            HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)4, (String)checkConfigDesc.getMsg(), cellErrColMap);
        }
        if (!(checkConfigOption = ConfigFormatCheckUtil.checkConfigOption((String)configInfoExcel.getConfigOptionValues())).isSuccess()) {
            HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)5, (String)checkConfigOption.getMsg(), cellErrColMap);
        }
        ConfigFormatCheckResult optionContainValue = ConfigFormatCheckUtil.checkOptionContainValue((String)configInfoExcel.getConfigKey(), (String)configInfoExcel.getConfigOptionValues());
        if (!checkConfigOption.isSuccess()) {
            HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)3, (String)optionContainValue.getMsg(), cellErrColMap);
            HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)5, (String)optionContainValue.getMsg(), cellErrColMap);
        }
    }

    private void checkContactInfoForExit(int i, Map<Integer, Map<Integer, String>> cellNewColMap, Map<Integer, Map<Integer, String>> cellExitColMap, Map<Integer, Map<Integer, String>> cellUpdateColMap, Map<String, ConfigInfoExcel> configKey2Excel, ConfigInfoExcel configInfoExcel) {
        int[] indexArrAdd = new int[]{0};
        if (!configKey2Excel.containsKey(configInfoExcel.getConfigKey())) {
            HussarBaseExcelValidateHelper.addMsgBatch((int)i, (String)"add", cellNewColMap, (int[])indexArrAdd, ConfigInfoExcel.class);
            return;
        }
        ConfigInfoExcel exitConfig = configKey2Excel.get(configInfoExcel.getConfigKey());
        if (exitConfig.equals((Object)configInfoExcel)) {
            HussarBaseExcelValidateHelper.addMsgBatch((int)i, (String)"exit", cellExitColMap, (int[])indexArrAdd, ConfigInfoExcel.class);
            return;
        }
        if (!Objects.equals(exitConfig.getConfigName(), configInfoExcel.getConfigName())) {
            HussarBaseExcelValidateHelper.addUpdateMsg((int)i, (int)1, (String)"\u66f4\u65b0\u914d\u7f6e\u540d\u79f0", cellUpdateColMap);
        }
        if (!Objects.equals(exitConfig.getConfigValue(), configInfoExcel.getConfigValue())) {
            HussarBaseExcelValidateHelper.addUpdateMsg((int)i, (int)2, (String)"\u66f4\u65b0\u914d\u7f6e\u503c", cellUpdateColMap);
        }
        if (!Objects.equals(exitConfig.getValueType(), configInfoExcel.getValueType())) {
            HussarBaseExcelValidateHelper.addUpdateMsg((int)i, (int)3, (String)"\u66f4\u65b0\u914d\u7f6e\u503c\u7c7b\u578b", cellUpdateColMap);
        }
        if (!Objects.equals(exitConfig.getConfigDesc(), configInfoExcel.getConfigDesc())) {
            HussarBaseExcelValidateHelper.addUpdateMsg((int)i, (int)4, (String)"\u66f4\u65b0\u914d\u7f6e\u63cf\u8ff0", cellUpdateColMap);
        }
        if (!Objects.equals(exitConfig.getConfigOptionValues(), configInfoExcel.getConfigOptionValues())) {
            HussarBaseExcelValidateHelper.addUpdateMsg((int)i, (int)5, (String)"\u66f4\u65b0\u914d\u7f6e\u53ef\u9009\u9879", cellUpdateColMap);
        }
    }

    public void saveData(List<ConfigInfoExcel> datas, List<Object> otherParams) {
        Map<String, Collection<ConfigGroupEntity>> saveAndUpdateGroupMap = this.getSaveAndUpdateGroups(datas);
        Collection<ConfigGroupEntity> saveGroups = saveAndUpdateGroupMap.get("save");
        Collection<ConfigGroupEntity> updateGroups = saveAndUpdateGroupMap.get("update");
        ArrayList<ConfigInfoEntity> saveConfigInfos = new ArrayList<ConfigInfoEntity>();
        HashSet delOptionKey = new HashSet();
        ArrayList<ConfigOptionEntity> saveOptionList = new ArrayList<ConfigOptionEntity>();
        for (ConfigInfoExcel configInfoExcel : datas) {
            ConfigInfoEntity configInfoEntity = this.getConfigInfoEntity(configInfoExcel);
            if (HussarUtils.isNotEmpty((Object)configInfoExcel.getConfigOptionValues())) {
                configInfoEntity.setValueSource(ValueSourceEnum.DROP_DOWN.getType());
                List<ConfigOptionEntity> configOptionEntity = this.getOptionEntities(configInfoExcel.getConfigKey(), configInfoExcel.getConfigOptionValues());
                saveOptionList.addAll(configOptionEntity);
            }
            saveConfigInfos.add(configInfoEntity);
        }
        this.configGroupDaoService.updateBatchById(updateGroups);
        this.configGroupDaoService.saveBatch(saveGroups);
        this.configInfoDaoMigrationService.saveBatch(saveConfigInfos);
        this.configOptionDaoService.saveBatch(saveOptionList);
    }

    public void updateData(List<ConfigInfoExcel> datas, List<Object> otherParams) {
        ArrayList<ConfigInfoEntity> updatedConfigInfos = new ArrayList<ConfigInfoEntity>();
        HashSet<String> delOptionKey = new HashSet<String>();
        ArrayList<ConfigOptionEntity> saveOptionList = new ArrayList<ConfigOptionEntity>();
        List exitConfigs = this.configInfoDaoService.getConfigInfo(new GetConfigInfoDto());
        Map configKey2Entity = exitConfigs.stream().collect(Collectors.toMap(ConfigInfoEntity::getConfigKey, Function.identity()));
        for (ConfigInfoExcel configInfoExcel : datas) {
            delOptionKey.add(configInfoExcel.getConfigKey());
            ConfigInfoEntity configInfoEntity = this.getConfigInfoEntity(configInfoExcel);
            configInfoEntity.setConfigId(((ConfigInfoEntity)configKey2Entity.get(configInfoExcel.getConfigKey())).getConfigId());
            if (HussarUtils.isNotEmpty((Object)configInfoExcel.getConfigOptionValues())) {
                configInfoEntity.setValueSource(ValueSourceEnum.DROP_DOWN.getType());
                List<ConfigOptionEntity> configOptionEntity = this.getOptionEntities(configInfoExcel.getConfigKey(), configInfoExcel.getConfigOptionValues());
                saveOptionList.addAll(configOptionEntity);
            }
            updatedConfigInfos.add(configInfoEntity);
        }
        this.configInfoDaoMigrationService.updateBatchById(updatedConfigInfos);
        this.configOptionDaoService.remove((Wrapper)Wrappers.lambdaQuery(ConfigOptionEntity.class).in(ConfigOptionEntity::getConfigKey, delOptionKey));
        this.configOptionDaoService.saveBatch(saveOptionList);
    }

    private List<ConfigOptionEntity> getOptionEntities(String configKey, String configOptionValues) {
        ConfigOptionEntity configOptionEntity;
        ArrayList<ConfigOptionEntity> saveOptions = new ArrayList<ConfigOptionEntity>();
        if (ConfigFormatCheckUtil.canBeList((String)configOptionValues)) {
            Set options = (Set)JSON.parseObject((String)configOptionValues, (TypeReference)new TypeReference<Set<String>>(){}, (Feature[])new Feature[0]);
            for (String option : options) {
                configOptionEntity = new ConfigOptionEntity();
                configOptionEntity.setConfigKey(configKey);
                configOptionEntity.setSourceType("0");
                configOptionEntity.setOptionValue(option);
                SetTenantUtil.SetTenantIdCode((HussarTenantEntity)configOptionEntity);
                saveOptions.add(configOptionEntity);
            }
        }
        if (ConfigFormatCheckUtil.canBeObject((String)configOptionValues)) {
            JSONObject jsonObject = JSON.parseObject((String)configOptionValues);
            for (String key : jsonObject.keySet()) {
                configOptionEntity = new ConfigOptionEntity();
                configOptionEntity.setConfigKey(configKey);
                configOptionEntity.setSourceType("0");
                configOptionEntity.setOptionValue(key);
                configOptionEntity.setOptionName(jsonObject.getString(key));
                SetTenantUtil.SetTenantIdCode((HussarTenantEntity)configOptionEntity);
                saveOptions.add(configOptionEntity);
            }
        }
        return saveOptions;
    }

    private Map<String, Collection<ConfigGroupEntity>> getSaveAndUpdateGroups(List<ConfigInfoExcel> datas) {
        List exitGroups = this.configGroupDaoService.getConfigGroup(new GetConfigGroupDto());
        Map<String, ConfigGroupEntity> exitGroupMap = exitGroups.stream().collect(Collectors.toMap(ConfigGroupEntity::getGroupPath, Function.identity()));
        HashMap<String, ConfigGroupEntity> saveGroupList = new HashMap<String, ConfigGroupEntity>();
        ArrayList<ConfigGroupEntity> updateGroupList = new ArrayList<ConfigGroupEntity>();
        for (ConfigInfoExcel configInfoExcel : datas) {
            String groupPath;
            String configKey = configInfoExcel.getConfigKey();
            String string = groupPath = configKey.contains(".") ? configKey.substring(0, configKey.lastIndexOf(".")) : "default";
            if ("default".equals(groupPath) && !exitGroupMap.containsKey("default")) {
                ConfigGroupEntity defaultGroup = this.configGroupDaoService.saveDefaultGroup();
                exitGroupMap.put(defaultGroup.getGroupPath(), defaultGroup);
            }
            String[] split = groupPath.split("\\.");
            String prefix = "";
            for (String groupCode : split) {
                String newPath = prefix + groupCode;
                if (exitGroupMap.containsKey(newPath)) continue;
                Long parentId = this.getParentId(prefix, saveGroupList, exitGroupMap);
                ConfigGroupEntity configGroupEntity = this.getConfigGroupEntity(groupCode, parentId, newPath);
                saveGroupList.put(newPath, configGroupEntity);
            }
        }
        Collection<ConfigGroupEntity> groupEntities = saveGroupList.values();
        this.fillIsLeaf(groupEntities, updateGroupList, exitGroups);
        HashMap<String, Collection<ConfigGroupEntity>> resultMap = new HashMap<String, Collection<ConfigGroupEntity>>();
        resultMap.put("save", groupEntities);
        resultMap.put("update", updateGroupList);
        return resultMap;
    }

    private Long getParentId(String prefix, Map<String, ConfigGroupEntity> saveGroup, Map<String, ConfigGroupEntity> exitGroup) {
        Long parentId = null;
        if (prefix.isEmpty()) {
            parentId = ConfigConstant.defaultParentId;
        }
        if (exitGroup.containsKey(prefix)) {
            parentId = exitGroup.get(prefix).getGroupId();
        }
        if (saveGroup.containsKey(prefix)) {
            parentId = saveGroup.get(prefix).getGroupId();
        }
        HussarException.throwBy((boolean)HussarUtils.isEmpty((Object)parentId), (String)"\u8ba1\u7b97\u9519\u8bef\uff0c\u672a\u53d6\u5230\u7236\u7ea7id");
        return parentId;
    }

    private ConfigGroupEntity getConfigGroupEntity(String groupCode, Long parentId, String groupPath) {
        ConfigGroupDto configGroupEntity = new ConfigGroupDto();
        configGroupEntity.setGroupId(Long.valueOf(IdUtil.getSnowflakeNextId()));
        configGroupEntity.setConfigType(ConfigConstant.defaultConfigType);
        configGroupEntity.setGroupCode(groupCode);
        configGroupEntity.setGroupDesc(groupCode);
        configGroupEntity.setGroupName(groupCode);
        SetTenantUtil.SetTenantIdCode((HussarTenantEntity)configGroupEntity);
        configGroupEntity.setParentGroupId(parentId);
        configGroupEntity.setGroupPath(groupPath);
        return configGroupEntity;
    }

    private ConfigInfoEntity getConfigInfoEntity(ConfigInfoExcel configInfoExcel) {
        String configKey = configInfoExcel.getConfigKey();
        String groupPath = configKey.contains(".") ? configKey.substring(0, configKey.lastIndexOf(46)) : "default";
        String simpleKey = configKey.contains(".") ? configKey.substring(configKey.lastIndexOf(46) + 1) : configKey;
        ConfigInfoEntity configInfoEntity = (ConfigInfoEntity)BeanUtil.copyProperties((Object)configInfoExcel, ConfigInfoEntity.class);
        configInfoEntity.setGroupPath(groupPath);
        configInfoEntity.setConfigKey(configKey);
        configInfoEntity.setMd5(DigestUtil.md5Hex((String)configInfoExcel.getConfigValue()));
        configInfoEntity.setSourceIp(IpUtils.getIp());
        configInfoEntity.setSimpleKey(simpleKey);
        configInfoEntity.setValueSource(ValueSourceEnum.NORMAL.getType());
        SetTenantUtil.SetTenantIdCode((HussarTenantEntity)configInfoEntity);
        return configInfoEntity;
    }

    private void fillIsLeaf(Collection<ConfigGroupEntity> addGroups, Collection<ConfigGroupEntity> updateGroups, Collection<ConfigGroupEntity> exitGroups) {
        Set parentIds = addGroups.stream().map(ConfigGroupEntity::getParentGroupId).collect(Collectors.toSet());
        parentIds.addAll(exitGroups.stream().map(ConfigGroupEntity::getParentGroupId).collect(Collectors.toSet()));
        for (ConfigGroupEntity groupEntity : addGroups) {
            groupEntity.setIsLeaf(parentIds.contains(groupEntity.getGroupId()) ? ConfigConstant.no_leaf : ConfigConstant.is_leaf);
        }
        for (ConfigGroupEntity exitGroup : exitGroups) {
            if (!parentIds.contains(exitGroup.getGroupId()) || ConfigConstant.no_leaf.equals(exitGroup.getIsLeaf())) continue;
            exitGroup.setIsLeaf(ConfigConstant.no_leaf);
            updateGroups.add(exitGroup);
        }
    }
}

