/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.config.extend.migration.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.jxdinfo.hussar.config.extend.migration.dto.ConfigFormatCheckResult;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.convert.ConverterRegistry;
import com.jxdinfo.hussar.support.config.manager.core.enums.ValueTypeEnum;
import java.lang.reflect.Type;
import java.util.Set;

public class ConfigFormatCheckUtil {
    public static ConfigFormatCheckResult checkConfigKey(String configKey) {
        int supportLength = 500;
        ConfigFormatCheckResult configFormatCheckResult = new ConfigFormatCheckResult();
        if (HussarUtils.isEmpty((Object)configKey)) {
            configFormatCheckResult.setMsg("\u914d\u7f6e\u6807\u8bc6\u4e0d\u53ef\u4e3a\u7a7a");
            return configFormatCheckResult;
        }
        if (configKey.length() > supportLength) {
            configFormatCheckResult.setMsg("\u914d\u7f6e\u6807\u8bc6\u957f\u5ea6\u4e0d\u53ef\u8d85\u8fc7" + supportLength);
            return configFormatCheckResult;
        }
        if (!configKey.matches("^[a-zA-Z0-9_.-]+$")) {
            configFormatCheckResult.setMsg("\u914d\u7f6e\u6807\u8bc6\u53ea\u53ef\u586b\u5199\u5b57\u6bcd\u3001\u6570\u5b57\u3001\u4e0b\u5212\u7ebf\u3001\u8fde\u5b57\u7b26\u3001\u70b9");
            return configFormatCheckResult;
        }
        configFormatCheckResult.setSuccess(true);
        return configFormatCheckResult;
    }

    public static ConfigFormatCheckResult checkConfigName(String configName) {
        int supportLength = 255;
        ConfigFormatCheckResult configFormatCheckResult = new ConfigFormatCheckResult();
        if (HussarUtils.isEmpty((Object)configName)) {
            configFormatCheckResult.setMsg("\u914d\u7f6e\u540d\u79f0\u4e0d\u53ef\u4e3a\u7a7a");
            return configFormatCheckResult;
        }
        if (configName.length() > supportLength) {
            configFormatCheckResult.setMsg("\u914d\u7f6e\u540d\u79f0\u957f\u5ea6\u4e0d\u53ef\u8d85\u8fc7" + supportLength);
            return configFormatCheckResult;
        }
        configFormatCheckResult.setSuccess(true);
        return configFormatCheckResult;
    }

    public static ConfigFormatCheckResult checkConfigValue(String configValue) {
        ConfigFormatCheckResult configFormatCheckResult = new ConfigFormatCheckResult();
        if (HussarUtils.isEmpty((Object)configValue)) {
            configFormatCheckResult.setMsg("\u914d\u7f6e\u503c\u4e0d\u53ef\u4e3a\u7a7a");
            return configFormatCheckResult;
        }
        configFormatCheckResult.setSuccess(true);
        return configFormatCheckResult;
    }

    public static ConfigFormatCheckResult checkValueType(String valueType) {
        ConfigFormatCheckResult configFormatCheckResult = new ConfigFormatCheckResult();
        try {
            Class.forName(valueType);
        }
        catch (ClassNotFoundException e) {
            configFormatCheckResult.setMsg("[" + valueType + "]\u7c7b\u4e0d\u5b58\u5728");
            return configFormatCheckResult;
        }
        if (ValueTypeEnum.getEnumsByTypeName((String)valueType) == null) {
            configFormatCheckResult.setMsg("\u4e0d\u652f\u6301\u6b64\u914d\u7f6e\u503c\u7c7b\u578b");
            return configFormatCheckResult;
        }
        configFormatCheckResult.setSuccess(true);
        return configFormatCheckResult;
    }

    public static ConfigFormatCheckResult checkConfigValueWithType(String configValue, String valueType) {
        ConfigFormatCheckResult configFormatCheckResult = new ConfigFormatCheckResult();
        ValueTypeEnum enumsByTypeName = ValueTypeEnum.getEnumsByTypeName((String)valueType);
        try {
            ConverterRegistry instance = ConverterRegistry.getInstance();
            instance.convert((Type)enumsByTypeName.getType(), (Object)configValue);
        }
        catch (Exception e) {
            configFormatCheckResult.setMsg("\u914d\u7f6e\u503c[" + configValue + "]\u4e0e[" + valueType + "]\u7c7b\u578b\u65e0\u6cd5\u8f6c\u5316");
            return configFormatCheckResult;
        }
        configFormatCheckResult.setSuccess(true);
        return configFormatCheckResult;
    }

    public static ConfigFormatCheckResult checkConfigDisc(String configDisc) {
        int supportLength = 255;
        ConfigFormatCheckResult configFormatCheckResult = new ConfigFormatCheckResult();
        if (configDisc.length() > supportLength) {
            configFormatCheckResult.setMsg("\u914d\u7f6e\u63cf\u8ff0\u957f\u5ea6\u4e0d\u53ef\u8d85\u8fc7" + supportLength);
            return configFormatCheckResult;
        }
        configFormatCheckResult.setSuccess(true);
        return configFormatCheckResult;
    }

    public static ConfigFormatCheckResult checkConfigOption(String configOption) {
        ConfigFormatCheckResult configFormatCheckResult = new ConfigFormatCheckResult();
        if (HussarUtils.isNotEmpty((Object)configOption) && !ConfigFormatCheckUtil.canBeList(configOption) && !ConfigFormatCheckUtil.canBeObject(configOption)) {
            configFormatCheckResult.setMsg("\u53ea\u53ef\u4ee5json\u683c\u5f0f\u8f93\u5165");
            return configFormatCheckResult;
        }
        configFormatCheckResult.setSuccess(true);
        return configFormatCheckResult;
    }

    public static ConfigFormatCheckResult checkOptionContainValue(String configKey, String configOptionValues) {
        JSONObject jsonObject;
        Set options;
        ConfigFormatCheckResult configFormatCheckResult = new ConfigFormatCheckResult();
        if (ConfigFormatCheckUtil.canBeList(configOptionValues) && !(options = (Set)JSON.parseObject((String)configOptionValues, (TypeReference)new TypeReference<Set<String>>(){}, (Feature[])new Feature[0])).contains(configKey)) {
            configFormatCheckResult.setMsg("\u914d\u7f6e\u503c\u53ea\u80fd\u8f93\u5165\u53ef\u9009\u503c\u5185\u7684\u6570\u636e");
            return configFormatCheckResult;
        }
        if (ConfigFormatCheckUtil.canBeObject(configOptionValues) && !(jsonObject = JSON.parseObject((String)configOptionValues)).containsKey((Object)configKey)) {
            configFormatCheckResult.setMsg("\u914d\u7f6e\u503c\u53ea\u80fd\u8f93\u5165\u53ef\u9009\u503c\u5185\u7684\u6570\u636e");
            return configFormatCheckResult;
        }
        configFormatCheckResult.setSuccess(true);
        return configFormatCheckResult;
    }

    public static boolean canBeList(String json) {
        if (HussarUtils.isEmpty((Object)json)) {
            return false;
        }
        try {
            JSON.parseArray((String)json);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean canBeObject(String json) {
        if (HussarUtils.isEmpty((Object)json)) {
            return false;
        }
        try {
            JSON.parseObject((String)json);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

